/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.checkbox;

import com.alee.extended.checkbox.CheckState;
import com.alee.extended.checkbox.WebTristateCheckBox;
import com.alee.laf.checkbox.SimpleCheckIcon;
import com.alee.utils.GeometryUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;

public class TristateCheckIcon
extends SimpleCheckIcon {
    protected static final float[] fractions = new float[]{0.0f, 1.0f};
    protected static final Color[] colors = new Color[]{new Color(28, 66, 97), new Color(55, 84, 108)};
    protected static final Color[] disabledColors = new Color[]{new Color(112, 112, 112), new Color(150, 150, 150)};
    protected WeakReference<WebTristateCheckBox> checkBox;
    protected int checkStep = -1;
    protected int mixedStep = -1;

    public TristateCheckIcon(WebTristateCheckBox checkBox) {
        this.checkBox = new WeakReference<WebTristateCheckBox>(checkBox);
    }

    @Override
    public void setNextState(CheckState nextState) {
        super.setNextState(nextState);
        block0 : switch (this.state) {
            case checked: {
                switch (nextState) {
                    case mixed: {
                        this.checkStep = 3;
                        this.mixedStep = -1;
                        break;
                    }
                    case unchecked: {
                        this.checkStep = 3;
                        this.mixedStep = -1;
                    }
                }
                break;
            }
            case mixed: {
                switch (nextState) {
                    case checked: {
                        this.mixedStep = 3;
                        this.checkStep = -1;
                        break;
                    }
                    case unchecked: {
                        this.mixedStep = 3;
                        this.checkStep = -1;
                    }
                }
                break;
            }
            case unchecked: {
                switch (nextState) {
                    case checked: {
                        this.mixedStep = -1;
                        this.checkStep = -1;
                        break block0;
                    }
                    case mixed: {
                        this.mixedStep = -1;
                        this.checkStep = -1;
                    }
                }
            }
        }
    }

    @Override
    public void doStep() {
        block0 : switch (this.state) {
            case checked: {
                switch (this.nextState) {
                    case mixed: {
                        --this.checkStep;
                        ++this.mixedStep;
                        break;
                    }
                    case unchecked: {
                        --this.checkStep;
                    }
                }
                break;
            }
            case mixed: {
                switch (this.nextState) {
                    case checked: {
                        --this.mixedStep;
                        ++this.checkStep;
                        break;
                    }
                    case unchecked: {
                        --this.mixedStep;
                    }
                }
                break;
            }
            case unchecked: {
                switch (this.nextState) {
                    case checked: {
                        ++this.checkStep;
                        break block0;
                    }
                    case mixed: {
                        ++this.mixedStep;
                    }
                }
            }
        }
    }

    @Override
    public void resetStep() {
        switch (this.state) {
            case checked: {
                this.checkStep = 3;
                this.mixedStep = -1;
                break;
            }
            case mixed: {
                this.mixedStep = 3;
                this.checkStep = -1;
                break;
            }
            case unchecked: {
                this.checkStep = -1;
                this.mixedStep = -1;
            }
        }
    }

    @Override
    public boolean isTransitionCompleted() {
        switch (this.state) {
            case checked: {
                switch (this.nextState) {
                    case mixed: {
                        return this.mixedStep == 3;
                    }
                    case unchecked: {
                        return this.checkStep == -1;
                    }
                }
                break;
            }
            case mixed: {
                switch (this.nextState) {
                    case checked: {
                        return this.checkStep == 3;
                    }
                    case unchecked: {
                        return this.mixedStep == -1;
                    }
                }
                break;
            }
            case unchecked: {
                switch (this.nextState) {
                    case checked: {
                        return this.checkStep == 3;
                    }
                    case mixed: {
                        return this.mixedStep == 3;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void paintIcon(Component c, Graphics2D g2d, int x, int y, int w, int h) {
        WebTristateCheckBox cb = (WebTristateCheckBox)this.checkBox.get();
        if (cb != null) {
            if (this.mixedStep > -1) {
                int r = 3 - this.mixedStep;
                int s = cb.getShadeWidth() + 3;
                Rectangle b = new Rectangle(x + s, y + s, w - s * 2, h - s * 2);
                RoundRectangle2D.Double shape = new RoundRectangle2D.Double(b.x + r, b.y + r, b.width - r * 2, b.height - r * 2, 3.0, 3.0);
                Point center = GeometryUtils.middle(b);
                int radius = Math.max(b.width / 2, b.height / 2);
                g2d.setPaint(new RadialGradientPaint(center, radius, fractions, cb.isEnabled() ? colors : disabledColors));
                g2d.fill(shape);
            }
            if (this.checkStep > -1) {
                ImageIcon icon = this.enabled ? (ImageIcon)CHECK_STATES.get(this.checkStep) : (ImageIcon)DISABLED_CHECK_STATES.get(this.checkStep);
                g2d.drawImage(icon.getImage(), x + w / 2 - this.getIconWidth() / 2, y + h / 2 - this.getIconHeight() / 2, null);
            }
        }
    }
}

