/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.ColorChooserFieldType;
import com.alee.extended.image.WebImage;
import com.alee.extended.painter.AbstractPainter;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.colorchooser.ColorChooserListener;
import com.alee.laf.colorchooser.WebColorChooserPanel;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.text.WebTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.ColorUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.SwingUtils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebColorChooserField
extends WebTextField {
    public static final ImageIcon pipetteIcon = new ImageIcon(WebColorChooserField.class.getResource("icons/eyedropper.png"));
    private Color color;
    private ColorChooserFieldType fieldType;
    private boolean pipetteEnabled = true;
    private final int pipettePixels = 9;
    private final int pixelSize = 11;
    private String last = "";
    private final WebButton colorButton;
    private Robot robot;
    private WebImage pipettePicker;
    private WebWindow popup;
    private WebColorChooserPanel colorChooserPanel;

    public WebColorChooserField() {
        this(Color.WHITE);
    }

    public WebColorChooserField(Color color) {
        this.updatePipette();
        this.colorButton = new WebButton(ImageUtils.createColorChooserIcon(color));
        this.colorButton.setFocusable(false);
        this.colorButton.setShadeWidth(0);
        this.colorButton.setMoveIconOnPress(false);
        this.colorButton.setRolloverDecoratedOnly(true);
        this.colorButton.setCursor(Cursor.getDefaultCursor());
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserField.this.showColorChooserPopup();
            }
        });
        this.setTrailingComponent(this.colorButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (WebColorChooserField.this.isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                    WebColorChooserField.this.showColorChooserPopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                WebColorChooserField.this.updateColorFromField();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (WebColorChooserField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(e)) {
                        WebColorChooserField.this.updateViewFromColor();
                    } else if (Hotkey.DOWN.isTriggered(e)) {
                        WebColorChooserField.this.showColorChooserPopup();
                    }
                }
            }
        });
        this.setFieldType(ColorChooserFieldType.rgb);
        this.setColor(color);
        this.updateMargin();
        this.setHorizontalAlignment(0);
    }

    public boolean isPipetteEnabled() {
        return this.pipetteEnabled;
    }

    public void setPipetteEnabled(boolean pipetteEnabled) {
        this.pipetteEnabled = pipetteEnabled;
        this.updatePipette();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateViewFromColor();
    }

    public ColorChooserFieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(ColorChooserFieldType fieldType) {
        this.fieldType = fieldType;
        this.updateFieldType();
    }

    @Override
    public void setDrawBorder(boolean drawBorder) {
        super.setDrawBorder(drawBorder);
        this.updateMargin();
    }

    private void updateViewFromColor() {
        this.colorButton.setIcon(ImageUtils.createColorChooserIcon(this.color));
        this.updateText();
    }

    private void updateColorFromField() {
        String current = this.getText();
        if (!current.equals(this.last)) {
            try {
                Color newColor;
                boolean hex = this.fieldType.equals((Object)ColorChooserFieldType.hex);
                Color color = newColor = hex ? ColorUtils.parseHexColor(current) : ColorUtils.parseRgbColor(current);
                if (newColor != null) {
                    newColor = ColorUtils.removeAlpha(newColor);
                    this.setColor(newColor);
                } else {
                    this.updateViewFromColor();
                }
            }
            catch (Throwable e) {
                this.updateViewFromColor();
            }
        }
    }

    private void updateFieldType() {
        if (this.fieldType != null) {
            boolean hex = this.fieldType.equals((Object)ColorChooserFieldType.hex);
            this.setColumns(hex ? 6 : 9);
            this.updateText();
        }
    }

    private void updateText() {
        if (this.color != null) {
            String text = this.getColorText(this.color);
            this.setText(text);
            this.last = text;
        }
    }

    private String getColorText(Color color) {
        boolean hex = this.fieldType.equals((Object)ColorChooserFieldType.hex);
        return hex ? ColorUtils.getHexColor(color) : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    private void updateMargin() {
        this.setMargin(this.isDrawBorder() ? new Insets(-1, 0, -1, -1) : new Insets(0, 0, 0, 0));
    }

    private void updatePipette() {
        if (this.pipetteEnabled) {
            this.installPipette();
        } else {
            this.uninstallPipette();
        }
        this.revalidate();
    }

    private void installPipette() {
        if (this.pipettePicker == null) {
            this.pipettePicker = new WebImage(pipetteIcon);
            try {
                this.robot = new Robot();
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            if (this.robot != null) {
                MouseAdapter mouseAdapter = new MouseAdapter(){
                    private boolean shouldUpdateColor;
                    private WebDialog window;
                    private WebPanel screen;
                    private WebLabel info;
                    private boolean updating = false;
                    private BufferedImage screenshot;
                    private Color color;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (WebColorChooserField.this.pipetteEnabled && SwingUtils.isLeftMouseButton(e)) {
                            this.shouldUpdateColor = true;
                            this.createPreviewWindow();
                            this.updateWindowLocation();
                            this.window.pack();
                            this.window.setVisible(true);
                            this.screen.requestFocus();
                            this.updateScreenshot();
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        if (WebColorChooserField.this.pipetteEnabled && SwingUtils.isLeftMouseButton(e) && this.window != null) {
                            this.updateWindowLocation();
                            this.updateScreenshot();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (WebColorChooserField.this.pipetteEnabled && SwingUtils.isLeftMouseButton(e) && this.window != null) {
                            this.window.dispose();
                        }
                    }

                    private void updateScreenshot() {
                        if (!this.updating) {
                            this.updating = true;
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (screen != null) {
                                        Point p = MouseInfo.getPointerInfo().getLocation();
                                        screenshot = WebColorChooserField.this.robot.createScreenCapture(new Rectangle(p.x - 4, p.y - 4, 9, 9));
                                        color = new Color(screenshot.getRGB(4, 4));
                                        if (screen != null) {
                                            screen.repaint();
                                            info.setText(WebColorChooserField.this.getColorText(color));
                                        } else {
                                            screenshot.flush();
                                            screenshot = null;
                                            color = null;
                                        }
                                    }
                                    updating = false;
                                }
                            }).start();
                        }
                    }

                    private void createPreviewWindow() {
                        this.window = new WebDialog(WebColorChooserField.this.pipettePicker);
                        this.window.setLayout(new BorderLayout());
                        this.window.setUndecorated(true);
                        this.window.setAlwaysOnTop(true);
                        this.window.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosed(WindowEvent e) {
                                if (screenshot != null) {
                                    if (shouldUpdateColor) {
                                        WebColorChooserField.this.setColor(color);
                                    }
                                    screenshot.flush();
                                    screenshot = null;
                                }
                                HotkeyManager.unregisterHotkeys(screen);
                                window = null;
                                screen = null;
                            }
                        });
                        AbstractPainter<WebPanel> screenPainter = new AbstractPainter<WebPanel>(){

                            @Override
                            public void paint(Graphics2D g2d, Rectangle bounds, WebPanel c) {
                                if (window.isShowing() && WebColorChooserField.this.robot != null) {
                                    g2d.drawImage(screenshot, bounds.x + 2, bounds.y + 2, bounds.width - 4, bounds.height - 4, null);
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawRect(0, 0, bounds.width - 1, bounds.height - 1);
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawRect(1, 1, bounds.width - 3, bounds.height - 3);
                                    int mx = bounds.x + bounds.width / 2;
                                    int my = bounds.y + bounds.height / 2;
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawLine(mx - 1, my - 7, mx - 1, my + 7);
                                    g2d.drawLine(mx + 1, my - 7, mx + 1, my + 7);
                                    g2d.drawLine(mx - 7, my - 1, mx + 7, my - 1);
                                    g2d.drawLine(mx - 7, my + 1, mx + 7, my + 1);
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawLine(mx, my - 7, mx, my + 7);
                                    g2d.drawLine(mx - 7, my, mx + 7, my);
                                }
                            }
                        };
                        this.screen = new WebPanel(screenPainter);
                        this.screen.setFocusable(true);
                        this.screen.setPreferredSize(new Dimension(103, 103));
                        this.window.add((Component)this.screen, "Center");
                        this.info = new WebLabel(10);
                        this.info.setMargin(4);
                        this.info.setIcon(new Icon(){

                            @Override
                            public void paintIcon(Component c, Graphics g, int x, int y) {
                                if (color != null) {
                                    Graphics2D g2d = (Graphics2D)g;
                                    g2d.setPaint(Color.BLACK);
                                    g2d.drawRect(x, y, 15, 15);
                                    g2d.setPaint(Color.WHITE);
                                    g2d.drawRect(x + 1, y + 1, 13, 13);
                                    g2d.setPaint(color);
                                    g2d.fillRect(x + 2, y + 2, 12, 12);
                                }
                            }

                            @Override
                            public int getIconWidth() {
                                return 16;
                            }

                            @Override
                            public int getIconHeight() {
                                return 16;
                            }
                        });
                        this.info.setPainter(new AbstractPainter<WebLabel>(){

                            @Override
                            public Insets getMargin(WebLabel c) {
                                return new Insets(0, 2, 2, 2);
                            }

                            @Override
                            public void paint(Graphics2D g2d, Rectangle bounds, WebLabel c) {
                                g2d.setPaint(Color.BLACK);
                                g2d.drawRect(bounds.x, bounds.y - 1, bounds.width - 1, bounds.height);
                            }
                        });
                        this.window.add((Component)this.info, "South");
                        HotkeyManager.registerHotkey((Component)this.screen, Hotkey.ESCAPE, new HotkeyRunnable(){

                            @Override
                            public void run(KeyEvent e) {
                                if (window != null) {
                                    shouldUpdateColor = false;
                                    window.dispose();
                                }
                            }
                        });
                    }

                    private void updateWindowLocation() {
                        Point p = MouseInfo.getPointerInfo().getLocation();
                        Rectangle b = this.window.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getBounds();
                        int ww = this.window.getWidth();
                        int wh = this.window.getHeight();
                        int x = p.x + 20 + ww < b.x + b.width ? p.x + 20 : p.x - 20 - ww;
                        int y = p.y + 20 + wh < b.y + b.height ? p.y + 20 : p.y - 20 - wh;
                        this.window.setLocation(x, y);
                    }
                };
                this.pipettePicker.addMouseListener(mouseAdapter);
                this.pipettePicker.addMouseMotionListener(mouseAdapter);
                this.pipettePicker.setCursor(Cursor.getDefaultCursor());
            }
        }
        this.setLeadingComponent(this.pipettePicker);
    }

    private void uninstallPipette() {
        this.setLeadingComponent(null);
    }

    private void showColorChooserPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.updateColorFromField();
        if (this.popup == null || this.colorChooserPanel == null) {
            Window ancestor = SwingUtils.getWindowAncestor(this);
            this.colorChooserPanel = new WebColorChooserPanel(true);
            this.colorChooserPanel.setColor(this.color);
            this.colorChooserPanel.setUndecorated(false);
            this.colorChooserPanel.setPaintFocus(false);
            this.colorChooserPanel.setRound(StyleConstants.smallRound);
            this.colorChooserPanel.setShadeWidth(0);
            this.popup = new WebWindow(ancestor);
            this.popup.setLayout(new BorderLayout());
            this.popup.setCloseOnFocusLoss(true);
            this.popup.setWindowOpaque(false);
            this.popup.add(this.colorChooserPanel);
            this.popup.pack();
            this.updatePopupLocation();
            ancestor.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            ancestor.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (WebColorChooserField.this.popup.isShowing()) {
                        WebColorChooserField.this.updatePopupLocation();
                    }
                }
            });
            this.colorChooserPanel.addColorChooserListener(new ColorChooserListener(){

                @Override
                public void okPressed(ActionEvent e) {
                    WebColorChooserField.this.setColor(WebColorChooserField.this.colorChooserPanel.getColor());
                    WebColorChooserField.this.popup.setVisible(false);
                }

                @Override
                public void resetPressed(ActionEvent e) {
                }

                @Override
                public void cancelPressed(ActionEvent e) {
                    WebColorChooserField.this.popup.setVisible(false);
                }
            });
        } else {
            this.updatePopupLocation();
            this.colorChooserPanel.setColor(this.color);
        }
        SwingUtils.copyOrientation(this, this.popup);
        this.popup.setVisible(true);
        this.colorChooserPanel.requestFocusInWindow();
    }

    private void updatePopupLocation() {
        Point los = this.getLocationOnScreen();
        Rectangle gb = this.popup.getGraphicsConfiguration().getBounds();
        int shadeWidth = this.isDrawBorder() ? this.getShadeWidth() : 0;
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        int w = this.getWidth();
        int h = this.getHeight();
        int x = ltr ? (los.x + shadeWidth + this.popup.getWidth() <= gb.x + gb.width ? los.x + shadeWidth : los.x + w - shadeWidth - this.popup.getWidth()) : (los.x + w - shadeWidth - this.popup.getWidth() >= gb.x ? los.x + w - shadeWidth - this.popup.getWidth() : los.x + shadeWidth);
        int y = los.y + h + this.popup.getHeight() <= gb.y + gb.height ? los.y + h + (this.isDrawBorder() ? 0 : 1) : los.y - this.popup.getHeight() - (this.isDrawBorder() ? 0 : 1);
        this.popup.setLocation(x, y);
    }
}

