/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.DirectoryChooserListener;
import com.alee.extended.filechooser.WebDirectoryChooserPanel;
import com.alee.extended.panel.GroupPanel;
import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.utils.SwingUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.swing.DialogOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class WebDirectoryChooser
extends WebDialog
implements DialogOptions {
    protected static final ImageIcon ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/dir_icon.png"));
    protected static final ImageIcon SETTINGS_ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/settings.png"));
    protected static final ImageIcon OK_ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/ok.png"));
    protected static final ImageIcon CANCEL_ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/cancel.png"));
    protected WebDirectoryChooserPanel directoryChooserPanel;
    protected WebButton approveButton;
    protected WebButton cancelButton;
    protected int result = -2;

    public WebDirectoryChooser(Window parent) {
        this(parent, (String)null);
    }

    public WebDirectoryChooser(Window parent, String title) {
        super(parent, title != null ? title : "");
        this.setIconImage(ICON.getImage());
        if (title == null) {
            this.setLanguage("weblaf.ex.dirchooser.title", new Object[0]);
        }
        HotkeyManager.installShowAllHotkeysAction(this, Hotkey.F1);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.directoryChooserPanel = new WebDirectoryChooserPanel();
        this.getContentPane().add((Component)this.directoryChooserPanel, "Center");
        HotkeyManager.addContainerHotkeyCondition(this, new HotkeyCondition(){

            @Override
            public boolean checkCondition(Component component) {
                return WebDirectoryChooser.this.directoryChooserPanel.allowHotkeys();
            }
        });
        final WebPanel buttonsPanel = new WebPanel();
        buttonsPanel.setMargin(0, 3, 3, 3);
        buttonsPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.approveButton = new WebButton("", (Icon)OK_ICON);
        this.approveButton.setLanguage("weblaf.ex.dirchooser.choose", new Object[0]);
        this.approveButton.addHotkey(this, Hotkey.CTRL_ENTER);
        this.approveButton.setRolloverShine(StyleConstants.highlightControlButtons);
        this.approveButton.setShineColor(StyleConstants.greenHighlight);
        this.approveButton.setEnabled(false);
        this.approveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryChooser.this.result = 0;
                WebDirectoryChooser.this.dispose();
            }
        });
        this.cancelButton = new WebButton("", (Icon)CANCEL_ICON);
        this.cancelButton.setLanguage("weblaf.ex.dirchooser.cancel", new Object[0]);
        this.cancelButton.addHotkey(this, Hotkey.ESCAPE);
        this.cancelButton.setRolloverShine(StyleConstants.highlightControlButtons);
        this.cancelButton.setShineColor(StyleConstants.redHighlight);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebDirectoryChooser.this.result = 1;
                WebDirectoryChooser.this.dispose();
            }
        });
        buttonsPanel.add((Component)new GroupPanel(4, this.approveButton, this.cancelButton), (Object)"After");
        SwingUtils.equalizeComponentsSize(this.approveButton, this.cancelButton);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebDirectoryChooser.this.approveButton.setPreferredSize(null);
                WebDirectoryChooser.this.cancelButton.setPreferredSize(null);
                SwingUtils.equalizeComponentsSize(WebDirectoryChooser.this.approveButton, WebDirectoryChooser.this.cancelButton);
                buttonsPanel.revalidate();
            }
        };
        this.approveButton.addPropertyChangeListener("text", pcl);
        this.cancelButton.addPropertyChangeListener("text", pcl);
        this.directoryChooserPanel.addDirectoryChooserListener(new DirectoryChooserListener(){

            @Override
            public void selectionChanged(File file) {
                WebDirectoryChooser.this.updateButtonsState(file);
            }
        });
        this.updateButtonsState(this.directoryChooserPanel.getSelectedDirectory());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                WebDirectoryChooser.this.result = -1;
            }
        });
        this.setModal(true);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    protected void updateButtonsState(File file) {
        this.approveButton.setEnabled(file != null);
    }

    public AbstractFileFilter getFilter() {
        return this.directoryChooserPanel.getFilter();
    }

    public void setFilter(AbstractFileFilter filter) {
        this.directoryChooserPanel.setFilter(filter);
    }

    public int getResult() {
        return this.result;
    }

    public File getSelectedDirectory() {
        return this.directoryChooserPanel.getSelectedDirectory();
    }

    public void setSelectedDirectory(File selectedDirectory) {
        this.directoryChooserPanel.setSelectedDirectory(selectedDirectory);
    }

    public void addDirectoryChooserListener(DirectoryChooserListener listener) {
        this.directoryChooserPanel.addDirectoryChooserListener(listener);
    }

    public void removeDirectoryChooserListener(DirectoryChooserListener listener) {
        this.directoryChooserPanel.removeDirectoryChooserListener(listener);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.getResult();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -2;
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(b);
    }

    public static File showDialog(Window parent) {
        return WebDirectoryChooser.showDialog(parent, null);
    }

    public static File showDialog(Window parent, String title) {
        WebDirectoryChooser wdc = new WebDirectoryChooser(parent, title);
        wdc.setVisible(true);
        return wdc.getResult() == 0 ? wdc.getSelectedDirectory() : null;
    }
}

