/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.list;

import com.alee.extended.list.CheckBoxCellData;
import com.alee.extended.list.WebCheckBoxListElement;
import com.alee.laf.checkbox.WebCheckBoxStyle;
import com.alee.laf.list.WebListStyle;
import com.alee.laf.list.WebListUI;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ListUI;

public class WebCheckBoxListCellRenderer
implements ListCellRenderer {
    protected Map<String, WebCheckBoxListElement> elements = new HashMap<String, WebCheckBoxListElement>();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        CheckBoxCellData data = (CheckBoxCellData)value;
        WebCheckBoxListElement renderer = this.getElement(data);
        renderer.setFont(list.getFont());
        renderer.setEnabled(list.isEnabled());
        renderer.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        renderer.setText(data.getUserObject() == null ? "" : data.getUserObject().toString());
        ListUI lui = list.getUI();
        int sw = lui instanceof WebListUI ? ((WebListUI)lui).getSelectionShadeWidth() : WebListStyle.selectionShadeWidth;
        renderer.setMargin(sw + 2, sw + 2, sw + 2, sw + 4);
        renderer.setComponentOrientation(list.getComponentOrientation());
        return renderer;
    }

    public WebCheckBoxListElement getElement(CheckBoxCellData data) {
        String key = data.getId();
        if (this.elements.containsKey(key)) {
            WebCheckBoxListElement element = this.elements.get(key);
            element.setSelected(data.isSelected(), WebCheckBoxStyle.animated);
            return element;
        }
        WebCheckBoxListElement element = new WebCheckBoxListElement();
        element.setName("List.cellRenderer");
        element.setSelected(data.isSelected(), false);
        this.elements.put(key, element);
        return element;
    }
}

