/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterListener;
import com.alee.utils.CollectionUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractPainter<E extends JComponent>
implements Painter<E> {
    protected Boolean opaque = false;
    protected Dimension preferredSize = new Dimension(0, 0);
    protected Insets margin = new Insets(0, 0, 0, 0);
    protected List<PainterListener> listeners = new ArrayList<PainterListener>(1);

    @Override
    public void install(E c) {
    }

    @Override
    public void uninstall(E c) {
    }

    @Override
    public Boolean isOpaque(E c) {
        return this.opaque;
    }

    public void setOpaque(Boolean opaque) {
        this.opaque = opaque;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize(E c) {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
        this.revalidate();
    }

    @Override
    public Insets getMargin(E c) {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.revalidate();
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
    }

    public void setMargin(int margin) {
        this.setMargin(margin, margin, margin, margin);
    }

    @Override
    public void addPainterListener(PainterListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePainterListener(PainterListener listener) {
        this.listeners.remove(listener);
    }

    public void repaint() {
        for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
            listener.repaint();
        }
    }

    public void repaint(Rectangle bounds) {
        this.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void repaint(int x, int y, int width, int height) {
        for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
            listener.repaint(x, y, width, height);
        }
    }

    public void revalidate() {
        for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
            listener.revalidate();
        }
    }

    public void updateOpacity() {
        for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
            listener.updateOpacity();
        }
    }

    public void updateAll() {
        for (PainterListener listener : CollectionUtils.copy(this.listeners)) {
            listener.updateOpacity();
            listener.revalidate();
            listener.repaint();
        }
    }

    protected Point p(int x, int y) {
        return new Point(x, y);
    }
}

