/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.progress;

import com.alee.extended.panel.WebOverlay;
import com.alee.global.StyleConstants;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProducer;
import com.alee.utils.laf.WebShapeProducer;
import com.alee.utils.swing.EmptyMouseAdapter;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class WebProgressOverlay
extends WebOverlay {
    private ShapeProducer clipShapeProducer = null;
    private int progressWidth = 15;
    private int speed = 1;
    private Color progressColor = Color.GRAY;
    private ProgressLayer progressLayer;

    public WebProgressOverlay() {
        this.initializeProgressLayer();
    }

    public WebProgressOverlay(Component component) {
        super(component);
        this.initializeProgressLayer();
    }

    protected void initializeProgressLayer() {
        this.progressLayer = new ProgressLayer();
        this.progressLayer.setVisible(false);
        this.addOverlay(this.progressLayer);
    }

    @Override
    public void setComponent(Component component) {
        super.setComponent(component);
        this.setClipShapeProducer(component != null ? new WebShapeProducer(component) : null);
    }

    public void setClipShapeProducer(ShapeProducer clipShapeProducer) {
        this.clipShapeProducer = clipShapeProducer;
    }

    public ShapeProducer getClipShapeProducer() {
        return this.clipShapeProducer;
    }

    public boolean isShowLoad() {
        return this.progressLayer.isShowLoad();
    }

    public void setShowLoad(boolean showLoad) {
        this.progressLayer.setShowLoad(showLoad);
    }

    public boolean isConsumeEvents() {
        return this.progressLayer.isConsumeEvents();
    }

    public void setConsumeEvents(boolean consumeEvents) {
        this.progressLayer.setConsumeEvents(consumeEvents);
    }

    public int getProgressWidth() {
        return this.progressWidth;
    }

    public void setProgressWidth(int progressWidth) {
        this.progressWidth = progressWidth;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public Color getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(Color progressColor) {
        this.progressColor = progressColor;
    }

    private class ProgressLayer
    extends JComponent {
        private boolean showLoad = false;
        private boolean consumeEvents = true;
        private WebTimer opacityAnimator = null;
        private WebTimer animator = null;
        private int opacity = 0;
        private int loadProgress = 0;

        public ProgressLayer() {
            SwingUtils.setOrientation(this);
            EmptyMouseAdapter.install(this);
        }

        @Override
        public boolean contains(int x, int y) {
            return this.consumeEvents && super.contains(x, y);
        }

        public boolean isConsumeEvents() {
            return this.consumeEvents;
        }

        public void setConsumeEvents(boolean consumeEvents) {
            this.consumeEvents = consumeEvents;
        }

        public boolean isShowLoad() {
            return this.showLoad;
        }

        public void setShowLoad(boolean showLoad) {
            this.showLoad = showLoad;
            if (showLoad) {
                this.setVisible(true);
                this.stopOpacityAnimator();
                this.opacityAnimator = new WebTimer("WebProgressOverlay.opacityAnimator", StyleConstants.animationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ProgressLayer.this.opacity < 128) {
                            ProgressLayer.this.opacity += 8;
                        } else {
                            ProgressLayer.this.opacity = 128;
                            ProgressLayer.this.opacityAnimator.stop();
                        }
                    }
                });
                this.opacityAnimator.start();
                this.stopAnimator();
                this.animator = new WebTimer("WebProgressOverlay.animator", StyleConstants.avgAnimationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ProgressLayer.this.loadProgress < WebProgressOverlay.this.getProgressWidth() * 2) {
                            ProgressLayer.this.loadProgress += WebProgressOverlay.this.speed;
                        } else {
                            ProgressLayer.this.loadProgress = 0;
                        }
                        if (ProgressLayer.this.isVisible()) {
                            ProgressLayer.this.repaint();
                        }
                    }
                });
                this.animator.start();
            } else {
                this.stopOpacityAnimator();
                this.opacityAnimator = new WebTimer("WebProgressOverlay.opacityAnimator", StyleConstants.avgAnimationDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ProgressLayer.this.opacity > 0) {
                            ProgressLayer.this.opacity -= 8;
                        } else {
                            ProgressLayer.this.opacity = 0;
                            ProgressLayer.this.opacityAnimator.stop();
                            ProgressLayer.this.stopAnimator();
                            ProgressLayer.this.setVisible(false);
                        }
                    }
                });
                this.opacityAnimator.start();
            }
        }

        private void stopAnimator() {
            if (this.animator != null && this.animator.isRunning()) {
                this.animator.stop();
                this.animator = null;
            }
        }

        private void stopOpacityAnimator() {
            if (this.opacityAnimator != null && this.opacityAnimator.isRunning()) {
                this.opacityAnimator.stop();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.opacity > 0) {
                int w = this.getWidth();
                int h = this.getHeight();
                int pw = WebProgressOverlay.this.getProgressWidth();
                if (w > 0 && h > 0 && pw > 0) {
                    Shape clip;
                    Graphics2D g2d = (Graphics2D)g;
                    Object aa = GraphicsUtils.setupAntialias(g2d);
                    Shape oldClip = GraphicsUtils.intersectClip(g2d, clip, (clip = this.getClipShape()) != null);
                    g2d.setPaint(new Color(WebProgressOverlay.this.progressColor.getRed(), WebProgressOverlay.this.progressColor.getGreen(), WebProgressOverlay.this.progressColor.getBlue(), this.opacity));
                    for (int i = this.loadProgress % (pw * 2); i < w + 2 * h; i += pw * 2) {
                        if (i <= 0) continue;
                        GeneralPath gp = new GeneralPath(0);
                        gp.moveTo(i < w ? (float)i : (float)w, i < w ? 0.0f : (float)Math.min(h, i - w));
                        if (i - pw < w && i > w) {
                            gp.lineTo(w, 0.0f);
                        }
                        gp.lineTo(i - pw < w ? (float)Math.max(0, i - pw) : (float)w, i - pw < w ? 0.0f : (float)(i - pw - w));
                        gp.lineTo(i - pw < h ? 0.0f : (float)(i - pw - h), i - pw < h ? (float)Math.max(0, i - pw) : (float)h);
                        if (i - pw < h && i > h) {
                            gp.lineTo(0.0f, h);
                        }
                        gp.lineTo(i < h ? 0.0f : (float)Math.min(w, i - h), i < h ? (float)i : (float)h);
                        gp.closePath();
                        g2d.fill(gp);
                    }
                    GraphicsUtils.restoreClip(g, oldClip, clip != null);
                    GraphicsUtils.restoreAntialias(g2d, aa);
                }
            }
        }

        private Shape getClipShape() {
            if (WebProgressOverlay.this.clipShapeProducer != null) {
                return WebProgressOverlay.this.clipShapeProducer.produce();
            }
            return null;
        }
    }
}

