/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.style;

import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.WebBreadcrumbLabel;
import com.alee.extended.breadcrumb.WebBreadcrumbPanel;
import com.alee.extended.layout.HorizontalFlowLayout;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.extended.panel.CenterPanel;
import com.alee.extended.panel.GroupPanel;
import com.alee.extended.panel.GroupingType;
import com.alee.extended.panel.WebButtonGroup;
import com.alee.extended.statusbar.WebMemoryBar;
import com.alee.extended.statusbar.WebStatusBar;
import com.alee.extended.style.CodeLinkGenerator;
import com.alee.extended.style.StyleEditorSkin;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.label.WebLabel;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.panel.WebPanelUI;
import com.alee.laf.rootpane.WebFrame;
import com.alee.laf.scroll.WebScrollBar;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.scroll.WebScrollPaneUI;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.laf.text.WebTextField;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.log.Log;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.SupportedComponent;
import com.alee.managers.style.data.SkinInfo;
import com.alee.managers.style.data.SkinInfoConverter;
import com.alee.managers.style.skin.CustomSkin;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.utils.ImageUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TimeUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.DocumentChangeListener;
import com.alee.utils.swing.IntDocumentChangeListener;
import com.alee.utils.swing.IntTextDocument;
import com.alee.utils.swing.WebTimer;
import com.alee.utils.xml.ResourceFile;
import com.alee.utils.xml.ResourceLocation;
import com.thoughtworks.xstream.converters.ConversionException;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RUndoManager;

public class StyleEditor
extends WebFrame {
    private static final ImageIcon info = new ImageIcon(StyleEditor.class.getResource("icons/status/info.png"));
    private static final ImageIcon ok = new ImageIcon(StyleEditor.class.getResource("icons/status/ok.png"));
    private static final ImageIcon error = new ImageIcon(StyleEditor.class.getResource("icons/status/error.png"));
    private static final ImageIcon tabIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/tab.png"));
    private static final BufferedImage magnifier = ImageUtils.getBufferedImage(new ImageIcon(StyleEditor.class.getResource("icons/editor/magnifierImage.png")));
    private WebToolBar toolBar;
    private WebPanel container;
    private WebSplitPane split;
    private WebPanel componentViewer;
    private WebPanel editorsContainer;
    private WebStatusBar statusbar;
    private WebBreadcrumbLabel statusMessage;
    private final List<JComponent> previewComponents = new ArrayList<JComponent>();
    private final List<WebPanel> boundsPanels = new ArrayList<WebPanel>();
    private int updateDelay = 50;
    private int zoomFactor = 4;
    private ComponentOrientation orientation = WebLookAndFeel.getOrientation();
    private boolean enabled = true;
    private final ResourceFile baseSkinFile;
    private List<RSyntaxTextArea> editors;

    public StyleEditor(ResourceFile editedSkinFile) {
        super("WebLaF skin editor");
        this.setIconImages(WebLookAndFeel.getImages());
        this.baseSkinFile = editedSkinFile;
        this.initializeContainer();
        this.initializeToolBar();
        this.initializeStatusBar();
        this.initializeViewer();
        this.initializeEditors();
        this.setDefaultCloseOperation(3);
        this.setSize(1200, 800);
        this.setLocationRelativeTo(null);
    }

    private void initializeToolBar() {
        this.toolBar = new WebToolBar(0);
        this.toolBar.setToolbarStyle(ToolbarStyle.attached);
        this.toolBar.setMargin(4);
        this.toolBar.setSpacing(4);
        this.toolBar.setFloatable(false);
        ImageIcon magnifierIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/magnifier.png"));
        WebToggleButton magnifierButton = new WebToggleButton(magnifierIcon);
        TooltipManager.setTooltip((Component)magnifierButton, magnifierIcon, "Show/hide magnifier tool");
        magnifierButton.addHotkey(Hotkey.ALT_Q);
        magnifierButton.setRound(0);
        magnifierButton.setFocusable(false);
        this.initializeMagnifier(magnifierButton);
        final WebButton zoomFactorButton = new WebButton("4x");
        zoomFactorButton.setRound(0);
        zoomFactorButton.setFocusable(false);
        zoomFactorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPopupMenu menu = new WebPopupMenu();
                for (int i = 2; i <= 6; ++i) {
                    final int factor = i;
                    WebMenuItem menuItem = new WebMenuItem(i + "x zoom");
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            StyleEditor.this.zoomFactor = factor;
                            zoomFactorButton.setText(factor + "x");
                        }
                    });
                    menu.add(menuItem);
                }
                menu.showBelowMiddle(zoomFactorButton);
            }
        });
        this.toolBar.add((Component)new WebButtonGroup(magnifierButton, zoomFactorButton));
        ImageIcon boundsIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/bounds.png"));
        final WebToggleButton boundsButton = new WebToggleButton(boundsIcon);
        TooltipManager.setTooltip((Component)boundsButton, boundsIcon, "Show/hide component bounds");
        boundsButton.addHotkey(Hotkey.ALT_W);
        boundsButton.setRound(0);
        boundsButton.setFocusable(false);
        boundsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (WebPanel boundsPanel : StyleEditor.this.boundsPanels) {
                    boundsPanel.setStyleId(boundsButton.isSelected() ? "dashed-border" : "empty-border");
                }
            }
        });
        this.toolBar.add((Component)boundsButton);
        ImageIcon disabledIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/disabled.png"));
        WebToggleButton disabledButton = new WebToggleButton(disabledIcon);
        TooltipManager.setTooltip((Component)disabledButton, disabledIcon, "Disable/enable components");
        disabledButton.addHotkey(Hotkey.ALT_D);
        disabledButton.setRound(0);
        disabledButton.setFocusable(false);
        disabledButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.enabled = !StyleEditor.this.enabled;
                for (JComponent component : StyleEditor.this.previewComponents) {
                    SwingUtils.setEnabledRecursively(component, StyleEditor.this.enabled);
                }
            }
        });
        this.toolBar.add((Component)disabledButton);
        ImageIcon orientationIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/orientation.png"));
        WebToggleButton orientationButton = new WebToggleButton(orientationIcon);
        TooltipManager.setTooltip((Component)orientationButton, orientationIcon, "Change components orientation");
        orientationButton.addHotkey(Hotkey.ALT_R);
        orientationButton.setRound(0);
        orientationButton.setFocusable(false);
        orientationButton.setSelected(!this.orientation.isLeftToRight());
        orientationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleEditor.this.orientation = StyleEditor.this.orientation.isLeftToRight() ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
                StyleEditor.this.componentViewer.applyComponentOrientation(StyleEditor.this.orientation);
                for (JComponent component : StyleEditor.this.previewComponents) {
                    component.applyComponentOrientation(StyleEditor.this.orientation);
                }
            }
        });
        this.toolBar.add((Component)orientationButton);
    }

    private void initializeContainer() {
        this.container = new WebPanel();
        this.getContentPane().add((Component)this.container, "Center");
        this.split = new WebSplitPane(1, true);
        this.split.setDividerLocation(300);
        this.split.setDividerSize(8);
        this.split.setDrawDividerBorder(true);
        this.split.setOneTouchExpandable(true);
        this.container.add((Component)this.split, (Object)"Center");
    }

    private void initializeStatusBar() {
        this.statusbar = new WebStatusBar();
        WebBreadcrumb updateBreadcrumb = new WebBreadcrumb(false);
        updateBreadcrumb.setEncloseLastElement(false);
        ImageIcon updateIcon = new ImageIcon(StyleEditor.class.getResource("icons/editor/update.png"));
        WebLabel delayLabel = new WebLabel("Skin update delay:", updateIcon);
        WebTextField delayField = new WebTextField(new IntTextDocument(), "" + this.updateDelay, 3);
        delayField.setShadeWidth(0);
        delayField.setHorizontalAlignment(0);
        delayField.getDocument().addDocumentListener(new IntDocumentChangeListener(){

            @Override
            public void documentChanged(Integer newValue, DocumentEvent e) {
                StyleEditor.this.updateDelay = newValue != null ? newValue : StyleEditor.this.updateDelay;
                if (StyleEditor.this.updateDelay < 0) {
                    StyleEditor.this.updateDelay = 0;
                }
            }
        });
        WebLabel msLabel = new WebLabel("ms").setMargin(4);
        WebBreadcrumbPanel panel = new WebBreadcrumbPanel();
        panel.setLayout(new HorizontalFlowLayout(4, false));
        panel.add(delayLabel, new CenterPanel(delayField, false, true), msLabel);
        updateBreadcrumb.add((Component)panel);
        this.statusMessage = new WebBreadcrumbLabel("Edit XML at the right side and see UI changes at the left side!", info);
        this.statusMessage.setStyleId("status-message-label");
        updateBreadcrumb.add((Component)this.statusMessage);
        this.statusbar.add(updateBreadcrumb);
        this.statusbar.addToEnd(new WebMemoryBar().setPreferredWidth(200));
        this.container.add((Component)this.statusbar, (Object)"South");
    }

    private void initializeViewer() {
        this.componentViewer = new WebPanel(new VerticalFlowLayout(0, 0, 15, true, false));
        this.componentViewer.setMargin(10);
        WebScrollPane previewScroll = new WebScrollPane(this.componentViewer, false);
        previewScroll.setScrollBarStyleId("preview-scroll");
        previewScroll.setVerticalScrollBarPolicy(22);
        this.split.setLeftComponent(new GroupPanel(GroupingType.fillLast, 0, false, this.toolBar, previewScroll));
        WebLabel label = new WebLabel("Just a label", WebLookAndFeel.getIcon(16));
        this.addViewComponent("JLabel", label, label, true);
        WebScrollBar hsb = new WebScrollBar(0, 45, 10, 0, 100);
        this.addViewComponent("JScrollBar (horizontal)", hsb, hsb, false);
        WebScrollBar vsb = new WebScrollBar(1, 45, 10, 0, 100).setPreferredHeight(100);
        this.addViewComponent("JScrollBar (vertical)", vsb, vsb, true);
        final WebLabel scrollComponent = new WebLabel();
        scrollComponent.setPreferredSize(new Dimension(1000, 600));
        scrollComponent.setFocusable(true);
        scrollComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                scrollComponent.requestFocusInWindow();
            }
        });
        WebScrollPane sp = new WebScrollPane(scrollComponent);
        sp.setPreferredSize(new Dimension(1, 100));
        this.addViewComponent("JScrollBar in JScrollPane", sp, sp, false);
        Object[] comboData = new String[]{"Mikle Garin", "Lilly Stewart", "Alex Jackson", "Joshua Martin", "Mark Einsberg", "Joe Phillips", "Alice Manson", "Nancy Drew", "John Linderman", "Trisha Mathew"};
        WebComboBox cb = new WebComboBox(comboData);
        this.addViewComponent("JScrollBar in JComboBox", cb, cb, true);
        final WebPopupMenu popupMenu = new WebPopupMenu();
        popupMenu.add(new WebMenuItem("Item 1", WebLookAndFeel.getIcon(16)));
        popupMenu.add(new WebMenuItem("Item 2"));
        popupMenu.add(new WebMenuItem("Item 3"));
        popupMenu.addSeparator();
        popupMenu.add(new WebMenuItem("Item 4", (Icon)WebLookAndFeel.getIcon(16), Hotkey.ALT_F4));
        WebButton popupButton = new WebButton("Show popup menu", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popupMenu.showBelowMiddle((WebButton)e.getSource());
            }
        });
        this.addViewComponent("JPopupMenu under JButton", popupButton, popupMenu, true);
    }

    private void addViewComponent(String title, JComponent displayedView, JComponent view, boolean center) {
        SupportedComponent type = SupportedComponent.getComponentTypeByUIClassID(view.getUIClassID());
        WebLabel titleLabel = new WebLabel(title, type.getIcon()).setMargin(0, 7, 3, 0);
        WebPanel boundsPanel = new WebPanel(displayedView);
        boundsPanel.setStyleId("empty-border");
        this.boundsPanels.add(boundsPanel);
        final WebPanel viewPanel = new WebPanel(center ? new CenterPanel(boundsPanel) : boundsPanel);
        viewPanel.setStyleId("inner-shade");
        WebPanel container = new WebPanel(new BorderLayout(0, 0));
        container.add((Component)titleLabel, (Object)"North");
        container.add((Component)viewPanel, (Object)"Center");
        this.componentViewer.add((Component)container);
        titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                viewPanel.setVisible(!viewPanel.isVisible());
                StyleEditor.this.componentViewer.revalidate();
                StyleEditor.this.componentViewer.repaint();
            }
        });
        this.previewComponents.add(view);
    }

    private void initializeEditors() {
        WebTabbedPane editorTabs = new WebTabbedPane(TabbedPaneStyle.attached);
        this.editorsContainer = new WebPanel(false, (Component)editorTabs);
        Theme theme = this.loadXmlEditorTheme();
        ArrayList<String> xmlContent = new ArrayList<String>();
        ArrayList<String> xmlNames = new ArrayList<String>();
        ArrayList<ResourceFile> xmlFiles = new ArrayList<ResourceFile>();
        this.loadSkinSources(xmlContent, xmlNames, xmlFiles);
        this.editors = new ArrayList<RSyntaxTextArea>(xmlContent.size());
        for (int i = 0; i < xmlContent.size(); ++i) {
            WebPanel tabContent = new WebPanel();
            tabContent.add((Component)new TabContentSeparator(), (Object)"North");
            tabContent.add((Component)this.createSingleXmlEditor(theme, (String)xmlContent.get(i), (ResourceFile)xmlFiles.get(i)), (Object)"Center");
            editorTabs.addTab((String)xmlNames.get(i), tabContent);
            editorTabs.setIconAt(i, tabIcon);
        }
        this.split.setRightComponent(this.editorsContainer);
    }

    private RTextScrollPane createSingleXmlEditor(Theme theme, String xml, final ResourceFile xmlFile) {
        final RUndoManager[] xmlEditorHistory = new RUndoManager[1];
        final RSyntaxTextArea xmlEditor = new RSyntaxTextArea(){

            @Override
            protected RUndoManager createUndoManager() {
                xmlEditorHistory[0] = super.createUndoManager();
                xmlEditorHistory[0].setLimit(50);
                return xmlEditorHistory[0];
            }
        };
        xmlEditor.setSyntaxEditingStyle("text/xml");
        xmlEditor.setMargin(new Insets(0, 5, 0, 0));
        xmlEditor.setAntiAliasingEnabled(true);
        xmlEditor.setUseFocusableTips(true);
        xmlEditor.setTabSize(4);
        xmlEditor.setCodeFoldingEnabled(true);
        xmlEditor.setPaintTabLines(false);
        xmlEditor.setWhitespaceVisible(false);
        xmlEditor.setEOLMarkersVisible(false);
        xmlEditor.setText(xml);
        xmlEditor.setCaretPosition(0);
        xmlEditor.setHyperlinksEnabled(true);
        xmlEditor.setLinkGenerator(new CodeLinkGenerator(xmlEditor));
        HotkeyManager.registerHotkey((Component)xmlEditor, xmlEditor, Hotkey.CTRL_SHIFT_Z, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                xmlEditor.undoLastAction();
            }
        });
        RTextScrollPane xmlEditorScroll = new RTextScrollPane(xmlEditor);
        xmlEditorScroll.setVerticalScrollBarPolicy(22);
        ((WebScrollPaneUI)xmlEditorScroll.getUI()).setDrawBorder(false);
        ((WebPanelUI)xmlEditorScroll.getGutter().getUI()).setStyleId("editor-gutter");
        theme.apply(xmlEditor);
        xmlEditorHistory[0].discardAllEdits();
        xmlEditor.getDocument().addDocumentListener(new DocumentChangeListener(){
            private final WebTimer updateTimer;
            {
                this.updateTimer = new WebTimer((long)StyleEditor.this.updateDelay, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TimeUtils.pinTime();
                        SkinInfoConverter.addCustomResource(xmlFile.getClassName(), xmlFile.getSource(), xmlEditor.getText());
                        StyleEditor.this.applySkin();
                        TimeUtils.showPassedTime("Time to apply skin: ");
                    }
                }).setRepeats(false);
            }

            @Override
            public void documentChanged(DocumentEvent e) {
                this.updateTimer.restart(StyleEditor.this.updateDelay);
            }
        });
        this.editors.add(xmlEditor);
        return xmlEditorScroll;
    }

    private void loadSkinSources(List<String> xmlContent, List<String> xmlNames, List<ResourceFile> xmlFiles) {
        ArrayList<ResourceFile> resources = new ArrayList<ResourceFile>();
        resources.add(this.baseSkinFile);
        while (resources.size() > 0) {
            try {
                this.loadFirstResource(resources, xmlContent, xmlNames, xmlFiles);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadFirstResource(List<ResourceFile> resources, List<String> xmlContent, List<String> xmlNames, List<ResourceFile> xmlFiles) throws IOException {
        ResourceFile rf = resources.get(0);
        Source xmlSource = new Source(ReflectUtils.getClassSafely(rf.getClassName()).getResource(rf.getSource()));
        xmlSource.fullSequentialParse();
        Element baseClassTag = xmlSource.getFirstElement("class");
        String baseClass = baseClassTag != null ? baseClassTag.getContent().toString() : null;
        for (Element includeTag : xmlSource.getAllElements("include")) {
            String includeClass = includeTag.getAttributeValue("nearClass");
            String finalClass = includeClass != null ? includeClass : baseClass;
            String src = includeTag.getContent().toString();
            resources.add(new ResourceFile(ResourceLocation.nearClass, src, finalClass));
        }
        xmlContent.add(xmlSource.toString());
        xmlNames.add(new File(rf.getSource()).getName());
        xmlFiles.add(rf);
        resources.remove(0);
    }

    private Theme loadXmlEditorTheme() {
        try {
            return Theme.load(StyleEditor.class.getResourceAsStream("resources/XmlEditorTheme.xml"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void applySkin() {
        try {
            long time = System.currentTimeMillis();
            StyleManager.applySkin(new CustomSkin((SkinInfo)XmlUtils.fromXML(this.editors.get(0).getText())));
            this.componentViewer.revalidate();
            time = System.currentTimeMillis() - time;
            this.statusMessage.setIcon(ok);
            this.statusMessage.setText("Style updated succesfully within " + time + " ms");
        }
        catch (ConversionException ex) {
            Log.error((Object)this, "Unable to update skin: " + ex.getMessage());
            this.statusMessage.setIcon(error);
            this.statusMessage.setText("Fix syntax problems within the XML to update styling");
        }
        catch (Throwable ex) {
            Log.error(this, "Unable to update skin: " + ex.getMessage(), ex);
            this.statusMessage.setIcon(error);
            this.statusMessage.setText("Fix syntax problems within the XML to update styling");
        }
    }

    private void initializeMagnifier(WebToggleButton button) {
        final WebGlassPane glassPane = GlassPaneManager.getGlassPane(this);
        final JLayeredPane zoomProvider = SwingUtils.getRootPane(this).getLayeredPane();
        button.addActionListener(new ActionListener(){
            private boolean visible = false;
            private AWTEventListener listener;
            private WebTimer forceUpdater;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.performAction();
            }

            protected void performAction() {
                if (!this.visible) {
                    this.visible = true;
                    if (this.forceUpdater == null || this.listener == null) {
                        this.forceUpdater = new WebTimer(200L, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                this.updateMagnifier();
                            }
                        });
                        this.listener = new AWTEventListener(){

                            @Override
                            public void eventDispatched(AWTEvent event) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (visible) {
                                            forceUpdater.restart();
                                            this.updateMagnifier();
                                        }
                                    }
                                });
                            }
                        };
                    }
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 32L);
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 131072L);
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 16L);
                    this.updateMagnifier();
                    StyleEditor.this.setCursor(SystemUtils.getTransparentCursor());
                } else {
                    this.visible = false;
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
                    this.forceUpdater.stop();
                    this.hideMagnifier();
                    StyleEditor.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            protected void updateMagnifier() {
                Point mp = MouseInfo.getPointerInfo().getLocation();
                Rectangle gb = SwingUtils.getBoundsOnScreen(glassPane);
                if (gb.contains(mp)) {
                    Point gp = gb.getLocation();
                    int mx = mp.x - gp.x - magnifier.getWidth() / 2;
                    int my = mp.y - gp.y - magnifier.getHeight() / 2;
                    int w = 162 / StyleEditor.this.zoomFactor;
                    BufferedImage image = ImageUtils.createCompatibleImage(w, w, 3);
                    Graphics2D g2d = image.createGraphics();
                    g2d.translate(-(mp.x - gp.x - w / 2), -(mp.y - gp.y - w / 2));
                    zoomProvider.paintAll(g2d);
                    g2d.dispose();
                    BufferedImage finalImage = ImageUtils.createCompatibleImage(220, 220, 3);
                    Graphics2D g = finalImage.createGraphics();
                    g.setClip(new Ellipse2D.Double(29.0, 29.0, 162.0, 162.0));
                    g.drawImage(image, 29, 29, 162, 162, null);
                    g.setClip(null);
                    g.drawImage((Image)magnifier, 0, 0, null);
                    g.dispose();
                    glassPane.setPaintedImage(finalImage, new Point(mx, my));
                } else {
                    this.hideMagnifier();
                }
            }

            protected void hideMagnifier() {
                glassPane.setPaintedImage(null, null);
            }
        });
    }

    public static void main(String[] args) {
        StyleManager.setDefaultSkin(StyleEditorSkin.class.getCanonicalName());
        WebLookAndFeel.install();
        ResourceFile skin = new ResourceFile(ResourceLocation.nearClass, "resources/StyleEditorSkin.xml", StyleEditorSkin.class);
        StyleEditor styleEditor = new StyleEditor(skin);
        styleEditor.setVisible(true);
    }

    private class TabContentSeparator
    extends JComponent {
        private TabContentSeparator() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(new Color(237, 237, 237));
            g.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            g.setColor(StyleConstants.darkBorderColor);
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(0, 4);
        }
    }
}

