/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.checkbox.CheckState;
import com.alee.extended.tree.CheckStateChange;
import com.alee.extended.tree.CheckStateChangeListener;
import com.alee.extended.tree.TreeCheckingModel;
import com.alee.extended.tree.WebCheckBoxTree;
import com.alee.laf.tree.TreeUtils;
import com.alee.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultTreeCheckingModel<E extends DefaultMutableTreeNode>
implements TreeCheckingModel<E> {
    protected WebCheckBoxTree<E> checkBoxTree;
    protected Map<E, CheckState> nodeCheckStates = new WeakHashMap<E, CheckState>();
    protected List<CheckStateChangeListener<E>> checkStateChangeListeners = new ArrayList<CheckStateChangeListener<E>>(1);

    public DefaultTreeCheckingModel(WebCheckBoxTree<E> checkBoxTree) {
        this.checkBoxTree = checkBoxTree;
    }

    public WebCheckBoxTree<E> getCheckBoxTree() {
        return this.checkBoxTree;
    }

    public void setCheckBoxTree(WebCheckBoxTree<E> checkBoxTree) {
        this.nodeCheckStates.clear();
        this.checkBoxTree = checkBoxTree;
    }

    @Override
    public List<E> getCheckedNodes(boolean optimize) {
        return this.getAllNodesForState(CheckState.checked, optimize);
    }

    @Override
    public List<E> getMixedNodes() {
        return this.getAllNodesForState(CheckState.mixed, false);
    }

    protected List<E> getAllNodesForState(CheckState state, boolean optimize) {
        ArrayList<E> checkedNodes = new ArrayList<E>(this.nodeCheckStates.size());
        for (Map.Entry<E, CheckState> entry : this.nodeCheckStates.entrySet()) {
            if (entry.getValue() != state) continue;
            checkedNodes.add(entry.getKey());
        }
        if (optimize) {
            TreeUtils.optimizeNodes(checkedNodes);
        }
        return checkedNodes;
    }

    @Override
    public void setChecked(Collection<E> nodes, boolean checked) {
        boolean collectChanges = this.checkStateChangeListeners.size() > 0;
        ArrayList<CheckStateChange<E>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<E>>(nodes.size());
        }
        ArrayList toUpdate = new ArrayList();
        for (DefaultMutableTreeNode node : nodes) {
            this.setCheckedImpl(node, checked, toUpdate, changes);
        }
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    @Override
    public CheckState getCheckState(E node) {
        CheckState checkState = this.nodeCheckStates.get(node);
        return checkState != null ? checkState : CheckState.unchecked;
    }

    @Override
    public void setChecked(E node, boolean checked) {
        boolean collectChanges = this.checkStateChangeListeners.size() > 0;
        ArrayList<CheckStateChange<E>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<E>>(1);
        }
        ArrayList toUpdate = new ArrayList();
        this.setCheckedImpl(node, checked, toUpdate, changes);
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    protected void setCheckedImpl(E node, boolean checked, List<E> toUpdate, List<CheckStateChange<E>> changes) {
        CheckState newState;
        CheckState oldState = this.getCheckState(node);
        CheckState checkState = newState = checked ? CheckState.checked : CheckState.unchecked;
        if (oldState != newState) {
            this.updateNodeState(node, newState, toUpdate);
            if (changes != null) {
                changes.add(new CheckStateChange<E>(node, oldState, newState));
            }
            if (this.checkBoxTree.isRecursiveCheckingEnabled()) {
                this.updateChildNodesState(node, newState, toUpdate, changes);
                this.updateParentStates(node, toUpdate, changes);
            }
        }
    }

    protected void updateParentStates(E node, List<E> toUpdate, List<CheckStateChange<E>> changes) {
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            CheckState oldState;
            CheckState state = CheckState.unchecked;
            boolean hasChecked = false;
            boolean hasUnchecked = false;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                CheckState checkState = this.getCheckState((DefaultMutableTreeNode)parent.getChildAt(i));
                if (checkState == CheckState.mixed) {
                    state = CheckState.mixed;
                    break;
                }
                if (checkState == CheckState.checked) {
                    hasChecked = true;
                    if (hasUnchecked) {
                        state = CheckState.mixed;
                        break;
                    }
                    state = CheckState.checked;
                    continue;
                }
                if (checkState != CheckState.unchecked) continue;
                hasUnchecked = true;
                if (hasChecked) {
                    state = CheckState.mixed;
                    break;
                }
                state = CheckState.unchecked;
            }
            if ((oldState = this.getCheckState(parent)) == state) continue;
            if (changes != null) {
                changes.add(new CheckStateChange<DefaultMutableTreeNode>(parent, oldState, state));
            }
            this.updateNodeState(parent, state, toUpdate);
        }
    }

    protected void updateChildNodesState(E node, CheckState newState, List<E> toUpdate, List<CheckStateChange<E>> changes) {
        for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i);
            if (changes != null) {
                changes.add(new CheckStateChange<DefaultMutableTreeNode>(childNode, this.getCheckState(childNode), newState));
            }
            this.updateNodeState(childNode, newState, toUpdate);
            this.updateChildNodesState(childNode, newState, toUpdate, changes);
        }
    }

    protected void updateNodeState(E node, CheckState newState, List<E> toUpdate) {
        if (newState != CheckState.unchecked) {
            this.nodeCheckStates.put(node, newState);
        } else {
            this.nodeCheckStates.remove(node);
        }
        toUpdate.add(node);
    }

    @Override
    public void invertCheck(E node) {
        boolean collectChanges = this.checkStateChangeListeners.size() > 0;
        ArrayList<CheckStateChange<E>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<E>>(1);
        }
        ArrayList toUpdate = new ArrayList();
        this.setCheckedImpl(node, this.getNextState(this.getCheckState(node)) == CheckState.checked, toUpdate, changes);
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void invertCheck(Collection<E> nodes) {
        boolean collectChanges = this.checkStateChangeListeners.size() > 0;
        ArrayList<CheckStateChange<E>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<E>>(nodes.size());
        }
        ArrayList toUpdate = new ArrayList();
        boolean check = false;
        for (DefaultMutableTreeNode node : nodes) {
            if (this.getCheckState(node) == CheckState.checked) continue;
            check = true;
            break;
        }
        for (DefaultMutableTreeNode node : nodes) {
            this.setCheckedImpl(node, check, toUpdate, changes);
        }
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void uncheckAll() {
        ArrayList<CheckStateChange<CheckStateChange<DefaultMutableTreeNode>>> changes = null;
        if (this.checkStateChangeListeners.size() > 0) {
            changes = new ArrayList<CheckStateChange<CheckStateChange<DefaultMutableTreeNode>>>(this.nodeCheckStates.size());
            for (Map.Entry<E, CheckState> entry : this.nodeCheckStates.entrySet()) {
                CheckState state = entry.getValue();
                if (state != CheckState.mixed && state != CheckState.checked) continue;
                changes.add(new CheckStateChange<DefaultMutableTreeNode>((DefaultMutableTreeNode)entry.getKey(), state, CheckState.unchecked));
            }
        }
        this.nodeCheckStates.clear();
        this.repaintVisibleTreeRect();
        this.fireCheckStateChanged(changes);
    }

    @Override
    public void checkAll() {
        List allNodes = this.checkBoxTree.getAllNodes();
        ArrayList<CheckStateChange<CheckStateChange<DefaultMutableTreeNode>>> changes = null;
        if (this.checkStateChangeListeners.size() > 0) {
            changes = new ArrayList<CheckStateChange<CheckStateChange<DefaultMutableTreeNode>>>(allNodes.size());
            for (DefaultMutableTreeNode node : allNodes) {
                CheckState state = this.getCheckState(node);
                if (state == CheckState.checked) continue;
                changes.add(new CheckStateChange<DefaultMutableTreeNode>(node, state, CheckState.checked));
            }
        }
        for (DefaultMutableTreeNode node : allNodes) {
            this.nodeCheckStates.put(node, CheckState.checked);
        }
        this.repaintVisibleTreeRect();
        this.fireCheckStateChanged(changes);
    }

    protected CheckState getNextState(CheckState checkState) {
        switch (checkState) {
            case unchecked: {
                return CheckState.checked;
            }
            case checked: {
                return CheckState.unchecked;
            }
            case mixed: {
                return this.checkBoxTree.isCheckMixedOnToggle() ? CheckState.checked : CheckState.unchecked;
            }
        }
        return CheckState.unchecked;
    }

    @Override
    public void checkingModeChanged(boolean recursive) {
        boolean collectChanges = this.checkStateChangeListeners.size() > 0;
        ArrayList<CheckStateChange<CheckStateChange<DefaultMutableTreeNode>>> changes = null;
        if (collectChanges) {
            changes = new ArrayList<CheckStateChange<CheckStateChange<DefaultMutableTreeNode>>>();
        }
        ArrayList<DefaultMutableTreeNode> toUpdate = new ArrayList<DefaultMutableTreeNode>();
        if (recursive) {
            ArrayList<E> checked = new ArrayList<E>(this.nodeCheckStates.size());
            for (Map.Entry<E, CheckState> entry : this.nodeCheckStates.entrySet()) {
                if (entry.getValue() != CheckState.checked) continue;
                checked.add(entry.getKey());
            }
            this.filterOutChildNodes(checked);
            for (DefaultMutableTreeNode node : checked) {
                this.updateParentStates(node, toUpdate, changes);
                this.updateChildNodesState(node, CheckState.checked, toUpdate, changes);
            }
        } else {
            Iterator<Map.Entry<E, CheckState>> iterator = this.nodeCheckStates.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<E, CheckState> entry = iterator.next();
                if (entry.getValue() != CheckState.mixed) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)entry.getKey();
                toUpdate.add(node);
                iterator.remove();
                if (changes == null) continue;
                changes.add(new CheckStateChange<DefaultMutableTreeNode>(node, CheckState.mixed, CheckState.unchecked));
            }
        }
        this.repaintTreeNodes(toUpdate);
        this.fireCheckStateChanged(changes);
    }

    protected void filterOutChildNodes(List<E> nodes) {
        Iterator<E> checkedIterator = nodes.iterator();
        block0: while (checkedIterator.hasNext()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)checkedIterator.next();
            for (DefaultMutableTreeNode otherNode : nodes) {
                if (!this.isChildNode(node, otherNode)) continue;
                checkedIterator.remove();
                continue block0;
            }
        }
    }

    protected boolean isChildNode(E node, E childOf) {
        if (node == childOf) {
            return false;
        }
        if (childOf == null) {
            return true;
        }
        for (TreeNode parent = ((DefaultMutableTreeNode)node).getParent(); parent != null; parent = parent.getParent()) {
            if (parent != childOf) continue;
            return true;
        }
        return false;
    }

    protected void repaintVisibleTreeRect() {
        this.checkBoxTree.repaint(this.checkBoxTree.getVisibleRect());
    }

    protected void repaintTreeNodes(List<E> nodes) {
        this.checkBoxTree.repaint(nodes);
    }

    @Override
    public void addCheckStateChangeListener(CheckStateChangeListener listener) {
        this.checkStateChangeListeners.add(listener);
    }

    @Override
    public void removeCheckStateChangeListener(CheckStateChangeListener listener) {
        this.checkStateChangeListeners.remove(listener);
    }

    public void fireCheckStateChanged(List<CheckStateChange<E>> stateChanges) {
        if (stateChanges != null) {
            for (CheckStateChangeListener<E> listener : CollectionUtils.copy(this.checkStateChangeListeners)) {
                listener.checkStateChanged(stateChanges);
            }
        }
    }
}

