/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tree;

import com.alee.extended.image.WebImage;
import com.alee.extended.tree.FileTreeNode;
import com.alee.laf.text.WebTextField;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.utils.FileUtils;
import com.alee.utils.swing.WebDefaultCellEditor;
import java.io.File;
import javax.swing.text.JTextComponent;

public class WebFileTreeCellEditor
extends WebTreeCellEditor<WebTextField> {
    public WebFileTreeCellEditor() {
        this.clickCountToStart = 3;
        this.autoUpdateLeadingIcon = false;
        this.delegate = new FileNameEditorDelegate();
    }

    protected class FileNameEditorDelegate
    extends WebDefaultCellEditor.EditorDelegate<FileTreeNode> {
        protected FileNameEditorDelegate() {
            super(WebFileTreeCellEditor.this);
        }

        @Override
        public void setValue(FileTreeNode value) {
            File file = value.getFile();
            ((WebTextField)WebFileTreeCellEditor.this.editorComponent).setLeadingComponent(new WebImage(FileUtils.getFileIcon(file)));
            FileUtils.displayFileName((JTextComponent)WebFileTreeCellEditor.this.editorComponent, file);
            super.setValue(value);
        }

        @Override
        public boolean stopCellEditing() {
            File file = ((FileTreeNode)this.value).getFile();
            String newName = ((WebTextField)WebFileTreeCellEditor.this.editorComponent).getText();
            if (!newName.equals(file.getName())) {
                File renamed = new File(file.getParent(), newName);
                if (file.renameTo(renamed)) {
                    ((FileTreeNode)this.value).setFile(renamed);
                }
                return super.stopCellEditing();
            }
            super.cancelCellEditing();
            return true;
        }
    }
}

