/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.global.StyleConstants;
import com.alee.laf.desktoppane.WebInternalFrameTitlePane;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class WebInternalFrameUI
extends BasicInternalFrameUI {
    protected int sideSpacing = 1;
    protected FocusTracker focusTracker;
    protected boolean focused = false;

    public WebInternalFrameUI(JInternalFrame b) {
        super(b);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WebInternalFrameUI((JInternalFrame)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.frame);
        LookAndFeel.installProperty(this.frame, "opaque", Boolean.FALSE);
        this.frame.setBackground(new Color(90, 90, 90, 220));
        this.frame.setBorder(LafUtils.createWebBorder(0, 0, 0, 0));
        this.focusTracker = new DefaultFocusTracker(){

            @Override
            public void focusChanged(boolean focused) {
                WebInternalFrameUI.this.focused = focused;
                WebInternalFrameUI.this.frame.repaint();
            }
        };
        FocusManager.addFocusTracker(this.frame, this.focusTracker);
    }

    @Override
    public void uninstallUI(JComponent c) {
        FocusManager.removeFocusTracker(this.focusTracker);
        super.uninstallUI(c);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new WebInternalFrameTitlePane(w);
        return this.titlePane;
    }

    @Override
    protected JComponent createWestPane(JInternalFrame w) {
        return new JComponent(){
            {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(4 + WebInternalFrameUI.this.sideSpacing, 0);
            }
        };
    }

    @Override
    protected JComponent createEastPane(JInternalFrame w) {
        return new JComponent(){
            {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(4 + WebInternalFrameUI.this.sideSpacing, 0);
            }
        };
    }

    @Override
    protected JComponent createSouthPane(JInternalFrame w) {
        return new JComponent(){
            {
                this.setOpaque(false);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, 4 + WebInternalFrameUI.this.sideSpacing);
            }
        };
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Insets insets = c.getInsets();
        RoundRectangle2D.Double innerBorder = new RoundRectangle2D.Double(insets.left + 3 + this.sideSpacing, insets.top + this.titlePane.getHeight() - 1, c.getWidth() - 1 - insets.left - 3 - this.sideSpacing - insets.right - 3 - this.sideSpacing, c.getHeight() - 1 - insets.top - this.titlePane.getHeight() + 1 - insets.bottom - 3 - this.sideSpacing, (StyleConstants.bigRound - 1) * 2, (StyleConstants.bigRound - 1) * 2);
        LafUtils.drawWebStyle(g2d, c, c.isEnabled() && this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, StyleConstants.shadeWidth, StyleConstants.bigRound, true, false);
        g2d.setPaint(Color.GRAY);
        g2d.draw(innerBorder);
        GraphicsUtils.restoreAntialias(g2d, aa);
    }
}

