/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.global.GlobalConstants;
import com.alee.laf.filechooser.FileApproveText;
import com.alee.laf.filechooser.FileChooserType;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.managers.language.LanguageManager;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;

public class WebFileChooserUI
extends FileChooserUI {
    private JFileChooser fileChooser;
    private WebFileView fileView;
    private WebFileChooserPanel fileChooserPanel;
    private PropertyChangeListener propertyChangeListener;
    private boolean ignoreFileSelectionChanges = false;

    public static ComponentUI createUI(JComponent c) {
        return new WebFileChooserUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.fileChooser = (JFileChooser)c;
        this.fileView = new WebFileView();
        this.fileChooser.setLayout(new BorderLayout());
        this.fileChooser.setBorder(LafUtils.createWebBorder(0, 0, 0, 0));
        this.fileChooserPanel = new WebFileChooserPanel(this.getFileChooserType(), this.fileChooser.getControlButtonsAreShown());
        this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        this.fileChooserPanel.setShowHiddenFiles(!this.fileChooser.isFileHidingEnabled());
        this.fileChooserPanel.setApproveListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                List<File> selectedFiles = WebFileChooserUI.this.fileChooserPanel.getSelectedFiles();
                WebFileChooserUI.this.fileChooser.setSelectedFiles(selectedFiles.toArray(new File[selectedFiles.size()]));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
                WebFileChooserUI.this.fileChooser.approveSelection();
            }
        });
        this.fileChooserPanel.setCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebFileChooserUI.this.fileChooser.cancelSelection();
            }
        });
        this.fileChooser.add((Component)this.fileChooserPanel, "Center");
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebFileChooserUI.this.propertyChanged(evt);
            }
        };
        this.fileChooser.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.fileChooser.removePropertyChangeListener(this.propertyChangeListener);
        this.fileChooserPanel = null;
        this.fileChooser = null;
        this.fileView = null;
    }

    public WebFileChooserPanel getFileChooserPanel() {
        return this.fileChooserPanel;
    }

    public List<AbstractFileFilter> getAvailableFilters() {
        return this.fileChooserPanel.getAvailableFilters();
    }

    public AbstractFileFilter getActiveFileFilter() {
        return this.fileChooserPanel.getActiveFileFilter();
    }

    public boolean isGenerateThumbnails() {
        return this.fileChooserPanel.isGenerateThumbnails();
    }

    public void setGenerateThumbnails(boolean generate) {
        this.fileChooserPanel.setGenerateThumbnails(generate);
    }

    public void setApproveButtonText(FileApproveText approveText) {
        this.fileChooserPanel.setApproveButtonText(approveText);
    }

    public void setApproveButtonLanguage(String key) {
        this.fileChooserPanel.setApproveButtonLanguage(key);
    }

    protected void propertyChanged(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop.equals("ApproveButtonTextChangedProperty")) {
            this.fileChooserPanel.setApproveButtonText(this.fileChooser.getApproveButtonText());
        } else if (prop.equals("ControlButtonsAreShownChangedProperty")) {
            this.fileChooserPanel.setShowControlButtons(this.fileChooser.getControlButtonsAreShown());
        } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
            this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        } else if (prop.equals("fileFilterChanged") || prop.equals("ChoosableFileFilterChangedProperty") || prop.equals("acceptAllFileFilterUsedChanged")) {
            FileFilter filter = this.fileChooser.getFileFilter();
            FileFilter[] filters = this.fileChooser.getChoosableFileFilters();
            int initialCapacity = (filters != null ? filters.length : 0) + (filter != null ? 1 : 0);
            ArrayList<FileFilter> collected = new ArrayList<FileFilter>(initialCapacity);
            if (filter != null) {
                collected.add(filter);
            }
            if (filters != null && filters.length > 0) {
                for (FileFilter fileFilter : filters) {
                    if (collected.contains(fileFilter)) continue;
                    collected.add(fileFilter);
                }
            }
            if (collected.size() > 0) {
                this.fileChooserPanel.setFileFilters(collected.toArray(new FileFilter[collected.size()]));
            } else {
                this.fileChooserPanel.setFileFilter(GlobalConstants.ALL_FILES_FILTER);
            }
        } else if (prop.equals("directoryChanged")) {
            if (!this.ignoreFileSelectionChanges) {
                this.fileChooserPanel.setCurrentFolder(this.fileChooser.getCurrentDirectory());
            }
        } else if (prop.equals("SelectedFileChangedProperty")) {
            if (!this.ignoreFileSelectionChanges) {
                File[] selectedFiles = this.fileChooser.getSelectedFiles();
                if (selectedFiles.length > 0) {
                    this.fileChooserPanel.setSelectedFiles(selectedFiles);
                } else {
                    this.fileChooserPanel.setSelectedFile(this.fileChooser.getSelectedFile());
                }
            }
        } else if (prop.equals("DialogTypeChangedProperty")) {
            this.fileChooserPanel.setChooserType(this.getFileChooserType());
        } else if (prop.equals("FileHidingChanged")) {
            this.fileChooserPanel.setShowHiddenFiles(!this.fileChooser.isFileHidingEnabled());
        } else if (prop.equals("fileSelectionChanged")) {
            this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        } else if (prop.equals("componentOrientation")) {
            this.fileChooserPanel.applyComponentOrientation(this.fileChooser.getComponentOrientation());
        }
    }

    @Override
    public FileFilter getAcceptAllFileFilter(JFileChooser fc) {
        return GlobalConstants.ALL_FILES_FILTER;
    }

    @Override
    public FileView getFileView(JFileChooser fc) {
        return this.fileView;
    }

    public void setFileView(WebFileView fileView) {
        this.fileView = fileView;
    }

    @Override
    public String getApproveButtonText(JFileChooser fc) {
        return this.fileChooserPanel.getApproveButtonText();
    }

    @Override
    public String getDialogTitle(JFileChooser fc) {
        String dialogTitle = fc.getDialogTitle();
        return dialogTitle != null ? dialogTitle : LanguageManager.get("weblaf.filechooser.title");
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.fileChooserPanel.reloadCurrentFolder();
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    public FileChooserType getFileChooserType() {
        if (this.fileChooser.getDialogType() == 1) {
            return FileChooserType.save;
        }
        if (this.fileChooser.getDialogType() == 0) {
            return FileChooserType.open;
        }
        return FileChooserType.custom;
    }

    protected class WebFileView
    extends FileView {
        @Override
        public String getName(File f) {
            return FileUtils.getDisplayFileName(f);
        }

        @Override
        public String getDescription(File f) {
            return this.getTypeDescription(f);
        }

        @Override
        public String getTypeDescription(File f) {
            return FileUtils.getFileTypeDescription(f);
        }

        @Override
        public Icon getIcon(File f) {
            return FileUtils.getFileIcon(f);
        }
    }
}

