/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.label;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.laf.label.AdaptiveLabelPainter;
import com.alee.laf.label.LabelPainter;
import com.alee.laf.label.WebLabelStyle;
import com.alee.managers.style.StyleManager;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class WebLabelUI
extends BasicLabelUI
implements Styleable,
BorderMethods {
    protected Insets margin = WebLabelStyle.margin;
    protected boolean drawShade = WebLabelStyle.drawShade;
    protected LabelPainter painter;
    protected PropertyChangeListener propertyChangeListener;
    protected String styleId = null;
    protected JLabel label;

    public static ComponentUI createUI(JComponent c) {
        return new WebLabelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.label = (JLabel)c;
        SwingUtils.setOrientation(this.label);
        StyleManager.applySkin(this.label);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebLabelUI.this.updateBorder();
            }
        };
        this.label.addPropertyChangeListener("componentOrientation", this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.label.removePropertyChangeListener("componentOrientation", this.propertyChangeListener);
        StyleManager.removeSkin(this.label);
        this.label = null;
        super.uninstallUI(c);
    }

    @Override
    public String getStyleId() {
        return this.styleId;
    }

    @Override
    public void setStyleId(String id) {
        this.styleId = id;
        StyleManager.applySkin(this.label);
    }

    @Override
    public void updateBorder() {
        LafUtils.updateBorder(this.label, this.margin, this.painter);
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
        if (this.painter != null) {
            this.painter.setDrawShade(drawShade);
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        this.margin = margin;
        this.updateBorder();
    }

    public Color getShadeColor() {
        Color shadeColor = (Color)StyleManager.getPainterPropertyValue(this.label, "shadeColor");
        return shadeColor != null ? shadeColor : WebLabelStyle.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        StyleManager.setCustomPainterProperty(this.label, "shadeColor", shadeColor);
    }

    public Float getTransparency() {
        Float transparency = (Float)StyleManager.getPainterPropertyValue(this.label, "transparency");
        return transparency != null ? transparency : WebLabelStyle.transparency;
    }

    public void setTransparency(Float transparency) {
        StyleManager.setCustomPainterProperty(this.label, "transparency", transparency);
    }

    public Painter getPainter() {
        return LafUtils.getAdaptedPainter(this.painter);
    }

    public void setPainter(Painter painter) {
        LabelPainter properPainter = (LabelPainter)LafUtils.getProperPainter(painter, LabelPainter.class, AdaptiveLabelPainter.class);
        PainterSupport.uninstallPainter(this.label, this.painter);
        LabelPainter oldPainter = this.painter;
        this.painter = properPainter;
        this.applyPainterSettings(properPainter);
        PainterSupport.installPainter(this.label, properPainter);
        LafUtils.firePainterChanged(this.label, oldPainter, properPainter);
    }

    private void applyPainterSettings(LabelPainter painter) {
        if (painter != null) {
            painter.setDrawShade(this.drawShade);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension ps;
        if (this.painter != null) {
            ps = this.painter.getPreferredSize(c);
            if (c.getLayout() != null) {
                ps = SwingUtils.max(ps, c.getLayout().preferredLayoutSize(c));
            }
        } else {
            ps = new Dimension(0, 0);
        }
        return ps;
    }
}

