/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.panel;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PartialDecoration;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.panel.WebPanelUI;
import com.alee.managers.language.LanguageContainerMethods;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.style.StyleManager;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SizeUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.laf.Styleable;
import com.alee.utils.swing.SizeMethods;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;
import javax.swing.JPanel;

public class WebPanel
extends JPanel
implements Styleable,
ShapeProvider,
PartialDecoration,
SizeMethods<WebPanel>,
LanguageContainerMethods {
    public WebPanel() {
        super(new BorderLayout());
    }

    public WebPanel(boolean decorated) {
        super(new BorderLayout());
        this.setUndecorated(!decorated);
    }

    public WebPanel(boolean decorated, LayoutManager layout) {
        super(layout);
        this.setUndecorated(!decorated);
    }

    public WebPanel(boolean decorated, Component component) {
        super(new BorderLayout());
        this.setUndecorated(!decorated);
        this.add(component, (Object)"Center");
    }

    public WebPanel(Component component) {
        super(new BorderLayout());
        this.add(component, (Object)"Center");
    }

    public WebPanel(Painter painter) {
        super(new BorderLayout());
        this.setPainter(painter);
    }

    public WebPanel(LayoutManager layout, Painter painter) {
        super(layout);
        this.setPainter(painter);
    }

    public WebPanel(Painter painter, Component component) {
        super(new BorderLayout());
        this.setPainter(painter);
        this.add(component, (Object)"Center");
    }

    public WebPanel(LayoutManager layout, Painter painter, Component ... components) {
        super(layout);
        this.setPainter(painter);
        this.add(components);
    }

    public WebPanel(LayoutManager layout) {
        super(layout);
    }

    public WebPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public WebPanel(LayoutManager layout, Component ... components) {
        super(layout);
        this.add(components);
    }

    public WebPanel(String styleId) {
        super(new BorderLayout());
        this.setStyleId(styleId);
    }

    public WebPanel(String styleId, LayoutManager layout) {
        super(layout);
        this.setStyleId(styleId);
    }

    public WebPanel(String styleId, Component component) {
        super(new BorderLayout());
        this.setStyleId(styleId);
        this.add(component, (Object)"Center");
    }

    public WebPanel add(List<? extends Component> components, int index) {
        if (components != null) {
            int skipped = 0;
            for (int i = 0; i < components.size(); ++i) {
                Component component = components.get(i);
                if (component != null) {
                    this.add(component, index + i - skipped);
                    continue;
                }
                ++skipped;
            }
        }
        return this;
    }

    public WebPanel add(List<? extends Component> components, String constraints) {
        if (components != null) {
            for (Component component : components) {
                if (component == null) continue;
                this.add(component, (Object)constraints);
            }
        }
        return this;
    }

    public WebPanel add(List<? extends Component> components) {
        if (components != null) {
            for (Component component : components) {
                if (component == null) continue;
                this.add(component);
            }
        }
        return this;
    }

    public WebPanel add(int index, Component ... components) {
        if (components != null && components.length > 0) {
            int skipped = 0;
            for (int i = 0; i < components.length; ++i) {
                Component component = components[i];
                if (component != null) {
                    this.add(component, index + i - skipped);
                    continue;
                }
                ++skipped;
            }
        }
        return this;
    }

    public WebPanel add(String constraints, Component ... components) {
        if (components != null && components.length > 0) {
            for (Component component : components) {
                if (component == null) continue;
                this.add(component, (Object)constraints);
            }
        }
        return this;
    }

    public WebPanel add(Component ... components) {
        if (components != null && components.length > 0) {
            for (Component component : components) {
                if (component == null) continue;
                this.add(component);
            }
        }
        return this;
    }

    public Component getFirstComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public Component getLastComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(this.getComponentCount() - 1);
        }
        return null;
    }

    public boolean isUndecorated() {
        return this.getWebUI().isUndecorated();
    }

    public WebPanel setUndecorated(boolean undecorated) {
        this.getWebUI().setUndecorated(undecorated);
        return this;
    }

    public boolean isPaintFocus() {
        return this.getWebUI().isPaintFocus();
    }

    public WebPanel setPaintFocus(boolean paint) {
        this.getWebUI().setPaintFocus(paint);
        return this;
    }

    public Insets getMargin() {
        return this.getWebUI().getMargin();
    }

    public void setMargin(Insets margin) {
        this.getWebUI().setMargin(margin);
    }

    public WebPanel setMargin(int top, int left, int bottom, int right) {
        this.setMargin(new Insets(top, left, bottom, right));
        return this;
    }

    public WebPanel setMargin(int spacing) {
        return this.setMargin(spacing, spacing, spacing, spacing);
    }

    public boolean isPaintTop() {
        return this.getWebUI().isPaintTop();
    }

    @Override
    public void setPaintTop(boolean top) {
        this.getWebUI().setPaintTop(top);
    }

    public boolean isPaintLeft() {
        return this.getWebUI().isPaintLeft();
    }

    @Override
    public void setPaintLeft(boolean left) {
        this.getWebUI().setPaintLeft(left);
    }

    public boolean isPaintBottom() {
        return this.getWebUI().isPaintBottom();
    }

    @Override
    public void setPaintBottom(boolean bottom) {
        this.getWebUI().setPaintBottom(bottom);
    }

    public boolean isPaintRight() {
        return this.getWebUI().isPaintRight();
    }

    @Override
    public void setPaintRight(boolean right) {
        this.getWebUI().setPaintRight(right);
    }

    @Override
    public void setPaintSides(boolean top, boolean left, boolean bottom, boolean right) {
        this.getWebUI().setPaintSides(top, left, bottom, right);
    }

    public boolean isPaintTopLine() {
        return this.getWebUI().isPaintTopLine();
    }

    @Override
    public void setPaintTopLine(boolean top) {
        this.getWebUI().setPaintTopLine(top);
    }

    public boolean isPaintLeftLine() {
        return this.getWebUI().isPaintLeftLine();
    }

    @Override
    public void setPaintLeftLine(boolean left) {
        this.getWebUI().setPaintLeftLine(left);
    }

    public boolean isPaintBottomLine() {
        return this.getWebUI().isPaintBottomLine();
    }

    @Override
    public void setPaintBottomLine(boolean bottom) {
        this.getWebUI().setPaintBottomLine(bottom);
    }

    public boolean isPaintRightLine() {
        return this.getWebUI().isPaintRightLine();
    }

    @Override
    public void setPaintRightLine(boolean right) {
        this.getWebUI().setPaintRightLine(right);
    }

    @Override
    public void setPaintSideLines(boolean top, boolean left, boolean bottom, boolean right) {
        this.getWebUI().setPaintSideLines(top, left, bottom, right);
    }

    public int getRound() {
        return this.getWebUI().getRound();
    }

    public WebPanel setRound(int round) {
        this.getWebUI().setRound(round);
        return this;
    }

    public int getShadeWidth() {
        return this.getWebUI().getShadeWidth();
    }

    public WebPanel setShadeWidth(int shadeWidth) {
        this.getWebUI().setShadeWidth(shadeWidth);
        return this;
    }

    public float getShadeTransparency() {
        return this.getWebUI().getShadeTransparency();
    }

    public WebPanel setShadeTransparency(float transparency) {
        this.getWebUI().setShadeTransparency(transparency);
        return this;
    }

    public Stroke getBorderStroke() {
        return this.getWebUI().getBorderStroke();
    }

    public WebPanel setBorderStroke(Stroke stroke) {
        this.getWebUI().setBorderStroke(stroke);
        return this;
    }

    public Color getBorderColor() {
        return this.getWebUI().getBorderColor();
    }

    public WebPanel setBorderColor(Color color) {
        this.getWebUI().setBorderColor(color);
        return this;
    }

    public Color getDisabledBorderColor() {
        return this.getWebUI().getDisabledBorderColor();
    }

    public WebPanel setDisabledBorderColor(Color color) {
        this.getWebUI().setDisabledBorderColor(color);
        return this;
    }

    public boolean isPaintBackground() {
        return this.getWebUI().isPaintBackground();
    }

    public WebPanel setPaintBackground(boolean paint) {
        this.getWebUI().setPaintBackground(paint);
        return this;
    }

    public boolean isWebColoredBackground() {
        return this.getWebUI().isWebColoredBackground();
    }

    public WebPanel setWebColoredBackground(boolean webColored) {
        this.getWebUI().setWebColoredBackground(webColored);
        return this;
    }

    public Painter getPainter() {
        return StyleManager.getPainter(this);
    }

    public WebPanel setPainter(Painter painter) {
        StyleManager.setCustomPainter(this, painter);
        return this;
    }

    @Override
    public String getStyleId() {
        return this.getWebUI().getStyleId();
    }

    @Override
    public void setStyleId(String id) {
        this.getWebUI().setStyleId(id);
    }

    @Override
    public Shape provideShape() {
        return this.getWebUI().provideShape();
    }

    public WebPanelUI getWebUI() {
        return (WebPanelUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebPanelUI)) {
            try {
                this.setUI((WebPanelUI)ReflectUtils.createInstance(WebLookAndFeel.panelUI, new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebPanelUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    @Override
    public int getPreferredWidth() {
        return SizeUtils.getPreferredWidth(this);
    }

    @Override
    public WebPanel setPreferredWidth(int preferredWidth) {
        return SizeUtils.setPreferredWidth(this, preferredWidth);
    }

    @Override
    public int getPreferredHeight() {
        return SizeUtils.getPreferredHeight(this);
    }

    @Override
    public WebPanel setPreferredHeight(int preferredHeight) {
        return SizeUtils.setPreferredHeight(this, preferredHeight);
    }

    @Override
    public int getMinimumWidth() {
        return SizeUtils.getMinimumWidth(this);
    }

    @Override
    public WebPanel setMinimumWidth(int minimumWidth) {
        return SizeUtils.setMinimumWidth(this, minimumWidth);
    }

    @Override
    public int getMinimumHeight() {
        return SizeUtils.getMinimumHeight(this);
    }

    @Override
    public WebPanel setMinimumHeight(int minimumHeight) {
        return SizeUtils.setMinimumHeight(this, minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = SizeUtils.getPreferredSize(this, super.getPreferredSize());
        Painter painter = this.getPainter();
        if (painter != null) {
            ps = SwingUtils.max(ps, painter.getPreferredSize(this));
        }
        return ps;
    }

    @Override
    public void setLanguageContainerKey(String key) {
        LanguageManager.registerLanguageContainer(this, key);
    }

    @Override
    public void removeLanguageContainerKey() {
        LanguageManager.unregisterLanguageContainer(this);
    }

    @Override
    public String getLanguageContainerKey() {
        return LanguageManager.getLanguageContainerKey(this);
    }
}

