/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.extended.painter.Painter;
import com.alee.extended.painter.PainterSupport;
import com.alee.global.StyleConstants;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPaneStyle;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.BorderMethods;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class WebTabbedPaneUI
extends BasicTabbedPaneUI
implements ShapeProvider,
BorderMethods {
    private TabbedPaneStyle tabbedPaneStyle = WebTabbedPaneStyle.tabbedPaneStyle;
    private Color selectedTopBg = WebTabbedPaneStyle.selectedTopBg;
    private Color selectedBottomBg = WebTabbedPaneStyle.selectedBottomBg;
    private Color topBg = WebTabbedPaneStyle.topBg;
    private Color bottomBg = WebTabbedPaneStyle.bottomBg;
    private int round = WebTabbedPaneStyle.round;
    private int shadeWidth = WebTabbedPaneStyle.shadeWidth;
    private boolean rotateTabInsets = WebTabbedPaneStyle.rotateTabInsets;
    private Insets contentInsets = WebTabbedPaneStyle.contentInsets;
    private Insets tabInsets = WebTabbedPaneStyle.tabInsets;
    private Painter painter = WebTabbedPaneStyle.painter;
    private int tabRunIndent = WebTabbedPaneStyle.tabRunIndent;
    private int tabOverlay = WebTabbedPaneStyle.tabOverlay;
    private TabStretchType tabStretchType = WebTabbedPaneStyle.tabStretchType;
    private final Map<Integer, Color> selectedForegroundAt = new HashMap<Integer, Color>();
    private final Map<Integer, Painter> backgroundPainterAt = new HashMap<Integer, Painter>();
    private FocusAdapter focusAdapter;

    public static ComponentUI createUI(JComponent c) {
        return new WebTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.tabPane);
        this.tabPane.setBackground(StyleConstants.backgroundColor);
        PainterSupport.installPainter(this.tabPane, this.painter);
        this.updateBorder();
        this.focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                WebTabbedPaneUI.this.tabPane.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addFocusListener(this.focusAdapter);
    }

    @Override
    public void uninstallUI(JComponent c) {
        PainterSupport.uninstallPainter(this.tabPane, this.painter);
        if (this.focusAdapter != null) {
            c.removeFocusListener(this.focusAdapter);
        }
        super.uninstallUI(c);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.tabPane, this.getShadeWidth(), this.getRound());
    }

    @Override
    public void updateBorder() {
        if (this.tabPane != null) {
            if (SwingUtils.isPreserveBorders(this.tabPane)) {
                return;
            }
            Insets bgInsets = this.getBackgroundInsets(this.tabPane);
            if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
                this.tabPane.setBorder(LafUtils.createWebBorder(SwingUtils.max(bgInsets, new Insets(this.shadeWidth, this.shadeWidth, this.shadeWidth, this.shadeWidth))));
            } else {
                this.tabPane.setBorder(LafUtils.createWebBorder(bgInsets));
            }
        }
    }

    private Insets getBackgroundInsets(JComponent c) {
        return this.painter != null ? this.painter.getMargin(c) : new Insets(0, 0, 0, 0);
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
    }

    public boolean isRotateTabInsets() {
        return this.rotateTabInsets;
    }

    public void setRotateTabInsets(boolean rotateTabInsets) {
        this.rotateTabInsets = rotateTabInsets;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
    }

    public Insets getContentInsets() {
        return this.contentInsets;
    }

    public void setContentInsets(Insets contentInsets) {
        this.contentInsets = contentInsets;
    }

    public Insets getTabInsets() {
        return this.tabInsets;
    }

    public void setTabInsets(Insets tabInsets) {
        this.tabInsets = tabInsets;
    }

    public Color getSelectedTopBg() {
        return this.selectedTopBg;
    }

    public void setSelectedTopBg(Color selectedTopBg) {
        this.selectedTopBg = selectedTopBg;
    }

    public Color getSelectedBottomBg() {
        return this.selectedBottomBg;
    }

    public void setSelectedBottomBg(Color selectedBottomBg) {
        this.selectedBottomBg = selectedBottomBg;
    }

    public Color getTopBg() {
        return this.topBg;
    }

    public void setTopBg(Color topBg) {
        this.topBg = topBg;
    }

    public Color getBottomBg() {
        return this.bottomBg;
    }

    public void setBottomBg(Color bottomBg) {
        this.bottomBg = bottomBg;
    }

    public void setSelectedForegroundAt(int tabIndex, Color foreground) {
        this.selectedForegroundAt.put(tabIndex, foreground);
    }

    public Color getSelectedForegroundAt(int tabIndex) {
        return this.selectedForegroundAt.get(tabIndex);
    }

    public void setBackgroundPainterAt(int tabIndex, Painter painter) {
        this.backgroundPainterAt.put(tabIndex, painter);
    }

    public Painter getBackgroundPainterAt(int tabIndex) {
        return this.backgroundPainterAt.get(tabIndex);
    }

    public TabbedPaneStyle getTabbedPaneStyle() {
        return this.tabbedPaneStyle;
    }

    public void setTabbedPaneStyle(TabbedPaneStyle tabbedPaneStyle) {
        this.tabbedPaneStyle = tabbedPaneStyle;
        this.updateBorder();
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        PainterSupport.uninstallPainter(this.tabPane, this.painter);
        this.painter = painter;
        PainterSupport.installPainter(this.tabPane, this.painter);
        this.updateBorder();
    }

    public int getTabRunIndent() {
        return this.tabRunIndent;
    }

    public void setTabRunIndent(int tabRunIndent) {
        this.tabRunIndent = tabRunIndent;
    }

    public int getTabOverlay() {
        return this.tabOverlay;
    }

    public void setTabOverlay(int tabOverlay) {
        this.tabOverlay = tabOverlay;
    }

    public TabStretchType getTabStretchType() {
        return this.tabStretchType;
    }

    public void setTabStretchType(TabStretchType tabStretchType) {
        this.tabStretchType = tabStretchType;
    }

    @Override
    protected int getTabRunIndent(int tabPlacement, int run) {
        return this.tabRunIndent;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabOverlay;
    }

    @Override
    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return !this.tabStretchType.equals((Object)TabStretchType.never) && (this.tabStretchType.equals((Object)TabStretchType.always) || this.tabStretchType.equals((Object)TabStretchType.multiline) && this.runCount > 1);
    }

    @Override
    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            Insets insets = tabPlacement == 1 ? new Insets(1, 2, 1, 2) : (tabPlacement == 3 ? new Insets(2, 2, 0, 2) : (tabPlacement == 2 ? new Insets(2, 1, 2, 1) : (tabPlacement == 4 ? new Insets(2, 2, 2, 0) : new Insets(0, 0, 0, 0))));
            insets.top += this.contentInsets.top - 1;
            insets.left += this.contentInsets.left - 1;
            insets.bottom += this.contentInsets.bottom - 1;
            insets.right += this.contentInsets.right - 1;
            return insets;
        }
        return new Insets(0, 0, 0, 0);
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets targetInsets = new Insets(0, 0, 0, 0);
        WebTabbedPaneUI.rotateInsets(this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? new Insets(tabPlacement == 4 ? 1 : 0, 1, 0, 2) : new Insets(-1, -1, 0, 0), targetInsets, tabPlacement);
        return targetInsets;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets insets = SwingUtils.copy(this.tabInsets);
        if (tabIndex == 0 && this.tabPane.getSelectedIndex() == 0) {
            --insets.left;
            ++insets.right;
        }
        if (this.rotateTabInsets) {
            Insets targetInsets = new Insets(0, 0, 0, 0);
            WebTabbedPaneUI.rotateInsets(insets, targetInsets, tabPlacement);
            return targetInsets;
        }
        return insets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        Insets targetInsets = new Insets(0, 0, 0, 0);
        WebTabbedPaneUI.rotateInsets(this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? new Insets(2, 2, 2, 1) : new Insets(0, 0, 0, 0), targetInsets, tabPlacement);
        return targetInsets;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            return super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            return super.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        }
        return 0;
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        boolean drawFocus;
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        GeneralPath borderShape = this.createTabShape(TabShapeType.border, tabPlacement, x, y, w, h, isSelected);
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            GeneralPath shadeShape = this.createTabShape(TabShapeType.shade, tabPlacement, x, y, w, h, isSelected);
            GraphicsUtils.drawShade(g2d, (Shape)shadeShape, StyleConstants.shadeColor, this.shadeWidth, new Rectangle2D.Double(0.0, 0.0, this.tabPane.getWidth(), y + h), this.round > 0);
        }
        GeneralPath bgShape = this.createTabShape(TabShapeType.background, tabPlacement, x, y, w, h, isSelected);
        if (this.backgroundPainterAt.containsKey(tabIndex) && isSelected) {
            Shape old = GraphicsUtils.intersectClip(g2d, bgShape);
            Painter bp = this.backgroundPainterAt.get(tabIndex);
            bp.paint(g2d, new Rectangle(x, y, w, h), this.tabPane);
            GraphicsUtils.restoreClip(g2d, old);
        } else {
            Point topPoint = this.getTopTabBgPoint(tabPlacement, x, y, w, h);
            Point bottomPoint = this.getBottomTabBgPoint(tabPlacement, x, y, w, h);
            if (isSelected) {
                Color bg = this.tabPane.getBackgroundAt(tabIndex);
                bg = bg != null ? bg : this.tabPane.getBackground();
                g2d.setPaint(new GradientPaint(topPoint.x, topPoint.y, this.selectedTopBg, bottomPoint.x, bottomPoint.y, bg));
            } else {
                g2d.setPaint(new GradientPaint(topPoint.x, topPoint.y, this.topBg, bottomPoint.x, bottomPoint.y, this.bottomBg));
            }
            g2d.fill(isSelected ? borderShape : bgShape);
        }
        g2d.setPaint(StyleConstants.darkBorderColor);
        g2d.draw(borderShape);
        boolean bl = drawFocus = isSelected && this.tabPane.isFocusOwner();
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            LafUtils.drawCustomWebFocus(g2d, null, StyleConstants.focusType, borderShape, null, drawFocus);
        }
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if (isSelected && fg instanceof UIResource) {
                    if (this.selectedForegroundAt.containsKey(tabIndex)) {
                        fg = this.selectedForegroundAt.get(tabIndex);
                    } else {
                        Color selectedFG = UIManager.getColor("TabbedPane.selectedForeground");
                        if (selectedFG != null) {
                            fg = selectedFG;
                        }
                    }
                }
                g.setColor(fg);
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                SwingUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }

    private GeneralPath createTabShape(TabShapeType tabShapeType, int tabPlacement, int x, int y, int w, int h, boolean isSelected) {
        Insets insets = this.tabPane.getInsets();
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.attached) && isSelected && tabPlacement == 1 && x == insets.left) {
            --x;
            ++w;
        }
        int actualRound = this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone) ? this.round : 0;
        GeneralPath bgShape = new GeneralPath(0);
        if (tabPlacement == 1) {
            bgShape.moveTo(x, y + h + this.getChange(tabShapeType));
            bgShape.lineTo(x, y + actualRound);
            bgShape.quadTo(x, y, x + actualRound, y);
            bgShape.lineTo(x + w - actualRound, y);
            bgShape.quadTo(x + w, y, x + w, y + actualRound);
            bgShape.lineTo(x + w, y + h + this.getChange(tabShapeType));
        } else if (tabPlacement == 3) {
            bgShape.moveTo(x, y - this.getChange(tabShapeType));
            bgShape.lineTo(x, y + h - actualRound);
            bgShape.quadTo(x, y + h, x + actualRound, y + h);
            bgShape.lineTo(x + w - actualRound, y + h);
            bgShape.quadTo(x + w, y + h, x + w, y + h - actualRound);
            bgShape.lineTo(x + w, y - this.getChange(tabShapeType));
        } else if (tabPlacement == 2) {
            bgShape.moveTo(x + w + this.getChange(tabShapeType), y);
            bgShape.lineTo(x + actualRound, y);
            bgShape.quadTo(x, y, x, y + actualRound);
            bgShape.lineTo(x, y + h - actualRound);
            bgShape.quadTo(x, y + h, x + actualRound, y + h);
            bgShape.lineTo(x + w + this.getChange(tabShapeType), y + h);
        } else {
            bgShape.moveTo(x - this.getChange(tabShapeType), y);
            bgShape.lineTo(x + w - actualRound, y);
            bgShape.quadTo(x + w, y, x + w, y + actualRound);
            bgShape.lineTo(x + w, y + h - actualRound);
            bgShape.quadTo(x + w, y + h, x + w - actualRound, y + h);
            bgShape.lineTo(x - this.getChange(tabShapeType), y + h);
        }
        return bgShape;
    }

    private int getChange(TabShapeType tabShapeType) {
        if (tabShapeType.equals((Object)TabShapeType.shade)) {
            return -(this.round > 0 ? this.round : 1);
        }
        if (tabShapeType.equals((Object)TabShapeType.border)) {
            return -1;
        }
        if (tabShapeType.equals((Object)TabShapeType.backgroundPainter)) {
            return 2;
        }
        return 0;
    }

    private Point getTopTabBgPoint(int tabPlacement, int x, int y, int w, int h) {
        if (tabPlacement == 1) {
            return new Point(x, y);
        }
        if (tabPlacement == 3) {
            return new Point(x, y + h);
        }
        if (tabPlacement == 2) {
            return new Point(x, y);
        }
        return new Point(x + w, y);
    }

    private Point getBottomTabBgPoint(int tabPlacement, int x, int y, int w, int h) {
        if (tabPlacement == 1) {
            return new Point(x, y + h - 4);
        }
        if (tabPlacement == 3) {
            return new Point(x, y + 4);
        }
        if (tabPlacement == 2) {
            return new Point(x + w - 4, y);
        }
        return new Point(x + 4, y);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        int tabAreaSize = this.getTabAreaLength(tabPlacement);
        Insets bi = this.tabPane.getInsets();
        if (tabPlacement == 1 || tabPlacement == 3) {
            ++bi.right;
        } else {
            ++bi.bottom;
        }
        Rectangle selected = selectedIndex != -1 ? this.getTabBounds(this.tabPane, selectedIndex) : null;
        Shape bs = this.createBackgroundShape(tabPlacement, tabAreaSize, bi, selected);
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            GeneralPath clip = new GeneralPath(0);
            clip.append(new Rectangle2D.Double(0.0, 0.0, this.tabPane.getWidth(), this.tabPane.getHeight()), false);
            clip.append(bs, false);
            GraphicsUtils.drawShade(g2d, bs, StyleConstants.shadeColor, this.shadeWidth, clip, this.round > 0);
            if (this.backgroundPainterAt.containsKey(selectedIndex)) {
                Shape old = GraphicsUtils.intersectClip(g2d, bs);
                this.backgroundPainterAt.get(selectedIndex).paint(g2d, bs.getBounds(), this.tabPane);
                GraphicsUtils.restoreClip(g2d, old);
            } else {
                Color bg = selectedIndex != -1 ? this.tabPane.getBackgroundAt(selectedIndex) : null;
                g2d.setPaint(bg != null ? bg : this.tabPane.getBackground());
                g2d.fill(bs);
            }
            g2d.setPaint(StyleConstants.darkBorderColor);
            g2d.draw(bs);
            LafUtils.drawCustomWebFocus(g2d, null, StyleConstants.focusType, bs, null, this.tabPane.isFocusOwner());
        } else {
            if (this.backgroundPainterAt.containsKey(selectedIndex)) {
                this.backgroundPainterAt.get(selectedIndex).paint(g2d, bs.getBounds(), this.tabPane);
            } else {
                Color bg = selectedIndex != -1 ? this.tabPane.getBackgroundAt(selectedIndex) : null;
                g2d.setPaint(bg != null ? bg : this.tabPane.getBackground());
                g2d.fill(bs);
            }
            g2d.setPaint(Color.GRAY);
            if (tabPlacement == 1) {
                if (selected != null) {
                    if (bi.left < selected.x) {
                        g2d.drawLine(bi.left, bi.top + tabAreaSize, selected.x, bi.top + tabAreaSize);
                    }
                    if (selected.x + selected.width < this.tabPane.getWidth() - bi.right) {
                        g2d.drawLine(selected.x + selected.width, bi.top + tabAreaSize, this.tabPane.getWidth() - bi.right, bi.top + tabAreaSize);
                    }
                } else {
                    g2d.drawLine(bi.left, bi.top + tabAreaSize, this.tabPane.getWidth() - bi.right, bi.top + tabAreaSize);
                }
            }
        }
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    public int getTabAreaLength(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3 ? this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) - 1 : this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) - 1;
    }

    private Shape createBackgroundShape(int tabPlacement, int tabAreaSize, Insets bi, Rectangle selected) {
        if (this.tabbedPaneStyle.equals((Object)TabbedPaneStyle.standalone)) {
            if (selected != null) {
                GeneralPath gp = new GeneralPath(0);
                if (tabPlacement == 1) {
                    int topY = bi.top + tabAreaSize;
                    gp.moveTo(selected.x, topY);
                    if (selected.x > bi.left + this.round && this.round > 0) {
                        gp.lineTo(bi.left + this.round, topY);
                        gp.quadTo(bi.left, topY, bi.left, topY + this.round);
                    } else {
                        gp.lineTo(bi.left, topY);
                    }
                    if (this.round > 0) {
                        gp.lineTo(bi.left, this.tabPane.getHeight() - bi.bottom - this.round);
                        gp.quadTo(bi.left, this.tabPane.getHeight() - bi.bottom, bi.left + this.round, this.tabPane.getHeight() - bi.bottom);
                        gp.lineTo(this.tabPane.getWidth() - bi.right - this.round, this.tabPane.getHeight() - bi.bottom);
                        gp.quadTo(this.tabPane.getWidth() - bi.right, this.tabPane.getHeight() - bi.bottom, this.tabPane.getWidth() - bi.right, this.tabPane.getHeight() - bi.bottom - this.round);
                    } else {
                        gp.lineTo(bi.left, this.tabPane.getHeight() - bi.bottom);
                        gp.lineTo(this.tabPane.getWidth() - bi.right, this.tabPane.getHeight() - bi.bottom);
                    }
                    if (selected.x + selected.width < this.tabPane.getWidth() - bi.right - this.round && this.round > 0) {
                        gp.lineTo(this.tabPane.getWidth() - bi.right, topY + this.round);
                        gp.quadTo(this.tabPane.getWidth() - bi.right, topY, this.tabPane.getWidth() - bi.right - this.round, topY);
                    } else {
                        gp.lineTo(this.tabPane.getWidth() - bi.right, topY);
                    }
                    gp.lineTo(selected.x + selected.width, topY);
                } else if (tabPlacement == 3) {
                    int bottomY = this.tabPane.getHeight() - bi.bottom - tabAreaSize;
                    gp.moveTo(selected.x, bottomY);
                    if (selected.x > bi.left + this.round && this.round > 0) {
                        gp.lineTo(bi.left + this.round, bottomY);
                        gp.quadTo(bi.left, bottomY, bi.left, bottomY - this.round);
                    } else {
                        gp.lineTo(bi.left, bottomY);
                    }
                    if (this.round > 0) {
                        gp.lineTo(bi.left, bi.top + this.round);
                        gp.quadTo(bi.left, bi.top, bi.left + this.round, bi.top);
                        gp.lineTo(this.tabPane.getWidth() - bi.right - this.round, bi.top);
                        gp.quadTo(this.tabPane.getWidth() - bi.right, bi.top, this.tabPane.getWidth() - bi.right, bi.top + this.round);
                    } else {
                        gp.lineTo(bi.left, bi.top);
                        gp.lineTo(this.tabPane.getWidth() - bi.right, bi.top);
                    }
                    if (selected.x + selected.width < this.tabPane.getWidth() - bi.right - this.round && this.round > 0) {
                        gp.lineTo(this.tabPane.getWidth() - bi.right, bottomY - this.round);
                        gp.quadTo(this.tabPane.getWidth() - bi.right, bottomY, this.tabPane.getWidth() - bi.right - this.round, bottomY);
                    } else {
                        gp.lineTo(this.tabPane.getWidth() - bi.right, bottomY);
                    }
                    gp.lineTo(selected.x + selected.width, bottomY);
                } else if (tabPlacement == 2) {
                    int leftX = bi.left + tabAreaSize;
                    gp.moveTo(leftX, selected.y);
                    if (selected.y > bi.top + this.round && this.round > 0) {
                        gp.lineTo(leftX, bi.top + this.round);
                        gp.quadTo(leftX, bi.top, leftX + this.round, bi.top);
                    } else {
                        gp.lineTo(leftX, bi.top);
                    }
                    if (this.round > 0) {
                        gp.lineTo(this.tabPane.getWidth() - bi.right - this.round, bi.top);
                        gp.quadTo(this.tabPane.getWidth() - bi.right, bi.top, this.tabPane.getWidth() - bi.right, bi.top + this.round);
                        gp.lineTo(this.tabPane.getWidth() - bi.right, this.tabPane.getHeight() - bi.bottom - this.round);
                        gp.quadTo(this.tabPane.getWidth() - bi.right, this.tabPane.getHeight() - bi.bottom, this.tabPane.getWidth() - bi.right - this.round, this.tabPane.getHeight() - bi.bottom);
                    } else {
                        gp.lineTo(this.tabPane.getWidth() - bi.right, bi.top);
                        gp.lineTo(this.tabPane.getWidth() - bi.right, this.tabPane.getHeight() - bi.bottom);
                    }
                    if (selected.y + selected.height < this.tabPane.getHeight() - bi.bottom - this.round && this.round > 0) {
                        gp.lineTo(leftX + this.round, this.tabPane.getHeight() - bi.bottom);
                        gp.quadTo(leftX, this.tabPane.getHeight() - bi.bottom, leftX, this.tabPane.getHeight() - bi.bottom - this.round);
                    } else {
                        gp.lineTo(leftX, this.tabPane.getHeight() - bi.bottom);
                    }
                    gp.lineTo(leftX, selected.y + selected.height);
                } else {
                    int rightX = this.tabPane.getWidth() - bi.right - tabAreaSize;
                    gp.moveTo(rightX, selected.y);
                    if (selected.y > bi.top + this.round && this.round > 0) {
                        gp.lineTo(rightX, bi.top + this.round);
                        gp.quadTo(rightX, bi.top, rightX - this.round, bi.top);
                    } else {
                        gp.lineTo(rightX, bi.top);
                    }
                    if (this.round > 0) {
                        gp.lineTo(bi.left + this.round, bi.top);
                        gp.quadTo(bi.left, bi.top, bi.left, bi.top + this.round);
                        gp.lineTo(bi.left, this.tabPane.getHeight() - bi.bottom - this.round);
                        gp.quadTo(bi.left, this.tabPane.getHeight() - bi.bottom, bi.left + this.round, this.tabPane.getHeight() - bi.bottom);
                    } else {
                        gp.lineTo(bi.left, bi.top);
                        gp.lineTo(bi.left, this.tabPane.getHeight() - bi.bottom);
                    }
                    if (selected.y + selected.height < this.tabPane.getHeight() - bi.bottom - this.round && this.round > 0) {
                        gp.lineTo(rightX - this.round, this.tabPane.getHeight() - bi.bottom);
                        gp.quadTo(rightX, this.tabPane.getHeight() - bi.bottom, rightX, this.tabPane.getHeight() - bi.bottom - this.round);
                    } else {
                        gp.lineTo(rightX, this.tabPane.getHeight() - bi.bottom);
                    }
                    gp.lineTo(rightX, selected.y + selected.height);
                }
                return gp;
            }
            boolean top = tabPlacement == 1;
            boolean bottom = tabPlacement == 3;
            boolean left = tabPlacement == 2;
            boolean right = tabPlacement == 4;
            return new RoundRectangle2D.Double(bi.left + (left ? tabAreaSize : 0), bi.top + (top ? tabAreaSize : 0), this.tabPane.getWidth() - bi.left - bi.right - (left || right ? tabAreaSize : 0), this.tabPane.getHeight() - bi.top - bi.bottom - (top || bottom ? tabAreaSize : 0), this.round * 2, this.round * 2);
        }
        int x = bi.left + (tabPlacement == 2 ? tabAreaSize : 0);
        int y = bi.top + (tabPlacement == 1 ? tabAreaSize : 0);
        int width = this.tabPane.getWidth() - bi.left - bi.right - (tabPlacement == 2 || tabPlacement == 4 ? tabAreaSize : 0);
        int height = this.tabPane.getHeight() - bi.top - bi.bottom - (tabPlacement == 1 || tabPlacement == 3 ? tabAreaSize : 0);
        return new Rectangle(x, y, width + 1, height);
    }

    public Shape getContentClip() {
        RoundRectangle2D.Double clip = null;
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabAreaLength = this.getTabAreaLength(tabPlacement);
        Insets insets = this.tabPane.getInsets();
        if (tabPlacement == 1) {
            clip = new RoundRectangle2D.Double(insets.left, insets.top + tabAreaLength, this.tabPane.getWidth() - insets.left - insets.right, this.tabPane.getHeight() - insets.top - tabAreaLength - insets.bottom, this.round * 2, this.round * 2);
        } else if (tabPlacement == 3) {
            clip = new RoundRectangle2D.Double(insets.left, insets.top, this.tabPane.getWidth() - insets.left - insets.right, this.tabPane.getHeight() - insets.top - tabAreaLength - insets.bottom, this.round * 2, this.round * 2);
        } else if (tabPlacement == 2) {
            clip = new RoundRectangle2D.Double(insets.left + tabAreaLength, insets.top, this.tabPane.getWidth() - insets.left - tabAreaLength - insets.right, this.tabPane.getHeight() - insets.top - insets.bottom, this.round * 2, this.round * 2);
        } else if (tabPlacement == 4) {
            clip = new RoundRectangle2D.Double(insets.left, insets.top, this.tabPane.getWidth() - insets.left - tabAreaLength - insets.right, this.tabPane.getHeight() - insets.top - insets.bottom, this.round * 2, this.round * 2);
        }
        return clip;
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)g, SwingUtils.size(c), c);
        }
        Map hints = SwingUtils.setupTextAntialias(g);
        super.paint(g, c);
        SwingUtils.restoreTextAntialias(g, hints);
    }

    private static enum TabShapeType {
        shade,
        background,
        backgroundPainter,
        border;

    }
}

