/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeRolloverSelectionAdapter;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.TreeUtils;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTreeModel;
import com.alee.laf.tree.WebTreeUI;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.FontMethods;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebTree<E extends DefaultMutableTreeNode>
extends JTree
implements FontMethods<WebTree<E>> {
    public static final int SINGLE_TREE_SELECTION = 1;
    public static final int CONTIGUOUS_TREE_SELECTION = 2;
    public static final int DISCONTIGUOUS_TREE_SELECTION = 4;
    protected List<CellEditorListener> cellEditorListeners = new ArrayList<CellEditorListener>(1);
    protected TreeSelectionListener scrollToSelectionListener = null;

    public WebTree() {
        this(WebTree.getDefaultTreeModel());
    }

    public WebTree(Object[] value) {
        this(WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(Vector<?> value) {
        this(WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(Hashtable<?, ?> value) {
        this(WebTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public WebTree(E root) {
        this(new WebTreeModel<E>(root));
    }

    public WebTree(E root, boolean asksAllowsChildren) {
        this(new WebTreeModel<E>(root, asksAllowsChildren));
    }

    public WebTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    protected void init() {
    }

    @Override
    public void setCellEditor(TreeCellEditor cellEditor) {
        for (CellEditorListener listener : this.cellEditorListeners) {
            this.cellEditor.removeCellEditorListener(listener);
        }
        super.setCellEditor(cellEditor);
        for (CellEditorListener listener : this.cellEditorListeners) {
            this.cellEditor.addCellEditorListener(listener);
        }
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.cellEditorListeners.add(listener);
        if (this.cellEditor != null) {
            this.cellEditor.addCellEditorListener(listener);
        }
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.cellEditorListeners.remove(listener);
        if (this.cellEditor != null) {
            this.cellEditor.removeCellEditorListener(listener);
        }
    }

    public void expandRoot() {
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void expandNode(E node) {
        this.expandPath(this.getPathForNode(node));
    }

    public boolean isExpanded(E node) {
        return this.isExpanded((E)this.getPathForNode(node));
    }

    public Rectangle getNodeBounds(E node) {
        return this.getPathBounds(this.getPathForNode(node));
    }

    public Rectangle getNodeBounds(List<E> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Rectangle combined = null;
        for (DefaultMutableTreeNode node : nodes) {
            combined = GeometryUtils.getContainingRect(combined, this.getNodeBounds(node));
        }
        return combined;
    }

    public E getNodeForRow(int row) {
        return this.getNodeForPath(this.getPathForRow(row));
    }

    public TreePath getPathForNode(E node) {
        return node != null ? new TreePath(((DefaultMutableTreeNode)node).getPath()) : null;
    }

    public E getNodeForPath(TreePath path) {
        return (E)(path != null ? (DefaultMutableTreeNode)path.getLastPathComponent() : null);
    }

    public E getNodeForLocation(Point location) {
        return this.getNodeForLocation(location.x, location.y);
    }

    public E getNodeForLocation(int x, int y) {
        return this.getNodeForPath(this.getPathForLocation(x, y));
    }

    public TreePath getPathForLocation(Point location) {
        return this.getPathForLocation(location.x, location.y);
    }

    public E getClosestNodeForLocation(Point location) {
        return this.getClosestNodeForLocation(location.x, location.y);
    }

    public E getClosestNodeForLocation(int x, int y) {
        return this.getNodeForPath(this.getClosestPathForLocation(x, y));
    }

    public TreePath getClosestPathForLocation(Point location) {
        return this.getClosestPathForLocation(location.x, location.y);
    }

    public boolean isSelected(E node) {
        return this.isPathSelected(this.getPathForNode(node));
    }

    public E getSelectedNode() {
        return this.getNodeForPath(this.getSelectionPath());
    }

    public List<E> getSelectedNodes() {
        ArrayList<E> selectedNodes = new ArrayList<E>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath path : selectionPaths) {
                selectedNodes.add(this.getNodeForPath(path));
            }
        }
        return selectedNodes;
    }

    public void selectNodeUnderPoint(Point point) {
        this.selectNodeUnderPoint(point.x, point.y);
    }

    public void selectNodeUnderPoint(int x, int y) {
        this.setSelectionPath(this.getPathForLocation(x, y));
    }

    public void setSelectedNode(E node) {
        TreePath path = this.getPathForNode(node);
        if (path != null) {
            this.setSelectionPath(path);
        }
    }

    public void setSelectedNodes(List<E> nodes) {
        TreePath[] paths = new TreePath[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            paths[i] = this.getPathForNode((DefaultMutableTreeNode)nodes.get(i));
        }
        this.setSelectionPaths(paths);
    }

    public void setSelectedNodes(E[] nodes) {
        TreePath[] paths = new TreePath[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            paths[i] = this.getPathForNode(nodes[i]);
        }
        this.setSelectionPaths(paths);
    }

    public E getFirstVisibleLeafNode() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            E node = this.getNodeForRow(i);
            if (!this.getModel().isLeaf(node)) continue;
            return node;
        }
        return null;
    }

    public void selectFirstVisibleLeafNode() {
        E node = this.getFirstVisibleLeafNode();
        if (node != null) {
            this.setSelectedNode(node);
        }
    }

    public void selectNextRow() {
        this.selectNextRow(true);
    }

    public void selectNextRow(boolean cycle) {
        int row = this.getLeadSelectionRow();
        if (row != -1) {
            if (row < this.getRowCount() - 1) {
                this.setSelectionRow(row + 1);
            } else if (cycle) {
                this.setSelectionRow(0);
            }
        } else {
            this.setSelectionRow(0);
        }
    }

    public void selectPreviousRow() {
        this.selectPreviousRow(true);
    }

    public void selectPreviousRow(boolean cycle) {
        int row = this.getLeadSelectionRow();
        if (row != -1) {
            if (row > 0) {
                this.setSelectionRow(row - 1);
            } else if (cycle) {
                this.setSelectionRow(this.getRowCount() - 1);
            }
        } else {
            this.setSelectionRow(this.getRowCount() - 1);
        }
    }

    public E getRootNode() {
        return (E)((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    public List<E> getAllNodes() {
        ArrayList nodes = new ArrayList();
        this.getAllNodesImpl(nodes, this.getRootNode());
        return nodes;
    }

    private void getAllNodesImpl(List<E> nodes, E node) {
        nodes.add(node);
        for (int i = 0; i < ((DefaultMutableTreeNode)node).getChildCount(); ++i) {
            this.getAllNodesImpl(nodes, (DefaultMutableTreeNode)((DefaultMutableTreeNode)node).getChildAt(i));
        }
    }

    public void setSelectionMode(int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    public void setMultiplySelectionAllowed(boolean allowed) {
        this.setSelectionMode(allowed ? 4 : 1);
    }

    public boolean isScrollToSelection() {
        return this.scrollToSelectionListener != null;
    }

    public void setScrollToSelection(boolean scroll) {
        if (scroll) {
            if (!this.isScrollToSelection()) {
                this.scrollToSelectionListener = new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        WebTree.this.scrollToSelection();
                    }
                };
                this.addTreeSelectionListener(this.scrollToSelectionListener);
            }
        } else if (this.isScrollToSelection()) {
            this.removeTreeSelectionListener(this.scrollToSelectionListener);
            this.scrollToSelectionListener = null;
        }
    }

    public void scrollToStart() {
        this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public void scrollToSelection() {
        Rectangle bounds = this.getPathBounds(this.getSelectionPath());
        if (bounds != null) {
            this.scrollRectToVisible(bounds);
        }
    }

    public void scrollToNode(E node) {
        Rectangle bounds = this.getNodeBounds(node);
        if (bounds != null) {
            this.scrollRectToVisible(bounds);
        }
    }

    public void startEditingSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            this.startEditingAtPath(path);
        }
    }

    public void startEditingNode(E node) {
        TreePath path = this.getPathForNode(node);
        if (path != null) {
            this.startEditingAtPath(path);
        }
    }

    public void updateAllVisibleNodes() {
        this.revalidate();
        this.repaint();
    }

    public TreeState getTreeState() {
        return TreeUtils.getTreeState(this);
    }

    public TreeState getTreeState(boolean saveSelection) {
        return TreeUtils.getTreeState(this, saveSelection);
    }

    public void setTreeState(TreeState treeState) {
        TreeUtils.setTreeState(this, treeState);
    }

    public void setTreeState(TreeState treeState, boolean restoreSelection) {
        TreeUtils.setTreeState(this, treeState, restoreSelection);
    }

    public boolean isAutoExpandSelectedNode() {
        return this.getWebUI().isAutoExpandSelectedNode();
    }

    public void setAutoExpandSelectedNode(boolean autoExpandSelectedNode) {
        this.getWebUI().setAutoExpandSelectedNode(autoExpandSelectedNode);
    }

    public boolean isRolloverSelectionEnabled() {
        return TreeRolloverSelectionAdapter.isInstalled(this);
    }

    public void setRolloverSelectionEnabled(boolean enabled) {
        if (enabled) {
            if (!this.isRolloverSelectionEnabled()) {
                this.setHighlightRolloverNode(false);
                TreeRolloverSelectionAdapter.install(this);
            }
        } else if (this.isRolloverSelectionEnabled()) {
            TreeRolloverSelectionAdapter.uninstall(this);
        }
    }

    public boolean isHighlightRolloverNode() {
        return this.getWebUI().isHighlightRolloverNode();
    }

    public void setHighlightRolloverNode(boolean highlight) {
        this.getWebUI().setHighlightRolloverNode(highlight);
    }

    public boolean isPaintLines() {
        return this.getWebUI().isPaintLines();
    }

    public void setPaintLines(boolean paint) {
        this.getWebUI().setPaintLines(paint);
    }

    public Color getLinesColor() {
        return this.getWebUI().getLinesColor();
    }

    public void setLinesColor(Color color) {
        this.getWebUI().setLinesColor(color);
    }

    public TreeSelectionStyle getSelectionStyle() {
        return this.getWebUI().getSelectionStyle();
    }

    public void setSelectionStyle(TreeSelectionStyle style) {
        this.getWebUI().setSelectionStyle(style);
    }

    public int getSelectionRound() {
        return this.getWebUI().getSelectionRound();
    }

    public void setSelectionRound(int round) {
        this.getWebUI().setSelectionRound(round);
    }

    public int getSelectionShadeWidth() {
        return this.getWebUI().getSelectionShadeWidth();
    }

    public void setSelectionShadeWidth(int shadeWidth) {
        this.getWebUI().setSelectionShadeWidth(shadeWidth);
    }

    public boolean isSelectorEnabled() {
        return this.getWebUI().isSelectorEnabled();
    }

    public void setSelectorEnabled(boolean enabled) {
        this.getWebUI().setSelectorEnabled(enabled);
    }

    public Color getSelectorColor() {
        return this.getWebUI().getSelectorColor();
    }

    public void setSelectorColor(Color color) {
        this.getWebUI().setSelectorColor(color);
    }

    public Color getSelectorBorderColor() {
        return this.getWebUI().getSelectorBorderColor();
    }

    public void setSelectorBorderColor(Color color) {
        this.getWebUI().setSelectorBorderColor(color);
    }

    public int getSelectorRound() {
        return this.getWebUI().getSelectorRound();
    }

    public void setSelectorRound(int round) {
        this.getWebUI().setSelectorRound(round);
    }

    public BasicStroke getSelectorStroke() {
        return this.getWebUI().getSelectorStroke();
    }

    public void setSelectorStroke(BasicStroke stroke) {
        this.getWebUI().setSelectorStroke(stroke);
    }

    public int getDropCellShadeWidth() {
        return this.getWebUI().getDropCellShadeWidth();
    }

    public void setDropCellShadeWidth(int dropCellShadeWidth) {
        this.getWebUI().setDropCellShadeWidth(dropCellShadeWidth);
    }

    public WebTreeUI getWebUI() {
        return (WebTreeUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTreeUI)) {
            try {
                this.setUI((WebTreeUI)ReflectUtils.createInstance(WebLookAndFeel.treeUI, new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setUI(new WebTreeUI());
            }
        } else {
            this.setUI(this.getUI());
        }
    }

    public void repaint(int row) {
        this.repaint((E)this.getWebUI().getRowBounds(row));
    }

    public void repaint(int from, int to) {
        Rectangle toBounds;
        WebTreeUI webUI = this.getWebUI();
        Rectangle fromBounds = webUI.getRowBounds(from);
        Rectangle rect = GeometryUtils.getContainingRect(fromBounds, toBounds = webUI.getRowBounds(to));
        if (rect != null) {
            this.repaint((E)rect);
        }
    }

    public void repaint(E node) {
        if (node != null) {
            this.repaint((E)this.getNodeBounds(node));
        }
    }

    public void repaint(List<E> nodes) {
        if (nodes != null && nodes.size() > 0) {
            Rectangle summ = null;
            for (DefaultMutableTreeNode node : nodes) {
                summ = GeometryUtils.getContainingRect(summ, this.getNodeBounds(node));
            }
            if (summ != null) {
                this.repaint((E)summ);
            }
        }
    }

    @Override
    public WebTree<E> setPlainFont() {
        return SwingUtils.setPlainFont(this);
    }

    @Override
    public WebTree<E> setPlainFont(boolean apply) {
        return SwingUtils.setPlainFont(this, apply);
    }

    @Override
    public boolean isPlainFont() {
        return SwingUtils.isPlainFont(this);
    }

    @Override
    public WebTree<E> setBoldFont() {
        return SwingUtils.setBoldFont(this);
    }

    @Override
    public WebTree<E> setBoldFont(boolean apply) {
        return SwingUtils.setBoldFont(this, apply);
    }

    @Override
    public boolean isBoldFont() {
        return SwingUtils.isBoldFont(this);
    }

    @Override
    public WebTree<E> setItalicFont() {
        return SwingUtils.setItalicFont(this);
    }

    @Override
    public WebTree<E> setItalicFont(boolean apply) {
        return SwingUtils.setItalicFont(this, apply);
    }

    @Override
    public boolean isItalicFont() {
        return SwingUtils.isItalicFont(this);
    }

    @Override
    public WebTree<E> setFontStyle(boolean bold, boolean italic) {
        return SwingUtils.setFontStyle(this, bold, italic);
    }

    @Override
    public WebTree<E> setFontStyle(int style) {
        return SwingUtils.setFontStyle(this, style);
    }

    @Override
    public WebTree<E> setFontSize(int fontSize) {
        return SwingUtils.setFontSize(this, fontSize);
    }

    @Override
    public WebTree<E> changeFontSize(int change) {
        return SwingUtils.changeFontSize(this, change);
    }

    @Override
    public int getFontSize() {
        return SwingUtils.getFontSize(this);
    }

    @Override
    public WebTree<E> setFontSizeAndStyle(int fontSize, boolean bold, boolean italic) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, bold, italic);
    }

    @Override
    public WebTree<E> setFontSizeAndStyle(int fontSize, int style) {
        return SwingUtils.setFontSizeAndStyle(this, fontSize, style);
    }

    @Override
    public WebTree<E> setFontName(String fontName) {
        return SwingUtils.setFontName(this, fontName);
    }

    @Override
    public String getFontName() {
        return SwingUtils.getFontName(this);
    }

    protected static TreeModel createTreeModel(Object value) {
        DefaultMutableTreeNode root;
        if (value instanceof Object[] || value instanceof Hashtable || value instanceof Vector) {
            root = new DefaultMutableTreeNode("root");
            JTree.DynamicUtilTreeNode.createChildren(root, value);
        } else {
            root = new JTree.DynamicUtilTreeNode((Object)"root", value);
        }
        return new WebTreeModel<DefaultMutableTreeNode>(root, false);
    }

    public static TreeModel getDefaultTreeModel() {
        UniqueNode root = new UniqueNode("JTree");
        UniqueNode parent = new UniqueNode("colors");
        parent.add(new UniqueNode("blue"));
        parent.add(new UniqueNode("violet"));
        parent.add(new UniqueNode("red"));
        parent.add(new UniqueNode("yellow"));
        root.add(parent);
        parent = new UniqueNode("sports");
        parent.add(new UniqueNode("basketball"));
        parent.add(new UniqueNode("soccer"));
        parent.add(new UniqueNode("football"));
        parent.add(new UniqueNode("hockey"));
        root.add(parent);
        parent = new UniqueNode("food");
        parent.add(new UniqueNode("hot dogs"));
        parent.add(new UniqueNode("pizza"));
        parent.add(new UniqueNode("ravioli"));
        parent.add(new UniqueNode("bananas"));
        root.add(parent);
        return new WebTreeModel<UniqueNode>(root);
    }
}

