/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.extended.tree.WebCheckBoxTree;
import com.alee.global.StyleConstants;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.tree.TreeSelectionStyle;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.laf.tree.WebTreeCellRenderer;
import com.alee.laf.tree.WebTreeStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class WebTreeUI
extends BasicTreeUI {
    public static ImageIcon EXPAND_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/expand.png"));
    public static ImageIcon COLLAPSE_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/collapse.png"));
    public static ImageIcon DISABLED_EXPAND_ICON = ImageUtils.createDisabledCopy(EXPAND_ICON);
    public static ImageIcon DISABLED_COLLAPSE_ICON = ImageUtils.createDisabledCopy(COLLAPSE_ICON);
    public static ImageIcon ROOT_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/root.png"));
    public static ImageIcon CLOSED_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/closed.png"));
    public static ImageIcon OPEN_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/open.png"));
    public static ImageIcon LEAF_ICON = new ImageIcon(WebTreeUI.class.getResource("icons/leaf.png"));
    protected static final float[] fractions = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
    protected boolean autoExpandSelectedNode = WebTreeStyle.autoExpandSelectedPath;
    protected boolean highlightRolloverNode = WebTreeStyle.highlightRolloverNode;
    protected boolean paintLines = WebTreeStyle.paintLines;
    protected Color linesColor = WebTreeStyle.linesColor;
    protected TreeSelectionStyle selectionStyle = WebTreeStyle.selectionStyle;
    protected int selectionRound = WebTreeStyle.selectionRound;
    protected int selectionShadeWidth = WebTreeStyle.selectionShadeWidth;
    protected boolean selectorEnabled = WebTreeStyle.selectorEnabled;
    protected Color selectorColor = WebTreeStyle.selectorColor;
    protected Color selectorBorderColor = WebTreeStyle.selectorBorderColor;
    protected int selectorRound = WebTreeStyle.selectorRound;
    protected BasicStroke selectorStroke = WebTreeStyle.selectorStroke;
    protected int dropCellShadeWidth = WebTreeStyle.dropCellShadeWidth;
    protected PropertyChangeListener orientationChangeListener;
    protected PropertyChangeListener dropLocationChangeListener;
    protected TreeSelectionListener treeSelectionListener;
    protected TreeExpansionListener treeExpansionListener;
    protected MouseAdapter mouseAdapter;
    protected int rolloverRow = -1;
    protected List<Integer> initialSelection = new ArrayList<Integer>();
    protected Point selectionStart = null;
    protected Point selectionEnd = null;
    protected boolean leftToRight = true;
    protected TreePath draggablePath = null;

    public static ComponentUI createUI(JComponent c) {
        return new WebTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.leftToRight = this.tree.getComponentOrientation().isLeftToRight();
        if (!WebLookAndFeel.isInstalled()) {
            this.setRightChildIndent(WebTreeStyle.nodeLineIndent);
            this.setLeftChildIndent(WebTreeStyle.nodeLineIndent);
        }
        this.tree.setRowHeight(-1);
        this.tree.setVisibleRowCount(10);
        this.orientationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WebTreeUI.this.leftToRight = WebTreeUI.this.tree.getComponentOrientation().isLeftToRight();
            }
        };
        this.tree.addPropertyChangeListener("componentOrientation", this.orientationChangeListener);
        SwingUtils.setOrientation(this.tree);
        this.dropLocationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JTree.DropLocation newLocation;
                JTree.DropLocation oldLocation = (JTree.DropLocation)evt.getOldValue();
                if (oldLocation != null) {
                    WebTreeUI.this.tree.repaint(WebTreeUI.this.getNodeDropLocationBounds(oldLocation.getPath()));
                }
                if ((newLocation = (JTree.DropLocation)evt.getNewValue()) != null) {
                    WebTreeUI.this.tree.repaint(WebTreeUI.this.getNodeDropLocationBounds(newLocation.getPath()));
                }
            }
        };
        this.tree.addPropertyChangeListener("dropLocation", this.dropLocationChangeListener);
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WebTreeUI.this.repaintSelection();
                if (WebTreeUI.this.autoExpandSelectedNode && WebTreeUI.this.tree.getSelectionCount() > 0) {
                    WebTreeUI.this.tree.expandPath(WebTreeUI.this.tree.getSelectionPath());
                }
            }
        };
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                WebTreeUI.this.repaintSelection();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                WebTreeUI.this.repaintSelection();
            }
        };
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && WebTreeUI.this.getRowForPoint(e.getPoint(), false) == -1) {
                    TreePath path;
                    if (WebTreeUI.this.isSelectorAvailable()) {
                        TreePath path2 = WebTreeUI.this.getClosestPathForLocation(WebTreeUI.this.tree, e.getX(), e.getY());
                        if (path2 == null || !WebTreeUI.this.isLocationInExpandControl(path2, e.getX(), e.getY()) && !WebTreeUI.this.isLocationInCheckBoxControl(path2, e.getX(), e.getY())) {
                            int rowForPath = WebTreeUI.this.getRowForPath(WebTreeUI.this.tree, path2);
                            if (WebTreeUI.this.isDragAvailable() && WebTreeUI.this.getRowBounds(rowForPath).contains(e.getX(), e.getY()) && WebTreeUI.this.tree.isRowSelected(rowForPath)) {
                                WebTreeUI.this.draggablePath = path2;
                            } else {
                                WebTreeUI.this.selectionEnd = WebTreeUI.this.selectionStart = e.getPoint();
                                WebTreeUI.this.initialSelection = this.getSelectionRowsList();
                                this.validateSelection(e);
                                this.repaintSelector();
                            }
                        }
                    } else if (WebTreeUI.this.isFullLineSelection() && (path = WebTreeUI.this.getClosestPathForLocation(WebTreeUI.this.tree, e.getX(), e.getY())) != null && !WebTreeUI.this.isLocationInExpandControl(path, e.getX(), e.getY()) && !WebTreeUI.this.isLocationInCheckBoxControl(path, e.getX(), e.getY())) {
                        if (WebTreeUI.this.tree.getSelectionModel().getSelectionMode() == 1) {
                            WebTreeUI.this.tree.setSelectionRow(WebTreeUI.this.getRowForPoint(e.getPoint(), true));
                        }
                        int rowForPath = WebTreeUI.this.getRowForPath(WebTreeUI.this.tree, path);
                        if (WebTreeUI.this.isDragAvailable() && WebTreeUI.this.getRowBounds(rowForPath).contains(e.getX(), e.getY()) && WebTreeUI.this.tree.isRowSelected(rowForPath)) {
                            WebTreeUI.this.draggablePath = path;
                        }
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (WebTreeUI.this.draggablePath != null) {
                    TransferHandler transferHandler = WebTreeUI.this.tree.getTransferHandler();
                    transferHandler.exportAsDrag(WebTreeUI.this.tree, e, transferHandler.getSourceActions(WebTreeUI.this.tree));
                    WebTreeUI.this.draggablePath = null;
                }
                if (WebTreeUI.this.isSelectorAvailable() && WebTreeUI.this.selectionStart != null) {
                    WebTreeUI.this.selectionEnd = e.getPoint();
                    this.validateSelection(e);
                    this.repaintSelector();
                    if (!WebTreeUI.this.tree.getVisibleRect().contains(e.getPoint())) {
                        WebTreeUI.this.tree.scrollRectToVisible(new Rectangle(e.getPoint(), new Dimension(0, 0)));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (WebTreeUI.this.draggablePath != null) {
                    WebTreeUI.this.draggablePath = null;
                }
                if (WebTreeUI.this.isSelectorAvailable() && WebTreeUI.this.selectionStart != null) {
                    WebTreeUI.this.selectionStart = null;
                    WebTreeUI.this.selectionEnd = null;
                    this.repaintSelector();
                }
            }

            private void validateSelection(MouseEvent e) {
                Rectangle selection = GeometryUtils.getContainingRect(WebTreeUI.this.selectionStart, WebTreeUI.this.selectionEnd);
                ArrayList<Integer> newSelection = new ArrayList<Integer>();
                if (SwingUtils.isShift(e)) {
                    for (int row = 0; row < WebTreeUI.this.tree.getRowCount(); ++row) {
                        if (!WebTreeUI.this.getRowBounds(row).intersects(selection) || WebTreeUI.this.initialSelection.contains(row)) continue;
                        newSelection.add(row);
                    }
                    for (int row : WebTreeUI.this.initialSelection) {
                        newSelection.add(row);
                    }
                } else if (SwingUtils.isCtrl(e)) {
                    ArrayList<Integer> excludedRows = new ArrayList<Integer>();
                    for (int row = 0; row < WebTreeUI.this.tree.getRowCount(); ++row) {
                        if (!WebTreeUI.this.getRowBounds(row).intersects(selection)) continue;
                        if (WebTreeUI.this.initialSelection.contains(row)) {
                            excludedRows.add(row);
                            continue;
                        }
                        newSelection.add(row);
                    }
                    for (int row : WebTreeUI.this.initialSelection) {
                        if (excludedRows.contains(row)) continue;
                        newSelection.add(row);
                    }
                } else {
                    for (int row = 0; row < WebTreeUI.this.tree.getRowCount(); ++row) {
                        if (!WebTreeUI.this.getRowBounds(row).intersects(selection)) continue;
                        newSelection.add(row);
                    }
                }
                if (!CollectionUtils.areEqual(this.getSelectionRowsList(), newSelection)) {
                    if (newSelection.size() > 0) {
                        WebTreeUI.this.tree.setSelectionRows(CollectionUtils.toArray(newSelection));
                    } else {
                        WebTreeUI.this.tree.clearSelection();
                    }
                }
            }

            private List<Integer> getSelectionRowsList() {
                ArrayList<Integer> selection = new ArrayList<Integer>();
                int[] selectionRows = WebTreeUI.this.tree.getSelectionRows();
                if (selectionRows != null) {
                    for (int row : selectionRows) {
                        selection.add(row);
                    }
                }
                return selection;
            }

            private void repaintSelector() {
                WebTreeUI.this.tree.repaint(WebTreeUI.this.tree.getVisibleRect());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.updateMouseover(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.clearMouseover();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateMouseover(e);
            }

            private void updateMouseover(MouseEvent e) {
                if (WebTreeUI.this.tree.isEnabled() && WebTreeUI.this.highlightRolloverNode) {
                    int index = WebTreeUI.this.getRowForPoint(e.getPoint());
                    if (WebTreeUI.this.rolloverRow != index) {
                        int oldRollover = WebTreeUI.this.rolloverRow;
                        WebTreeUI.this.rolloverRow = index;
                        this.updateRow(index);
                        this.updateRow(oldRollover);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                int oldRollover = WebTreeUI.this.rolloverRow;
                WebTreeUI.this.rolloverRow = -1;
                this.updateRow(oldRollover);
            }

            private void updateRow(int row) {
                Rectangle rowBounds;
                if (row != -1 && (rowBounds = WebTreeUI.this.getFullRowBounds(row)) != null) {
                    WebTreeUI.this.tree.repaint(rowBounds);
                }
            }
        };
        this.tree.addMouseListener(this.mouseAdapter);
        this.tree.addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.tree.removePropertyChangeListener("componentOrientation", this.orientationChangeListener);
        this.tree.removePropertyChangeListener("dropLocation", this.dropLocationChangeListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        this.tree.removeMouseListener(this.mouseAdapter);
        this.tree.removeMouseMotionListener(this.mouseAdapter);
        super.uninstallUI(c);
    }

    protected boolean isDragAvailable() {
        return this.tree != null && this.tree.isEnabled() && this.tree.getDragEnabled() && this.tree.getTransferHandler() != null && this.tree.getTransferHandler().getSourceActions(this.tree) > 0;
    }

    public boolean isAutoExpandSelectedNode() {
        return this.autoExpandSelectedNode;
    }

    public void setAutoExpandSelectedNode(boolean autoExpandSelectedNode) {
        this.autoExpandSelectedNode = autoExpandSelectedNode;
    }

    public boolean isHighlightRolloverNode() {
        return this.highlightRolloverNode;
    }

    public void setHighlightRolloverNode(boolean highlight) {
        this.highlightRolloverNode = highlight;
    }

    public boolean isPaintLines() {
        return this.paintLines;
    }

    public void setPaintLines(boolean paint) {
        this.paintLines = paint;
    }

    public Color getLinesColor() {
        return this.linesColor;
    }

    public void setLinesColor(Color color) {
        this.linesColor = color;
    }

    public TreeSelectionStyle getSelectionStyle() {
        return this.selectionStyle;
    }

    public void setSelectionStyle(TreeSelectionStyle style) {
        this.selectionStyle = style;
    }

    public int getSelectionRound() {
        return this.selectionRound;
    }

    public void setSelectionRound(int round) {
        this.selectionRound = round;
    }

    public int getSelectionShadeWidth() {
        return this.selectionShadeWidth;
    }

    public void setSelectionShadeWidth(int shadeWidth) {
        this.selectionShadeWidth = shadeWidth;
    }

    public boolean isSelectorEnabled() {
        return this.selectorEnabled;
    }

    public void setSelectorEnabled(boolean enabled) {
        this.selectorEnabled = enabled;
    }

    public Color getSelectorColor() {
        return this.selectorColor;
    }

    public void setSelectorColor(Color color) {
        this.selectorColor = color;
    }

    public Color getSelectorBorderColor() {
        return this.selectorBorderColor;
    }

    public void setSelectorBorderColor(Color color) {
        this.selectorBorderColor = color;
    }

    public int getSelectorRound() {
        return this.selectorRound;
    }

    public void setSelectorRound(int round) {
        this.selectorRound = round;
    }

    public BasicStroke getSelectorStroke() {
        return this.selectorStroke;
    }

    public void setSelectorStroke(BasicStroke stroke) {
        this.selectorStroke = stroke;
    }

    public int getDropCellShadeWidth() {
        return this.dropCellShadeWidth;
    }

    public void setDropCellShadeWidth(int dropCellShadeWidth) {
        this.dropCellShadeWidth = dropCellShadeWidth;
    }

    public boolean isSelectorAvailable() {
        return this.isSelectorEnabled() && this.tree != null && this.tree.isEnabled() && this.tree.getSelectionModel().getSelectionMode() != 1;
    }

    public boolean isFullLineSelection() {
        return this.selectionStyle == TreeSelectionStyle.line;
    }

    public int getRowForPoint(Point point) {
        return this.getRowForPoint(point, this.isFullLineSelection());
    }

    public int getRowForPoint(Point point, boolean countFullRow) {
        if (this.tree != null) {
            for (int row = 0; row < this.tree.getRowCount(); ++row) {
                Rectangle bounds = this.getRowBounds(row, countFullRow);
                if (!bounds.contains(point)) continue;
                return row;
            }
        }
        return -1;
    }

    public Rectangle getRowBounds(int row) {
        return this.getRowBounds(row, this.isFullLineSelection());
    }

    public Rectangle getRowBounds(int row, boolean countFullRow) {
        return countFullRow ? this.getFullRowBounds(row) : this.tree.getRowBounds(row);
    }

    public Rectangle getFullRowBounds(int row) {
        Rectangle b = this.tree.getRowBounds(row);
        if (b != null) {
            Insets insets = this.tree.getInsets();
            b.x = insets.left;
            b.width = this.tree.getWidth() - insets.left - insets.right;
        }
        return b;
    }

    @Override
    protected TreeCellEditor createDefaultCellEditor() {
        return new WebTreeCellEditor();
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WebTreeCellRenderer();
    }

    @Override
    protected void selectPathForEvent(TreePath path, MouseEvent e) {
        if (!this.isLocationInCheckBoxControl(path, e.getX(), e.getY())) {
            super.selectPathForEvent(path, e);
        }
    }

    protected boolean isLocationInCheckBoxControl(TreePath path, int x, int y) {
        if (this.tree instanceof WebCheckBoxTree) {
            WebCheckBoxTree checkBoxTree = (WebCheckBoxTree)this.tree;
            if (checkBoxTree.isCheckingByUserEnabled()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (checkBoxTree.isCheckBoxVisible(node) && checkBoxTree.isCheckBoxEnabled(node)) {
                    Rectangle checkBoxBounds = checkBoxTree.getCheckBoxBounds(path);
                    return checkBoxBounds != null && checkBoxBounds.contains(x, y);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    protected Color getHashColor() {
        return this.linesColor;
    }

    @Override
    public Icon getExpandedIcon() {
        return this.tree.isEnabled() ? COLLAPSE_ICON : DISABLED_COLLAPSE_ICON;
    }

    @Override
    public Icon getCollapsedIcon() {
        return this.tree.isEnabled() ? EXPAND_ICON : DISABLED_EXPAND_ICON;
    }

    @Override
    protected void drawCentered(Component c, Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(c, g, this.findCenteredX(x, icon.getIconWidth()), y - icon.getIconHeight() / 2);
    }

    protected int findCenteredX(int x, int iconWidth) {
        return this.leftToRight ? x - 2 - (int)Math.ceil((double)iconWidth / 2.0) : x - 1 - (int)Math.floor((double)iconWidth / 2.0);
    }

    protected void repaintSelection() {
        if (this.tree.getSelectionCount() > 0) {
            for (Rectangle rect : this.getSelectionRects()) {
                this.tree.repaint(rect);
            }
        }
    }

    protected List<Rectangle> getSelectionRects() {
        ArrayList<Rectangle> selections = new ArrayList<Rectangle>();
        int[] rows = this.tree.getSelectionRows();
        if (rows == null) {
            return selections;
        }
        Arrays.sort(rows);
        Insets insets = this.tree.getInsets();
        Rectangle maxRect = null;
        int lastRow = -1;
        for (int row : rows) {
            if (this.selectionStyle.equals((Object)TreeSelectionStyle.single)) {
                selections.add(this.tree.getRowBounds(row));
                continue;
            }
            if (lastRow != -1 && lastRow + 1 != row) {
                selections.add(maxRect);
                maxRect = null;
                lastRow = -1;
            }
            if (lastRow != -1 && lastRow + 1 != row) continue;
            Rectangle b = this.tree.getRowBounds(row);
            if (this.isFullLineSelection()) {
                b.x = insets.left;
                b.width = this.tree.getWidth() - insets.left - insets.right;
            }
            maxRect = lastRow == -1 ? b : GeometryUtils.getContainingRect(maxRect, b);
            lastRow = row;
        }
        if (maxRect != null) {
            selections.add(maxRect);
        }
        return selections;
    }

    @Override
    protected int getHorizontalLegBuffer() {
        return -2;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.tree != c) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        this.paintSelection(g2d);
        this.paintRolloverNodeHighlight(g2d);
        this.paintTree(g2d);
        this.paintDropLocation(g2d);
        this.paintMultiselector(g2d);
    }

    protected void paintSelection(Graphics2D g2d) {
        if (this.tree.getSelectionCount() > 0) {
            List<Rectangle> selections = this.getSelectionRects();
            for (Rectangle rect : selections) {
                LafUtils.drawCustomWebBorder(g2d, this.tree, new RoundRectangle2D.Double(rect.x + this.selectionShadeWidth, rect.y + this.selectionShadeWidth, rect.width - this.selectionShadeWidth * 2 - 1, rect.height - this.selectionShadeWidth * 2 - 1, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, true);
            }
        }
    }

    protected void paintRolloverNodeHighlight(Graphics2D g2d) {
        if (this.tree.isEnabled() && this.highlightRolloverNode && this.rolloverRow != -1 && !this.tree.isRowSelected(this.rolloverRow)) {
            Rectangle rect;
            Rectangle rectangle = rect = this.isFullLineSelection() ? this.getFullRowBounds(this.rolloverRow) : this.tree.getRowBounds(this.rolloverRow);
            if (rect != null) {
                rect.x += this.selectionShadeWidth;
                rect.y += this.selectionShadeWidth;
                rect.width -= this.selectionShadeWidth * 2 + 1;
                rect.height -= this.selectionShadeWidth * 2 + 1;
                Composite old = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(0.35f));
                LafUtils.drawCustomWebBorder(g2d, this.tree, new RoundRectangle2D.Double(rect.x, rect.y, rect.width, rect.height, this.selectionRound * 2, this.selectionRound * 2), StyleConstants.shadeColor, this.selectionShadeWidth, true, true);
                GraphicsUtils.restoreComposite(g2d, old);
            }
        }
    }

    protected void paintTree(Graphics2D g2d) {
        Rectangle paintBounds = g2d.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
        Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
        int endY = paintBounds.y + paintBounds.height;
        int row = this.treeState.getRowForPath(initialPath);
        this.drawingCache.clear();
        if (initialPath != null && paintingEnumerator != null) {
            TreePath parentPath = initialPath;
            for (parentPath = parentPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
                this.paintVerticalPartOfLeg(g2d, paintBounds, insets, parentPath);
                this.drawingCache.put(parentPath, Boolean.TRUE);
            }
            Rectangle boundsBuffer = new Rectangle();
            boolean rootVisible = this.isRootVisible();
            boolean done = false;
            while (!done && paintingEnumerator.hasMoreElements()) {
                TreePath path = paintingEnumerator.nextElement();
                if (path != null) {
                    boolean isExpanded;
                    boolean hasBeenExpanded;
                    boolean isLeaf = this.treeModel.isLeaf(path.getLastPathComponent());
                    if (isLeaf) {
                        hasBeenExpanded = false;
                        isExpanded = false;
                    } else {
                        isExpanded = this.treeState.getExpandedState(path);
                        hasBeenExpanded = this.tree.hasBeenExpanded(path);
                    }
                    Rectangle bounds = this.getPathBounds(path, insets, boundsBuffer);
                    if (bounds == null) {
                        return;
                    }
                    parentPath = path.getParentPath();
                    if (parentPath != null) {
                        if (this.drawingCache.get(parentPath) == null) {
                            this.paintVerticalPartOfLeg(g2d, paintBounds, insets, parentPath);
                            this.drawingCache.put(parentPath, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    } else if (rootVisible && row == 0) {
                        this.paintHorizontalPartOfLeg(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                        this.paintExpandControl(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    }
                    this.paintRow(g2d, paintBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
                    if (bounds.y + bounds.height >= endY) {
                        done = true;
                    }
                } else {
                    done = true;
                }
                ++row;
            }
        }
        this.rendererPane.removeAll();
    }

    protected void paintDropLocation(Graphics2D g2d) {
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        if (dropLocation != null) {
            TreePath dropPath = dropLocation.getPath();
            if (this.isDropLine(dropLocation)) {
                Color background = this.tree.getBackground();
                Color dropLineColor = UIManager.getColor("Tree.dropLineColor");
                Color[] colors = new Color[]{background, dropLineColor, dropLineColor, background};
                Rectangle rect = this.getDropLineRect(dropLocation);
                g2d.setPaint(new LinearGradientPaint(rect.x, rect.y, rect.x + rect.width, rect.y, fractions, colors));
                g2d.fillRect(rect.x, rect.y, rect.width, 1);
            } else {
                Rectangle bounds = this.getNodeDropLocationBounds(dropPath);
                NinePatchIcon dropShade = NinePatchUtils.getShadeIcon(this.dropCellShadeWidth, this.selectionRound, 1.0f);
                dropShade.paintIcon(g2d, bounds);
            }
        }
    }

    protected Rectangle getNodeDropLocationBounds(TreePath dropPath) {
        Rectangle bounds = this.tree.getPathBounds(dropPath);
        bounds.x -= this.dropCellShadeWidth;
        bounds.y -= this.dropCellShadeWidth;
        bounds.width += this.dropCellShadeWidth * 2;
        bounds.height += this.dropCellShadeWidth * 2;
        return bounds;
    }

    protected void paintMultiselector(Graphics2D g2d) {
        if (this.isSelectorAvailable() && this.selectionStart != null && this.selectionEnd != null) {
            Object aa = GraphicsUtils.setupAntialias(g2d);
            Stroke os = GraphicsUtils.setupStroke(g2d, this.selectorStroke);
            Rectangle sb = GeometryUtils.getContainingRect(this.selectionStart, this.selectionEnd);
            Rectangle fsb = sb.intersection(SwingUtils.size(this.tree));
            --fsb.width;
            --fsb.height;
            g2d.setPaint(this.selectorColor);
            g2d.fill(this.getSelectionShape(fsb, true));
            g2d.setPaint(this.selectorBorderColor);
            g2d.draw(this.getSelectionShape(fsb, false));
            GraphicsUtils.restoreStroke(g2d, os);
            GraphicsUtils.restoreAntialias(g2d, aa);
        }
    }

    @Override
    protected boolean isDropLine(JTree.DropLocation loc) {
        return loc != null && loc.getPath() != null && loc.getChildIndex() != -1;
    }

    @Override
    protected Rectangle getDropLineRect(JTree.DropLocation loc) {
        Rectangle rect;
        TreePath path = loc.getPath();
        int index = loc.getChildIndex();
        Insets insets = this.tree.getInsets();
        if (this.tree.getRowCount() == 0) {
            rect = new Rectangle(insets.left, insets.top, this.tree.getWidth() - insets.left - insets.right, 0);
        } else {
            TreeModel model = this.getModel();
            Object root = model.getRoot();
            if (path.getLastPathComponent() == root && index >= model.getChildCount(root)) {
                Rectangle xRect;
                rect = this.tree.getRowBounds(this.tree.getRowCount() - 1);
                rect.y += rect.height;
                if (!this.tree.isRootVisible()) {
                    xRect = this.tree.getRowBounds(0);
                } else if (model.getChildCount(root) == 0) {
                    xRect = this.tree.getRowBounds(0);
                    xRect.x += this.totalChildIndent;
                    xRect.width -= this.totalChildIndent + this.totalChildIndent;
                } else {
                    TreePath lastChildPath = path.pathByAddingChild(model.getChild(root, model.getChildCount(root) - 1));
                    xRect = this.tree.getPathBounds(lastChildPath);
                }
                rect.x = xRect.x;
                rect.width = xRect.width;
            } else {
                rect = this.tree.getPathBounds(path.pathByAddingChild(model.getChild(path.getLastPathComponent(), index)));
            }
        }
        if (rect.y != 0) {
            --rect.y;
        }
        if (!this.leftToRight) {
            rect.x = rect.x + rect.width - 80;
        }
        rect.width = 80;
        rect.height = 2;
        return rect;
    }

    protected Rectangle getPathBounds(TreePath path, Insets insets, Rectangle bounds) {
        if ((bounds = this.treeState.getBounds(path, bounds)) != null) {
            bounds.x = this.leftToRight ? (bounds.x += insets.left) : this.tree.getWidth() - (bounds.x + bounds.width) - insets.right;
            bounds.y += insets.top;
        }
        return bounds;
    }

    protected Shape getSelectionShape(Rectangle sb, boolean fill) {
        int shear;
        int n = shear = fill ? 1 : 0;
        if (this.selectorRound > 0) {
            return new RoundRectangle2D.Double(sb.x + shear, sb.y + shear, sb.width - shear, sb.height - shear, this.selectorRound * 2, this.selectorRound * 2);
        }
        return new Rectangle2D.Double(sb.x + shear, sb.y + shear, sb.width - shear, sb.height - shear);
    }
}

