/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.plugin;

import com.alee.global.GlobalConstants;
import com.alee.log.Log;
import com.alee.managers.plugin.Plugin;
import com.alee.managers.plugin.PluginsListener;
import com.alee.managers.plugin.data.DetectedPlugin;
import com.alee.managers.plugin.data.InitializationStrategy;
import com.alee.managers.plugin.data.PluginInformation;
import com.alee.managers.plugin.data.PluginLibrary;
import com.alee.managers.plugin.data.PluginStatus;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.ZipUtils;
import com.alee.utils.compare.Filter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public abstract class PluginManager<T extends Plugin> {
    protected List<PluginsListener<T>> listeners = new ArrayList<PluginsListener<T>>(1);
    protected final Object checkLock = new Object();
    protected List<DetectedPlugin<T>> detectedPlugins;
    protected List<DetectedPlugin<T>> recentlyDetected;
    protected Filter<DetectedPlugin<T>> pluginFilter = null;
    protected boolean allowSimilarPlugins = false;
    protected List<T> availablePlugins;
    protected Map<String, T> availablePluginsById = new HashMap<String, T>();
    protected Map<Class<? extends Plugin>, T> availablePluginsByClass = new HashMap<Class<? extends Plugin>, T>();
    protected List<T> recentlyInitialized;
    protected String pluginsDirectoryPath;
    protected boolean checkRecursively;
    protected FileFilter fileFilter;
    protected boolean createNewClassLoader = false;

    public PluginManager() {
        this(null);
    }

    public PluginManager(String pluginsDirectoryPath) {
        this(pluginsDirectoryPath, true);
    }

    public PluginManager(String pluginsDirectoryPath, boolean checkRecursively) {
        this.pluginsDirectoryPath = pluginsDirectoryPath;
        this.checkRecursively = checkRecursively;
        this.fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".plugin");
            }
        };
        this.detectedPlugins = new ArrayList<DetectedPlugin<T>>();
        this.availablePlugins = new ArrayList<T>(this.detectedPlugins.size());
    }

    protected String getPluginDescriptorFile() {
        return "plugin.xml";
    }

    protected String getPluginLogoFile() {
        return "logo.png";
    }

    protected String getAcceptedPluginType() {
        return null;
    }

    public void registerPlugin(T plugin) {
        this.registerPlugin(plugin, ((Plugin)plugin).getPluginInformation(), ((Plugin)plugin).getPluginLogo());
    }

    public void registerPlugin(T plugin, PluginInformation information, ImageIcon logo) {
        String prefix = "[" + information + "] ";
        Log.info(this, prefix + "Initializing pre-loaded plugin...", new Object[0]);
        DetectedPlugin detectedPlugin = new DetectedPlugin(null, null, information, logo);
        detectedPlugin.setStatus(PluginStatus.loaded);
        detectedPlugin.setPlugin(plugin);
        ((Plugin)plugin).setPluginManager(this);
        ((Plugin)plugin).setDetectedPlugin(detectedPlugin);
        this.detectedPlugins.add(detectedPlugin);
        this.availablePlugins.add(plugin);
        this.availablePluginsById.put(((Plugin)plugin).getId(), plugin);
        this.availablePluginsByClass.put(plugin.getClass(), plugin);
        Log.info(this, prefix + "Pre-loaded plugin initialized", new Object[0]);
        this.firePluginsInitialized(Arrays.asList(plugin));
    }

    public void checkPlugins() {
        this.checkPlugins(this.pluginsDirectoryPath, this.checkRecursively);
    }

    public void checkPlugins(boolean checkRecursively) {
        this.checkPlugins(this.pluginsDirectoryPath, checkRecursively);
    }

    public void checkPlugins(String pluginsDirectoryPath) {
        this.checkPlugins(pluginsDirectoryPath, this.checkRecursively);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPlugins(String pluginsDirectoryPath, boolean checkRecursively) {
        Object object = this.checkLock;
        synchronized (object) {
            if (pluginsDirectoryPath == null) {
                return;
            }
            this.firePluginsCheckStarted(pluginsDirectoryPath, checkRecursively);
            if (this.collectPluginsInformation(pluginsDirectoryPath, checkRecursively)) {
                this.firePluginsDetected(this.recentlyDetected);
                Log.info(this, "Initializing plugins...", new Object[0]);
                this.initializePlugins();
                this.applyInitializationStrategy();
                Collections.sort(this.recentlyInitialized, new Comparator<T>(){

                    @Override
                    public int compare(T o1, T o2) {
                        Integer i1 = PluginManager.this.availablePlugins.indexOf(o1);
                        Integer i2 = PluginManager.this.availablePlugins.indexOf(o2);
                        return i1.compareTo(i2);
                    }
                });
                this.firePluginsInitialized(this.recentlyInitialized);
                Log.info(this, "Plugins initialization finished", new Object[0]);
            }
            this.firePluginsCheckEnded(pluginsDirectoryPath, checkRecursively);
        }
    }

    protected boolean collectPluginsInformation(String pluginsDirectoryPath, boolean checkRecursively) {
        if (pluginsDirectoryPath != null) {
            Log.info(this, "Collecting plugins information...", new Object[0]);
            this.recentlyDetected = new ArrayList<DetectedPlugin<T>>();
            return this.collectPluginsInformationImpl(new File(pluginsDirectoryPath), checkRecursively);
        }
        Log.error((Object)this, "Plugins directory is not yet specified");
        return false;
    }

    protected boolean collectPluginsInformationImpl(File dir, boolean checkRecursively) {
        File[] subfolders;
        File[] files = dir.listFiles(this.fileFilter);
        if (files != null) {
            for (File file : files) {
                this.collectPluginInformation(file);
            }
        }
        if (checkRecursively && (subfolders = dir.listFiles(GlobalConstants.DIRECTORIES_FILTER)) != null) {
            for (File subfolder : subfolders) {
                this.collectPluginsInformationImpl(subfolder, checkRecursively);
            }
        }
        return true;
    }

    protected void collectPluginInformation(File file) {
        try {
            String pluginDescriptor = this.getPluginDescriptorFile();
            String pluginLogo = this.getPluginLogoFile();
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ImageIcon logo;
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(pluginDescriptor)) continue;
                InputStream inputStream = zipFile.getInputStream(entry);
                PluginInformation info = (PluginInformation)XmlUtils.fromXML(inputStream);
                inputStream.close();
                ZipEntry logoEntry = new ZipEntry(ZipUtils.getZipEntryFileLocation(entry) + pluginLogo);
                InputStream logoInputStream = zipFile.getInputStream(logoEntry);
                if (logoInputStream != null) {
                    logo = new ImageIcon(ImageIO.read(logoInputStream));
                    logoInputStream.close();
                } else {
                    logo = null;
                }
                if (this.wasDetected(file.getParent(), file.getName())) break;
                DetectedPlugin plugin = new DetectedPlugin(file.getParent(), file.getName(), info, logo);
                this.detectedPlugins.add(plugin);
                this.recentlyDetected.add(plugin);
                Log.info(this, "Plugin detected: " + info, new Object[0]);
                break;
            }
            zipFile.close();
        }
        catch (IOException e) {
            Log.error((Object)this, (Throwable)e);
        }
    }

    protected boolean wasDetected(String pluginFolder, String pluginFile) {
        for (DetectedPlugin<T> plugin : this.detectedPlugins) {
            if (plugin.getPluginFile() == null || !plugin.getPluginFolder().equals(pluginFolder) || !plugin.getPluginFile().equals(pluginFile)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void initializePlugins() {
        HashMap<String, HashMap<PluginLibrary, PluginInformation>> pluginLibraries = new HashMap<String, HashMap<PluginLibrary, PluginInformation>>();
        this.recentlyInitialized = new ArrayList<T>();
        String acceptedPluginType = this.getAcceptedPluginType();
        for (DetectedPlugin<Plugin> detectedPlugin : this.detectedPlugins) {
            if (detectedPlugin.getStatus() != PluginStatus.detected) continue;
            File pluginFile = new File(detectedPlugin.getPluginFolder(), detectedPlugin.getPluginFile());
            PluginInformation info = detectedPlugin.getInformation();
            String prefix = "[" + FileUtils.getRelativePath(pluginFile, new File(this.pluginsDirectoryPath)) + "] [" + info + "] ";
            try {
                if (!(acceptedPluginType == null || info.getType() != null && info.getType().equals(acceptedPluginType))) {
                    Log.warn(this, prefix + "Plugin of type \"" + info.getType() + "\" cannot be loaded, " + "required plugin type is \"" + acceptedPluginType + "\"");
                    detectedPlugin.setStatus(PluginStatus.failed);
                    detectedPlugin.setFailureCause("Wrong type");
                    detectedPlugin.setExceptionMessage("Detected plugin type: " + info.getType() + "\", " + "required plugin type: \"" + acceptedPluginType + "\"");
                    continue;
                }
                if (this.isDeprecatedVersion(detectedPlugin)) {
                    Log.warn(this, prefix + "This plugin is deprecated, newer version loaded instead");
                    detectedPlugin.setStatus(PluginStatus.failed);
                    detectedPlugin.setFailureCause("Deprecated");
                    detectedPlugin.setExceptionMessage("This plugin is deprecated, newer version loaded instead");
                    continue;
                }
                if (this.isSameVersionAlreadyLoaded(detectedPlugin, this.detectedPlugins)) {
                    Log.warn(this, prefix + "Plugin is duplicate, it will be loaded from another file");
                    detectedPlugin.setStatus(PluginStatus.failed);
                    detectedPlugin.setFailureCause("Duplicate");
                    detectedPlugin.setExceptionMessage("This plugin is duplicate, it will be loaded from another file");
                    continue;
                }
                if (this.getPluginFilter() != null && !this.getPluginFilter().accept(detectedPlugin)) {
                    Log.info(this, prefix + "Plugin was not accepted by plugin filter", new Object[0]);
                    detectedPlugin.setStatus(PluginStatus.failed);
                    detectedPlugin.setFailureCause("Filtered");
                    detectedPlugin.setExceptionMessage("Plugin was not accepted by plugin filter");
                    continue;
                }
                Log.info(this, prefix + "Initializing plugin...", new Object[0]);
                detectedPlugin.setStatus(PluginStatus.loading);
                ArrayList<URL> jarPaths = new ArrayList<URL>(1 + info.getLibrariesCount());
                jarPaths.add(pluginFile.toURI().toURL());
                if (info.getLibraries() != null) {
                    for (PluginLibrary pluginLibrary : info.getLibraries()) {
                        File file = new File(detectedPlugin.getPluginFolder(), pluginLibrary.getFile());
                        if (file.exists()) {
                            jarPaths.add(file.toURI().toURL());
                            HashMap<PluginLibrary, PluginInformation> libraries = (HashMap<PluginLibrary, PluginInformation>)pluginLibraries.get(pluginLibrary.getId());
                            if (libraries == null) {
                                libraries = new HashMap<PluginLibrary, PluginInformation>(1);
                                pluginLibraries.put(pluginLibrary.getId(), libraries);
                            }
                            libraries.put(pluginLibrary, info);
                            continue;
                        }
                        Log.warn(this, prefix + "Unable to locate library: " + pluginLibrary.getFile());
                    }
                }
                try {
                    void var10_18;
                    ClassLoader cl = this.getClass().getClassLoader();
                    if (this.createNewClassLoader || !(cl instanceof URLClassLoader)) {
                        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(jarPaths.toArray(new URL[jarPaths.size()]), cl);
                    } else {
                        ClassLoader classLoader = cl;
                        for (URL url : jarPaths) {
                            ReflectUtils.callMethodSafely(classLoader, "addURL", url);
                        }
                    }
                    Class<?> pluginClass = var10_18.loadClass(info.getMainClass());
                    Plugin plugin = (Plugin)ReflectUtils.createInstance(pluginClass, new Object[0]);
                    plugin.setPluginManager(this);
                    plugin.setDetectedPlugin(detectedPlugin);
                    this.availablePlugins.add(plugin);
                    this.availablePluginsById.put(plugin.getId(), plugin);
                    this.availablePluginsByClass.put(plugin.getClass(), plugin);
                    this.recentlyInitialized.add(plugin);
                    Log.info(this, prefix + "Plugin initialized", new Object[0]);
                    detectedPlugin.setStatus(PluginStatus.loaded);
                    detectedPlugin.setPlugin(plugin);
                }
                catch (Throwable e) {
                    Log.error(this, prefix + "Unable to initialize plugin", e);
                    detectedPlugin.setStatus(PluginStatus.failed);
                    detectedPlugin.setFailureCause("Internal exception");
                    detectedPlugin.setException(e);
                }
            }
            catch (Throwable e) {
                Log.error(this, prefix + "Unable to initialize plugin data", e);
                detectedPlugin.setStatus(PluginStatus.failed);
                detectedPlugin.setFailureCause("Data exception");
                detectedPlugin.setException(e);
            }
        }
        boolean warned = false;
        for (Map.Entry libraries : pluginLibraries.entrySet()) {
            Map sameLibraries = (Map)libraries.getValue();
            if (sameLibraries.size() <= 1) continue;
            String title = ((PluginLibrary)sameLibraries.keySet().iterator().next()).getTitle();
            StringBuilder sb = new StringBuilder("Library [ ").append(title).append(" ] was found in plugins: ");
            for (Map.Entry entry : sameLibraries.entrySet()) {
                PluginInformation plugin = (PluginInformation)entry.getValue();
                String libraryVersion = ((PluginLibrary)entry.getKey()).getVersion();
                sb.append("[ ").append(plugin.toString()).append(", version ").append(libraryVersion).append(" ] ");
            }
            Log.warn(this, sb.toString());
            warned = true;
        }
        if (warned) {
            Log.warn(this, "Make sure the same library usafe within different plugins was actually your intent");
        }
    }

    public boolean isDeprecatedVersion(DetectedPlugin<T> plugin) {
        return this.isDeprecatedVersion(plugin, this.detectedPlugins);
    }

    public boolean isDeprecatedVersion(DetectedPlugin<T> plugin, List<DetectedPlugin<T>> detectedPlugins) {
        PluginInformation pluginInfo = plugin.getInformation();
        for (DetectedPlugin<T> detectedPlugin : detectedPlugins) {
            PluginInformation detectedPluginInfo;
            if (detectedPlugin == plugin || !(detectedPluginInfo = detectedPlugin.getInformation()).getId().equals(pluginInfo.getId()) || detectedPluginInfo.getVersion() == null || pluginInfo.getVersion() == null || !detectedPluginInfo.getVersion().isNewerThan(pluginInfo.getVersion())) continue;
            return true;
        }
        return false;
    }

    protected boolean isSameVersionAlreadyLoaded(DetectedPlugin<T> plugin, List<DetectedPlugin<T>> detectedPlugins) {
        PluginInformation pluginInfo = plugin.getInformation();
        for (DetectedPlugin<T> detectedPlugin : detectedPlugins) {
            PluginInformation detectedPluginInfo;
            if (detectedPlugin == plugin || !(detectedPluginInfo = detectedPlugin.getInformation()).getId().equals(pluginInfo.getId()) || (detectedPluginInfo.getVersion() != null || pluginInfo.getVersion() != null) && !detectedPluginInfo.getVersion().isSame(pluginInfo.getVersion()) || detectedPlugin.getStatus() != PluginStatus.loaded) continue;
            return true;
        }
        return false;
    }

    protected void applyInitializationStrategy() {
        if (this.availablePlugins.size() == 0) {
            return;
        }
        ArrayList<Plugin> beforeAll = new ArrayList<Plugin>(this.availablePlugins.size());
        ArrayList<Plugin> middle = new ArrayList<Plugin>(this.availablePlugins.size());
        ArrayList<Plugin> afterAll = new ArrayList<Plugin>(this.availablePlugins.size());
        for (Plugin plugin : this.availablePlugins) {
            InitializationStrategy strategy = plugin.getInitializationStrategy();
            if (strategy.getId().equals("all")) {
                switch (strategy.getType()) {
                    case before: {
                        beforeAll.add(plugin);
                        break;
                    }
                    case any: {
                        middle.add(plugin);
                        break;
                    }
                    case after: {
                        afterAll.add(plugin);
                    }
                }
                continue;
            }
            middle.add(plugin);
        }
        if (middle.size() == 0) {
            this.availablePlugins.clear();
            this.availablePlugins.addAll(beforeAll);
            this.availablePlugins.addAll(afterAll);
        } else {
            ArrayList<Plugin> sortedMiddle = new ArrayList<Plugin>(middle);
            block10: for (Plugin plugin : middle) {
                InitializationStrategy strategy = plugin.getInitializationStrategy();
                String id = strategy.getId();
                if (plugin.getId().equals(id)) continue;
                int oldIndex = sortedMiddle.indexOf(plugin);
                for (int index = 0; index < sortedMiddle.size(); ++index) {
                    if (!((Plugin)sortedMiddle.get(index)).getId().equals(id)) continue;
                    switch (strategy.getType()) {
                        case before: {
                            sortedMiddle.remove(oldIndex);
                            if (oldIndex < index) {
                                sortedMiddle.add(index - 1, plugin);
                                break;
                            }
                            sortedMiddle.add(index, plugin);
                            break;
                        }
                        case after: {
                            sortedMiddle.remove(oldIndex);
                            if (oldIndex < index) {
                                sortedMiddle.add(index, plugin);
                                break;
                            }
                            sortedMiddle.add(index + 1, plugin);
                        }
                    }
                    continue block10;
                }
            }
            this.availablePlugins.clear();
            this.availablePlugins.addAll(beforeAll);
            this.availablePlugins.addAll(sortedMiddle);
            this.availablePlugins.addAll(afterAll);
        }
    }

    public List<DetectedPlugin<T>> getDetectedPlugins() {
        return this.detectedPlugins;
    }

    public List<T> getAvailablePlugins() {
        return this.availablePlugins;
    }

    public <P extends T> P getPlugin(String pluginId) {
        return (P)((Plugin)this.availablePluginsById.get(pluginId));
    }

    public <P extends T> P getPlugin(Class<P> pluginClass) {
        return (P)((Plugin)this.availablePluginsByClass.get(pluginClass));
    }

    public int getDetectedPluginsAmount() {
        return this.getDetectedPlugins().size();
    }

    public int getLoadedPluginsAmount() {
        return this.getAvailablePlugins().size();
    }

    public int getFailedPluginsAmount() {
        return this.getDetectedPlugins().size() - this.getAvailablePlugins().size();
    }

    public String getPluginsDirectoryPath() {
        return this.pluginsDirectoryPath;
    }

    public void setPluginsDirectoryPath(String path) {
        this.pluginsDirectoryPath = path;
    }

    public boolean isCheckRecursively() {
        return this.checkRecursively;
    }

    public void setCheckRecursively(boolean checkRecursively) {
        this.checkRecursively = checkRecursively;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter filter) {
        this.fileFilter = filter;
    }

    public boolean isCreateNewClassLoader() {
        return this.createNewClassLoader;
    }

    public void setCreateNewClassLoader(boolean createNewClassLoader) {
        this.createNewClassLoader = createNewClassLoader;
    }

    public Filter<DetectedPlugin<T>> getPluginFilter() {
        return this.pluginFilter;
    }

    public void setPluginFilter(Filter<DetectedPlugin<T>> pluginFilter) {
        this.pluginFilter = pluginFilter;
    }

    public boolean isAllowSimilarPlugins() {
        return this.allowSimilarPlugins;
    }

    public void setAllowSimilarPlugins(boolean allow) {
        this.allowSimilarPlugins = allow;
    }

    public void addPluginsListener(PluginsListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removePluginsListener(PluginsListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void firePluginsCheckStarted(String directory, boolean recursive) {
        for (PluginsListener<T> listener : CollectionUtils.copy(this.listeners)) {
            listener.pluginsCheckStarted(directory, recursive);
        }
    }

    public void firePluginsCheckEnded(String directory, boolean recursive) {
        for (PluginsListener<T> listener : CollectionUtils.copy(this.listeners)) {
            listener.pluginsCheckEnded(directory, recursive);
        }
    }

    public void firePluginsDetected(List<DetectedPlugin<T>> plugins) {
        for (PluginsListener<T> listener : CollectionUtils.copy(this.listeners)) {
            listener.pluginsDetected(CollectionUtils.copy(plugins));
        }
    }

    public void firePluginsInitialized(List<T> plugins) {
        for (PluginsListener<T> listener : CollectionUtils.copy(this.listeners)) {
            listener.pluginsInitialized(CollectionUtils.copy(plugins));
        }
    }
}

