/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.painter.Painter;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.PopupManager;
import com.alee.managers.popup.PopupStyle;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.DataProvider;
import com.alee.utils.swing.EmptyMouseAdapter;
import com.alee.utils.swing.FadeStateType;
import com.alee.utils.swing.PopupListener;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebPopup
extends WebPanel {
    protected List<PopupListener> popupListeners = new ArrayList<PopupListener>(2);
    protected static final int fadeFps = 24;
    protected static final long fadeTime = 400L;
    protected boolean animated = false;
    protected boolean closeOnFocusLoss = false;
    protected boolean requestFocusOnShow = true;
    protected Component defaultFocusComponent = null;
    protected List<Component> focusableChilds = new ArrayList<Component>();
    protected Component lastComponent = null;
    protected ComponentListener lastComponentListener = null;
    protected AncestorListener lastAncestorListener = null;
    protected boolean focused = false;
    protected FadeStateType fadeStateType;
    protected float fade = 0.0f;
    protected WebTimer fadeTimer;
    protected DefaultFocusTracker focusTracker;

    public WebPopup() {
        this(PopupManager.getDefaultPopupPainter());
    }

    public WebPopup(PopupStyle popupStyle) {
        this(PopupManager.getPopupPainter(popupStyle));
    }

    public WebPopup(Painter stylePainter) {
        super(stylePainter);
        this.initializePopup();
    }

    protected void initializePopup() {
        this.setOpaque(false);
        this.setFocusCycleRoot(true);
        EmptyMouseAdapter.install(this);
        this.fadeTimer = new WebTimer("WebPopup.fade", 41L);
        this.fadeTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float roundsCount = 9.599999f;
                float fadeSpeed = 0.10416667f;
                if (WebPopup.this.fadeStateType.equals((Object)FadeStateType.fadeIn)) {
                    if (WebPopup.this.fade < 1.0f) {
                        WebPopup.this.fade = Math.min(WebPopup.this.fade + 0.10416667f, 1.0f);
                        WebPopup.this.repaint();
                    } else {
                        WebPopup.this.fadeTimer.stop();
                    }
                } else if (WebPopup.this.fadeStateType.equals((Object)FadeStateType.fadeOut)) {
                    if (WebPopup.this.fade > 0.0f) {
                        WebPopup.this.fade = Math.max(WebPopup.this.fade - 0.10416667f, 0.0f);
                        WebPopup.this.repaint();
                    } else {
                        WebPopup.this.hidePopupImpl();
                        WebPopup.this.fadeTimer.stop();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (WebPopup.this.requestFocusOnShow) {
                    if (WebPopup.this.defaultFocusComponent != null) {
                        WebPopup.this.defaultFocusComponent.requestFocusInWindow();
                    } else {
                        WebPopup.this.transferFocus();
                    }
                }
                if (WebPopup.this.animated) {
                    WebPopup.this.fade = 0.0f;
                    WebPopup.this.fadeStateType = FadeStateType.fadeIn;
                    WebPopup.this.fadeTimer.start();
                } else {
                    WebPopup.this.fade = 1.0f;
                }
                WebPopup.this.firePopupOpened();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                WebPopup.this.firePopupClosed();
            }
        });
        this.focusTracker = new DefaultFocusTracker(true){

            @Override
            public boolean isTrackingEnabled() {
                return WebPopup.this.isShowing();
            }

            @Override
            public void focusChanged(boolean focused) {
                WebPopup.this.focusChanged(focused);
            }
        };
        FocusManager.addFocusTracker(this, this.focusTracker);
    }

    protected void focusChanged(boolean focused) {
        if (this.isShowing() && !focused && !this.isChildFocused() && this.closeOnFocusLoss) {
            this.hidePopup();
        }
    }

    public PopupLayer getPopupLayer() {
        return (PopupLayer)this.getParent();
    }

    public void setPopupStyle(PopupStyle popupStyle) {
        this.setPainter(PopupManager.getPopupPainter(popupStyle));
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean closeOnFocusLoss) {
        this.closeOnFocusLoss = closeOnFocusLoss;
    }

    public boolean isRequestFocusOnShow() {
        return this.requestFocusOnShow;
    }

    public void setRequestFocusOnShow(boolean requestFocusOnShow) {
        this.requestFocusOnShow = requestFocusOnShow;
    }

    public Component getDefaultFocusComponent() {
        return this.defaultFocusComponent;
    }

    public void setDefaultFocusComponent(Component defaultFocusComponent) {
        this.defaultFocusComponent = defaultFocusComponent;
    }

    public List<Component> getFocusableChilds() {
        return this.focusableChilds;
    }

    public void addFocusableChild(Component child) {
        this.focusableChilds.add(child);
    }

    public void removeFocusableChild(Component child) {
        this.focusableChilds.remove(child);
    }

    public boolean isChildFocused() {
        for (Component child : this.focusableChilds) {
            if (!SwingUtils.hasFocusOwner(child)) continue;
            return true;
        }
        return false;
    }

    public void showAsPopupMenu(final Component component) {
        this.showPopup(component, new DataProvider<Rectangle>(){

            @Override
            public Rectangle provide() {
                Rectangle cb = SwingUtils.getBoundsInWindow(component);
                Dimension rps = SwingUtils.getRootPane(component).getSize();
                Dimension ps = WebPopup.this.getPreferredSize();
                Point p = new Point();
                p.x = cb.x + ps.width < rps.width || rps.width - cb.x - ps.width > cb.x ? 0 : cb.width - ps.width;
                p.y = cb.y + cb.height + ps.height < rps.height || rps.height - cb.y - cb.height - ps.height > cb.y ? cb.height : -ps.height;
                return new Rectangle(p, WebPopup.this.getPreferredSize());
            }
        });
    }

    public void showPopup(Component component) {
        PopupManager.showPopup(component, this, this.requestFocusOnShow);
        this.clearLocationListeners();
    }

    public void showPopup(Component component, Rectangle bounds) {
        this.showPopup(component, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void showPopup(Component component, int x, int y, int width, int height) {
        this.updatePopupBounds(component, x, y, width, height);
        PopupManager.showPopup(component, this, this.requestFocusOnShow);
        this.updateComponentAncestorListener(component, x, y, width, height);
    }

    public void showPopup(Component component, Point location) {
        this.showPopup(component, location.x, location.y);
    }

    public void showPopup(Component component, final int x, final int y) {
        this.showPopup(component, new DataProvider<Rectangle>(){

            @Override
            public Rectangle provide() {
                Dimension ps = WebPopup.this.getPreferredSize();
                return new Rectangle(x, y, ps.width, ps.height);
            }
        });
    }

    public void showPopup(Component component, DataProvider<Rectangle> boundsProvider) {
        this.updatePopupBounds(component, boundsProvider.provide());
        PopupManager.showPopup(component, this, this.requestFocusOnShow);
        this.updateLocationListeners(component, boundsProvider);
    }

    protected void updatePopupBounds(Component component, Rectangle bounds) {
        this.updatePopupBounds(component, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void updatePopupBounds(Component component, int x, int y, int width, int height) {
        if (component.isShowing()) {
            Rectangle cb = SwingUtils.getBoundsInWindow(component);
            this.setBounds(cb.x + x, cb.y + y, width, height);
            this.revalidate();
            this.repaint();
        }
    }

    protected void updateComponentAncestorListener(final Component component, final int x, final int y, final int width, final int height) {
        this.clearLocationListeners();
        this.lastComponent = component;
        if (component instanceof JComponent) {
            this.lastAncestorListener = new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    WebPopup.this.updatePopupBounds(component, x, y, width, height);
                }
            };
            ((JComponent)this.lastComponent).addAncestorListener(this.lastAncestorListener);
        }
    }

    protected void updateLocationListeners(final Component component, final DataProvider<Rectangle> boundsProvider) {
        this.clearLocationListeners();
        this.lastComponent = component;
        this.lastComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                WebPopup.this.updatePopupBounds(component, (Rectangle)boundsProvider.provide());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                WebPopup.this.updatePopupBounds(component, (Rectangle)boundsProvider.provide());
            }
        };
        this.lastComponent.addComponentListener(this.lastComponentListener);
        if (component instanceof JComponent) {
            this.lastAncestorListener = new AncestorAdapter(){

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    WebPopup.this.updatePopupBounds(component, (Rectangle)boundsProvider.provide());
                }
            };
            ((JComponent)this.lastComponent).addAncestorListener(this.lastAncestorListener);
        }
    }

    protected void clearLocationListeners() {
        if (this.lastComponent != null) {
            if (this.lastComponentListener != null) {
                this.lastComponent.removeComponentListener(this.lastComponentListener);
            }
            if (this.lastAncestorListener != null && this.lastComponent instanceof JComponent) {
                ((JComponent)this.lastComponent).removeAncestorListener(this.lastAncestorListener);
            }
        }
    }

    public void showPopupAsModal(Component component) {
        this.showPopupAsModal(component, false, false);
    }

    public void showPopupAsModal(Component component, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(component, this, hfill, vfill);
    }

    public void hidePopup() {
        if (this.animated) {
            this.fadeStateType = FadeStateType.fadeOut;
            if (!this.fadeTimer.isRunning()) {
                this.fadeTimer.start();
            }
        } else {
            this.hidePopupImpl();
        }
    }

    protected void hidePopupImpl() {
        this.clearLocationListeners();
        PopupLayer layer = (PopupLayer)this.getParent();
        if (layer != null) {
            layer.hidePopup(this);
        }
    }

    public void packPopup() {
        this.setSize(this.getPreferredSize());
    }

    public void updateBounds() {
        if (this.lastAncestorListener != null) {
            this.lastAncestorListener.ancestorMoved(null);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return this.fadeStateType != FadeStateType.fadeOut && this.provideShape().contains(x, y);
    }

    public void addPopupListener(PopupListener listener) {
        this.popupListeners.add(listener);
    }

    public void removePopupListener(PopupListener listener) {
        this.popupListeners.remove(listener);
    }

    public void firePopupWillBeOpened() {
        for (PopupListener listener : CollectionUtils.copy(this.popupListeners)) {
            listener.popupWillBeOpened();
        }
    }

    public void firePopupOpened() {
        for (PopupListener listener : CollectionUtils.copy(this.popupListeners)) {
            listener.popupOpened();
        }
    }

    public void firePopupWillBeClosed() {
        for (PopupListener listener : CollectionUtils.copy(this.popupListeners)) {
            listener.popupWillBeClosed();
        }
    }

    public void firePopupClosed() {
        for (PopupListener listener : CollectionUtils.copy(this.popupListeners)) {
            listener.popupClosed();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.fade < 1.0f) {
            GraphicsUtils.setupAlphaComposite((Graphics2D)g, Float.valueOf(this.fade));
        }
        super.paintComponent(g);
    }
}

