/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.log.Log;
import com.alee.managers.settings.ComponentSettingsManager;
import com.alee.managers.settings.DefaultValue;
import com.alee.managers.settings.ReadState;
import com.alee.managers.settings.SettingsGroup;
import com.alee.managers.settings.SettingsGroupState;
import com.alee.managers.settings.SettingsListener;
import com.alee.managers.settings.SettingsProcessor;
import com.alee.managers.settings.SettingsProcessorData;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SettingsManager {
    private static final Map<String, Map<String, List<SettingsListener>>> settingsListeners = new HashMap<String, Map<String, List<SettingsListener>>>();
    private static String settingsFilesExtension = ".xml";
    private static String backupFilesExtension = ".backup";
    private static String defaultSettingsDir = null;
    private static String defaultSettingsDirName = ".weblaf";
    private static String defaultSettingsGroup = "default";
    private static final Map<String, String> groupFileLocation = new HashMap<String, String>();
    private static final Map<String, SettingsGroupState> groupState = new HashMap<String, SettingsGroupState>();
    private static final Map<String, SettingsGroup> groups = new HashMap<String, SettingsGroup>();
    private static final Map<String, Object> files = new HashMap<String, Object>();
    private static boolean saveOnChange = true;
    private static boolean saveDefaultValues = true;
    private static final Object saveOnChangeLock = new Object();
    private static long saveOnChangeDelay = 500L;
    private static WebTimer groupSaveScheduler = null;
    private static final List<String> groupsToSaveOnChange = new ArrayList<String>();
    private static boolean displayExceptions = true;
    private static boolean allowSave = true;
    private static boolean initialized = false;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            XmlUtils.processAnnotations(SettingsGroup.class);
            XmlUtils.processAnnotations(SettingsGroupState.class);
            XmlUtils.processAnnotations(ReadState.class);
            ComponentSettingsManager.initializeManager();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    SettingsManager.saveSettings();
                }
            }));
        }
    }

    public static List<SettingsGroup> getLoadedGroups() {
        return CollectionUtils.copy(groups.values());
    }

    public static Map<String, SettingsGroup> getLoadedGroupsMap() {
        return groups;
    }

    public static void registerComponent(Component component, String key) {
        SettingsManager.registerComponent(component, key, (Object)null);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent(component, key, SettingsManager.getDefaultValue(defaultValueClass));
    }

    public static void registerComponent(Component component, String key, Object defaultValue) {
        SettingsManager.registerComponent(component, defaultSettingsGroup, key, defaultValue);
    }

    public static void registerComponent(Component component, String group, String key) {
        SettingsManager.registerComponent(component, group, key, (Object)null);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String group, String key, Class<T> defaultValueClass) {
        SettingsManager.registerComponent(component, group, key, SettingsManager.getDefaultValue(defaultValueClass));
    }

    public static void registerComponent(Component component, String group, String key, Object defaultValue) {
        SettingsManager.registerComponent(component, group, key, defaultValue, true, true);
    }

    public static void registerComponent(Component component, String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, key, null, loadInitialSettings, applySettingsChanges);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, key, SettingsManager.getDefaultValue(defaultValueClass), loadInitialSettings, applySettingsChanges);
    }

    public static void registerComponent(Component component, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, defaultSettingsGroup, key, defaultValue, loadInitialSettings, applySettingsChanges);
    }

    public static <T extends DefaultValue> void registerComponent(Component component, String group, String key, Class<T> defaultValueClass, boolean loadInitialSettings, boolean applySettingsChanges) {
        SettingsManager.registerComponent(component, group, key, SettingsManager.getDefaultValue(defaultValueClass), loadInitialSettings, applySettingsChanges);
    }

    public static void registerComponent(Component component, String group, String key, Object defaultValue, boolean loadInitialSettings, boolean applySettingsChanges) {
        ComponentSettingsManager.registerComponent(new SettingsProcessorData(component, group, key, defaultValue, loadInitialSettings, applySettingsChanges));
    }

    public static void registerComponent(Component component, SettingsProcessor settingsProcessor) {
        ComponentSettingsManager.registerComponent(component, settingsProcessor);
    }

    public static void unregisterComponent(Component component) {
        ComponentSettingsManager.unregisterComponent(component);
    }

    public static void loadComponentSettings(Component component) {
        ComponentSettingsManager.loadSettings(component);
    }

    public static void saveComponentSettings(Component component) {
        ComponentSettingsManager.saveSettings(component);
    }

    public static <T extends SettingsProcessor> void registerSettingsProcessor(Class componentType, Class<T> settingsProcessor) {
        ComponentSettingsManager.registerSettingsProcessor(componentType, settingsProcessor);
    }

    public static Boolean getBoolean(String key) {
        return SettingsManager.get(key, (Boolean)null);
    }

    public static Boolean getBoolean(String group, String key) {
        return SettingsManager.get(group, key, (Boolean)null);
    }

    public static String getString(String key) {
        return SettingsManager.get(key, (String)null);
    }

    public static String getString(String group, String key) {
        return SettingsManager.get(group, key, (String)null);
    }

    public static Integer getInteger(String key) {
        return SettingsManager.get(key, (Integer)null);
    }

    public static Integer getInteger(String group, String key) {
        return SettingsManager.get(group, key, (Integer)null);
    }

    public static Long getLong(String key) {
        return SettingsManager.get(key, (Long)null);
    }

    public static Long getLong(String group, String key) {
        return SettingsManager.get(group, key, (Long)null);
    }

    public static Float getFloat(String key) {
        return SettingsManager.get(key, (Float)null);
    }

    public static Float getFloat(String group, String key) {
        return SettingsManager.get(group, key, (Float)null);
    }

    public static Double getDouble(String key) {
        return SettingsManager.get(key, (Double)null);
    }

    public static Double getDouble(String group, String key) {
        return SettingsManager.get(group, key, (Double)null);
    }

    public static Dimension getDimension(String key) {
        return SettingsManager.get(key, (Dimension)null);
    }

    public static Dimension getDimension(String group, String key) {
        return SettingsManager.get(group, key, (Dimension)null);
    }

    public static Point getPoint(String key) {
        return SettingsManager.get(key, (Point)null);
    }

    public static Point getPoint(String group, String key) {
        return SettingsManager.get(group, key, (Point)null);
    }

    public static Color getColor(String key) {
        return SettingsManager.get(key, (Color)null);
    }

    public static Color getColor(String group, String key) {
        return SettingsManager.get(group, key, (Color)null);
    }

    public static Rectangle getRectangle(String key) {
        return SettingsManager.get(key, (Rectangle)null);
    }

    public static Rectangle getRectangle(String group, String key) {
        return SettingsManager.get(group, key, (Rectangle)null);
    }

    public static Insets getInsets(String key) {
        return SettingsManager.get(key, (Insets)null);
    }

    public static Insets getInsets(String group, String key) {
        return SettingsManager.get(group, key, (Insets)null);
    }

    public static <T> T get(String key) {
        return (T)SettingsManager.get(key, (Object)null);
    }

    public static <T extends DefaultValue> T get(String key, Class<T> defaultValueClass) {
        return (T)((DefaultValue)SettingsManager.get(defaultSettingsGroup, key, SettingsManager.getDefaultValue(defaultValueClass)));
    }

    public static <T> T get(String key, T defaultValue) {
        return SettingsManager.get(defaultSettingsGroup, key, defaultValue);
    }

    public static <T extends DefaultValue> T get(String group, String key, Class<T> defaultValueClass) {
        return (T)((DefaultValue)SettingsManager.get(group, key, SettingsManager.getDefaultValue(defaultValueClass)));
    }

    public static <T> T get(String group, String key, T defaultValue) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        Object value = settingsGroup.get(key);
        if (value == null && defaultValue != null) {
            value = defaultValue;
            if (saveDefaultValues) {
                SettingsManager.set(group, key, value);
            }
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            if (displayExceptions) {
                Log.error(SettingsManager.class, "Unable to load settings value for group \"" + group + "\" and key \"" + key + "\" because it has inappropriate class type:", e);
            }
            if (saveDefaultValues) {
                SettingsManager.set(group, key, defaultValue);
            }
            return defaultValue;
        }
    }

    public static <T extends DefaultValue> T getDefaultValue(Class<T> defaultValueClass) {
        if (defaultValueClass == null) {
            return null;
        }
        return (T)((DefaultValue)ReflectUtils.callStaticMethodSafely(defaultValueClass, "getDefaultValue", new Object[0]));
    }

    public static <T> T set(String key, T object) {
        return SettingsManager.set(defaultSettingsGroup, key, object);
    }

    public static <T> T set(String group, String key, T object) {
        SettingsManager.initialize();
        SettingsGroup settingsGroup = SettingsManager.getSettingsGroup(group);
        T oldValue = settingsGroup.put(key, object);
        if (saveOnChange) {
            SettingsManager.delayedSaveSettingsGroup(group);
        }
        SettingsManager.fireSettingsChanged(group, key, object);
        return oldValue;
    }

    public static SettingsGroup getSettingsGroup(String group) {
        if (groups.containsKey(group)) {
            return groups.get(group);
        }
        return SettingsManager.loadSettingsGroup(group);
    }

    private static SettingsGroup loadSettingsGroup(String group) {
        SettingsGroup settingsGroup = null;
        File dir = new File(SettingsManager.getGroupFileLocation(group));
        if (dir.exists() && dir.isDirectory()) {
            File file = new File(dir, group + settingsFilesExtension);
            File dumpFile = new File(dir, file.getName() + backupFilesExtension);
            if (file.exists() && file.isFile() || dumpFile.exists() && dumpFile.isFile()) {
                boolean readFromDump = false;
                if (dumpFile.exists() && dumpFile.isFile()) {
                    FileUtils.copyFile(dumpFile, file);
                    FileUtils.deleteFile(dumpFile);
                    readFromDump = true;
                }
                if (file.exists() && file.isFile()) {
                    try {
                        settingsGroup = (SettingsGroup)XmlUtils.fromXML(file);
                        groupState.put(group, new SettingsGroupState(readFromDump ? ReadState.restored : ReadState.ok));
                    }
                    catch (Throwable e) {
                        if (displayExceptions) {
                            Log.error(SettingsManager.class, "Unable to load settings group \"" + group + "\" due to unexpected exception:", e);
                        }
                        FileUtils.deleteFile(file);
                        groupState.put(group, new SettingsGroupState(ReadState.failed, e));
                    }
                }
            } else {
                groupState.put(group, new SettingsGroupState(ReadState.created));
            }
        } else {
            groupState.put(group, new SettingsGroupState(ReadState.created));
        }
        if (settingsGroup == null) {
            settingsGroup = new SettingsGroup(group);
        }
        groups.put(group, settingsGroup);
        return settingsGroup;
    }

    public static void saveSettings() {
        for (Map.Entry<String, SettingsGroup> entry : groups.entrySet()) {
            SettingsManager.saveSettingsGroup(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : files.entrySet()) {
            SettingsManager.saveSettings(entry.getKey(), entry.getValue());
        }
        ComponentSettingsManager.saveSettings();
    }

    public static void saveSettingsGroup(String group) {
        SettingsManager.saveSettingsGroup(SettingsManager.getSettingsGroup(group));
    }

    public static void saveSettingsGroup(SettingsGroup settingsGroup) {
        block6: {
            if (allowSave) {
                try {
                    String group = settingsGroup.getName();
                    File dir = new File(SettingsManager.getGroupFileLocation(group));
                    if (FileUtils.ensureDirectoryExists(dir)) {
                        File file = new File(dir, group + settingsFilesExtension);
                        File dumpFile = null;
                        if (file.exists()) {
                            dumpFile = new File(dir, group + settingsFilesExtension + backupFilesExtension);
                            FileUtils.copyFile(file, dumpFile);
                        }
                        XmlUtils.toXML((Object)settingsGroup, file);
                        if (dumpFile != null && dumpFile.exists()) {
                            FileUtils.deleteFile(dumpFile);
                        }
                        break block6;
                    }
                    throw new RuntimeException("Cannot create settings directory: " + dir.getAbsolutePath());
                }
                catch (Throwable e) {
                    if (!displayExceptions) break block6;
                    Log.error(SettingsManager.class, "Unable to save settings group \"" + settingsGroup.getName() + "\" due to unexpected exception:", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delayedSaveSettingsGroup(String group) {
        if (saveOnChangeDelay > 0L) {
            Object object = saveOnChangeLock;
            synchronized (object) {
                if (!groupsToSaveOnChange.contains(group)) {
                    groupsToSaveOnChange.add(group);
                }
                if (groupSaveScheduler == null || !groupSaveScheduler.isRunning()) {
                    if (groupSaveScheduler == null) {
                        groupSaveScheduler = new WebTimer("SettingsManager.groupSaveScheduler", saveOnChangeDelay, new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Object object = saveOnChangeLock;
                                synchronized (object) {
                                    for (String group : groupsToSaveOnChange) {
                                        SettingsManager.saveSettingsGroup(group);
                                    }
                                    groupsToSaveOnChange.clear();
                                }
                            }
                        });
                        groupSaveScheduler.setRepeats(false);
                    } else {
                        groupSaveScheduler.setDelay(saveOnChangeDelay);
                    }
                    groupSaveScheduler.start();
                }
            }
        } else {
            SettingsManager.saveSettingsGroup(group);
        }
    }

    public SettingsGroupState getSettingsGroupState(String group) {
        if (!groupState.containsKey(group)) {
            groupState.put(group, new SettingsGroupState(ReadState.none));
        }
        return groupState.get(group);
    }

    public static Object getSettings(String fileName) {
        return SettingsManager.getSettings(fileName, null);
    }

    public static <T> T getSettings(String fileName, T defaultValue) {
        Object value;
        if (files.containsKey(fileName)) {
            return (T)files.get(fileName);
        }
        try {
            value = XmlUtils.fromXML(SettingsManager.getSettingsFile(fileName));
        }
        catch (Throwable e) {
            value = defaultValue;
        }
        files.put(fileName, value);
        return value;
    }

    public static void setSettings(String fileName, Object settings) {
        files.put(fileName, settings);
        if (saveOnChange) {
            SettingsManager.saveSettings(fileName, settings);
        }
    }

    private static void saveSettings(String fileName, Object settings) {
        if (allowSave) {
            XmlUtils.toXML(settings, SettingsManager.getSettingsFile(fileName));
        }
    }

    public static boolean settingsExists(String fileName) {
        return SettingsManager.getSettingsFile(fileName).exists();
    }

    private static File getSettingsFile(String fileName) {
        return new File(SettingsManager.getDefaultSettingsDir(), fileName);
    }

    public static String getSettingsFilesExtension() {
        return settingsFilesExtension;
    }

    public static void setSettingsFilesExtension(String settingsFilesExtension) {
        SettingsManager.settingsFilesExtension = settingsFilesExtension;
    }

    public static String getBackupFilesExtension() {
        return backupFilesExtension;
    }

    public static void setBackupFilesExtension(String backupFilesExtension) {
        SettingsManager.backupFilesExtension = backupFilesExtension;
    }

    public static String getDefaultSettingsDir() {
        if (defaultSettingsDir == null) {
            return FileUtils.getUserHomePath() + defaultSettingsDirName;
        }
        return defaultSettingsDir;
    }

    public static void setDefaultSettingsDir(String defaultSettingsDir) {
        SettingsManager.defaultSettingsDir = defaultSettingsDir;
    }

    public static String getDefaultSettingsDirName() {
        return defaultSettingsDirName;
    }

    public static void setDefaultSettingsDirName(String defaultSettingsDir) {
        defaultSettingsDirName = defaultSettingsDir;
    }

    public static String getDefaultSettingsGroup() {
        return defaultSettingsGroup;
    }

    public static void setDefaultSettingsGroup(String defaultSettingsGroup) {
        SettingsManager.defaultSettingsGroup = defaultSettingsGroup;
    }

    public static void setGroupFileLocation(String group, String dir) {
        groupFileLocation.put(group, dir);
    }

    public static String getGroupFileLocation(String group) {
        if (groupFileLocation.containsKey(group)) {
            return groupFileLocation.get(group);
        }
        return SettingsManager.getDefaultSettingsDir();
    }

    public static boolean isSaveOnChange() {
        return saveOnChange;
    }

    public static void setSaveOnChange(boolean saveOnChange) {
        SettingsManager.saveOnChange = saveOnChange;
    }

    public static boolean isSaveDefaultValues() {
        return saveDefaultValues;
    }

    public static void setSaveDefaultValues(boolean saveDefaultValues) {
        SettingsManager.saveDefaultValues = saveDefaultValues;
    }

    public static long getSaveOnChangeDelay() {
        return saveOnChangeDelay;
    }

    public static void setSaveOnChangeDelay(long saveOnChangeDelay) {
        SettingsManager.saveOnChangeDelay = saveOnChangeDelay;
    }

    public static boolean isDisplayExceptions() {
        return displayExceptions;
    }

    public static void setDisplayExceptions(boolean displayExceptions) {
        SettingsManager.displayExceptions = displayExceptions;
    }

    public static boolean isAllowSave() {
        return allowSave;
    }

    public static void setAllowSave(boolean allowSave) {
        SettingsManager.allowSave = allowSave;
    }

    public static void disableSave() {
        SettingsManager.setAllowSave(false);
    }

    public static void enableSave() {
        SettingsManager.setAllowSave(true);
    }

    public static void addSettingsListener(String key, SettingsListener listener) {
        SettingsManager.addSettingsListener(SettingsManager.getDefaultSettingsGroup(), key, listener);
    }

    public static void addSettingsListener(String group, String key, SettingsListener listener) {
        if (!settingsListeners.containsKey(group)) {
            settingsListeners.put(group, new HashMap());
        }
        if (!settingsListeners.get(group).containsKey(key)) {
            settingsListeners.get(group).put(key, new ArrayList());
        }
        settingsListeners.get(group).get(key).add(listener);
    }

    public static void removeSettingsListener(String key, SettingsListener listener) {
        SettingsManager.removeSettingsListener(SettingsManager.getDefaultSettingsGroup(), key, listener);
    }

    public static void removeSettingsListener(String group, String key, SettingsListener listener) {
        if (settingsListeners.containsKey(group) && settingsListeners.get(group).containsKey(key)) {
            settingsListeners.get(group).get(key).remove(listener);
        }
    }

    private static void fireSettingsChanged(String group, String key, Object newValue) {
        if (settingsListeners.containsKey(group) && settingsListeners.get(group).containsKey(key)) {
            for (SettingsListener listener : CollectionUtils.copy((Collection)settingsListeners.get(group).get(key))) {
                listener.settingsChanged(group, key, newValue);
            }
        }
    }
}

