/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.extended.painter.Painter;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.managers.style.skin.WebLafSkin;
import com.alee.managers.style.skin.web.WebSkin;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.laf.Styleable;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;

public final class StyleManager {
    public static final String DEFAULT_PAINTER_ID = "painter";
    private static final Map<JComponent, WebLafSkin> appliedSkins;
    private static final Map<JComponent, Map<String, Map<String, Object>>> customPainterProperties;
    private static final Map<JComponent, Map<String, Painter>> customPainters;
    private static WebLafSkin defaultSkin;
    private static WebLafSkin currentSkin;
    private static boolean strictStyleChecks;
    private static boolean initialized;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            StyleManager.applyDefaultSkin();
        }
    }

    public static boolean isStrictStyleChecks() {
        return strictStyleChecks;
    }

    public static void setStrictStyleChecks(boolean strict) {
        strictStyleChecks = strict;
    }

    private static void checkSupport(WebLafSkin skin) {
        if (skin == null) {
            throw new StyleException("Empty skin provided");
        }
        if (!skin.isSupported()) {
            throw new StyleException("Skin \"" + skin.getName() + "\" is not supported in this system");
        }
    }

    public static WebLafSkin getDefaultSkin() {
        if (defaultSkin == null) {
            StyleManager.setDefaultSkin(new WebSkin());
        }
        return defaultSkin;
    }

    public static WebLafSkin setDefaultSkin(String skinClassName) {
        return StyleManager.setDefaultSkin(ReflectUtils.getClassSafely(skinClassName));
    }

    public static WebLafSkin setDefaultSkin(Class skinClass) {
        return StyleManager.setDefaultSkin(StyleManager.createSkin(skinClass));
    }

    public static WebLafSkin createSkin(Class skinClass) {
        return (WebLafSkin)ReflectUtils.createInstanceSafely(skinClass, new Object[0]);
    }

    public static WebLafSkin setDefaultSkin(WebLafSkin skin) {
        StyleManager.checkSupport(skin);
        WebLafSkin oldSkin = defaultSkin;
        defaultSkin = skin;
        return oldSkin;
    }

    public static WebLafSkin applyDefaultSkin() {
        return StyleManager.applySkin(StyleManager.getDefaultSkin());
    }

    public static WebLafSkin getCurrentSkin() {
        return currentSkin != null ? currentSkin : StyleManager.getDefaultSkin();
    }

    public static WebLafSkin applySkin(String skinClassName) {
        return StyleManager.applySkin(ReflectUtils.getClassSafely(skinClassName));
    }

    public static WebLafSkin applySkin(Class skinClass) {
        return StyleManager.applySkin(StyleManager.createSkin(skinClass));
    }

    public static WebLafSkin applySkin(WebLafSkin skin) {
        StyleManager.checkSupport(skin);
        WebLafSkin previousSkin = currentSkin;
        currentSkin = skin;
        for (Map.Entry<JComponent, WebLafSkin> entry : appliedSkins.entrySet()) {
            JComponent component = entry.getKey();
            WebLafSkin oldSkin = entry.getValue();
            if (oldSkin != null) {
                oldSkin.removeSkin(component);
            }
            if (skin != null) {
                skin.applySkin(component);
            }
            entry.setValue(skin);
        }
        return previousSkin;
    }

    public static WebLafSkin applySkin(JComponent component) {
        return StyleManager.applySkin(component, StyleManager.getCurrentSkin());
    }

    public static WebLafSkin applySkin(JComponent component, WebLafSkin skin) {
        StyleManager.checkSupport(skin);
        WebLafSkin previousSkin = StyleManager.removeSkin(component);
        skin.applySkin(component);
        appliedSkins.put(component, skin);
        return previousSkin;
    }

    public static WebLafSkin removeSkin(JComponent component) {
        WebLafSkin skin = appliedSkins.get(component);
        if (skin != null) {
            skin.removeSkin(component);
            appliedSkins.remove(component);
        }
        return skin;
    }

    public static <T> T getPainterPropertyValue(JComponent component, String key) {
        return StyleManager.getPainterPropertyValue(component, null, key);
    }

    public static <T> T getPainterPropertyValue(JComponent component, String painterId, String key) {
        WebLafSkin skin = appliedSkins.get(component);
        return skin != null ? (T)skin.getPainterPropertyValue(component, painterId, key) : null;
    }

    public static <T> T setCustomPainterProperty(JComponent component, String key, T value) {
        return StyleManager.setCustomPainterProperty(component, null, key, value);
    }

    public static <T> T setCustomPainterProperty(JComponent component, String painterId, String key, T value) {
        Map<String, Object> properties;
        Map<String, Map<String, Object>> allProperties = customPainterProperties.get(component);
        if (allProperties == null) {
            allProperties = new HashMap<String, Map<String, Object>>(1);
            customPainterProperties.put(component, allProperties);
        }
        if ((properties = allProperties.get(painterId)) == null) {
            properties = new HashMap<String, Object>(1);
            allProperties.put(painterId, properties);
        }
        Object oldValue = properties.put(key, value);
        WebLafSkin componentSkin = appliedSkins.get(component);
        if (componentSkin != null) {
            componentSkin.setCustomPainterProperty(component, key, value);
        }
        return (T)oldValue;
    }

    public static Map<JComponent, Map<String, Map<String, Object>>> getCustomPainterProperties() {
        return customPainterProperties;
    }

    public static Map<String, Map<String, Object>> getCustomPainterProperties(JComponent component) {
        return customPainterProperties.get(component);
    }

    public static void clearCustomPainterProperties(JComponent component) {
        Map<String, Map<String, Object>> properties = customPainterProperties.get(component);
        if (properties != null) {
            properties.clear();
            StyleManager.applySkin(component);
        }
    }

    public static <T extends Painter> T getPainter(JComponent component) {
        return StyleManager.getPainter(component, DEFAULT_PAINTER_ID);
    }

    public static <T extends Painter> T getPainter(JComponent component, String painterId) {
        Map<String, Painter> painters = customPainters.get(component);
        if (painters != null && painters.containsKey(painterId)) {
            return (T)painters.get(painterId);
        }
        return StyleManager.getCurrentSkin().getPainter(component, painterId);
    }

    public static <T extends Painter> T setCustomPainter(JComponent component, T painter) {
        return StyleManager.setCustomPainter(component, DEFAULT_PAINTER_ID, painter);
    }

    public static <T extends Painter> T setCustomPainter(JComponent component, String id, T painter) {
        StyleManager.clearCustomPainterProperties(component);
        Map<String, Painter> painters = customPainters.get(component);
        if (painters == null) {
            painters = new HashMap<String, Painter>(1);
            customPainters.put(component, painters);
        }
        Painter oldValue = painters.put(id, painter);
        StyleManager.applySkin(component);
        return (T)oldValue;
    }

    public static Map<JComponent, Map<String, Painter>> getCustomPainters() {
        return customPainters;
    }

    public static Map<String, Painter> getCustomPainters(JComponent component) {
        return customPainters.get(component);
    }

    public static void removeCustomPainters(JComponent component) {
        Map<String, Painter> painters = customPainters.get(component);
        if (painters != null) {
            painters.clear();
            StyleManager.applySkin(component);
        }
    }

    public static boolean setStyleId(Component component, String styleId) {
        if (component instanceof Styleable) {
            ((Styleable)((Object)component)).setStyleId(styleId);
            return true;
        }
        Object ui = LafUtils.getUI(component);
        if (ui != null && ui instanceof Styleable) {
            ((Styleable)ui).setStyleId(styleId);
            return true;
        }
        return false;
    }

    static {
        XmlUtils.processAnnotations(SkinInfo.class);
        XmlUtils.processAnnotations(ComponentStyle.class);
        XmlUtils.processAnnotations(NinePatchIcon.class);
        appliedSkins = new WeakHashMap<JComponent, WebLafSkin>();
        customPainterProperties = new WeakHashMap<JComponent, Map<String, Map<String, Object>>>();
        customPainters = new WeakHashMap<JComponent, Map<String, Painter>>();
        defaultSkin = null;
        currentSkin = null;
        strictStyleChecks = true;
        initialized = false;
    }
}

