/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.log.Log;
import com.alee.managers.style.SupportedComponent;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfoConverter;
import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

@XStreamAlias(value="skin")
@XStreamConverter(value=SkinInfoConverter.class)
public final class SkinInfo
implements Serializable {
    private String id;
    private String name;
    private String description;
    private String author;
    private String supportedSystems;
    @XStreamAlias(value="class")
    private String skinClass;
    @XStreamImplicit
    private List<ComponentStyle> styles;
    private transient Map<SupportedComponent, Map<String, ComponentStyle>> stylesCache;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getSupportedSystems() {
        return this.supportedSystems;
    }

    public List<String> getSupportedSystemsList() {
        return TextUtils.stringToList(this.supportedSystems, ",");
    }

    public void setSupportedSystems(String supportedSystems) {
        this.supportedSystems = supportedSystems;
    }

    public void setSupportedSystems(List<String> supportedSystems) {
        this.supportedSystems = TextUtils.listToString(supportedSystems, ",");
    }

    public String getSkinClass() {
        return this.skinClass;
    }

    public void setSkinClass(String skinClass) {
        this.skinClass = skinClass;
    }

    public List<ComponentStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(List<ComponentStyle> styles) {
        this.styles = styles;
    }

    public Map<SupportedComponent, Map<String, ComponentStyle>> getStylesCache() {
        return this.stylesCache;
    }

    public void setStylesCache(Map<SupportedComponent, Map<String, ComponentStyle>> stylesCache) {
        this.stylesCache = stylesCache;
    }

    public ComponentStyle getStyle(JComponent component, SupportedComponent type) {
        Map<String, ComponentStyle> componentStyles = this.stylesCache.get((Object)type);
        if (componentStyles != null) {
            String styleId = type.getComponentStyleId(component);
            ComponentStyle style = componentStyles.get(styleId);
            if (style != null) {
                return style;
            }
            Log.error((Object)this, "Unable to find style with ID \"" + styleId + "\" for component: " + component);
            return componentStyles.get("default");
        }
        return null;
    }
}

