/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.skin.web;

import com.alee.extended.painter.AbstractPainter;
import com.alee.managers.style.skin.web.PopupStyle;
import com.alee.managers.style.skin.web.WebPopupPainterStyle;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.NinePatchUtils;
import com.alee.utils.ShapeCache;
import com.alee.utils.laf.PainterShapeProvider;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.swing.DataProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebPopupPainter<E extends JComponent>
extends AbstractPainter<E>
implements PainterShapeProvider<E>,
SwingConstants {
    protected static final String SIMPLE_FILL_SHAPE = "simple-fill";
    protected static final String SIMPLE_BORDER_SHAPE = "simple-border";
    protected static final String DROPDOWN_FILL_SHAPE = "dropdown-fill";
    protected static final String DROPDOWN_BORDER_SHAPE = "dropdown-border";
    protected PopupStyle popupStyle = WebPopupPainterStyle.popupStyle;
    protected Color borderColor = WebPopupPainterStyle.borderColor;
    protected int round = WebPopupPainterStyle.round;
    protected int shadeWidth = WebPopupPainterStyle.shadeWidth;
    protected float shadeTransparency = WebPopupPainterStyle.shadeTransparency;
    protected int cornerWidth = WebPopupPainterStyle.cornerWidth;
    protected float transparency = WebPopupPainterStyle.transparency;
    protected boolean transparent = true;
    protected int cornerSide = 1;
    protected int relativeCorner = 0;
    protected int cornerAlignment = -1;

    public PopupStyle getPopupStyle() {
        return this.popupStyle;
    }

    public void setPopupStyle(PopupStyle style) {
        if (this.popupStyle != style) {
            this.popupStyle = style;
            if (this.transparent) {
                this.updateAll();
            }
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (this.borderColor != color) {
            this.borderColor = color;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        if (this.round != round) {
            this.round = round;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int width) {
        if (this.shadeWidth != width) {
            this.shadeWidth = width;
            if (this.transparent) {
                this.updateAll();
            }
        }
    }

    public float getShadeTransparency() {
        return this.shadeTransparency;
    }

    public void setShadeTransparency(float transparency) {
        if (this.shadeTransparency != transparency) {
            this.shadeTransparency = transparency;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    public int getCornerWidth() {
        return this.cornerWidth;
    }

    public void setCornerWidth(int width) {
        if (this.cornerWidth != width) {
            this.cornerWidth = width;
            if (this.transparent) {
                this.updateAll();
            }
        }
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        if (this.transparency != transparency) {
            this.transparency = transparency;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        if (this.transparent != transparent) {
            this.transparent = transparent;
            this.updateAll();
        }
    }

    public int getCornerSide() {
        return this.cornerSide;
    }

    public void setCornerSide(int cornerSide) {
        if (this.cornerSide != cornerSide) {
            this.cornerSide = cornerSide;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    public int getRelativeCorner() {
        return this.relativeCorner;
    }

    public void setRelativeCorner(int relativeCorner) {
        if (this.relativeCorner != relativeCorner) {
            this.relativeCorner = relativeCorner;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    public int getCornerAlignment() {
        return this.cornerAlignment;
    }

    public void setCornerAlignment(int cornerAlignment) {
        if (this.cornerAlignment != cornerAlignment) {
            this.cornerAlignment = cornerAlignment;
            if (this.transparent) {
                this.repaint();
            }
        }
    }

    @Override
    public Shape provideShape(E component, Rectangle bounds) {
        return this.getBorderShape(component, ((Component)component).getSize(), false);
    }

    @Override
    public Boolean isOpaque(E c) {
        return !this.transparent;
    }

    @Override
    public Insets getMargin(E c) {
        boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
        Insets m = new Insets(this.margin.top, ltr ? this.margin.left : this.margin.right, this.margin.bottom, ltr ? this.margin.right : this.margin.left);
        if (this.transparent) {
            int sideWidth = this.getSideWidth();
            m.top += sideWidth + 1;
            m.left += sideWidth + 1;
            m.bottom += sideWidth + 1;
            m.right += sideWidth + 1;
        } else {
            ++m.top;
            ++m.left;
            ++m.bottom;
            ++m.right;
        }
        return m;
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle bounds, E popup) {
        Object aa = GraphicsUtils.setupAntialias(g2d);
        if (this.transparent) {
            this.paintTransparentPopup(g2d, popup);
        } else {
            this.paintSimplePopup(g2d, popup);
        }
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    protected void paintTransparentPopup(Graphics2D g2d, E popup) {
        Dimension popupSize = ((Component)popup).getSize();
        this.paintShade(g2d, popup, popupSize);
        this.paintBackground(g2d, popup, popupSize);
        this.paintBorder(g2d, popup, popupSize);
    }

    protected void paintSimplePopup(Graphics2D g2d, E popup) {
        g2d.setColor(this.getBackgroundColor(popup));
        g2d.fillRoundRect(1, 1, ((JComponent)popup).getWidth() - 2, ((JComponent)popup).getHeight() - 2, this.round * 2, this.round * 2);
        g2d.setColor(this.borderColor);
        g2d.drawRoundRect(0, 0, ((JComponent)popup).getWidth() - 1, ((JComponent)popup).getHeight() - 1, this.round * 2, this.round * 2);
    }

    protected void paintShade(Graphics2D g2d, E popup, Dimension popupSize) {
        if (this.shadeWidth > 0) {
            NinePatchIcon shade = NinePatchUtils.getShadeIcon(this.shadeWidth, this.round * 2, this.getCurrentShadeTransparency());
            shade.setComponent((Component)popup);
            shade.paintIcon(g2d, this.getShadeBounds(popupSize));
        }
    }

    protected float getCurrentShadeTransparency() {
        return this.shadeTransparency;
    }

    protected void paintBackground(Graphics2D g2d, E popup, Dimension popupSize) {
        Color backgroundColor = this.getBackgroundColor(popup);
        if (backgroundColor != null) {
            g2d.setColor(backgroundColor);
            g2d.fill(this.getBorderShape(popup, popupSize, true));
        }
    }

    protected void paintBorder(Graphics2D g2d, E popup, Dimension popupSize) {
        if (this.borderColor != null) {
            g2d.setPaint(this.borderColor);
            g2d.draw(this.getBorderShape(popup, popupSize, false));
        }
    }

    protected Color getBackgroundColor(E popup) {
        Color bg = this.getComponentBackground(popup);
        return !this.transparent || this.transparency >= 1.0f ? bg : ColorUtils.getTransparentColor(bg, Math.max(0, Math.min((int)(this.transparency * 255.0f), 255)));
    }

    protected Color getComponentBackground(E popup) {
        return ((Component)popup).getBackground();
    }

    protected Rectangle getShadeBounds(Dimension popupSize) {
        switch (this.popupStyle) {
            case simple: {
                return new Rectangle(0, 0, popupSize.width, popupSize.height);
            }
            case dropdown: {
                int spacing = Math.max(0, this.cornerWidth - this.shadeWidth);
                return new Rectangle(spacing, spacing, popupSize.width - spacing * 2, popupSize.height - spacing * 2);
            }
        }
        return null;
    }

    protected Shape getBorderShape(final E popup, final Dimension popupSize, final boolean fill) {
        switch (this.popupStyle) {
            case simple: {
                return ShapeCache.getShape(popup, fill ? SIMPLE_FILL_SHAPE : SIMPLE_BORDER_SHAPE, new DataProvider<Shape>(){

                    @Override
                    public Shape provide() {
                        return WebPopupPainter.this.createSimpleShape(popup, popupSize, fill);
                    }
                }, this.getCachedShapeSettings(popup));
            }
            case dropdown: {
                return ShapeCache.getShape(popup, fill ? DROPDOWN_FILL_SHAPE : DROPDOWN_BORDER_SHAPE, new DataProvider<Shape>(){

                    @Override
                    public Shape provide() {
                        return WebPopupPainter.this.createDropdownShape(popup, popupSize, fill);
                    }
                }, this.getCachedShapeSettings(popup));
            }
        }
        return null;
    }

    protected Object[] getCachedShapeSettings(E popup) {
        return new Object[]{this.round, this.shadeWidth, this.cornerWidth, this.cornerSide, this.relativeCorner, this.cornerAlignment, ((Component)popup).getSize(), ((Component)popup).getComponentOrientation().isLeftToRight()};
    }

    protected GeneralPath createSimpleShape(E popup, Dimension popupSize, boolean fill) {
        int shear = fill ? 1 : 0;
        GeneralPath shape = new GeneralPath(0);
        int top = this.shadeWidth + shear;
        int left = this.shadeWidth + shear;
        int bottom = popupSize.height - 1 - this.shadeWidth;
        int right = popupSize.width - 1 - this.shadeWidth;
        shape.moveTo(left, top + this.round);
        shape.quadTo(left, top, left + this.round, top);
        shape.lineTo(right - this.round, top);
        shape.quadTo(right, top, right, top + this.round);
        shape.lineTo(right, bottom - this.round);
        shape.quadTo(right, bottom, right - this.round, bottom);
        shape.lineTo(left + this.round, bottom);
        shape.quadTo(left, bottom, left, bottom - this.round);
        shape.closePath();
        return shape;
    }

    protected GeneralPath createDropdownShape(E popup, Dimension popupSize, boolean fill) {
        int length;
        boolean topCorner = this.cornerSide == 1;
        boolean bottomCorner = this.cornerSide == 3;
        boolean leftCorner = this.cornerSide == 2 || this.cornerSide == 10;
        boolean rightCorner = this.cornerSide == 4 || this.cornerSide == 11;
        int shear = fill ? 1 : 0;
        int sideWidth = this.getSideWidth();
        boolean ltr = ((Component)popup).getComponentOrientation().isLeftToRight();
        int cornerShear = sideWidth + shear + this.round + this.cornerWidth * 2;
        int n = length = topCorner || bottomCorner ? popupSize.width : popupSize.height;
        int spacing = this.cornerAlignment == 0 || length < sideWidth * 2 + this.round * 2 + this.cornerWidth * 4 ? length / 2 - sideWidth - this.round - this.cornerWidth * 2 : (this.cornerAlignment == 2 || this.cornerAlignment == 10 && ltr || this.cornerAlignment == 11 && !ltr ? 0 : (this.cornerAlignment == 4 || this.cornerAlignment == 11 && ltr || this.cornerAlignment == 10 && !ltr ? length - cornerShear * 2 : (this.relativeCorner < sideWidth + this.round + this.cornerWidth * 2 ? 0 : Math.min(this.relativeCorner - cornerShear, length - cornerShear * 2))));
        int top = sideWidth + shear;
        int right = popupSize.width - 1 - sideWidth;
        int botom = popupSize.height - 1 - sideWidth;
        int left = sideWidth + shear;
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(left, top + this.round);
        shape.quadTo(left, top, left + this.round, top);
        if (topCorner) {
            shape.lineTo(left + this.round + spacing + this.cornerWidth, top);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 3 + 1, top);
        }
        shape.lineTo(right - this.round, top);
        shape.quadTo(right, top, right, top + this.round);
        if (rightCorner) {
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth * 3 + 1);
        }
        shape.lineTo(right, botom - this.round);
        shape.quadTo(right, botom, right - this.round, botom);
        if (bottomCorner) {
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 3 + 1, botom);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, botom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, botom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth, botom);
        }
        shape.lineTo(left + this.round, botom);
        shape.quadTo(left, botom, left, botom - this.round);
        if (leftCorner) {
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth * 3 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth);
        }
        shape.closePath();
        return shape;
    }

    protected Shape getDropdownCornerShape(final E popupMenu, final Dimension menuSize, final boolean fill) {
        return ShapeCache.getShape(popupMenu, fill ? "dropdown-corner-fill" : "dropdown-corner-border", new DataProvider<Shape>(){

            @Override
            public Shape provide() {
                return WebPopupPainter.this.createDropdownCornerShape(popupMenu, menuSize, fill);
            }
        }, this.getCachedShapeSettings(popupMenu));
    }

    protected GeneralPath createDropdownCornerShape(E popupMenu, Dimension menuSize, boolean fill) {
        int length;
        boolean topCorner = this.cornerSide == 1;
        boolean bottomCorner = this.cornerSide == 3;
        boolean leftCorner = this.cornerSide == 2 || this.cornerSide == 10;
        boolean rightCorner = this.cornerSide == 4 || this.cornerSide == 11;
        int shear = fill ? 1 : 0;
        int sideWidth = this.getSideWidth();
        boolean ltr = ((Component)popupMenu).getComponentOrientation().isLeftToRight();
        int cornerShear = sideWidth + shear + this.round + this.cornerWidth * 2;
        int n = length = topCorner || bottomCorner ? menuSize.width : menuSize.height;
        int spacing = this.cornerAlignment == 0 || length < sideWidth * 2 + this.round * 2 + this.cornerWidth * 4 ? length / 2 - sideWidth - this.round - this.cornerWidth * 2 : (this.cornerAlignment == 2 || this.cornerAlignment == 10 && ltr || this.cornerAlignment == 11 && !ltr ? 0 : (this.cornerAlignment == 4 || this.cornerAlignment == 11 && ltr || this.cornerAlignment == 10 && !ltr ? length - cornerShear * 2 : (this.relativeCorner < sideWidth + this.round + this.cornerWidth * 2 ? 0 : Math.min(this.relativeCorner - cornerShear, length - cornerShear * 2))));
        int top = sideWidth + shear;
        int right = menuSize.width - 1 - sideWidth;
        int botom = menuSize.height - 1 - sideWidth;
        int left = sideWidth + shear;
        GeneralPath shape = new GeneralPath(0);
        if (topCorner) {
            shape.moveTo(left + this.round + spacing + this.cornerWidth, top);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, top - this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 3 + 1, top);
            shape.closePath();
        }
        if (rightCorner) {
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(right + this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(right, top + this.round + spacing + this.cornerWidth * 3 + 1);
        }
        if (bottomCorner) {
            shape.moveTo(left + this.round + spacing + this.cornerWidth * 3 + 1, botom);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2 + 1, botom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth * 2, botom + this.cornerWidth);
            shape.lineTo(left + this.round + spacing + this.cornerWidth, botom);
            shape.closePath();
        }
        if (leftCorner) {
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth * 3 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2 + 1);
            shape.lineTo(left - this.cornerWidth, top + this.round + spacing + this.cornerWidth * 2);
            shape.lineTo(left, top + this.round + spacing + this.cornerWidth);
        }
        return shape;
    }

    protected int getSideWidth() {
        return this.popupStyle == PopupStyle.dropdown ? Math.max(this.cornerWidth, this.shadeWidth) : this.shadeWidth;
    }
}

