/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.ReflectUtils;
import com.alee.utils.collection.DoubleMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MapUtils {
    public static <K, V> Map<K, V> copyMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> HashMap<K, V> copyHashMap(HashMap<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> copyLinkedHashMap(LinkedHashMap<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> DoubleMap<K, V> copyDoubleMap(DoubleMap<K, V> map) {
        return new DoubleMap<K, V>(map);
    }

    public static <K, V extends Cloneable> Map<K, V> cloneMap(Map<K, V> map) {
        HashMap<K, Cloneable> clone = new HashMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V extends Cloneable> HashMap<K, V> cloneHashMap(HashMap<K, V> map) {
        HashMap<K, Cloneable> clone = new HashMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V extends Cloneable> LinkedHashMap<K, V> cloneLinkedHashMap(LinkedHashMap<K, V> map) {
        LinkedHashMap<K, Cloneable> clone = new LinkedHashMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V extends Cloneable> DoubleMap<K, V> cloneLinkedHashMap(DoubleMap<K, V> map) {
        DoubleMap<K, Cloneable> clone = new DoubleMap<K, Cloneable>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), ReflectUtils.cloneSafely((Cloneable)entry.getValue()));
        }
        return clone;
    }

    public static <K, V> HashMap<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> newLinkedHashMap(K key, V value) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(1);
        map.put(key, value);
        return map;
    }
}

