/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.FileUtils;
import com.alee.utils.file.FileDownloadListener;
import com.alee.utils.reflection.JarEntry;
import com.alee.utils.reflection.JarEntryType;
import com.alee.utils.reflection.JarStructure;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ReflectUtils {
    private static final Map<Class, Map<String, Method>> methodsLookupCache = new HashMap<Class, Map<String, Method>>();

    public static Class<?> getFieldTypeSafely(Class classType, String fieldName) {
        try {
            return ReflectUtils.getFieldType(classType, fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Class<?> getFieldType(Class classType, String fieldName) throws NoSuchFieldException {
        return ReflectUtils.getField(classType, fieldName).getType();
    }

    public static Field getFieldSafely(Class classType, String fieldName) throws NoSuchFieldException {
        try {
            return ReflectUtils.getField(classType, fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field getField(Class classType, String fieldName) throws NoSuchFieldException {
        Field field = ReflectUtils.getFieldImpl(classType, fieldName);
        if (field != null) {
            return field;
        }
        throw new NoSuchFieldException("Field \"" + fieldName + "\" not found in class: " + classType.getCanonicalName());
    }

    public static Field getFieldImpl(Class classType, String fieldName) throws NoSuchFieldException {
        Field field;
        try {
            field = classType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superclass = classType.getSuperclass();
            field = superclass != null ? ReflectUtils.getFieldImpl(superclass, fieldName) : null;
        }
        return field;
    }

    public static boolean applyFieldValueSafely(Object object, String field, Object value) {
        try {
            ReflectUtils.applyFieldValue(object, field, value);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public static void applyFieldValue(Object object, String field, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field actualField = object.getClass().getDeclaredField(field);
        actualField.setAccessible(true);
        actualField.set(object, value);
    }

    public static Class getClassSafely(String canonicalName) {
        try {
            return Class.forName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Class<T> getClass(String canonicalName) throws ClassNotFoundException {
        return Class.forName(canonicalName);
    }

    public static JarStructure getJarStructure(Class jarClass) {
        return ReflectUtils.getJarStructure(jarClass, null, null);
    }

    public static JarStructure getJarStructure(Class jarClass, List<String> allowedExtensions, List<String> allowedPackgages) {
        return ReflectUtils.getJarStructure(jarClass, allowedExtensions, allowedPackgages, null);
    }

    public static JarStructure getJarStructure(Class jarClass, List<String> allowedExtensions, List<String> allowedPackgages, FileDownloadListener listener) {
        try {
            CodeSource src = jarClass.getProtectionDomain().getCodeSource();
            if (src != null) {
                ZipEntry zipEntry;
                URL jarUrl = src.getLocation();
                URI uri = jarUrl.toURI();
                String scheme = uri.getScheme();
                File jarFile = scheme != null && scheme.equalsIgnoreCase("file") ? new File(uri) : FileUtils.downloadFile(jarUrl.toString(), File.createTempFile("jar_file", ".tmp"), listener);
                JarEntry jarEntry = new JarEntry(JarEntryType.jarEntry, jarFile.getName());
                JarStructure jarStructure = new JarStructure(jarEntry);
                jarStructure.setJarLocation(jarFile.getAbsolutePath());
                ZipInputStream zip = new ZipInputStream(jarUrl.openStream());
                while ((zipEntry = zip.getNextEntry()) != null) {
                    String entryName = zipEntry.getName();
                    if (!ReflectUtils.isAllowedPackage(entryName, allowedPackgages) || !zipEntry.isDirectory() && !ReflectUtils.isAllowedExtension(entryName, allowedExtensions)) continue;
                    ReflectUtils.parseElement(jarEntry, entryName, zipEntry);
                }
                zip.close();
                return jarStructure;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static URL getJarLocationURL(Class jarClass) {
        CodeSource src = jarClass.getProtectionDomain().getCodeSource();
        return src != null ? src.getLocation() : null;
    }

    public static File getJarLocationFile(Class jarClass) {
        try {
            URL jarUrl;
            URI uri;
            String scheme;
            CodeSource src = jarClass.getProtectionDomain().getCodeSource();
            if (src != null && (scheme = (uri = (jarUrl = src.getLocation()).toURI()).getScheme()) != null && scheme.equalsIgnoreCase("file")) {
                return new File(uri);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean isAllowedExtension(String entryName, List<String> allowedExtensions) {
        if (allowedExtensions == null || allowedExtensions.size() == 0) {
            return true;
        }
        String entryExt = FileUtils.getFileExtPart(entryName, true).toLowerCase();
        return allowedExtensions.contains(entryExt);
    }

    private static boolean isAllowedPackage(String entryName, List<String> allowedPackgages) {
        if (allowedPackgages == null || allowedPackgages.size() == 0) {
            return true;
        }
        for (String packageStart : allowedPackgages) {
            if (!entryName.startsWith(packageStart)) continue;
            return true;
        }
        return false;
    }

    private static void parseElement(JarEntry jarEntry, String entryName, ZipEntry zipEntry) {
        String[] path = entryName.split("/");
        JarEntry currentLevel = jarEntry;
        for (int i = 0; i < path.length; ++i) {
            if (i < path.length - 1) {
                JarEntry child = currentLevel.getChildByName(path[i]);
                if (child == null) {
                    child = new JarEntry(JarEntryType.packageEntry, path[i], currentLevel);
                    child.setZipEntry(zipEntry);
                    currentLevel.addChild(child);
                }
                currentLevel = child;
                continue;
            }
            JarEntry newEntry = new JarEntry(ReflectUtils.getJarEntryType(path[i]), path[i], currentLevel);
            newEntry.setZipEntry(zipEntry);
            currentLevel.addChild(newEntry);
        }
    }

    private static JarEntryType getJarEntryType(String file) {
        String ext = FileUtils.getFileExtPart(file, false);
        if (ext.equals("java")) {
            return JarEntryType.javaEntry;
        }
        if (ext.equals("class")) {
            return JarEntryType.classEntry;
        }
        if (!ext.isEmpty()) {
            return JarEntryType.fileEntry;
        }
        return JarEntryType.packageEntry;
    }

    public static Class getCallerClass() {
        return ReflectUtils.getCallerClass(1);
    }

    public static Class getCallerClass(int additionalDepth) {
        int depth = 2 + additionalDepth;
        try {
            return (Class)ReflectUtils.callStaticMethod("sun.reflect.Reflection", "getCallerClass", depth + 3);
        }
        catch (Throwable e) {
            try {
                return Class.forName(new Throwable().getStackTrace()[depth].getClassName());
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
    }

    public static String getJavaClassName(Object classObject) {
        return ReflectUtils.getJavaClassName(classObject.getClass());
    }

    public static String getJavaClassName(Class classType) {
        return ReflectUtils.getClassName(classType) + ".java";
    }

    public static String getClassFileName(Object classObject) {
        return ReflectUtils.getClassFileName(classObject.getClass());
    }

    public static String getClassFileName(Class classType) {
        return ReflectUtils.getClassName(classType) + ".class";
    }

    public static String getClassName(Object classObject) {
        return ReflectUtils.getClassName(classObject.getClass());
    }

    public static String getClassName(Class classType) {
        String canonicalName = classType.getCanonicalName();
        String fullName = canonicalName != null ? canonicalName : classType.toString();
        int dot = fullName.lastIndexOf(".");
        return dot != -1 ? fullName.substring(dot + 1) : fullName;
    }

    public static String[] getClassPackages(Object classObject) {
        return ReflectUtils.getClassPackages(classObject.getClass());
    }

    public static String[] getClassPackages(Class classType) {
        return ReflectUtils.getPackages(classType.getPackage().getName());
    }

    public static String[] getPackages(String packageName) {
        return packageName.split("\\.");
    }

    public static <T> T getStaticFieldValueSafely(Class classType, String fieldName) {
        try {
            return ReflectUtils.getStaticFieldValue(classType, fieldName);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static <T> T getStaticFieldValue(Class classType, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return (T)classType.getField(fieldName).get(null);
    }

    public static Class getInnerClass(Class fromClass, String innerClassName) {
        for (Class<?> innerClass : fromClass.getDeclaredClasses()) {
            if (!ReflectUtils.getClassName(innerClass).equals(innerClassName)) continue;
            return innerClass;
        }
        return null;
    }

    public static <T> T createInstanceSafely(String canonicalClassName, Object ... arguments) {
        try {
            return ReflectUtils.createInstance(canonicalClassName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T createInstance(String canonicalClassName, Object ... arguments) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        return ReflectUtils.createInstance(ReflectUtils.loadClass(canonicalClassName), arguments);
    }

    public static <T> T createInstanceSafely(Class theClass, Object ... arguments) {
        try {
            return ReflectUtils.createInstance(theClass, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T createInstance(Class theClass, Object ... arguments) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] parameterTypes = ReflectUtils.getClassTypes(arguments);
        Constructor constructor = ReflectUtils.getConstructor(theClass, parameterTypes);
        constructor.setAccessible(true);
        return constructor.newInstance(arguments);
    }

    public static Constructor getConstructor(Class theClass, Class ... parameterTypes) throws NoSuchMethodException {
        if (parameterTypes.length == 0) {
            return theClass.getConstructor(new Class[0]);
        }
        for (Constructor<?> constructor : theClass.getDeclaredConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length != parameterTypes.length) continue;
            if (types.length == parameterTypes.length && types.length == 0) {
                return constructor;
            }
            boolean fits = true;
            for (int i = 0; i < types.length; ++i) {
                if (ReflectUtils.isAssignable(types[i], parameterTypes[i])) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            return constructor;
        }
        throw new NoSuchMethodException(theClass.getCanonicalName() + ReflectUtils.argumentTypesToString(parameterTypes));
    }

    public static <T> T callStaticMethodSafely(String canonicalClassName, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callStaticMethod(canonicalClassName, methodName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T callStaticMethod(String canonicalClassName, String methodName, Object ... arguments) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        return ReflectUtils.callStaticMethod(ReflectUtils.getClass(canonicalClassName), methodName, arguments);
    }

    public static <T> T callStaticMethodSafely(Class theClass, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callStaticMethod(theClass, methodName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T callStaticMethod(Class theClass, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectUtils.getMethod(theClass, methodName, arguments);
        return (T)method.invoke(null, arguments);
    }

    public static <T> List<T> callMethodsSafely(List objects, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callMethods(objects, methodName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> List<T> callMethods(List objects, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<T> results = new ArrayList<T>();
        for (Object object : objects) {
            results.add(ReflectUtils.callMethod(object, methodName, arguments));
        }
        return results;
    }

    public static Object[] callMethodsSafely(Object[] objects, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callMethods(objects, methodName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Object[] callMethods(Object[] objects, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] results = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            results[i] = ReflectUtils.callMethod(objects[i], methodName, arguments);
        }
        return results;
    }

    public static <T> T callMethodSafely(Object object, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callMethod(object, methodName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> T callMethod(Object object, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectUtils.getMethod(object.getClass(), methodName, arguments);
        return (T)method.invoke(object, arguments);
    }

    public static Method getFieldGetter(Object object, String field) {
        return ReflectUtils.getFieldGetter(object.getClass(), field);
    }

    public static Method getFieldGetter(Class aClass, String field) {
        Method get = ReflectUtils.getMethodSafely(aClass, ReflectUtils.getGetterMethodName(field), new Object[0]);
        if (get != null) {
            return get;
        }
        Method is = ReflectUtils.getMethodSafely(aClass, ReflectUtils.getIsGetterMethodName(field), new Object[0]);
        return is != null ? is : null;
    }

    public static String getSetterMethodName(String field) {
        return "set" + field.substring(0, 1).toUpperCase() + field.substring(1);
    }

    public static String getGetterMethodName(String field) {
        return "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
    }

    public static String getIsGetterMethodName(String field) {
        return "is" + field.substring(0, 1).toUpperCase() + field.substring(1);
    }

    public static Method getMethodSafely(Object object, String methodName, Object ... arguments) {
        return ReflectUtils.getMethodSafely(object.getClass(), methodName, arguments);
    }

    public static Method getMethodSafely(Class aClass, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.getMethod(aClass, methodName, arguments);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Method getMethod(Object object, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectUtils.getMethod(object.getClass(), methodName, arguments);
    }

    public static Method getMethod(Class aClass, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class[] classTypes = ReflectUtils.getClassTypes(arguments);
        String key = aClass.getCanonicalName() + "." + methodName + ReflectUtils.argumentTypesToString(classTypes);
        Method method = null;
        Map<String, Method> classMethodsCache = methodsLookupCache.get(aClass);
        if (classMethodsCache != null) {
            method = classMethodsCache.get(key);
        } else {
            classMethodsCache = new HashMap<String, Method>(1);
            methodsLookupCache.put(aClass, classMethodsCache);
        }
        if (method == null) {
            method = ReflectUtils.getMethodImpl(aClass, methodName, arguments);
            classMethodsCache.put(key, method);
        }
        return method;
    }

    protected static Method getMethodImpl(Class aClass, String methodName, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (arguments.length == 0) {
            method = aClass.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
        } else {
            Class[] types = ReflectUtils.getClassTypes(arguments);
            method = ReflectUtils.getMethod(aClass, aClass, methodName, types);
            method.setAccessible(true);
        }
        return method;
    }

    private static Method getMethod(Class topClass, Class currentClass, String methodName, Class[] types) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (Method method : currentClass.getDeclaredMethods()) {
            Class<?>[] mt;
            if (!method.getName().equals(methodName) || (mt = method.getParameterTypes()).length != types.length) continue;
            boolean fits = true;
            for (int i = 0; i < mt.length; ++i) {
                if (ReflectUtils.isAssignable(mt[i], types[i])) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            return method;
        }
        Class superclass = currentClass.getSuperclass();
        if (superclass != null) {
            return ReflectUtils.getMethod(topClass, superclass, methodName, types);
        }
        throw new NoSuchMethodException(topClass.getCanonicalName() + "." + methodName + ReflectUtils.argumentTypesToString(types));
    }

    private static String argumentTypesToString(Class[] argTypes) {
        StringBuilder buf = new StringBuilder("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getCanonicalName());
            }
        }
        return buf.append(")").toString();
    }

    public static <T extends Cloneable> T clone(T object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (T)((Cloneable)ReflectUtils.callMethod(object, "clone", new Object[0]));
    }

    public static <T extends Cloneable> T cloneSafely(T object) {
        return (T)((Cloneable)ReflectUtils.callMethodSafely(object, "clone", new Object[0]));
    }

    public static Class loadClass(String canonicalClassName) throws ClassNotFoundException {
        return ReflectUtils.class.getClassLoader().loadClass(canonicalClassName);
    }

    public static Class[] getClassTypes(Object[] arguments) {
        Class[] parameterTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            parameterTypes[i] = arguments[i] != null ? arguments[i].getClass() : null;
        }
        return parameterTypes;
    }

    public static boolean isAssignable(Class type, Class from) {
        if (from == null) {
            return !type.isPrimitive();
        }
        if (type.isAssignableFrom(from)) {
            return true;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class.isAssignableFrom(from);
            }
            if (type == Integer.TYPE) {
                return Integer.class.isAssignableFrom(from);
            }
            if (type == Character.TYPE) {
                return Character.class.isAssignableFrom(from);
            }
            if (type == Byte.TYPE) {
                return Byte.class.isAssignableFrom(from);
            }
            if (type == Short.TYPE) {
                return Short.class.isAssignableFrom(from);
            }
            if (type == Long.TYPE) {
                return Long.class.isAssignableFrom(from);
            }
            if (type == Float.TYPE) {
                return Float.class.isAssignableFrom(from);
            }
            if (type == Double.TYPE) {
                return Double.class.isAssignableFrom(from);
            }
            if (type == Void.TYPE) {
                return Void.class.isAssignableFrom(from);
            }
        }
        return false;
    }

    public static boolean containsInClassOrSuperclassName(Class theClass, String text) {
        if (theClass == null) {
            return false;
        }
        String name = theClass.getCanonicalName();
        if (name != null) {
            return name.contains(text) || ReflectUtils.containsInClassOrSuperclassName(theClass.getSuperclass(), text);
        }
        return ReflectUtils.containsInClassOrSuperclassName(theClass.getSuperclass(), text);
    }
}

