/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.log.Log;
import java.util.Calendar;
import java.util.Date;

public final class TimeUtils {
    private static Long pinnedTime = null;
    private static Long lastTime = null;
    private static Long pinnedNanoTime = null;
    private static Long lastNanoTime = null;

    public static Long getPinnedTime() {
        return pinnedTime;
    }

    public static Long getLastTime() {
        return lastTime;
    }

    public static void pinTime() {
        lastTime = pinnedTime = Long.valueOf(TimeUtils.currentTime());
    }

    public static long getPassedTime() {
        return TimeUtils.getPassedTime(false);
    }

    public static long getPassedTime(boolean total) {
        long time = TimeUtils.currentTime();
        long passedTime = total ? time - pinnedTime : time - lastTime;
        lastTime = time;
        return passedTime;
    }

    public static void showPassedTime() {
        TimeUtils.showPassedTime(false);
    }

    public static void showPassedTime(String prefix) {
        TimeUtils.showPassedTime(false, prefix);
    }

    public static void showPassedTime(boolean total) {
        TimeUtils.showPassedTime(total, "");
    }

    public static void showPassedTime(boolean total, String prefix) {
        long time = TimeUtils.currentTime();
        Log.info(TimeUtils.class, prefix + (total ? time - pinnedTime : time - lastTime), new Object[0]);
        lastTime = time;
    }

    public static void resetTime() {
        pinnedTime = null;
        lastTime = null;
    }

    public static Long getPinnedNanoTime() {
        return pinnedNanoTime;
    }

    public static Long getLastNanoTime() {
        return lastNanoTime;
    }

    public static void pinNanoTime() {
        lastNanoTime = pinnedNanoTime = Long.valueOf(TimeUtils.currentNanoTime());
    }

    public static long getPassedNanoTime() {
        return TimeUtils.getPassedNanoTime(false);
    }

    public static long getPassedNanoTime(boolean total) {
        long time = TimeUtils.currentNanoTime();
        long passedTime = total ? time - pinnedNanoTime : time - lastNanoTime;
        lastNanoTime = time;
        return passedTime;
    }

    public static void showPassedNanoTime() {
        TimeUtils.showPassedNanoTime(false);
    }

    public static void showPassedNanoTime(String prefix) {
        TimeUtils.showPassedNanoTime(false, prefix);
    }

    public static void showPassedNanoTime(boolean total) {
        TimeUtils.showPassedNanoTime(total, "");
    }

    public static void showPassedNanoTime(boolean total, String prefix) {
        long time = TimeUtils.currentNanoTime();
        Log.info(TimeUtils.class, prefix + (total ? time - pinnedNanoTime : time - lastNanoTime), new Object[0]);
        lastNanoTime = time;
    }

    public static void resetNanoTime() {
        pinnedNanoTime = null;
        lastNanoTime = null;
    }

    public static long currentTime() {
        return System.currentTimeMillis();
    }

    public static long currentNanoTime() {
        return System.nanoTime();
    }

    public static Date currentDate() {
        return new Date(TimeUtils.currentTime());
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return TimeUtils.isSameDay(date1.getTime(), (Long)date2.getTime());
    }

    public static boolean isSameDay(Long time1, Long time2) {
        Calendar calendar = Calendar.getInstance();
        Date tmp = calendar.getTime();
        calendar.setTimeInMillis(time1);
        boolean same = TimeUtils.isSameDay(calendar, time2);
        calendar.setTime(tmp);
        return same;
    }

    public static boolean isSameDay(Calendar calendar, Date date) {
        return TimeUtils.isSameDay(calendar, (Long)date.getTime());
    }

    public static boolean isSameDay(Calendar calendar, Long date) {
        long time = calendar.getTimeInMillis();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.setTimeInMillis(date);
        boolean sameDay = year == calendar.get(1) && month == calendar.get(2) && day == calendar.get(5);
        calendar.setTimeInMillis(time);
        return sameDay;
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 1);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static void increaseByDay(Calendar calendar) {
        TimeUtils.changeByDays(calendar, 1);
    }

    public static void decreaseByDay(Calendar calendar) {
        TimeUtils.changeByDays(calendar, -1);
    }

    public static void changeByDays(Calendar calendar, int days) {
        calendar.set(5, calendar.get(5) + days);
    }
}

