/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.drag;

import com.alee.utils.DragUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FileTransferable
implements Transferable {
    public static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, DragUtils.getUriListDataFlavor()};
    protected final List<File> files;

    public FileTransferable(File file) {
        this(Arrays.asList(file));
    }

    public FileTransferable(List<File> files) {
        this.files = files;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor dataFlavor : flavors) {
            if (!dataFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.javaFileListFlavor.equals(flavor)) {
            return this.files;
        }
        if (DragUtils.getUriListDataFlavor().equals(flavor)) {
            return DragUtils.fileListToTextURIList(this.files);
        }
        return null;
    }
}

