/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.menu;

import com.alee.laf.menu.WebCheckBoxMenuItem;
import com.alee.laf.menu.WebMenu;
import com.alee.laf.menu.WebMenuItem;
import com.alee.laf.menu.WebRadioButtonMenuItem;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.managers.language.LM;
import com.alee.utils.swing.UnselectableButtonGroup;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;

public abstract class AbstractMenuGenerator {
    protected static final String defaultIconFormat = ".png";
    protected Class nearClass;
    protected String path;
    protected String extension;
    protected String languagePrefix;
    protected UnselectableButtonGroup group;

    public Class getNearClass() {
        return this.nearClass;
    }

    public void setNearClass(Class nearClass) {
        this.nearClass = nearClass;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension.startsWith(".") ? extension : "." + extension;
    }

    public void setIconSettings(Class nearClass, String path, String extension) {
        this.nearClass = nearClass;
        this.path = path;
        this.extension = extension;
    }

    public String getLanguagePrefix() {
        return this.languagePrefix;
    }

    public void setLanguagePrefix(String prefix) {
        this.languagePrefix = prefix;
    }

    public String getLanguageKey(String text) {
        if (this.languagePrefix == null) {
            return text;
        }
        String key = this.languagePrefix + "." + text;
        return LM.contains(key) ? key : text;
    }

    public WebMenuItem createItem(String icon, String text, HotkeyData hotkey, boolean enabled, ActionListener actionListener) {
        WebMenuItem item = new WebMenuItem();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.addActionListener(actionListener);
        return item;
    }

    public WebCheckBoxMenuItem createCheckBoxItem(String icon, String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        WebCheckBoxMenuItem item = new WebCheckBoxMenuItem();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.setSelected(selected);
        item.addActionListener(actionListener);
        this.group(item);
        return item;
    }

    public WebRadioButtonMenuItem createRadioButtonItem(String icon, String text, HotkeyData hotkey, boolean enabled, boolean selected, ActionListener actionListener) {
        WebRadioButtonMenuItem item = new WebRadioButtonMenuItem();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setAccelerator(hotkey);
        item.setEnabled(enabled);
        item.setSelected(selected);
        item.addActionListener(actionListener);
        this.group(item);
        return item;
    }

    public WebMenu createMenu(String icon, String text, boolean enabled, ActionListener actionListener) {
        WebMenu item = new WebMenu();
        item.setIcon(this.getIcon(icon));
        item.setLanguage(this.getLanguageKey(text), new Object[0]);
        item.setEnabled(enabled);
        item.addActionListener(actionListener);
        return item;
    }

    public UnselectableButtonGroup openGroup() {
        return this.openGroup(false);
    }

    public UnselectableButtonGroup openGroup(boolean unselectable) {
        this.group = new UnselectableButtonGroup(unselectable);
        return this.group;
    }

    public UnselectableButtonGroup group(AbstractButton button) {
        if (this.group != null) {
            this.group.add(button);
        }
        return this.group;
    }

    public UnselectableButtonGroup closeGroup() {
        UnselectableButtonGroup group = this.group;
        this.group = null;
        return group;
    }

    public ImageIcon getIcon(String icon) {
        if (icon != null) {
            try {
                return new ImageIcon(this.nearClass.getResource(this.path + icon + this.extension));
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }
}

