/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.Gsons;
import com.atlauncher.LogManager;
import com.atlauncher.data.Downloadable;
import com.atlauncher.data.Language;
import com.atlauncher.data.LoginResponse;
import com.atlauncher.data.mojang.api.MinecraftProfileResponse;
import com.atlauncher.data.mojang.api.ProfileTexture;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.utils.Authentication;
import com.atlauncher.utils.Utils;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class Account
implements Serializable {
    private static final long serialVersionUID = 525763616120118176L;
    private String username;
    private transient String password;
    private String encryptedPassword;
    private String clientToken;
    private String accessToken;
    private String minecraftUsername;
    private String uuid;
    private boolean remember;
    private transient boolean isReal;
    private List<String> collapsedPacks;
    private List<String> collapsedInstances;
    private boolean skinUpdating = false;
    private Map<String, Object> store;

    public Account(String username, String password, String minecraftUsername, String uuid, boolean remember) {
        this.username = username;
        if (remember) {
            this.password = password;
            this.encryptedPassword = Utils.encrypt(password);
        }
        this.minecraftUsername = minecraftUsername;
        this.uuid = uuid;
        this.remember = remember;
        this.isReal = true;
        this.collapsedPacks = new ArrayList<String>();
        this.collapsedInstances = new ArrayList<String>();
    }

    public Account(String name) {
        this.username = "";
        this.minecraftUsername = name;
        this.uuid = UUID.randomUUID() + "";
        this.remember = false;
        this.isReal = false;
        this.collapsedPacks = new ArrayList<String>();
        this.collapsedInstances = new ArrayList<String>();
    }

    public ImageIcon getMinecraftHead() {
        File file = null;
        if (this.isReal() && !(file = new File(App.settings.getSkinsDir(), this.minecraftUsername + ".png")).exists()) {
            this.updateSkin();
        }
        if (file == null || !file.exists()) {
            file = new File(App.settings.getSkinsDir(), "default.png");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        BufferedImage main = image.getSubimage(8, 8, 8, 8);
        BufferedImage helmet = image.getSubimage(40, 8, 8, 8);
        BufferedImage head = new BufferedImage(8, 8, 2);
        Graphics g = head.getGraphics();
        g.drawImage(main, 0, 0, null);
        if (Utils.nonTransparentPixels(helmet) <= 32) {
            g.drawImage(helmet, 0, 0, null);
        }
        return new ImageIcon(head.getScaledInstance(32, 32, 4));
    }

    public ImageIcon getMinecraftSkin() {
        File file = null;
        if (this.isReal() && !(file = new File(App.settings.getSkinsDir(), this.minecraftUsername + ".png")).exists()) {
            this.updateSkin();
        }
        if (file == null || !file.exists()) {
            file = new File(App.settings.getSkinsDir(), "default.png");
        }
        BufferedImage image = null;
        try {
            image = ImageIO.read(file);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        BufferedImage head = image.getSubimage(8, 8, 8, 8);
        BufferedImage helmet = image.getSubimage(40, 8, 8, 8);
        BufferedImage arm = image.getSubimage(44, 20, 4, 12);
        BufferedImage body = image.getSubimage(20, 20, 8, 12);
        BufferedImage leg = image.getSubimage(4, 20, 4, 12);
        BufferedImage skin = new BufferedImage(16, 32, 2);
        Graphics g = skin.getGraphics();
        g.drawImage(head, 4, 0, null);
        if (Utils.nonTransparentPixels(helmet) <= 32) {
            g.drawImage(helmet, 4, 0, null);
        }
        g.drawImage(arm, 0, 8, null);
        g.drawImage(Utils.flipImage(arm), 12, 8, null);
        g.drawImage(body, 4, 8, null);
        g.drawImage(leg, 4, 20, null);
        g.drawImage(Utils.flipImage(leg), 8, 20, null);
        return new ImageIcon(skin.getScaledInstance(128, 256, 4));
    }

    public boolean isReal() {
        return this.isReal;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getMinecraftUsername() {
        return this.minecraftUsername;
    }

    public void setMinecraftUsername(String username) {
        this.minecraftUsername = username;
    }

    public String getUUID() {
        return this.uuid == null ? "0" : this.uuid;
    }

    public String getUUIDNoDashes() {
        return this.uuid == null ? "0" : this.uuid.replace("-", "");
    }

    public UUID getRealUUID() {
        return this.uuid == null ? UUID.randomUUID() : UUIDTypeAdapter.fromString(this.uuid);
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public boolean hasUUID() {
        return this.uuid != null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.encryptedPassword = Utils.encrypt(this.password);
    }

    public boolean isRemembered() {
        return this.remember;
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
        if (!this.remember) {
            this.password = "";
            this.encryptedPassword = "";
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.encryptedPassword == null) {
            this.password = "";
            this.remember = false;
        } else {
            this.password = Utils.decrypt(this.encryptedPassword);
        }
        this.isReal = true;
    }

    public List<String> getCollapsedPacks() {
        if (this.collapsedPacks == null) {
            this.collapsedPacks = new ArrayList<String>();
        }
        return this.collapsedPacks;
    }

    public List<String> getCollapsedInstances() {
        if (this.collapsedInstances == null) {
            this.collapsedInstances = new ArrayList<String>();
        }
        return this.collapsedInstances;
    }

    public void updateSkin() {
        if (!this.skinUpdating) {
            this.skinUpdating = true;
            final File file = new File(App.settings.getSkinsDir(), this.minecraftUsername + ".png");
            LogManager.info("Downloading skin for " + this.minecraftUsername);
            final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("account.downloadingskin"), 0, Language.INSTANCE.localizeWithReplace("account.downloadingminecraftskin", this.minecraftUsername), "Aborting downloading Minecraft skin for " + this.minecraftUsername);
            dialog.addThread(new Thread(){

                @Override
                public void run() {
                    dialog.setReturnValue(false);
                    String skinURL = Account.this.getSkinURL();
                    if (skinURL == null) {
                        LogManager.error("Couldn't download skin because the url found was NULL");
                        if (!file.exists()) {
                            Utils.copyFile(new File(App.settings.getSkinsDir(), "default.png"), file, true);
                        }
                    } else {
                        try {
                            HttpURLConnection conn = (HttpURLConnection)new URL(skinURL).openConnection();
                            if (conn.getResponseCode() == 200) {
                                if (file.exists()) {
                                    Utils.delete(file);
                                }
                                Downloadable skin = new Downloadable(skinURL, file, null, null, false);
                                skin.download(false);
                                dialog.setReturnValue(true);
                            } else if (!file.exists()) {
                                Utils.copyFile(new File(App.settings.getSkinsDir(), "default.png"), file, true);
                            }
                        }
                        catch (MalformedURLException e) {
                            App.settings.logStackTrace(e);
                        }
                        catch (IOException e) {
                            App.settings.logStackTrace(e);
                        }
                        App.settings.reloadAccounts();
                    }
                    dialog.close();
                }
            });
            dialog.start();
            if (!((Boolean)dialog.getReturnValue()).booleanValue()) {
                Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("account.skinerror"), Language.INSTANCE.localize("common.error"), -1, 0, null, options, options[0]);
            }
            this.skinUpdating = false;
        }
    }

    public String getSkinURL() {
        StringBuilder response = null;
        try {
            String line;
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + this.getUUIDNoDashes());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            if (connection.getResponseCode() != 200) {
                return null;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            }
            catch (IOException e) {
                reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            }
            response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            reader.close();
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            response = null;
        }
        if (response == null) {
            return null;
        }
        MinecraftProfileResponse profile = Gsons.DEFAULT.fromJson(response.toString(), MinecraftProfileResponse.class);
        if (!profile.hasProperties()) {
            return null;
        }
        ProfileTexture texture = profile.getUserProperty("textures").getTexture("SKIN");
        if (texture == null) {
            return null;
        }
        return texture.getUrl();
    }

    public String getAccessToken() {
        return this.accessToken == null ? "0" : this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean hasAccessToken() {
        return this.accessToken != null;
    }

    public String getClientToken() {
        return this.clientToken == null ? "0" : this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public boolean hasClientToken() {
        return this.clientToken != null;
    }

    public String toString() {
        return this.minecraftUsername;
    }

    public String getSession(LoginResponse response) {
        if (!response.isOffline() && response != null && response.getAuth().isLoggedIn() && response.getAuth().canPlayOnline()) {
            if (response.getAuth() instanceof YggdrasilUserAuthentication) {
                return String.format("token:%s:%s", response.getAuth().getAuthenticatedToken(), UUIDTypeAdapter.fromUUID(response.getAuth().getSelectedProfile().getId()));
            }
            return response.getAuth().getAuthenticatedToken();
        }
        return "token:0:0";
    }

    public boolean hasStore() {
        return this.store != null;
    }

    public Map<String, Object> getStore() {
        return this.store;
    }

    public void saveStore(Map<String, Object> store) {
        this.store = store;
        App.settings.saveAccounts();
    }

    public LoginResponse login() {
        LoginResponse response = null;
        if (this.hasAccessToken() && this.hasStore()) {
            LogManager.info("Trying to login with access token!");
            response = Authentication.login(this);
        }
        if (response == null || response.hasError()) {
            if (this.hasAccessToken()) {
                LogManager.error("Access token is NOT valid! Will attempt to get another one!");
                this.setAccessToken(null);
                App.settings.saveAccounts();
            }
            if (!this.isRemembered()) {
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                JLabel passwordLabel = new JLabel(Language.INSTANCE.localizeWithReplace("instance.enterpassword", this.getMinecraftUsername()));
                JPasswordField passwordField = new JPasswordField();
                panel.add((Component)passwordLabel, "North");
                panel.add((Component)passwordField, "Center");
                int ret = JOptionPane.showConfirmDialog(App.settings.getParent(), panel, Language.INSTANCE.localize("instance.enterpasswordtitle"), 2);
                if (ret == 0) {
                    this.setPassword(new String(passwordField.getPassword()));
                } else {
                    LogManager.error("Aborting login for " + this.getMinecraftUsername());
                    App.settings.setMinecraftLaunched(false);
                    return null;
                }
            }
            response = Authentication.login(this, true);
        }
        if (response.hasError() && !response.isOffline()) {
            LogManager.error(response.getErrorMessage());
            Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
            JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.errorloggingin", "<br/><br/>" + response.getErrorMessage()) + "</p></html>", Language.INSTANCE.localize("instance.errorloggingintitle"), -1, 0, null, options, options[0]);
            App.settings.setMinecraftLaunched(false);
            return null;
        }
        if (!response.isOffline() && !response.getAuth().canPlayOnline()) {
            return null;
        }
        if (!response.isOffline()) {
            this.setAccessToken(response.getAuth().getAuthenticatedToken());
            this.setUUID(response.getAuth().getSelectedProfile().getId().toString());
            response.save();
            App.settings.saveAccounts();
        }
        return response;
    }
}

