/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.data.Mod;
import com.atlauncher.data.Type;
import com.atlauncher.utils.Utils;
import com.atlauncher.workers.InstanceInstaller;
import java.io.File;
import java.util.ArrayList;

public class Action {
    private ArrayList<Mod> mod = new ArrayList();
    private String action;
    private Type type;
    private String after;
    private String saveAs;
    private boolean client;
    private boolean server;

    public Action(String action, Type type, String after, String saveAs, boolean client, boolean server) {
        this.action = action;
        this.type = type;
        this.after = after;
        this.saveAs = saveAs;
        this.client = client;
        this.server = server;
    }

    public Action(String action, String after, String saveAs, boolean client, boolean server) {
        this.action = action;
        this.after = after;
        this.saveAs = saveAs;
        this.client = client;
        this.server = server;
    }

    public void addMod(Mod mod) {
        if (!this.mod.contains(mod)) {
            this.mod.add(mod);
        }
    }

    public void execute(InstanceInstaller instanceInstaller) {
        if (instanceInstaller.isServer() && !this.server || !instanceInstaller.isServer() && !this.client) {
            return;
        }
        Utils.deleteContents(instanceInstaller.getTempActionsDirectory());
        instanceInstaller.fireTask("Executing Action");
        instanceInstaller.fireSubProgressUnknown();
        if (this.action.equalsIgnoreCase("createzip")) {
            if (this.mod.size() >= 2) {
                for (Mod mod : this.mod) {
                    Utils.unzip(mod.getInstalledFile(instanceInstaller), instanceInstaller.getTempActionsDirectory());
                }
                switch (this.type) {
                    case mods: {
                        Utils.zip(instanceInstaller.getTempActionsDirectory(), new File(instanceInstaller.getModsDirectory(), this.saveAs));
                        break;
                    }
                    case coremods: {
                        if (instanceInstaller.getVersion().getMinecraftVersion().usesCoreMods()) {
                            Utils.zip(instanceInstaller.getTempActionsDirectory(), new File(instanceInstaller.getCoreModsDirectory(), this.saveAs));
                            break;
                        }
                        Utils.zip(instanceInstaller.getTempActionsDirectory(), new File(instanceInstaller.getModsDirectory(), this.saveAs));
                        break;
                    }
                    case jar: {
                        Utils.zip(instanceInstaller.getTempActionsDirectory(), new File(instanceInstaller.getJarModsDirectory(), this.saveAs));
                        instanceInstaller.addToJarOrder(this.saveAs);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (this.action.equalsIgnoreCase("rename") && this.mod.size() == 1) {
            File from = this.mod.get(0).getInstalledFile(instanceInstaller);
            File to = new File(from.getParentFile(), this.saveAs);
            Utils.moveFile(from, to, true);
        }
        if (this.after.equalsIgnoreCase("delete")) {
            for (Mod mod : this.mod) {
                Utils.delete(mod.getInstalledFile(instanceInstaller));
            }
        }
    }
}

