/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Type;
import com.atlauncher.utils.Utils;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class DisableableMod
implements Serializable {
    private static final long serialVersionUID = 8429405767313518704L;
    private String name;
    private String version;
    private boolean optional;
    private String file;
    private Type type;
    private Color colour;
    private String description;
    private boolean disabled;
    private boolean userAdded = false;

    public DisableableMod(String name, String version, boolean optional, String file, Type type, Color colour, String description, boolean disabled, boolean userAdded) {
        this.name = name;
        this.version = version;
        this.optional = optional;
        this.file = file;
        this.type = type;
        this.colour = colour;
        this.description = description;
        this.disabled = disabled;
        this.userAdded = userAdded;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean hasColour() {
        return this.colour != null;
    }

    public Color getColour() {
        return this.colour;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isUserAdded() {
        return this.userAdded;
    }

    public String getFilename() {
        return this.file;
    }

    public boolean enable(Instance instance) {
        if (this.disabled) {
            if (!this.getFile(instance).getParentFile().exists()) {
                this.getFile(instance).getParentFile().mkdir();
            }
            if (Utils.moveFile(this.getDisabledFile(instance), this.getFile(instance), true)) {
                if (this.type == Type.jar) {
                    File inputFile = instance.getMinecraftJar();
                    File outputTmpFile = new File(App.settings.getTempDir(), instance.getSafeName() + "-minecraft.jar");
                    if (Utils.hasMetaInf(inputFile)) {
                        try {
                            JarEntry entry;
                            JarInputStream input = new JarInputStream(new FileInputStream(inputFile));
                            JarOutputStream output = new JarOutputStream(new FileOutputStream(outputTmpFile));
                            while ((entry = input.getNextJarEntry()) != null) {
                                int amo;
                                if (entry.getName().contains("META-INF")) continue;
                                output.putNextEntry(entry);
                                byte[] buffer = new byte[1024];
                                while ((amo = input.read(buffer, 0, 1024)) != -1) {
                                    output.write(buffer, 0, amo);
                                }
                                output.closeEntry();
                            }
                            input.close();
                            output.close();
                            inputFile.delete();
                            outputTmpFile.renameTo(inputFile);
                        }
                        catch (IOException e) {
                            App.settings.logStackTrace(e);
                        }
                    }
                }
                this.disabled = false;
                return true;
            }
        }
        return false;
    }

    public boolean disable(Instance instance) {
        if (!this.disabled && Utils.moveFile(this.getFile(instance), instance.getDisabledModsDirectory(), false)) {
            this.disabled = true;
            return true;
        }
        return false;
    }

    public File getDisabledFile(Instance instance) {
        return new File(instance.getDisabledModsDirectory(), this.file);
    }

    public File getFile(Instance instance) {
        File dir = null;
        switch (this.type) {
            case jar: 
            case forge: 
            case mcpc: {
                dir = instance.getJarModsDirectory();
                break;
            }
            case texturepack: {
                dir = instance.getTexturePacksDirectory();
                break;
            }
            case resourcepack: {
                dir = instance.getResourcePacksDirectory();
                break;
            }
            case mods: {
                dir = instance.getModsDirectory();
                break;
            }
            case ic2lib: {
                dir = instance.getIC2LibDirectory();
                break;
            }
            case denlib: {
                dir = instance.getDenLibDirectory();
                break;
            }
            case coremods: {
                dir = instance.getCoreModsDirectory();
                break;
            }
            case shaderpack: {
                dir = instance.getShaderPacksDirectory();
                break;
            }
            default: {
                LogManager.warn("Unsupported mod for enabling/disabling " + this.name);
            }
        }
        if (dir == null) {
            return null;
        }
        return new File(dir, this.file);
    }

    public Type getType() {
        return this.type;
    }
}

