/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Server;
import com.atlauncher.utils.Utils;
import com.atlauncher.workers.InstanceInstaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class Downloadable {
    private String beforeURL;
    private String url;
    private File file;
    private File oldFile;
    private String hash;
    private int size;
    private HttpURLConnection connection;
    private InstanceInstaller instanceInstaller;
    private boolean isATLauncherDownload;
    private File copyTo;
    private boolean actuallyCopy;
    private int attempts = 0;
    private List<Server> servers;
    private Server server;

    public Downloadable(String url, File file, String hash, int size, InstanceInstaller instanceInstaller, boolean isATLauncherDownload, File copyTo, boolean actuallyCopy) {
        if (isATLauncherDownload) {
            this.servers = new ArrayList<Server>(App.settings.getServers());
            this.server = this.servers.get(0);
            for (Server server : this.servers) {
                if (!server.getName().equals(App.settings.getServer().getName())) continue;
                this.server = server;
                break;
            }
            this.url = this.server.getFileURL(url);
        } else {
            this.url = url;
        }
        this.beforeURL = url;
        this.file = file;
        this.hash = hash;
        this.size = size;
        this.instanceInstaller = instanceInstaller;
        this.isATLauncherDownload = isATLauncherDownload;
        this.copyTo = copyTo;
        this.actuallyCopy = actuallyCopy;
    }

    public Downloadable(String url, File file, String hash, int size, InstanceInstaller instanceInstaller, boolean isATLauncherDownload) {
        this(url, file, hash, size, instanceInstaller, isATLauncherDownload, null, false);
    }

    public Downloadable(String url, File file, String hash, InstanceInstaller instanceInstaller, boolean isATLauncherDownload) {
        this(url, file, hash, -1, instanceInstaller, isATLauncherDownload, null, false);
    }

    public Downloadable(String url, File file) {
        this(url, file, null, -1, null, false, null, false);
    }

    public Downloadable(String url, boolean isATLauncherDownload) {
        this(url, null, null, -1, null, isATLauncherDownload, null, false);
    }

    public String getFilename() {
        if (this.copyTo == null) {
            return this.file.getName();
        }
        return this.copyTo.getName();
    }

    public boolean isMD5() {
        return this.hash == null || this.hash.length() != 40;
    }

    public String getHashFromURL() throws IOException {
        String etag = null;
        etag = this.getConnection().getHeaderField("ETag");
        if (etag == null) {
            etag = this.getConnection().getHeaderField("ATLauncher-MD5");
        }
        if (etag == null) {
            return "-";
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        if (etag.matches("[A-Za-z0-9]{32}")) {
            return etag;
        }
        return "-";
    }

    public int getFilesize() {
        if (this.size == -1) {
            int size = this.getConnection().getContentLength();
            this.size = size == -1 ? 0 : size;
        }
        return this.size;
    }

    public boolean needToDownload() {
        if (this.file == null) {
            return true;
        }
        return !this.file.exists() || !(this.isMD5() ? Utils.getMD5(this.file).equalsIgnoreCase(this.getHash()) : Utils.getSHA1(this.file).equalsIgnoreCase(this.getHash()));
    }

    public void copyFile() {
        if (this.copyTo != null && this.actuallyCopy) {
            if (this.copyTo.exists()) {
                Utils.delete(this.copyTo);
            }
            new File(this.copyTo.getAbsolutePath().substring(0, this.copyTo.getAbsolutePath().lastIndexOf(File.separatorChar))).mkdirs();
            Utils.copyFile(this.file, this.copyTo, true);
        }
    }

    public String getHash() {
        if (this.hash == null || this.hash.isEmpty()) {
            try {
                this.hash = this.getHashFromURL();
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
                this.hash = "-";
                this.connection = null;
            }
        }
        return this.hash;
    }

    public File getFile() {
        return this.file;
    }

    public File getCopyToFile() {
        return this.copyTo;
    }

    public boolean isGziped() {
        if (this.getConnection().getContentEncoding() == null) {
            return false;
        }
        return this.getConnection().getContentEncoding().equalsIgnoreCase("gzip");
    }

    private HttpURLConnection getConnection() {
        block7: {
            if (this.instanceInstaller != null && this.instanceInstaller.isCancelled()) {
                return null;
            }
            if (this.connection == null) {
                LogManager.debug("Opening connection to " + this.url, 3);
                try {
                    this.connection = App.settings.getEnableProxy() ? (HttpURLConnection)new URL(this.url).openConnection(App.settings.getProxy()) : (HttpURLConnection)new URL(this.url).openConnection();
                    this.connection.setUseCaches(false);
                    this.connection.setDefaultUseCaches(false);
                    if (App.useGzipForDownloads) {
                        this.connection.setRequestProperty("Accept-Encoding", "gzip");
                    }
                    this.connection.setRequestProperty("User-Agent", App.settings.getUserAgent());
                    this.connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
                    this.connection.setRequestProperty("Expires", "0");
                    this.connection.setRequestProperty("Pragma", "no-cache");
                    this.connection.connect();
                    if (this.connection.getResponseCode() / 100 != 2) {
                        throw new IOException(this.url + " returned response code " + this.connection.getResponseCode() + (this.connection.getResponseMessage() != null ? " with message of " + this.connection.getResponseMessage() : ""));
                    }
                    LogManager.debug("Connection opened to " + this.url, 3);
                }
                catch (IOException e) {
                    LogManager.debug("Exception when opening connection to " + this.url, 3);
                    App.settings.logStackTrace(e);
                    if (!this.isATLauncherDownload) break block7;
                    if (this.getNextServer()) {
                        this.url = this.server.getFileURL(this.beforeURL);
                        this.connection = null;
                        return this.getConnection();
                    }
                    LogManager.error("Failed to download " + this.beforeURL + " from all ATLauncher servers. " + "Cancelling install!");
                    if (this.instanceInstaller == null) break block7;
                    this.instanceInstaller.cancel(true);
                }
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(boolean downloadAsLibrary) {
        if (this.instanceInstaller != null && this.instanceInstaller.isCancelled()) {
            return;
        }
        InputStream in = null;
        FileOutputStream writer = null;
        try {
            in = this.isGziped() && App.useGzipForDownloads ? new GZIPInputStream(this.getConnection().getInputStream()) : this.getConnection().getInputStream();
            writer = new FileOutputStream(this.file);
            byte[] buffer = new byte[2048];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[2048];
                if (this.instanceInstaller == null || !downloadAsLibrary || this.getFilesize() == 0) continue;
                this.instanceInstaller.addDownloadedBytes(bytesRead);
            }
        }
        catch (SocketException e) {
            LogManager.error("Failed to download " + this.url + " due to SocketException!");
            App.settings.logStackTrace(e);
            this.connection.disconnect();
            this.connection = null;
            if (this.oldFile != null && this.oldFile.exists()) {
                Utils.moveFile(this.oldFile, this.file, true);
            }
        }
        catch (IOException e) {
            LogManager.error("Failed to download " + this.url + " due to IOException!");
            App.settings.logStackTrace(e);
            if (this.oldFile != null && this.oldFile.exists()) {
                Utils.moveFile(this.oldFile, this.file, true);
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e1) {
                App.settings.logStackTrace(e1);
            }
        }
    }

    public String getContents() {
        if (this.instanceInstaller != null && this.instanceInstaller.isCancelled()) {
            return null;
        }
        StringBuilder response = null;
        try {
            String inputLine;
            InputStream in = null;
            in = this.isGziped() && App.useGzipForDownloads ? new GZIPInputStream(this.getConnection().getInputStream()) : this.getConnection().getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            response = new StringBuilder();
            while ((inputLine = br.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
        }
        catch (IOException e) {
            LogManager.error("Failed to get contents of " + this.url + " due to IOException!");
            App.settings.logStackTrace(e);
            return null;
        }
        this.connection.disconnect();
        return response.toString();
    }

    public void download(boolean downloadAsLibrary) {
        this.download(downloadAsLibrary, false);
    }

    public void download(boolean downloadAsLibrary, boolean force) {
        this.attempts = 0;
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        if (this.file == null) {
            LogManager.error("Cannot download " + this.url + " to file as one wasn't specified!");
            return;
        }
        if (this.file.exists()) {
            this.oldFile = new File(this.file.getParent(), this.file.getName() + ".bak");
            Utils.moveFile(this.file, this.oldFile, true);
        }
        if (this.instanceInstaller != null && this.instanceInstaller.isCancelled()) {
            return;
        }
        if (!this.file.canWrite()) {
            Utils.delete(this.file);
        }
        if (this.file.exists() && this.file.isFile()) {
            Utils.delete(this.file);
        }
        new File(this.file.getAbsolutePath().substring(0, this.file.getAbsolutePath().lastIndexOf(File.separatorChar))).mkdirs();
        if (this.getHash().equalsIgnoreCase("-")) {
            this.downloadFile(downloadAsLibrary);
        } else {
            String fileHash = "0";
            boolean done = false;
            while (this.attempts <= 3) {
                ++this.attempts;
                fileHash = this.file.exists() ? (this.isMD5() ? Utils.getMD5(this.file) : Utils.getSHA1(this.file)) : "0";
                if (fileHash.equalsIgnoreCase(this.getHash())) {
                    done = true;
                    break;
                }
                if (this.connection != null) {
                    this.connection.disconnect();
                    this.connection = null;
                }
                if (this.file.exists()) {
                    Utils.delete(this.file);
                }
                if (this.attempts != 1 && downloadAsLibrary) {
                    this.instanceInstaller.addTotalDownloadedBytes(this.size);
                }
                this.downloadFile(downloadAsLibrary);
            }
            if (!done) {
                if (this.isATLauncherDownload) {
                    if (this.getNextServer()) {
                        LogManager.warn("Error downloading " + this.file.getName() + " from " + this.url + ". " + "Expected hash of " + this.getHash() + " but got " + fileHash + " instead. Trying another " + "server!");
                        this.url = this.server.getFileURL(this.beforeURL);
                        if (downloadAsLibrary) {
                            this.instanceInstaller.addTotalDownloadedBytes(this.size);
                        }
                        this.download(downloadAsLibrary);
                    } else {
                        Utils.copyFile(this.file, App.settings.getFailedDownloadsDir());
                        LogManager.error("Failed to download file " + this.file.getName() + " from all ATLauncher " + "servers. Copied to FailedDownloads Folder. Cancelling install!");
                        if (this.instanceInstaller != null) {
                            this.instanceInstaller.cancel(true);
                        }
                    }
                } else {
                    Utils.copyFile(this.file, App.settings.getFailedDownloadsDir());
                    LogManager.error("Error downloading " + this.file.getName() + " from " + this.url + ". Expected " + "hash of " + this.getHash() + " but got " + fileHash + " instead. Copied to FailedDownloads " + "Folder. Cancelling install!");
                    if (this.instanceInstaller != null) {
                        this.instanceInstaller.cancel(true);
                    }
                }
            } else if (this.copyTo != null && this.actuallyCopy) {
                String fileHash2 = this.copyTo.exists() ? (this.isMD5() ? Utils.getMD5(this.file) : Utils.getSHA1(this.file)) : "0";
                if (!fileHash2.equalsIgnoreCase(this.getHash())) {
                    if (this.copyTo.exists()) {
                        Utils.delete(this.copyTo);
                    }
                    new File(this.copyTo.getAbsolutePath().substring(0, this.copyTo.getAbsolutePath().lastIndexOf(File.separatorChar))).mkdirs();
                    Utils.copyFile(this.file, this.copyTo, true);
                }
            }
            App.settings.clearTriedServers();
        }
        if (this.oldFile != null && this.oldFile.exists()) {
            Utils.delete(this.oldFile);
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public boolean getNextServer() {
        for (Server server : this.servers) {
            if (this.server == server) continue;
            LogManager.warn("Server " + this.server.getName() + " Not Available! Switching To " + server.getName());
            this.servers.remove(this.server);
            this.server = server;
            return true;
        }
        return false;
    }

    public int getResponseCode() {
        try {
            return this.getConnection().getResponseCode();
        }
        catch (IOException e) {
            App.settings.logStackTrace("IOException when getting response code for the url " + this.url, e);
            return -1;
        }
    }
}

