/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.data.SyncAbstract;
import com.atlauncher.gui.components.CollapsiblePanel;
import com.atlauncher.utils.Base64;
import com.atlauncher.utils.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class DropboxSync
extends SyncAbstract {
    private File dropboxLocation = null;
    private String backupFolder = "ATLauncherBackup";

    public DropboxSync() {
        super("Dropbox");
        if (App.settings.getDropboxLocation().length() > 1) {
            this.dropboxLocation = new File(App.settings.getDropboxLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findDropboxLocation() {
        File dropboxData = null;
        if (Utils.isWindows()) {
            dropboxData = new File(System.getProperty("user.home"), "/AppData/Roaming/Dropbox/host.db");
        } else if (Utils.isMac() || Utils.isLinux()) {
            dropboxData = new File(System.getProperty("user.home"), "/.dropbox/host.db");
        }
        if (dropboxData == null) {
            this.promptUserDropboxLocation();
        } else {
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new FileReader(dropboxData));
                File dropboxLoc = null;
                while ((line = bufferedReader.readLine()) != null && !(dropboxLoc = new File(new String(Base64.decode(line)))).exists()) {
                }
                this.dropboxLocation = dropboxLoc;
            }
            catch (IOException e) {
                LogManager.info("Couldn't auto find the dropbox settings location!");
                this.promptUserDropboxLocation();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        App.settings.logStackTrace(e);
                    }
                }
            }
        }
    }

    private void promptUserDropboxLocation() {
        FileChooseDialog dialog = new FileChooseDialog();
        dialog.setVisible(true);
    }

    @Override
    public void backupWorld(String backupName, File worldData, Instance instance) {
        if (this.dropboxLocation == null) {
            this.findDropboxLocation();
        }
        File backupDir = new File(this.dropboxLocation, this.backupFolder + File.separator + instance.getName());
        File backup = new File(backupDir, backupName + ".zip");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        if (backup.exists()) {
            JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localizeWithReplace("backup.message.backupexists", backupName), Language.INSTANCE.localize("backup.message.backupexists.title"), 0);
        } else {
            Utils.zip(worldData, backup);
            if (App.settings.getNotifyBackup()) {
                JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("backup.complete"), Language.INSTANCE.localize("backup.complete"), 1);
            }
        }
    }

    @Override
    public List<String> getBackupsForInstance(Instance instance) {
        File[] files;
        File backupDir;
        if (this.dropboxLocation == null) {
            this.findDropboxLocation();
        }
        if ((backupDir = new File(this.dropboxLocation, this.backupFolder + File.separator + instance.getName())).exists() && (files = backupDir.listFiles()) != null) {
            ArrayList<String> backupList = new ArrayList<String>();
            for (File file : files) {
                if (!file.getName().matches(".*\\.zip")) continue;
                backupList.add(file.getName());
            }
            return backupList;
        }
        return null;
    }

    @Override
    public void restoreBackup(String backupName, Instance instance) {
        File target = new File(instance.getSavesDirectory(), backupName.replace(".zip", ""));
        if (target.exists()) {
            if (JOptionPane.showConfirmDialog(App.settings.getParent(), Language.INSTANCE.localizeWithReplace("backup.message.backupoverwrite", backupName.replace(".zip", "")), Language.INSTANCE.localize("backup.message.backupoverwrite.title"), 2, 2) == 0) {
                Utils.unzip(new File(this.dropboxLocation, this.backupFolder + File.separator + instance.getName() + File.separator + backupName), target);
            }
        } else {
            Utils.unzip(new File(this.dropboxLocation, this.backupFolder + File.separator + instance.getName() + File.separator + backupName), target);
        }
        if (App.settings.getNotifyBackup()) {
            JOptionPane.showMessageDialog(App.settings.getParent(), Language.INSTANCE.localize("backup.message.restoresuccess"), Language.INSTANCE.localize("backup.message.restoresuccess.title"), 1);
        }
        App.settings.clearTempDir();
    }

    @Override
    public void deleteBackup(String backupName, Instance instance) {
        File backupData = new File(this.dropboxLocation, this.backupFolder + File.separator + instance.getName() + File.separator + backupName);
        if (backupData.exists()) {
            backupData.delete();
        }
    }

    @Override
    public CollapsiblePanel getSettingsPanel() {
        return null;
    }

    private class FileChooseDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1417439005699532910L;
        private final JButton folderChooseButton;
        private final JFileChooser fileChooser;

        public FileChooseDialog() {
            super(App.settings.getParent(), Language.INSTANCE.localize("dropbox.notfound.title"));
            this.fileChooser = new JFileChooser();
            this.setResizable(false);
            this.setSize(230, 90);
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(App.settings.getParent());
            this.folderChooseButton = new JButton(Language.INSTANCE.localize("dropbox.label.location"));
            this.folderChooseButton.addActionListener(this);
            this.folderChooseButton.setHorizontalAlignment(0);
            this.fileChooser.setFileSelectionMode(1);
            JLabel label = new JLabel(Language.INSTANCE.localize("dropbox.label.location"));
            label.setBorder(BorderFactory.createEmptyBorder());
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Center");
            this.add((Component)this.folderChooseButton, "South");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.folderChooseButton) {
                int returnVal = this.fileChooser.showOpenDialog(this);
                if (returnVal == 0) {
                    File selectedFolder = this.fileChooser.getSelectedFile();
                    LogManager.info("User selected folder " + selectedFolder);
                    DropboxSync.this.dropboxLocation = selectedFolder;
                    App.settings.setDropboxLocation(DropboxSync.this.dropboxLocation.toString());
                    this.dispose();
                } else {
                    DropboxSync.this.dropboxLocation = null;
                }
            }
        }
    }
}

