/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.Gsons;
import com.atlauncher.LogManager;
import com.atlauncher.data.Account;
import com.atlauncher.data.DisableableMod;
import com.atlauncher.data.Language;
import com.atlauncher.data.LoginResponse;
import com.atlauncher.data.Pack;
import com.atlauncher.data.PackVersion;
import com.atlauncher.data.SyncAbstract;
import com.atlauncher.data.Type;
import com.atlauncher.data.openmods.OpenEyeReportResponse;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.mclauncher.LegacyMCLauncher;
import com.atlauncher.mclauncher.MCLauncher;
import com.atlauncher.utils.Utils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Instance
implements Cloneable {
    private boolean CustomPack = false;
    private String name;
    private String pack;
    private String installedBy;
    private String version;
    private String hash;
    private String minecraftVersion;
    private int memory = 0;
    private int permgen = 0;
    private String jarOrder;
    private String librariesNeeded = null;
    private String extraArguments = null;
    private String minecraftArguments = null;
    private String mainClass = null;
    private String assets = null;
    private boolean isConverted = false;
    private transient Pack realPack;
    private boolean isDev;
    private boolean isPlayable;
    private boolean newLaunchMethod;
    private List<DisableableMod> mods;
    private List<String> ignoredUpdates;

    public Instance(String name, String pack, Pack realPack, boolean installJustForMe, String version, String minecraftVersion, int memory, int permgen, List<DisableableMod> mods, String jarOrder, String librariesNeeded, String extraArguments, String minecraftArguments, String mainClass, String assets, boolean isDev, boolean isPlayable, boolean newLaunchMethod) {
        this.name = name;
        this.pack = pack;
        this.realPack = realPack;
        this.version = version;
        this.minecraftVersion = minecraftVersion;
        this.memory = memory;
        this.permgen = permgen;
        this.mods = mods;
        this.jarOrder = jarOrder;
        this.librariesNeeded = librariesNeeded;
        this.mainClass = mainClass;
        this.assets = assets;
        this.jarOrder = jarOrder;
        this.extraArguments = extraArguments;
        this.minecraftArguments = minecraftArguments;
        this.isDev = isDev;
        this.isPlayable = isPlayable;
        this.newLaunchMethod = newLaunchMethod;
        this.installedBy = installJustForMe ? App.settings.getAccount().getMinecraftUsername() : null;
        this.isConverted = true;
    }

    public Instance(String name, String pack, Pack realPack, boolean installJustForMe, String version, String minecraftVersion, int memory, int permgen, List<DisableableMod> mods, String jarOrder, String librariesNeeded, String extraArguments, String minecraftArguments, String mainClass, String assets, boolean isDev, boolean newLaunchMethod) {
        this(name, pack, realPack, installJustForMe, version, minecraftVersion, memory, permgen, mods, jarOrder, librariesNeeded, extraArguments, minecraftArguments, mainClass, assets, isDev, true, newLaunchMethod);
    }

    public boolean getCustomPack() {
        return this.getPackName().equalsIgnoreCase("custompack");
    }

    public void setCustomPack(boolean isCustomPack) {
        this.CustomPack = isCustomPack;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getSafeName() {
        return this.name.replaceAll("[^A-Za-z0-9]", "");
    }

    public String getPackName() {
        return this.pack;
    }

    public boolean hasInstalledMods() {
        return this.mods == null ? false : this.mods.size() >= 1;
    }

    public String getJarOrder() {
        return this.jarOrder;
    }

    public void setJarOrder(String jarOrder) {
        this.jarOrder = jarOrder;
    }

    public int getMemory() {
        return this.memory;
    }

    public void setMemory(int memory) {
        this.memory = memory;
    }

    public List<DisableableMod> getInstalledMods() {
        return this.mods;
    }

    public int getPermGen() {
        return this.permgen;
    }

    public boolean rename(String newName) {
        String oldName = this.name;
        File oldDir = this.getRootDirectory();
        this.name = newName;
        File newDir = this.getRootDirectory();
        if (oldDir.renameTo(newDir)) {
            return true;
        }
        this.name = oldName;
        return false;
    }

    public String getSafePackName() {
        return this.pack.replaceAll("[^A-Za-z0-9]", "");
    }

    public ImageIcon getImage() {
        File customImage = new File(this.getRootDirectory(), "instance.png");
        File instancesImage = new File(App.settings.getImagesDir(), this.getSafePackName().toLowerCase() + ".png");
        if (customImage.exists()) {
            try {
                BufferedImage img = ImageIO.read(customImage);
                Image dimg = img.getScaledInstance(300, 150, 4);
                return new ImageIcon(dimg);
            }
            catch (IOException e) {
                App.settings.logStackTrace("Error creating scaled image from the custom image of instance " + this.getName(), e);
            }
        }
        if (instancesImage.exists()) {
            return Utils.getIconImage(instancesImage);
        }
        return Utils.getIconImage(new File(App.settings.getImagesDir(), "defaultimage.png"));
    }

    public String getPackDescription() {
        if (this.realPack != null) {
            return this.realPack.getDescription();
        }
        return Language.INSTANCE.localize("pack.nodescription");
    }

    public boolean hasBeenConverted() {
        return this.isConverted;
    }

    public boolean isLeaderboardsEnabled() {
        return this.realPack != null && this.realPack.isLeaderboardsEnabled();
    }

    public boolean isLoggingEnabled() {
        return this.realPack != null && this.realPack.isLoggingEnabled();
    }

    public void ignoreUpdate() {
        String version;
        if (this.ignoredUpdates == null) {
            this.ignoredUpdates = new ArrayList<String>();
        }
        if (!this.hasUpdateBeenIgnored(version = this.getLatestVersion())) {
            this.ignoredUpdates.add(version);
            App.settings.saveInstances();
        }
    }

    public boolean hasUpdateBeenIgnored(String version) {
        if (version == null || this.ignoredUpdates == null || this.ignoredUpdates.size() == 0) {
            return false;
        }
        for (String ignoredVersion : this.ignoredUpdates) {
            if (!ignoredVersion.equalsIgnoreCase(version)) continue;
            return true;
        }
        return false;
    }

    public void convert() {
        if (this.minecraftArguments != null) {
            this.extraArguments = this.minecraftArguments;
            this.minecraftArguments = null;
        }
        this.isConverted = true;
    }

    public void removeInstalledMod(DisableableMod mod) {
        Utils.delete(mod.isDisabled() ? mod.getDisabledFile(this) : mod.getFile(this));
        this.mods.remove(mod);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public void setMinecraftVersion(String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public File getRootDirectory() {
        return new File(App.settings.getInstancesDir(), this.getSafeName());
    }

    public File getAssetsDir() {
        return new File(App.settings.getVirtualAssetsDir(), this.getAssets());
    }

    public File getSavesDirectory() {
        return new File(this.getRootDirectory(), "saves");
    }

    public File getReportsDirectory() {
        return new File(this.getRootDirectory(), "reports");
    }

    public File getModsDirectory() {
        return new File(this.getRootDirectory(), "mods");
    }

    public File getIC2LibDirectory() {
        return new File(this.getModsDirectory(), "ic2");
    }

    public File getDenLibDirectory() {
        return new File(this.getModsDirectory(), "denlib");
    }

    public File getPluginsDirectory() {
        return new File(this.getRootDirectory(), "plugins");
    }

    public File getShaderPacksDirectory() {
        return new File(this.getRootDirectory(), "shaderpacks");
    }

    public File getDisabledModsDirectory() {
        return new File(this.getRootDirectory(), "disabledmods");
    }

    public File getCoreModsDirectory() {
        return new File(this.getRootDirectory(), "coremods");
    }

    public File getJarModsDirectory() {
        return new File(this.getRootDirectory(), "jarmods");
    }

    public File getTexturePacksDirectory() {
        return new File(this.getRootDirectory(), "texturepacks");
    }

    public File getResourcePacksDirectory() {
        return new File(this.getRootDirectory(), "resourcepacks");
    }

    public File getBinDirectory() {
        return new File(this.getRootDirectory(), "bin");
    }

    public File getNativesDirectory() {
        return new File(this.getBinDirectory(), "natives");
    }

    public File getMinecraftJar() {
        return new File(this.getBinDirectory(), "minecraft.jar");
    }

    public boolean canInstall() {
        return this.realPack != null && this.realPack.canInstall();
    }

    public Pack getRealPack() {
        return this.realPack;
    }

    public void setRealPack(Pack realPack) {
        this.realPack = realPack;
    }

    public boolean hasJarMods() {
        return this.jarOrder != null;
    }

    public void setPermgen(int permgen) {
        this.permgen = permgen;
    }

    public void setPlayable() {
        this.isPlayable = true;
    }

    public void setUnplayable() {
        this.isPlayable = false;
    }

    public void setDevVersion() {
        this.isDev = true;
    }

    public void setNotDevVersion() {
        this.isDev = false;
        this.hash = null;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public boolean isPlayable() {
        return this.isPlayable;
    }

    public void setIsNewLaunchMethod(boolean newLaunchMethod) {
        this.newLaunchMethod = newLaunchMethod;
    }

    public boolean isNewLaunchMethod() {
        return this.newLaunchMethod;
    }

    public String getLibrariesNeeded() {
        return this.librariesNeeded;
    }

    public void setLibrariesNeeded(String librariesNeeded) {
        this.librariesNeeded = librariesNeeded;
    }

    public boolean hasExtraArguments() {
        return this.extraArguments != null;
    }

    public String getExtraArguments() {
        return this.extraArguments;
    }

    public void setExtraArguments(String extraArguments) {
        this.extraArguments = extraArguments;
    }

    public boolean hasMinecraftArguments() {
        return this.minecraftArguments != null;
    }

    public String getMinecraftArguments() {
        return this.minecraftArguments;
    }

    public void setMinecraftArguments(String minecraftArguments) {
        this.minecraftArguments = minecraftArguments;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getAssets() {
        return this.assets == null ? "legacy" : this.assets;
    }

    public void setAssets(String assets) {
        this.assets = assets;
    }

    public boolean canPlay() {
        if (App.settings.getAccount() == null || !App.settings.getAccount().isReal()) {
            return false;
        }
        return this.installedBy == null || App.settings.getAccount().getMinecraftUsername().equalsIgnoreCase(this.installedBy);
    }

    public boolean hasUpdate() {
        if (this.realPack != null) {
            PackVersion devVersion;
            if (this.realPack.hasVersions() && !this.isDev() && !this.realPack.getLatestVersion().getVersion().equalsIgnoreCase(this.version) && !this.realPack.isLatestVersionNoUpdate()) {
                return true;
            }
            if (this.isDev() && this.hash != null && (devVersion = this.realPack.getDevVersionByName(this.version)) != null && !devVersion.hashMatches(this.hash)) {
                return true;
            }
        }
        return false;
    }

    public String getLatestVersion() {
        return this.realPack != null ? this.realPack.getLatestVersion().getVersion() : null;
    }

    public boolean wasModInstalled(String name) {
        if (this.mods != null) {
            for (DisableableMod mod : this.mods) {
                if (!mod.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public void setModsInstalled(List<DisableableMod> mods) {
        this.mods = mods;
    }

    public boolean launch() {
        int ret;
        Object[] options;
        final Account account = App.settings.getAccount();
        if (account == null) {
            Object[] options2 = new String[]{Language.INSTANCE.localize("common.ok")};
            JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.noaccount"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, options2, options2[0]);
            App.settings.setMinecraftLaunched(false);
            return false;
        }
        if (App.settings.getMaximumMemory() < this.memory && this.memory <= Utils.getSafeMaximumRam()) {
            options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
            ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.insufficientram", "<b>" + this.memory + "</b> MB<br/><br/>") + "</p></html>", Language.INSTANCE.localize("instance.insufficientramtitle"), -1, 0, null, options, options[0]);
            if (ret != 0) {
                LogManager.warn("Launching of instance cancelled due to user cancelling memory warning!");
                App.settings.setMinecraftLaunched(false);
                return false;
            }
        }
        if (App.settings.getPermGen() < this.permgen) {
            options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
            ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.insufficientpermgen", "<b>" + this.permgen + "</b> MB<br/><br/>") + "</p></html>", Language.INSTANCE.localize("instance.insufficientpermgentitle"), -1, 0, null, options, options[0]);
            if (ret != 0) {
                LogManager.warn("Launching of instance cancelled due to user cancelling permgen warning!");
                App.settings.setMinecraftLaunched(false);
                return false;
            }
        }
        LogManager.info("Logging into Minecraft!");
        final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("account.loggingin"), 0, Language.INSTANCE.localize("account.loggingin"), "Aborted login to Minecraft!");
        dialog.addThread(new Thread(){

            @Override
            public void run() {
                dialog.setReturnValue(account.login());
                dialog.close();
            }
        });
        dialog.start();
        final LoginResponse session = (LoginResponse)dialog.getReturnValue();
        if (session == null) {
            return false;
        }
        Thread launcher = new Thread(){

            @Override
            public void run() {
                try {
                    File[] files;
                    String line;
                    File[] files2;
                    long start = System.currentTimeMillis();
                    if (App.settings.getParent() != null) {
                        App.settings.getParent().setVisible(false);
                    }
                    HashMap<String, Long> preWorldList = new HashMap<String, Long>();
                    if (App.settings.isAdvancedBackupsEnabled() && App.settings.getAutoBackup() && Instance.this.getSavesDirectory().exists() && (files2 = Instance.this.getSavesDirectory().listFiles()) != null) {
                        for (File file : files2) {
                            if (!file.isDirectory()) continue;
                            preWorldList.put(file.getName(), file.lastModified());
                        }
                    }
                    LogManager.info("Launching pack " + Instance.this.getPackName() + " " + Instance.this.getVersion() + " for " + "Minecraft " + Instance.this.getMinecraftVersion());
                    Process process = null;
                    process = Instance.this.isNewLaunchMethod() ? MCLauncher.launch(account, Instance.this, session) : LegacyMCLauncher.launch(account, Instance.this, session);
                    App.settings.showKillMinecraft(process);
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (!LogManager.showDebug) {
                            line = line.replace(account.getMinecraftUsername(), "**MINECRAFTUSERNAME**");
                            line = line.replace(account.getUsername(), "**MINECRAFTUSERNAME**");
                            if (account.hasAccessToken()) {
                                line = line.replace(account.getAccessToken(), "**ACCESSTOKEN**");
                            }
                            if (account.hasUUID()) {
                                line = line.replace(account.getUUID(), "**UUID**");
                            }
                        }
                        LogManager.minecraft(line);
                    }
                    App.settings.hideKillMinecraft();
                    if (App.settings.getParent() != null && App.settings.keepLauncherOpen()) {
                        App.settings.getParent().setVisible(true);
                    }
                    long end = System.currentTimeMillis();
                    if (App.settings.isInOfflineMode()) {
                        App.settings.checkOnlineStatus();
                    }
                    int exitValue = 0;
                    try {
                        exitValue = process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        App.settings.logStackTrace(e);
                        process.destroy();
                    }
                    if (!App.settings.keepLauncherOpen()) {
                        App.settings.getConsole().setVisible(false);
                    }
                    if (exitValue != 0) {
                        if (App.settings.enableLogs() && App.settings.enableOpenEyeReporting()) {
                            App.TASKPOOL.submit(new Runnable(){

                                @Override
                                public void run() {
                                    Instance.this.sendOpenEyePendingReports();
                                }
                            });
                        }
                    } else if (App.settings.isAdvancedBackupsEnabled() && App.settings.getAutoBackup() && Instance.this.getSavesDirectory().exists() && (files = Instance.this.getSavesDirectory().listFiles()) != null) {
                        for (File file : files) {
                            SyncAbstract sync;
                            if (!file.isDirectory() || file.getName().equals("NEI")) continue;
                            if (preWorldList.containsKey(file.getName())) {
                                if (((Long)preWorldList.get(file.getName())).longValue() == file.lastModified()) continue;
                                sync = SyncAbstract.syncList.get(App.settings.getLastSelectedSync());
                                sync.backupWorld(file.getName() + String.valueOf(file.lastModified()), file, Instance.this);
                                continue;
                            }
                            sync = SyncAbstract.syncList.get(App.settings.getLastSelectedSync());
                            sync.backupWorld(file.getName() + String.valueOf(file.lastModified()).replace(":", ""), file, Instance.this);
                        }
                    }
                    App.settings.setMinecraftLaunched(false);
                    if (!App.settings.isInOfflineMode()) {
                        int timePlayed;
                        if (Instance.this.isLeaderboardsEnabled() && Instance.this.isLoggingEnabled() && !Instance.this.isDev() && App.settings.enableLogs() && (timePlayed = (int)(end - start) / 1000) > 0) {
                            App.TASKPOOL.submit(new Runnable(){

                                @Override
                                public void run() {
                                    Instance.this.addTimePlayed(timePlayed, Instance.this.isDev ? "dev" : Instance.this.getVersion());
                                }
                            });
                        }
                        if (App.settings.keepLauncherOpen() && App.settings.hasUpdatedFiles()) {
                            App.settings.reloadLauncherData();
                        }
                    }
                    if (!App.settings.keepLauncherOpen()) {
                        System.exit(1);
                    }
                }
                catch (IOException e1) {
                    App.settings.logStackTrace(e1);
                }
            }
        };
        launcher.start();
        return true;
    }

    public void sendOpenEyePendingReports() {
        File reportsDir = this.getReportsDirectory();
        if (reportsDir.exists()) {
            for (String filename : reportsDir.list(Utils.getOpenEyePendingReportsFileFilter())) {
                File report = new File(reportsDir, filename);
                LogManager.info("OpenEye: Sending pending crash report located at '" + report.getAbsolutePath() + "'");
                OpenEyeReportResponse response = Utils.sendOpenEyePendingReport(report);
                if (response == null) {
                    LogManager.error("OpenEye: Couldn't send pending crash report!");
                } else {
                    LogManager.info("OpenEye: Pending crash report sent! URL: " + response.getURL());
                    if (response.hasNote()) {
                        Object[] options = new String[]{Language.INSTANCE.localize("common.opencrashreport"), Language.INSTANCE.localize("common.ok")};
                        int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.openeyereport1", "<br/><br/>") + response.getNoteDisplay() + Language.INSTANCE.localize("instance.openeyereport2") + "</p></html>", Language.INSTANCE.localize("instance.aboutyourcrash"), -1, 1, null, options, options[1]);
                        if (ret == 0) {
                            Utils.openBrowser(response.getURL());
                        }
                    }
                }
                Utils.delete(report);
            }
        }
    }

    public String addTimePlayed(int time, String version) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        if (App.settings.enableLeaderboards()) {
            request.put("username", App.settings.getAccount().getMinecraftUsername());
        } else {
            request.put("username", null);
        }
        request.put("version", version);
        request.put("time", time);
        try {
            return Utils.sendAPICall("pack/" + this.getRealPack().getSafeName() + "/timeplayed/", request);
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
            return "Leaderboard Time Not Added!";
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            App.settings.logStackTrace(e);
            return null;
        }
    }

    public boolean hasCustomMods() {
        for (DisableableMod mod : this.mods) {
            if (!mod.isUserAdded()) continue;
            return true;
        }
        return false;
    }

    public List<String> getCustomMods(Type type) {
        ArrayList<String> customMods = new ArrayList<String>();
        for (DisableableMod mod : this.mods) {
            if (!mod.isUserAdded() || mod.getType() != type) continue;
            customMods.add(mod.getFilename());
        }
        return customMods;
    }

    public List<DisableableMod> getCustomDisableableMods() {
        ArrayList<DisableableMod> customMods = new ArrayList<DisableableMod>();
        for (DisableableMod mod : this.mods) {
            if (!mod.isUserAdded()) continue;
            customMods.add(mod);
        }
        return customMods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            OutputStreamWriter writer = null;
            try {
                writer = new FileWriter(new File(new File(App.settings.getInstancesDir(), this.getSafeName()), "instance.json"));
                writer.write(Gsons.DEFAULT.toJson(this));
                writer.flush();
                App.TOASTER.pop("Instance " + this.getName());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

