/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public enum Language {
    INSTANCE,
    Language;

    private final Map<String, Properties> langs = new HashMap<String, Properties>();
    private volatile String current;

    private Language() {
        try {
            this.load("English");
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static String[] available() {
        File[] files = App.settings.getLanguagesDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lang");
            }
        });
        String[] langs = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            langs[i] = files[i].getName().substring(0, 1).toUpperCase() + files[i].getName().substring(1, files[i].getName().lastIndexOf("."));
        }
        return langs;
    }

    public static synchronized String current() {
        return com.atlauncher.data.Language.INSTANCE.current;
    }

    public synchronized void load(String lang) throws IOException {
        if (!this.langs.containsKey(lang)) {
            Properties props = new Properties();
            File langFile = new File(App.settings.getLanguagesDir(), lang.toLowerCase() + ".lang");
            if (!langFile.exists()) {
                LogManager.error("Language file " + langFile.getName() + " doesn't exist! Defaulting it inbuilt one!");
                props.load(App.class.getResourceAsStream("/assets/lang/english.lang"));
            } else {
                props.load(new FileInputStream(langFile));
            }
            this.langs.put(lang, props);
            LogManager.info("Loading Language: " + lang);
        }
        this.current = lang;
    }

    public synchronized void reload(String lang) throws IOException {
        if (this.langs.containsKey(lang)) {
            this.langs.remove(lang);
        }
        this.load(lang);
    }

    public synchronized String localize(String lang, String tag) {
        if (this.langs.containsKey(lang)) {
            Properties props = this.langs.get(lang);
            if (props.containsKey(tag)) {
                return props.getProperty(tag, tag);
            }
            if (lang.equalsIgnoreCase("English")) {
                return "Unknown language key " + tag;
            }
            return this.localize("English", tag);
        }
        return this.localize("English", tag);
    }

    public synchronized String localize(String tag) {
        return this.localize(this.current, tag);
    }

    public synchronized String localizeWithReplace(String tag, String replaceWith) {
        return this.localize(this.current, tag).replace("%s", replaceWith);
    }

    public synchronized String getCurrent() {
        return this.current;
    }
}

