/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

public class LauncherVersion {
    private int reserved;
    private int major;
    private int minor;
    private int revision;
    private int build = 0;

    public LauncherVersion(int reserved, int major, int minor, int revision, int build) {
        this.reserved = reserved;
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.build = build;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getBuild() {
        return this.build;
    }

    public boolean needsUpdate(LauncherVersion toThis) {
        if (this.reserved > toThis.getReserved()) {
            return false;
        }
        if (this.reserved < toThis.getReserved()) {
            return true;
        }
        if (this.major > toThis.getMajor()) {
            return false;
        }
        if (this.major < toThis.getMajor()) {
            return true;
        }
        if (this.minor > toThis.getMinor()) {
            return false;
        }
        if (this.minor < toThis.getMinor()) {
            return true;
        }
        if (this.revision > toThis.getRevision()) {
            return false;
        }
        if (this.revision < toThis.getRevision()) {
            return true;
        }
        return toThis.getBuild() == 0 ? this.build != 0 : this.build < toThis.getBuild();
    }

    public String toString() {
        if (this.build == 0) {
            return String.format("%d.%d.%d.%d", this.reserved, this.major, this.minor, this.revision);
        }
        return String.format("%d.%d.%d.%d Build %d", this.reserved, this.major, this.minor, this.revision, this.build);
    }

    public boolean isBeta() {
        return this.build != 0;
    }
}

