/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.data.Account;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;

public class LoginResponse {
    private boolean offline = false;
    private boolean hasError = false;
    private String errorMessage;
    private YggdrasilUserAuthentication auth = null;
    private String username;

    public LoginResponse(String username) {
        this.username = username;
    }

    public void setOffline() {
        this.offline = true;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.hasError = true;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? "Unknown Error Occured" : this.errorMessage;
    }

    public void setAuth(YggdrasilUserAuthentication auth) {
        this.auth = auth;
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public YggdrasilUserAuthentication getAuth() {
        return this.auth;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isValidAuth() {
        if (!this.hasAuth()) {
            return false;
        }
        if (!this.auth.isLoggedIn()) {
            this.setErrorMessage("Response from Mojang wasn't valid!");
        } else if (this.auth.getAuthenticatedToken() == null) {
            this.setErrorMessage("No authentication token returned from Mojang!");
        } else if (this.auth.getSelectedProfile() == null && (this.auth.getAvailableProfiles() == null || this.auth.getAvailableProfiles().length == 0)) {
            this.setErrorMessage("There are no paid copies of Minecraft associated with this account!");
        } else if (this.auth.getSelectedProfile() == null) {
            this.setErrorMessage("No profile selected!");
        }
        return !this.hasError;
    }

    public void save() {
        Account account = App.settings.getAccountByName(this.username);
        if (account != null) {
            account.saveStore(this.auth.saveForStorage());
        }
    }
}

