/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.utils.MCQuery;
import com.google.gson.reflect.TypeToken;
import de.zh32.pingtest.QueryVersion;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.List;

public class MinecraftServer {
    public static final Type LIST_TYPE = new TypeToken<List<MinecraftServer>>(){}.getType();
    private String name;
    private String host;
    private int port;
    private QueryVersion queryVersion;
    private transient int playersOnline;
    private transient boolean hasRun;

    public MinecraftServer(String name, String host, int port, QueryVersion queryVersion) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.queryVersion = queryVersion;
    }

    public void checkServer() {
        int playersOnline = MCQuery.getNumberOfPlayers(this.host, this.port, this.queryVersion);
        if (!this.hasRun) {
            System.out.println("Server Checking Started");
            App.TOASTER.pop(String.format("Server Checking on %s has started!", this.name));
            this.hasRun = true;
        } else if (playersOnline == -1 && this.playersOnline >= 0) {
            App.TOASTER.popError(String.format("Server %s is now offline!", this.name));
        } else if (playersOnline >= 0 && this.playersOnline == -1) {
            App.TOASTER.pop(String.format("Server %s is now online with %d players", this.name, this.playersOnline));
        }
        this.playersOnline = playersOnline;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public QueryVersion getQueryVersion() {
        return this.queryVersion;
    }

    public void setQueryVersion(QueryVersion queryVersion) {
        this.queryVersion = queryVersion;
    }

    public String getPrintablePlayersOnline() {
        DecimalFormat df = new DecimalFormat("#,###,###");
        return df.format(this.playersOnline);
    }

    private String getStatusLocalization() {
        if (this.playersOnline == -1) {
            return Language.INSTANCE.localize("tools.serverchecker.offline");
        }
        return Language.INSTANCE.localize("tools.serverchecker.online") + " - " + this.getPrintablePlayersOnline() + " Players";
    }

    public String toString() {
        return String.format("%s (%s:%d) - %s", this.name, this.host, this.port, this.getStatusLocalization());
    }
}

