/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.data.Downloadable;
import com.atlauncher.data.Settings;
import com.atlauncher.data.mojang.MojangConstants;
import com.atlauncher.data.mojang.MojangVersion;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;

public class MinecraftVersion {
    private String version;
    private boolean server;
    private boolean legacy;
    private boolean coremods;
    private boolean resources;
    private MojangVersion mojangVersion;

    public void loadVersion() {
        Downloadable download;
        File versionFile = new File(App.settings.getVersionsDir(), this.version + ".json");
        if (!App.skipMinecraftVersionDownloads && (download = new Downloadable(MojangConstants.DOWNLOAD_BASE.getURL("versions/" + this.version + "/" + this.version + ".json"), versionFile, null, null, false)).needToDownload()) {
            download.download(false);
        }
        try {
            this.mojangVersion = Settings.altGson.fromJson((Reader)new FileReader(versionFile), MojangVersion.class);
        }
        catch (JsonSyntaxException e) {
            App.settings.logStackTrace(e);
        }
        catch (JsonIOException e) {
            App.settings.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            App.settings.logStackTrace(e);
        }
    }

    public boolean canCreateServer() {
        return this.server;
    }

    public String getVersion() {
        return this.version;
    }

    public MojangVersion getMojangVersion() {
        return this.mojangVersion;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean usesCoreMods() {
        return this.coremods;
    }

    public boolean hasResources() {
        return this.resources;
    }

    public String toString() {
        return this.version;
    }
}

