/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.data.MinecraftVersion;
import com.atlauncher.exceptions.InvalidMinecraftVersion;

public class PackVersion {
    private String version;
    private String minecraft;
    private String hash;
    private MinecraftVersion minecraftVersion;
    private boolean canUpdate = true;
    private boolean isRecommended = true;
    private boolean isDev;

    public String getVersion() {
        return this.version;
    }

    public String getSafeVersion() {
        return this.version.replaceAll("[^A-Za-z0-9]", "");
    }

    public void setMinecraftVesion() {
        try {
            this.minecraftVersion = App.settings.getMinecraftVersion(this.minecraft);
        }
        catch (InvalidMinecraftVersion e) {
            this.minecraftVersion = null;
            App.settings.logStackTrace(e);
        }
    }

    public MinecraftVersion getMinecraftVersion() {
        if (this.minecraftVersion == null) {
            this.setMinecraftVesion();
        }
        return this.minecraftVersion;
    }

    public String getHash() {
        if (this.hash == null || !this.isDev) {
            return null;
        }
        return this.hash;
    }

    public boolean canUpdate() {
        return this.canUpdate;
    }

    public boolean isRecommended() {
        return this.isRecommended;
    }

    public boolean isDev() {
        return this.isDev;
    }

    public String toString() {
        return this.version + " (Minecraft " + this.getMinecraftVersion().getVersion() + ")";
    }

    public boolean versionMatches(String version) {
        return this.version.equalsIgnoreCase(version);
    }

    public boolean hashMatches(String hash) {
        if (this.hash == null || !this.isDev) {
            return false;
        }
        return this.hash.equalsIgnoreCase(hash);
    }
}

