/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data;

import com.atlauncher.App;
import com.atlauncher.Gsons;
import com.atlauncher.LogManager;
import com.atlauncher.Update;
import com.atlauncher.adapter.ColorTypeAdapter;
import com.atlauncher.data.APIResponseInt;
import com.atlauncher.data.Account;
import com.atlauncher.data.Constants;
import com.atlauncher.data.Downloadable;
import com.atlauncher.data.DownloadableFile;
import com.atlauncher.data.DropboxSync;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.data.LauncherVersion;
import com.atlauncher.data.MinecraftServer;
import com.atlauncher.data.MinecraftVersion;
import com.atlauncher.data.News;
import com.atlauncher.data.Pack;
import com.atlauncher.data.PackUsers;
import com.atlauncher.data.Server;
import com.atlauncher.data.Status;
import com.atlauncher.data.json.LauncherLibrary;
import com.atlauncher.data.mojang.DateTypeAdapter;
import com.atlauncher.data.mojang.EnumTypeAdapterFactory;
import com.atlauncher.data.mojang.FileTypeAdapter;
import com.atlauncher.exceptions.InvalidMinecraftVersion;
import com.atlauncher.exceptions.InvalidPack;
import com.atlauncher.gui.LauncherConsole;
import com.atlauncher.gui.components.LauncherBottomBar;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.gui.tabs.InstancesTab;
import com.atlauncher.gui.tabs.NewsTab;
import com.atlauncher.gui.tabs.PacksTab;
import com.atlauncher.thread.LoggingThread;
import com.atlauncher.utils.Authentication;
import com.atlauncher.utils.Timestamper;
import com.atlauncher.utils.Utils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Settings {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Gson altGson = new GsonBuilder().setPrettyPrinting().registerTypeAdapterFactory(new EnumTypeAdapterFactory()).registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter()).registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter()).create();
    public static Gson themeGson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)Color.class), new ColorTypeAdapter()).create();
    private Server server;
    private String forgeLoggingLevel;
    private int initialMemory;
    private int maximumMemory;
    private int permGen;
    private int windowWidth;
    private int windowHeight;
    private boolean maximiseMinecraft;
    private boolean saveCustomMods;
    private boolean usingCustomJavaPath;
    private String javaPath;
    private String javaParamaters;
    private boolean advancedBackup;
    private boolean sortPacksAlphabetically;
    private boolean keepLauncherOpen;
    private boolean enableConsole;
    private boolean enableTrayIcon;
    private boolean enableLeaderboards;
    private boolean enableLogs;
    private boolean enableOpenEyeReporting;
    private boolean enableProxy = false;
    private boolean enablePackTags = false;
    private String proxyHost;
    private int proxyPort;
    private String proxyType;
    private int concurrentConnections;
    private int daysOfLogsToKeep;
    private Account account;
    private String addedPacks;
    private Proxy proxy = null;
    private String theme;
    private String dateFormat;
    private boolean hideOldJavaWarning;
    private boolean hideJava8Warning;
    private boolean enableServerChecker;
    private int serverCheckerWait;
    private boolean autoBackup;
    private String lastSelectedSync;
    private boolean notifyBackup;
    private String dropboxFolderLocation;
    private LauncherVersion latestLauncherVersion;
    private List<DownloadableFile> launcherFiles;
    private List<News> news;
    private Map<String, MinecraftVersion> minecraftVersions;
    private List<Pack> packs;
    private List<Instance> instances = new ArrayList<Instance>();
    private List<Account> accounts = new ArrayList<Account>();
    private List<MinecraftServer> checkingServers = new ArrayList<MinecraftServer>();
    private List<LauncherLibrary> launcherLibraries = new ArrayList<LauncherLibrary>();
    private File baseDir;
    private File backupsDir;
    private File configsDir;
    private File themesDir;
    private File jsonDir;
    private File versionsDir;
    private File imagesDir;
    private File skinsDir;
    private File jarsDir;
    private File commonConfigsDir;
    private File resourcesDir;
    private File librariesDir;
    private File launcherLibrariesdir;
    private File languagesDir;
    private File downloadsDir;
    private File usersDownloadsFolder;
    private File instancesDir;
    private File serversDir;
    private File tempDir;
    private File failedDownloadsDir;
    private File instancesDataFile;
    private File checkingServersFile;
    private File userDataFile;
    private File propertiesFile;
    private File logsDir;
    private JFrame parent;
    private Properties properties = new Properties();
    private LauncherConsole console;
    private List<Server> servers = new ArrayList<Server>();
    private List<Server> triedServers = new ArrayList<Server>();
    private InstancesTab instancesPanel;
    private NewsTab newsPanel;
    private PacksTab packsPanel;
    public LauncherBottomBar bottomBar;
    private boolean hadPasswordDialog = false;
    private boolean firstTimeRun = false;
    private boolean offlineMode = false;
    private Process minecraftProcess = null;
    private Server originalServer = null;
    private boolean minecraftLaunched = false;
    private String userAgent = "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.72 Safari/537.36";
    private boolean minecraftLoginServerUp = false;
    private boolean minecraftSessionServerUp = false;
    private DropboxSync dropbox;
    private boolean languageLoaded = false;
    private Timer checkingServersTimer = null;

    public Settings() {
        this.setupFiles();
        this.checkFolders();
        this.clearTempDir();
        this.loadStartingProperties();
    }

    public void loadConsole() {
        this.console = new LauncherConsole();
        LogManager.start();
    }

    public void setupFiles() {
        this.baseDir = Utils.getCoreGracefully();
        this.usersDownloadsFolder = new File(System.getProperty("user.home"), "Downloads");
        this.logsDir = new File(this.baseDir, "Logs");
        this.backupsDir = new File(this.baseDir, "Backups");
        this.configsDir = new File(this.baseDir, "Configs");
        this.themesDir = new File(this.configsDir, "Themes");
        this.jsonDir = new File(this.configsDir, "JSON");
        this.versionsDir = new File(this.configsDir, "Versions");
        this.imagesDir = new File(this.configsDir, "Images");
        this.skinsDir = new File(this.imagesDir, "Skins");
        this.jarsDir = new File(this.configsDir, "Jars");
        this.commonConfigsDir = new File(this.configsDir, "Common");
        this.resourcesDir = new File(this.configsDir, "Resources");
        this.librariesDir = new File(this.configsDir, "Libraries");
        this.launcherLibrariesdir = new File(this.librariesDir, "Launcher");
        this.languagesDir = new File(this.configsDir, "Languages");
        this.downloadsDir = new File(this.baseDir, "Downloads");
        this.instancesDir = new File(this.baseDir, "Instances");
        this.serversDir = new File(this.baseDir, "Servers");
        this.tempDir = new File(this.baseDir, "Temp");
        this.failedDownloadsDir = new File(this.baseDir, "FailedDownloads");
        this.instancesDataFile = new File(this.configsDir, "instancesdata");
        this.checkingServersFile = new File(this.configsDir, "checkingservers.json");
        this.userDataFile = new File(this.configsDir, "userdata");
        this.propertiesFile = new File(this.configsDir, "OpenLauncher.conf");
    }

    public void loadEverything() {
        Object[] options;
        this.setupServers();
        this.checkCreeperRepoEdges();
        this.loadServerProperty(true);
        if (this.server == null) {
            this.server = this.servers.get(0);
            LogManager.warn("Forced to use " + this.server.getName());
        }
        if (this.hasUpdatedFiles()) {
            this.downloadUpdatedFiles();
        }
        this.checkForLauncherUpdate();
        if (!Utils.checkAuthLibLoaded()) {
            LogManager.error("AuthLib was not loaded into the classpath!");
        }
        this.loadNews();
        this.languageLoaded = true;
        this.loadMinecraftVersions();
        this.loadPacks();
        this.loadUsers();
        this.loadInstances();
        this.loadAccounts();
        this.loadCheckingServers();
        this.loadProperties();
        this.console.setupLanguage();
        this.clearOldLogs();
        this.checkResources();
        this.checkAccountUUIDs();
        LogManager.debug("Checking for access to master server");
        block0: for (Pack pack : this.packs) {
            if (!pack.isTester()) continue;
            for (Server server : this.servers) {
                if (!server.getName().equals("Master Server (Testing Only)")) continue;
                server.setUserSelectable(true);
                LogManager.debug("Access to master server granted");
                break block0;
            }
        }
        LogManager.debug("Finished checking for access to master server");
        this.loadServerProperty(true);
        if (Utils.isWindows() && this.javaPath.contains("x86")) {
            LogManager.warn("You're using 32 bit Java on a 64 bit Windows install!");
            options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no")};
            int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("settings.running32bit", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("settings.running32bittitle"), -1, 0, null, options, options[0]);
            if (ret == 0) {
                Utils.openBrowser("http://www.atlauncher.com/help/32bit/");
                System.exit(0);
            }
        }
        if (!Utils.isJava7OrAbove(true) && !this.hideOldJavaWarning) {
            LogManager.warn("You're using an old unsupported version of Java (Java 6 or older)!");
            options = new String[]{Language.INSTANCE.localize("common.download"), Language.INSTANCE.localize("common.ok"), Language.INSTANCE.localize("instance.dontremindmeagain")};
            int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("settings.unsupportedjava", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("settings.unsupportedjavatitle"), -1, 0, null, options, options[0]);
            if (ret == 0) {
                Utils.openBrowser("http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html");
                System.exit(0);
            } else if (ret == 2) {
                this.hideOldJavaWarning = true;
                this.saveProperties();
            }
        }
        if (Utils.isJava8() && !this.hideJava8Warning) {
            LogManager.warn("You're using a possible game breaking version of Java (Java 8)!");
            options = new String[]{Language.INSTANCE.localize("common.download"), Language.INSTANCE.localize("common.ok"), Language.INSTANCE.localize("instance.dontremindmeagain")};
            int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("settings.java8warning", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("settings.java8warningtitle"), -1, 0, null, options, options[0]);
            if (ret == 0) {
                Utils.openBrowser("http://www.oracle.com/technetwork/java/javase/downloads/jre7-downloads-1880261.html");
                System.exit(0);
            } else if (ret == 2) {
                this.hideJava8Warning = true;
                this.saveProperties();
            }
        }
        if (this.advancedBackup) {
            this.dropbox = new DropboxSync();
        }
        if (!this.hadPasswordDialog) {
            this.checkAccounts();
        }
        if (this.enableServerChecker) {
            this.startCheckingServers();
        }
    }

    public void startCheckingServers() {
        if (this.checkingServersTimer != null) {
            this.checkingServersTimer.cancel();
            this.checkingServersTimer.purge();
        }
        if (this.enableServerChecker) {
            this.checkingServersTimer = new Timer();
            this.checkingServersTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    for (MinecraftServer server : Settings.this.checkingServers) {
                        server.checkServer();
                    }
                }
            }, 0L, (long)this.getServerCheckerWaitInMilliseconds());
        }
    }

    public void checkAccounts() {
        boolean matches = false;
        if (this.accounts != null || this.accounts.size() >= 1) {
            for (Account account : this.accounts) {
                if (!account.isRemembered()) continue;
                matches = true;
            }
        }
        if (matches) {
            Object[] options = new String[]{Language.INSTANCE.localize("common.ok"), Language.INSTANCE.localize("account.removepasswords")};
            int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("account.securitywarning", "<br/>") + "</p></html>", Language.INSTANCE.localize("account.securitywarningtitle"), -1, 0, null, options, options[0]);
            if (ret == 1) {
                for (Account account : this.accounts) {
                    if (!account.isRemembered()) continue;
                    account.setRemember(false);
                }
                this.saveAccounts();
            }
        }
        this.saveProperties();
    }

    public void clearOldLogs() {
        LogManager.debug("Clearing out old logs");
        File logFile1 = new File(this.getBaseDir(), "ATLauncher-Log-1.txt");
        File logFile2 = new File(this.getBaseDir(), "ATLauncher-Log-2.txt");
        File logFile3 = new File(this.getBaseDir(), "ATLauncher-Log-3.txt");
        if (logFile3.exists()) {
            Utils.delete(logFile3);
        }
        if (logFile2.exists()) {
            Utils.delete(logFile2);
        }
        if (logFile1.exists()) {
            Utils.delete(logFile1);
        }
        Date toDeleteAfter = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(toDeleteAfter);
        calendar.add(5, -this.getDaysOfLogsToKeep());
        toDeleteAfter = calendar.getTime();
        for (File file : this.logsDir.listFiles(Utils.getLogsFileFilter())) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(file.getName().replace("ATLauncher-Log_", "").replace(".log", ""));
                if (!date.before(toDeleteAfter)) continue;
                Utils.delete(file);
                LogManager.debug("Deleting log file " + file.getName());
            }
            catch (java.text.ParseException e) {
                LogManager.error("Invalid log file " + file.getName());
            }
        }
        LogManager.debug("Finished clearing out old logs");
    }

    public void clearAllLogs() {
        File logFile1 = new File(this.getBaseDir(), "ATLauncher-Log-1.txt");
        File logFile2 = new File(this.getBaseDir(), "ATLauncher-Log-2.txt");
        File logFile3 = new File(this.getBaseDir(), "ATLauncher-Log-3.txt");
        if (logFile3.exists()) {
            Utils.delete(logFile3);
        }
        if (logFile2.exists()) {
            Utils.delete(logFile2);
        }
        if (logFile1.exists()) {
            Utils.delete(logFile1);
        }
        for (File file : this.logsDir.listFiles(Utils.getLogsFileFilter())) {
            if (file.getName().equals(LoggingThread.filename)) continue;
            Utils.delete(file);
        }
    }

    public void checkResources() {
        LogManager.debug("Checking if using old format of resources");
        File indexesDir = new File(this.resourcesDir, "indexes");
        if (!indexesDir.exists() || !indexesDir.isDirectory()) {
            final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("settings.rearrangingresources"), 0, Language.INSTANCE.localize("settings.rearrangingresources"), null);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    File indexesDir = new File(Settings.this.getResourcesDir(), "indexes");
                    File objectsDir = new File(Settings.this.getResourcesDir(), "objects");
                    File virtualDir = new File(Settings.this.getResourcesDir(), "virtual");
                    File legacyDir = new File(virtualDir, "legacy");
                    File tempDir = new File(Settings.this.getTempDir(), "assets");
                    tempDir.mkdir();
                    Utils.moveDirectory(Settings.this.getResourcesDir(), tempDir);
                    indexesDir.mkdirs();
                    objectsDir.mkdirs();
                    virtualDir.mkdirs();
                    legacyDir.mkdirs();
                    Utils.moveDirectory(tempDir, legacyDir);
                    Utils.delete(tempDir);
                    Utils.spreadOutResourceFiles(legacyDir);
                    dialog.close();
                }
            };
            dialog.addThread(thread);
            dialog.start();
        }
        LogManager.debug("Finished checking if using old format of resources");
    }

    public void checkAccountUUIDs() {
        LogManager.debug("Checking account UUID's");
        LogManager.info("Checking account UUID's!");
        for (Account account : this.accounts) {
            if (account.getUUID() != null) continue;
            account.setUUID(Authentication.getUUID(account.getMinecraftUsername()));
            this.saveAccounts();
        }
        LogManager.debug("Finished checking account UUID's");
    }

    public void checkMojangStatus() {
        JSONParser parser = new JSONParser();
        try {
            Downloadable download = new Downloadable("http://status.mojang.com/check", false);
            String response = download.getContents();
            if (response == null) {
                this.minecraftSessionServerUp = false;
                this.minecraftLoginServerUp = false;
                return;
            }
            Object obj = parser.parse(response);
            JSONArray jsonObject = (JSONArray)obj;
            for (JSONObject object : jsonObject) {
                if (object.containsKey("authserver.mojang.com")) {
                    if (!((String)object.get("authserver.mojang.com")).equalsIgnoreCase("green")) continue;
                    this.minecraftLoginServerUp = true;
                    continue;
                }
                if (!object.containsKey("session.minecraft.net") || !((String)object.get("session.minecraft.net")).equalsIgnoreCase("green")) continue;
                this.minecraftSessionServerUp = true;
            }
        }
        catch (ParseException e) {
            this.logStackTrace(e);
            this.minecraftSessionServerUp = false;
            this.minecraftLoginServerUp = false;
        }
    }

    public Status getMojangStatus() {
        if (this.minecraftLoginServerUp && this.minecraftSessionServerUp) {
            return Status.ONLINE;
        }
        if (!this.minecraftLoginServerUp && !this.minecraftSessionServerUp) {
            return Status.OFFLINE;
        }
        return Status.PARTIAL;
    }

    public boolean launcherHasUpdate() {
        try {
            this.latestLauncherVersion = gson.fromJson((Reader)new FileReader(new File(this.jsonDir, "version.json")), LauncherVersion.class);
        }
        catch (JsonSyntaxException e) {
            this.logStackTrace("Exception when loading latest launcher version!", e);
        }
        catch (JsonIOException e) {
            this.logStackTrace("Exception when loading latest launcher version!", e);
        }
        catch (FileNotFoundException e) {
            this.logStackTrace("Exception when loading latest launcher version!", e);
        }
        if (this.latestLauncherVersion == null) {
            return false;
        }
        return Constants.VERSION.needsUpdate(this.latestLauncherVersion);
    }

    public boolean launcherHasBetaUpdate() {
        Downloadable downloadable = new Downloadable("https://api.atlauncher.com/v1/build/atlauncher/build/", false);
        APIResponseInt response = Gsons.DEFAULT.fromJson(downloadable.getContents(), APIResponseInt.class);
        return response.getData() > Constants.VERSION.getBuild();
    }

    public void downloadUpdate() {
        try {
            File thisFile = new File(Update.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            String path = thisFile.getCanonicalPath();
            path = URLDecoder.decode(path, "UTF-8");
            String saveAs = thisFile.getName();
            String toget = path.contains(".exe") ? "exe" : "jar";
            File newFile = new File(this.getTempDir(), saveAs);
            LogManager.info("Downloading Launcher Update");
            Downloadable update = new Downloadable("OpenLauncher." + toget, newFile, null, null, true);
            update.download(false);
            this.runUpdate(path, newFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
    }

    public void downloadBetaUpdate() {
        try {
            File thisFile = new File(Update.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            String path = thisFile.getCanonicalPath();
            path = URLDecoder.decode(path, "UTF-8");
            String saveAs = thisFile.getName();
            String toget = path.contains(".exe") ? "exe" : "jar";
            File newFile = new File(this.getTempDir(), saveAs);
            LogManager.info("Downloading Launcher Update");
            Downloadable update = new Downloadable("https://api.atlauncher.com/v1/build/atlauncher/download/" + toget, newFile, null, null, false);
            update.download(false);
            this.runUpdate(path, newFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
    }

    public void runUpdate(String currentPath, String temporaryUpdatePath) {
        ArrayList<String> arguments = new ArrayList<String>();
        String path = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (Utils.isWindows()) {
            path = path + "w";
        }
        arguments.add(path);
        arguments.add("-cp");
        arguments.add(temporaryUpdatePath);
        arguments.add("com.atlauncher.Update");
        arguments.add(currentPath);
        arguments.add(temporaryUpdatePath);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(arguments);
        LogManager.info("Running launcher update with command " + arguments);
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
        System.exit(0);
    }

    private void getFileHashes() {
        this.launcherFiles = null;
        Downloadable download = new Downloadable("launcher/json/hashes.json", true);
        Type type = new TypeToken<List<DownloadableFile>>(){}.getType();
        this.launcherFiles = (List)gson.fromJson(download.getContents(), type);
    }

    private ArrayList<Downloadable> getLauncherFiles() {
        this.getFileHashes();
        if (this.launcherFiles == null) {
            this.offlineMode = true;
            return null;
        }
        ArrayList<Downloadable> downloads = new ArrayList<Downloadable>();
        for (DownloadableFile file : this.launcherFiles) {
            if (file.isLauncher()) continue;
            downloads.add(file.getDownloadable());
        }
        return downloads;
    }

    public void downloadUpdatedFiles() {
        if (!App.refreshHashes) {
            return;
        }
        ArrayList<Downloadable> downloads = this.getLauncherFiles();
        if (downloads != null) {
            ExecutorService executor = Executors.newFixedThreadPool(this.concurrentConnections);
            for (final Downloadable download : downloads) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (download.needToDownload()) {
                            LogManager.info("Downloading Launcher File " + download.getFile().getName());
                            download.download(false);
                        }
                    }
                });
            }
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
        }
        LogManager.info("Finished downloading updated files!");
        if (Language.INSTANCE.getCurrent() != null) {
            try {
                Language.INSTANCE.reload(Language.INSTANCE.getCurrent());
            }
            catch (IOException e) {
                this.logStackTrace("Couldn't reload langauge " + Language.INSTANCE.getCurrent(), e);
            }
        }
    }

    public boolean hasUpdatedFiles() {
        if (this.isInOfflineMode() || !App.refreshHashes) {
            return false;
        }
        LogManager.info("Checking for updated files!");
        ArrayList<Downloadable> downloads = this.getLauncherFiles();
        if (downloads == null) {
            this.offlineMode = true;
            return false;
        }
        for (Downloadable download : downloads) {
            if (!download.needToDownload()) continue;
            LogManager.info("Updates found!");
            return true;
        }
        LogManager.info("No updates found!");
        return false;
    }

    public void reloadLauncherData() {
        final JDialog dialog = new JDialog((Window)this.parent, Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setSize(300, 100);
        dialog.setTitle("Updating Launcher");
        dialog.setLocationRelativeTo(App.settings.getParent());
        dialog.setLayout(new FlowLayout());
        dialog.setResizable(false);
        dialog.add(new JLabel("Updating Launcher... Please Wait"));
        App.TASKPOOL.execute(new Runnable(){

            @Override
            public void run() {
                if (Settings.this.hasUpdatedFiles()) {
                    Settings.this.downloadUpdatedFiles();
                }
                Settings.this.checkForLauncherUpdate();
                Settings.this.loadNews();
                Settings.this.reloadNewsPanel();
                Settings.this.loadPacks();
                Settings.this.reloadPacksPanel();
                Settings.this.loadUsers();
                Settings.this.loadInstances();
                Settings.this.reloadInstancesPanel();
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    private void checkForLauncherUpdate() {
        LogManager.debug("Checking for launcher update");
        if (this.launcherHasUpdate()) {
            if (!App.wasUpdated) {
                this.downloadUpdate();
            } else {
                Object[] options = new String[]{"Ok"};
                int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">Launcher Update failed. Please click Ok to close the launcher and open up the downloads page.<br/><br/>Download the update and replace the old OpenLauncher file.</p></html>", "Update Failed!", -1, 0, null, options, options[0]);
                if (ret == 0) {
                    Utils.openBrowser("http://rushmead.playat.ch/OpenLauncher.jar");
                    System.exit(0);
                }
            }
        } else if (Constants.VERSION.isBeta() && this.launcherHasBetaUpdate()) {
            this.downloadBetaUpdate();
        }
        LogManager.debug("Finished checking for launcher update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadExternalLibraries() {
        LogManager.debug("Downloading external libraries");
        InputStreamReader fr = null;
        try {
            fr = new FileReader(new File(this.jsonDir, "libraries.json"));
            Type type = new TypeToken<List<LauncherLibrary>>(){}.getType();
            this.launcherLibraries = (List)Gsons.DEFAULT.fromJson((Reader)fr, type);
        }
        catch (Exception e) {
            this.logStackTrace(e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.getConcurrentConnections());
        for (final LauncherLibrary library : this.launcherLibraries) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    Downloadable download = library.getDownloadable();
                    if (download.needToDownload()) {
                        LogManager.info("Downloading library " + library.getFilename() + "!");
                        download.download(false);
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        for (final LauncherLibrary library : this.launcherLibraries) {
            File file = library.getFile();
            if (!library.shouldAutoLoad() || Utils.addToClasspath(file)) continue;
            LogManager.error("Couldn't add " + file + " to the classpath!");
            if (!library.shouldExitOnFail()) continue;
            LogManager.error("Library is necessary so launcher will exit!");
            System.exit(1);
        }
        LogManager.debug("Finished downloading external libraries");
    }

    private void checkFolders() {
        File[] files;
        for (File file : files = new File[]{this.backupsDir, this.configsDir, this.themesDir, this.jsonDir, this.commonConfigsDir, this.imagesDir, this.skinsDir, this.jarsDir, this.resourcesDir, this.librariesDir, this.launcherLibrariesdir, this.languagesDir, this.downloadsDir, this.instancesDir, this.serversDir, this.tempDir, this.failedDownloadsDir, this.logsDir}) {
            if (!file.exists()) {
                file.mkdir();
            }
            if (file.isDirectory() || !file.delete()) continue;
            file.mkdir();
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getBackupsDir() {
        return this.backupsDir;
    }

    public File getConfigsDir() {
        return this.configsDir;
    }

    public File getThemesDir() {
        return this.themesDir;
    }

    public File getJSONDir() {
        return this.jsonDir;
    }

    public File getVersionsDir() {
        return this.versionsDir;
    }

    public File getCommonConfigsDir() {
        return this.commonConfigsDir;
    }

    public File getImagesDir() {
        return this.imagesDir;
    }

    public File getSkinsDir() {
        return this.skinsDir;
    }

    public File getJarsDir() {
        return this.jarsDir;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public File getVirtualAssetsDir() {
        return new File(this.resourcesDir, "virtual");
    }

    public File getObjectsAssetsDir() {
        return new File(this.resourcesDir, "objects");
    }

    public File getLegacyVirtualAssetsDir() {
        return new File(this.getVirtualAssetsDir(), "legacy");
    }

    public File getLibrariesDir() {
        return this.librariesDir;
    }

    public File getLauncherLibrariesDir() {
        return this.launcherLibrariesdir;
    }

    public File getLanguagesDir() {
        return this.languagesDir;
    }

    public File getDownloadsDir() {
        return this.downloadsDir;
    }

    public File getUsersDownloadsDir() {
        return this.usersDownloadsFolder;
    }

    public File getInstancesDir() {
        return this.instancesDir;
    }

    public File getServersDir() {
        return this.serversDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public File getFailedDownloadsDir() {
        return this.failedDownloadsDir;
    }

    public File getLogsDir() {
        return this.logsDir;
    }

    public void clearTempDir() {
        Utils.deleteContents(this.getTempDir());
    }

    public File getInstancesDataFile() {
        return this.instancesDataFile;
    }

    public File getCheckingServersFile() {
        return this.checkingServersFile;
    }

    public void setParentFrame(JFrame parent) {
        this.parent = parent;
    }

    public void loadServerProperty(boolean userSelectableOnly) {
        LogManager.debug("Loading server to use");
        try {
            this.properties.load(new FileInputStream(this.propertiesFile));
            String serv = this.properties.getProperty("server", "england3.creeperrepo.net");
            if (this.isServerByName(serv)) {
                this.originalServer = this.server = this.getServerByName(serv);
            }
            if (this.server == null) {
                LogManager.warn("Server " + serv + " is invalid");
                this.originalServer = this.server = this.getServerByName("Auto");
            }
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
        LogManager.debug("Finished loading server to use");
    }

    public void loadStartingProperties() {
        try {
            if (!this.propertiesFile.exists()) {
                this.propertiesFile.createNewFile();
            }
        }
        catch (IOException e) {
            Object[] options = new String[]{"OK"};
            JOptionPane.showOptionDialog(null, "<html><p align=\"center\">Cannot create the config file.<br/><br/>Make sure you are running the Launcher from somewhere with<br/>write permissions for your user account such as your Home/Users folder or desktop.</p></html>", "Warning", -1, 0, null, options, options[0]);
            System.exit(0);
        }
        try {
            this.properties.load(new FileInputStream(this.propertiesFile));
            this.theme = this.properties.getProperty("theme", "OpenLauncher");
            this.dateFormat = this.properties.getProperty("dateformat", "dd/M/yyy");
            if (!(this.dateFormat.equalsIgnoreCase("dd/M/yyy") || this.dateFormat.equalsIgnoreCase("M/dd/yyy") || this.dateFormat.equalsIgnoreCase("yyy/M/dd"))) {
                this.dateFormat = "dd/M/yyy";
            }
            this.enablePackTags = Boolean.parseBoolean(this.properties.getProperty("enablepacktags", "false"));
            this.enableConsole = Boolean.parseBoolean(this.properties.getProperty("enableconsole", "true"));
            this.enableTrayIcon = Boolean.parseBoolean(this.properties.getProperty("enabletrayicon", "true"));
            if (!this.properties.containsKey("usingcustomjavapath")) {
                this.usingCustomJavaPath = false;
                this.javaPath = Utils.getJavaHome();
            } else {
                this.usingCustomJavaPath = Boolean.parseBoolean(this.properties.getProperty("usingcustomjavapath", "false"));
                this.javaPath = this.isUsingCustomJavaPath() ? this.properties.getProperty("javapath", Utils.getJavaHome()) : Utils.getJavaHome();
            }
            this.enableProxy = Boolean.parseBoolean(this.properties.getProperty("enableproxy", "false"));
            if (this.enableProxy) {
                this.proxyHost = this.properties.getProperty("proxyhost", null);
                this.proxyPort = Integer.parseInt(this.properties.getProperty("proxyport", "0"));
                if (this.proxyPort <= 0 || this.proxyPort > 65535) {
                    this.enableProxy = false;
                }
                this.proxyType = this.properties.getProperty("proxytype", "");
                if (!(this.proxyType.equals("SOCKS") || this.proxyType.equals("HTTP") || this.proxyType.equals("DIRECT"))) {
                    this.enableProxy = false;
                }
            } else {
                this.proxyHost = "";
                this.proxyPort = 0;
                this.proxyType = "";
            }
            this.concurrentConnections = Integer.parseInt(this.properties.getProperty("concurrentconnections", "8"));
            if (this.concurrentConnections < 1) {
                this.concurrentConnections = 8;
            }
            this.daysOfLogsToKeep = Integer.parseInt(this.properties.getProperty("daysoflogstokeep", "7"));
            if (this.daysOfLogsToKeep < 1 || this.daysOfLogsToKeep > 30) {
                this.daysOfLogsToKeep = 7;
            }
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
    }

    public boolean enabledPackTags() {
        return this.enablePackTags;
    }

    public void setPackTags(boolean b) {
        this.enablePackTags = b;
    }

    public void loadProperties() {
        LogManager.debug("Loading properties");
        try {
            String lastAccountTemp;
            this.properties.load(new FileInputStream(this.propertiesFile));
            this.firstTimeRun = Boolean.parseBoolean(this.properties.getProperty("firsttimerun", "true"));
            this.hadPasswordDialog = Boolean.parseBoolean(this.properties.getProperty("hadpassworddialog", "false"));
            this.hideOldJavaWarning = Boolean.parseBoolean(this.properties.getProperty("hideoldjavawarning", "false"));
            this.hideJava8Warning = Boolean.parseBoolean(this.properties.getProperty("hidejava8warning", "false"));
            String lang = this.properties.getProperty("language", "English");
            if (!this.isLanguageByName(lang)) {
                LogManager.warn("Invalid language " + lang + ". Defaulting to English!");
                lang = "English";
            }
            Language.INSTANCE.load(lang);
            this.forgeLoggingLevel = this.properties.getProperty("forgelogginglevel", "INFO");
            if (!(this.forgeLoggingLevel.equalsIgnoreCase("SEVERE") || this.forgeLoggingLevel.equalsIgnoreCase("WARNING") || this.forgeLoggingLevel.equalsIgnoreCase("INFO") || this.forgeLoggingLevel.equalsIgnoreCase("CONFIG") || this.forgeLoggingLevel.equalsIgnoreCase("FINE") || this.forgeLoggingLevel.equalsIgnoreCase("FINER") || this.forgeLoggingLevel.equalsIgnoreCase("FINEST"))) {
                LogManager.warn("Invalid Forge Logging level " + this.forgeLoggingLevel + ". Defaulting to INFO!");
                this.forgeLoggingLevel = "INFO";
            }
            if (Utils.is64Bit()) {
                int halfRam = Utils.getMaximumRam() / 1000 * 512;
                int defaultRam = halfRam >= 4096 ? 4096 : halfRam;
                this.maximumMemory = Integer.parseInt(this.properties.getProperty("ram", defaultRam + ""));
                if (this.maximumMemory > Utils.getMaximumRam()) {
                    LogManager.warn("Tried to allocate " + this.maximumMemory + "MB of Ram but only " + Utils.getMaximumRam() + "MB is available to use!");
                    this.maximumMemory = defaultRam;
                }
            } else {
                this.maximumMemory = Integer.parseInt(this.properties.getProperty("ram", "1024"));
                if (this.maximumMemory > Utils.getMaximumRam()) {
                    LogManager.warn("Tried to allocate " + this.maximumMemory + "MB of Maximum Ram but only " + Utils.getMaximumRam() + "MB is available to use!");
                    this.maximumMemory = 1024;
                }
            }
            this.initialMemory = Integer.parseInt(this.properties.getProperty("initialmemory", "256"));
            if (this.initialMemory > Utils.getMaximumRam()) {
                LogManager.warn("Tried to allocate " + this.initialMemory + "MB of Initial Ram but only " + Utils.getMaximumRam() + "MB is available to use!");
                this.initialMemory = 256;
            } else if (this.initialMemory > this.maximumMemory) {
                LogManager.warn("Tried to allocate " + this.initialMemory + "MB of Initial Ram but maximum ram is " + this.maximumMemory + "MB which is less!");
                this.initialMemory = 256;
            }
            this.permGen = Integer.parseInt(this.properties.getProperty("permGen", Utils.is64Bit() ? "256" : "128"));
            this.windowWidth = Integer.parseInt(this.properties.getProperty("windowwidth", "854"));
            if (this.windowWidth > Utils.getMaximumWindowWidth()) {
                LogManager.warn("Tried to set window width to " + this.windowWidth + " pixels but the maximum is " + Utils.getMaximumWindowWidth() + " pixels!");
                this.windowWidth = Utils.getMaximumWindowWidth();
            }
            this.windowHeight = Integer.parseInt(this.properties.getProperty("windowheight", "480"));
            if (this.windowHeight > Utils.getMaximumWindowHeight()) {
                LogManager.warn("Tried to set window height to " + this.windowHeight + " pixels but the maximum is " + Utils.getMaximumWindowHeight() + " pixels!");
                this.windowHeight = Utils.getMaximumWindowHeight();
            }
            this.usingCustomJavaPath = Boolean.parseBoolean(this.properties.getProperty("usingcustomjavapath", "false"));
            if (this.isUsingCustomJavaPath()) {
                this.javaPath = this.properties.getProperty("javapath", Utils.getJavaHome());
            } else {
                File oracleJava;
                this.javaPath = Utils.getJavaHome();
                if (this.isUsingMacApp() && (oracleJava = new File("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java")).exists() && oracleJava.canExecute()) {
                    this.setJavaPath("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home");
                }
            }
            this.javaParamaters = this.properties.getProperty("javaparameters", "");
            this.maximiseMinecraft = Boolean.parseBoolean(this.properties.getProperty("maximiseminecraft", "false"));
            this.saveCustomMods = Boolean.parseBoolean(this.properties.getProperty("savecustommods", "true"));
            this.advancedBackup = Boolean.parseBoolean(this.properties.getProperty("advancedbackup", "false"));
            this.sortPacksAlphabetically = Boolean.parseBoolean(this.properties.getProperty("sortpacksalphabetically", "false"));
            this.keepLauncherOpen = Boolean.parseBoolean(this.properties.getProperty("keeplauncheropen", "true"));
            this.enableConsole = Boolean.parseBoolean(this.properties.getProperty("enableconsole", "true"));
            this.enableTrayIcon = Boolean.parseBoolean(this.properties.getProperty("enabletrayicon", "true"));
            this.enableLeaderboards = Boolean.parseBoolean(this.properties.getProperty("enableleaderboards", "false"));
            this.enableLogs = Boolean.parseBoolean(this.properties.getProperty("enablelogs", "true"));
            this.enableServerChecker = Boolean.parseBoolean(this.properties.getProperty("enableserverchecker", "false"));
            this.enableOpenEyeReporting = Boolean.parseBoolean(this.properties.getProperty("enableopeneyereporting", "true"));
            this.enableProxy = Boolean.parseBoolean(this.properties.getProperty("enableproxy", "false"));
            if (this.enableProxy) {
                this.proxyHost = this.properties.getProperty("proxyhost", null);
                this.proxyPort = Integer.parseInt(this.properties.getProperty("proxyport", "0"));
                if (this.proxyPort <= 0 || this.proxyPort > 65535) {
                    LogManager.warn("Tried to set proxy port to " + this.proxyPort + " which is not a valid port! " + "Proxy support disabled!");
                    this.enableProxy = false;
                }
                this.proxyType = this.properties.getProperty("proxytype", "");
                if (!(this.proxyType.equals("SOCKS") || this.proxyType.equals("HTTP") || this.proxyType.equals("DIRECT"))) {
                    LogManager.warn("Tried to set proxy type to " + this.proxyType + " which is not valid! Proxy " + "support disabled!");
                    this.enableProxy = false;
                }
            } else {
                this.proxyHost = "";
                this.proxyPort = 0;
                this.proxyType = "";
            }
            this.serverCheckerWait = Integer.parseInt(this.properties.getProperty("servercheckerwait", "5"));
            if (this.serverCheckerWait < 1 || this.serverCheckerWait > 30) {
                LogManager.warn("Tried to set server checker wait to " + this.serverCheckerWait + " which is not " + "valid! Must be between 1 and 30. Setting back to default of 5!");
                this.serverCheckerWait = 5;
            }
            this.concurrentConnections = Integer.parseInt(this.properties.getProperty("concurrentconnections", "8"));
            if (this.concurrentConnections < 1) {
                LogManager.warn("Tried to set the number of concurrent connections to " + this.concurrentConnections + " which is not valid! Must be 1 or more. Setting back to default of 8!");
                this.concurrentConnections = 8;
            }
            this.theme = this.properties.getProperty("theme", "OpenLauncher");
            this.daysOfLogsToKeep = Integer.parseInt(this.properties.getProperty("daysoflogstokeep", "7"));
            if (this.daysOfLogsToKeep < 1 || this.daysOfLogsToKeep > 30) {
                LogManager.warn("Tried to set the number of days worth of logs to keep to " + this.daysOfLogsToKeep + " which is not valid! Must be between 1 and 30 inclusive. Setting back to default of 7!");
                this.daysOfLogsToKeep = 7;
            }
            this.dateFormat = this.properties.getProperty("dateformat", "dd/M/yyy");
            if (!(this.dateFormat.equalsIgnoreCase("dd/M/yyy") || this.dateFormat.equalsIgnoreCase("M/dd/yyy") || this.dateFormat.equalsIgnoreCase("yyy/M/dd"))) {
                LogManager.warn("Tried to set the date format to " + this.dateFormat + " which is not valid! Setting " + "back to default of dd/M/yyy!");
                this.dateFormat = "dd/M/yyy";
            }
            if (!(lastAccountTemp = this.properties.getProperty("lastaccount", "")).isEmpty()) {
                if (this.isAccountByName(lastAccountTemp)) {
                    this.account = this.getAccountByName(lastAccountTemp);
                } else {
                    LogManager.warn("The Account " + lastAccountTemp + " is no longer available. Logging out of " + "Account!");
                    this.account = null;
                }
            }
            this.addedPacks = this.properties.getProperty("addedpacks", "");
            this.autoBackup = Boolean.parseBoolean(this.properties.getProperty("autobackup", "false"));
            this.notifyBackup = Boolean.parseBoolean(this.properties.getProperty("notifybackup", "true"));
            this.dropboxFolderLocation = this.properties.getProperty("dropboxlocation", "");
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
        LogManager.debug("Finished loading properties");
    }

    public void saveProperties() {
        try {
            this.properties.setProperty("firsttimerun", "false");
            this.properties.setProperty("hadpassworddialog", "true");
            this.properties.setProperty("hideoldjavawarning", this.hideOldJavaWarning + "");
            this.properties.setProperty("hidejava8warning", this.hideJava8Warning + "");
            this.properties.setProperty("language", Language.INSTANCE.getCurrent());
            this.properties.setProperty("server", this.server.getName());
            this.properties.setProperty("forgelogginglevel", this.forgeLoggingLevel);
            this.properties.setProperty("initialmemory", this.initialMemory + "");
            this.properties.setProperty("ram", this.maximumMemory + "");
            this.properties.setProperty("permGen", this.permGen + "");
            this.properties.setProperty("windowwidth", this.windowWidth + "");
            this.properties.setProperty("windowheight", this.windowHeight + "");
            this.properties.setProperty("usingcustomjavapath", this.usingCustomJavaPath ? "true" : "false");
            this.properties.setProperty("javapath", this.javaPath);
            this.properties.setProperty("javaparameters", this.javaParamaters);
            this.properties.setProperty("maximiseminecraft", this.maximiseMinecraft ? "true" : "false");
            this.properties.setProperty("savecustommods", this.saveCustomMods ? "true" : "false");
            this.properties.setProperty("advancedbackup", this.advancedBackup ? "true" : "false");
            this.properties.setProperty("sortpacksalphabetically", this.sortPacksAlphabetically ? "true" : "false");
            this.properties.setProperty("keeplauncheropen", this.keepLauncherOpen ? "true" : "false");
            this.properties.setProperty("enableconsole", this.enableConsole ? "true" : "false");
            this.properties.setProperty("enabletrayicon", this.enableTrayIcon ? "true" : "false");
            this.properties.setProperty("enableleaderboards", this.enableLeaderboards ? "true" : "false");
            this.properties.setProperty("enablelogs", this.enableLogs ? "true" : "false");
            this.properties.setProperty("enablepacktags", this.enablePackTags ? "true" : "false");
            this.properties.setProperty("enableserverchecker", this.enableServerChecker ? "true" : "false");
            this.properties.setProperty("enableopeneyereporting", this.enableOpenEyeReporting ? "true" : "false");
            this.properties.setProperty("enableproxy", this.enableProxy ? "true" : "false");
            this.properties.setProperty("proxyhost", this.proxyHost);
            this.properties.setProperty("proxyport", this.proxyPort + "");
            this.properties.setProperty("proxytype", this.proxyType);
            this.properties.setProperty("servercheckerwait", this.serverCheckerWait + "");
            this.properties.setProperty("concurrentconnections", this.concurrentConnections + "");
            this.properties.setProperty("daysoflogstokeep", this.daysOfLogsToKeep + "");
            this.properties.setProperty("dateformat", this.dateFormat);
            if (this.account != null) {
                this.properties.setProperty("lastaccount", this.account.getUsername());
            } else {
                this.properties.setProperty("lastaccount", "");
            }
            this.properties.setProperty("addedpacks", this.addedPacks);
            this.properties.setProperty("autobackup", this.autoBackup ? "true" : "false");
            this.properties.setProperty("notifybackup", this.notifyBackup ? "true" : "false");
            this.properties.setProperty("dropboxlocation", this.dropboxFolderLocation);
            this.properties.store(new FileOutputStream(this.propertiesFile), "OpenLauncher Settings");
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
    }

    public void addCheckingServer(MinecraftServer server) {
        this.checkingServers.add(server);
        this.saveCheckingServers();
    }

    public void removeCheckingServer(MinecraftServer server) {
        this.checkingServers.remove(server);
        this.saveCheckingServers();
        this.startCheckingServers();
    }

    public void switchAccount(Account account) {
        if (account == null) {
            LogManager.info("Logging out of account");
            this.account = null;
        } else if (account.isReal()) {
            LogManager.info("Changed account to " + account);
            this.account = account;
        } else {
            LogManager.info("Logging out of account");
            this.account = null;
        }
        this.reloadPacksPanel();
        this.reloadInstancesPanel();
        this.reloadAccounts();
        this.saveProperties();
    }

    private void setupServers() {
        this.servers = new ArrayList<Server>();
    }

    private void findActiveServers() {
        LogManager.debug("Finding servers to use");
        Downloadable download = new Downloadable(this.getMasterFileURL("launcher/json/servers.json"), false);
        String response = download.getContents();
        Type type = new TypeToken<List<Server>>(){}.getType();
        if (response != null) {
            try {
                this.servers = (List)gson.fromJson(response, type);
            }
            catch (Exception e) {
                this.logStackTrace("Exception when reading in the servers", e);
                this.servers = new ArrayList<Server>(Arrays.asList(Constants.SERVERS));
            }
        }
        LogManager.debug("Finished finding servers to use");
    }

    private void checkCreeperRepoEdges() {
        LogManager.debug("Checking CreeperRepo edges for availability");
        JSONParser parser = new JSONParser();
        try {
            Downloadable download = new Downloadable("http://www.creeperrepo.net/edges.json", false);
            String response = download.getContents();
            if (response != null) {
                Object obj = parser.parse(response);
                JSONObject jsonObject = (JSONObject)obj;
                Collection values = jsonObject.values();
                for (String string : values) {
                    this.servers.add(new Server(string, string + "/OpenLauncher", true, false));
                    LogManager.debug("Added " + string + "/OpenLauncher");
                }
                if (values.size() == 0) {
                    this.servers.add(new Server("Auto", "www.creeperrepo.net/OpenLauncher", false, false));
                    LogManager.warn("There was an error so we are running of the master server!");
                }
            }
        }
        catch (ParseException e) {
            this.logStackTrace(e);
        }
        LogManager.debug("Finished checking CreeperRepo edges for availability");
    }

    public boolean disableServerGetNext() {
        this.server.disableServer();
        for (Server server : this.servers) {
            if (server.isDisabled() || !server.isUserSelectable()) continue;
            LogManager.warn("Server " + this.server.getName() + " Not Available! Switching To " + server.getName());
            this.server = server;
            return true;
        }
        return false;
    }

    public void clearTriedServers() {
        if (this.triedServers.size() != 0) {
            this.triedServers = new ArrayList<Server>();
            this.server = this.originalServer;
        }
    }

    public boolean getNextServer() {
        this.triedServers.add(this.server);
        for (Server server : this.servers) {
            if (this.triedServers.contains(server) || server.isDisabled()) continue;
            LogManager.warn("Server " + this.server.getName() + " Not Available! Switching To " + server.getName());
            this.server = server;
            return true;
        }
        return false;
    }

    private void loadNews() {
        LogManager.debug("Loading news");
        try {
            Type type = new TypeToken<List<News>>(){}.getType();
            File fileDir = new File(this.getJSONDir(), "news.json");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileDir), "UTF-8"));
            this.news = (List)gson.fromJson((Reader)in, type);
            in.close();
        }
        catch (JsonSyntaxException e) {
            this.logStackTrace(e);
        }
        catch (JsonIOException e) {
            this.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        catch (UnsupportedEncodingException e) {
            this.logStackTrace(e);
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
        LogManager.debug("Finished loading news");
    }

    private void loadMinecraftVersions() {
        LogManager.debug("Loading Minecraft versions");
        this.minecraftVersions = new HashMap<String, MinecraftVersion>();
        List list = new ArrayList();
        try {
            Type type = new TypeToken<List<MinecraftVersion>>(){}.getType();
            list = (List)gson.fromJson((Reader)new FileReader(new File(this.getJSONDir(), "minecraftversions.json")), type);
        }
        catch (JsonSyntaxException e) {
            this.logStackTrace(e);
        }
        catch (JsonIOException e) {
            this.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        if (list == null) {
            LogManager.error("Error loading Minecraft Versions. List was null. Exiting!");
            System.exit(1);
        }
        for (MinecraftVersion mv : list) {
            this.minecraftVersions.put(mv.getVersion(), mv);
        }
        LogManager.info("[Background] Checking Minecraft Versions Started");
        ExecutorService executor = Executors.newFixedThreadPool(this.concurrentConnections);
        for (final Map.Entry<String, MinecraftVersion> entry : this.minecraftVersions.entrySet()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((MinecraftVersion)entry.getValue()).loadVersion();
                }
            });
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                LogManager.info("[Background] Checking Minecraft Versions Complete");
            }
        });
        executor.shutdown();
        while (!executor.isShutdown()) {
        }
        LogManager.debug("Finished loading Minecraft versions");
    }

    private void loadPacks() {
        LogManager.debug("Loading packs");
        try {
            Type type = new TypeToken<List<Pack>>(){}.getType();
            this.packs = (List)gson.fromJson((Reader)new FileReader(new File(this.getJSONDir(), "packs.json")), type);
        }
        catch (JsonSyntaxException e) {
            this.logStackTrace(e);
        }
        catch (JsonIOException e) {
            this.logStackTrace(e);
        }
        catch (FileNotFoundException e) {
            this.logStackTrace(e);
        }
        LogManager.debug("Finished loading packs");
    }

    private void loadUsers() {
        LogManager.debug("Loading users");
        Downloadable download = new Downloadable("launcher/json/users.json", true);
        List packUsers = null;
        try {
            Type type = new TypeToken<List<PackUsers>>(){}.getType();
            packUsers = (List)gson.fromJson(download.getContents(), type);
        }
        catch (JsonSyntaxException e) {
            this.logStackTrace(e);
        }
        catch (JsonIOException e) {
            this.logStackTrace(e);
        }
        if (packUsers == null) {
            this.offlineMode = true;
            return;
        }
        for (PackUsers pu : packUsers) {
            pu.addUsers();
        }
        LogManager.debug("Finished loading users");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInstances() {
        LogManager.debug("Loading instances");
        this.instances = new ArrayList<Instance>();
        if (this.instancesDataFile.exists()) {
            try {
                FileInputStream in = new FileInputStream(this.instancesDataFile);
                ObjectInputStream objIn = new ObjectInputStream(in);
                try {
                    Object obj;
                    while ((obj = objIn.readObject()) != null) {
                        File dir;
                        if (!(obj instanceof Instance) || !(dir = new File(this.getInstancesDir(), ((Instance)obj).getSafeName())).exists()) continue;
                        Instance instance = (Instance)obj;
                        if (!instance.hasBeenConverted()) {
                            LogManager.warn("Instance " + instance.getName() + " is being converted! This is " + "normal and should only appear once!");
                            instance.convert();
                        }
                        if (!instance.getDisabledModsDirectory().exists()) {
                            instance.getDisabledModsDirectory().mkdir();
                        }
                        this.instances.add(instance);
                        if (!this.isPackByName(instance.getPackName())) continue;
                        instance.setRealPack(this.getPackByName(instance.getPackName()));
                    }
                }
                catch (EOFException e) {
                }
                finally {
                    objIn.close();
                    in.close();
                }
            }
            catch (Exception e) {
                this.logStackTrace(e);
            }
            this.saveInstances();
            Utils.delete(this.instancesDataFile);
        } else {
            for (String folder : this.getInstancesDir().list(Utils.getInstanceFileFilter())) {
                FileReader fileReader;
                File instanceDir = new File(this.getInstancesDir(), folder);
                try {
                    fileReader = new FileReader(new File(instanceDir, "instance.json"));
                }
                catch (FileNotFoundException e) {
                    this.logStackTrace(e);
                    continue;
                }
                Instance instance = gson.fromJson((Reader)fileReader, Instance.class);
                if (instance == null) continue;
                if (!instance.getDisabledModsDirectory().exists()) {
                    instance.getDisabledModsDirectory().mkdir();
                }
                if (this.isPackByName(instance.getPackName())) {
                    instance.setRealPack(this.getPackByName(instance.getPackName()));
                }
                this.instances.add(instance);
            }
            if (this.instancesDataFile.exists()) {
                Utils.delete(this.instancesDataFile);
            }
        }
        LogManager.debug("Finished loading instances");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInstances() {
        for (Instance instance : this.instances) {
            File instanceFile = new File(instance.getRootDirectory(), "instance.json");
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                if (!instanceFile.exists()) {
                    instanceFile.createNewFile();
                }
                fw = new FileWriter(instanceFile);
                bw = new BufferedWriter(fw);
                bw.write(gson.toJson(instance));
            }
            catch (IOException e) {
                App.settings.logStackTrace(e);
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (fw == null) continue;
                    fw.close();
                }
                catch (IOException e) {
                    this.logStackTrace("Exception while trying to close FileWriter/BufferedWriter for saving instances json file.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAccounts() {
        LogManager.debug("Loading accounts");
        if (this.userDataFile.exists()) {
            FileInputStream in = null;
            ObjectInputStream objIn = null;
            try {
                Object obj;
                in = new FileInputStream(this.userDataFile);
                objIn = new ObjectInputStream(in);
                while ((obj = objIn.readObject()) != null) {
                    if (!(obj instanceof Account)) continue;
                    this.accounts.add((Account)obj);
                }
            }
            catch (EOFException e) {
            }
            catch (IOException e) {
                this.logStackTrace("Exception while trying to read accounts in from file.", e);
            }
            catch (ClassNotFoundException e) {
                this.logStackTrace("Exception while trying to read accounts in from file.", e);
            }
            finally {
                try {
                    if (objIn != null) {
                        objIn.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    this.logStackTrace("Exception while trying to close FileInputStream/ObjectInputStream when reading in accounts.", e);
                }
            }
        }
        LogManager.debug("Finished loading accounts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAccounts() {
        FileOutputStream out = null;
        ObjectOutputStream objOut = null;
        try {
            out = new FileOutputStream(this.userDataFile);
            objOut = new ObjectOutputStream(out);
            for (Account account : this.accounts) {
                objOut.writeObject(account);
            }
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
        finally {
            try {
                if (objOut != null) {
                    objOut.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                this.logStackTrace("Exception while trying to close FileOutputStream/ObjectOutputStream when saving accounts.", e);
            }
        }
    }

    public void removeAccount(Account account) {
        if (this.account == account) {
            this.switchAccount(null);
        }
        this.accounts.remove(account);
        this.saveAccounts();
        this.reloadAccounts();
    }

    private void loadCheckingServers() {
        LogManager.debug("Loading servers to check");
        this.checkingServers = new ArrayList<MinecraftServer>();
        if (this.checkingServersFile.exists()) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(this.checkingServersFile);
            }
            catch (FileNotFoundException e) {
                this.logStackTrace(e);
                return;
            }
            this.checkingServers = (List)gson.fromJson((Reader)fileReader, MinecraftServer.LIST_TYPE);
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    this.logStackTrace("Exception while trying to close FileReader when loading servers for server checker tool.", e);
                }
            }
        }
        LogManager.debug("Finished loading servers to check");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCheckingServers() {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            if (!this.checkingServersFile.exists()) {
                this.checkingServersFile.createNewFile();
            }
            fw = new FileWriter(this.checkingServersFile);
            bw = new BufferedWriter(fw);
            bw.write(gson.toJson(this.checkingServers));
        }
        catch (IOException e) {
            App.settings.logStackTrace(e);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {
                this.logStackTrace("Exception while trying to close FileWriter/BufferedWriter when saving servers for server checker tool.", e);
            }
        }
    }

    public List<MinecraftServer> getCheckingServers() {
        return this.checkingServers;
    }

    public boolean isFirstTimeRun() {
        return this.firstTimeRun;
    }

    public boolean isMinecraftLaunched() {
        return this.minecraftLaunched;
    }

    public void setMinecraftLaunched(boolean launched) {
        this.minecraftLaunched = launched;
        App.TRAY_MENU.setMinecraftLaunched(launched);
    }

    public List<Pack> getPacks() {
        return this.packs;
    }

    public List<Pack> getPacksSortedAlphabetically() {
        LinkedList<Pack> packs = new LinkedList<Pack>(this.packs);
        Collections.sort(packs, new Comparator<Pack>(){

            @Override
            public int compare(Pack result1, Pack result2) {
                return result1.getName().compareTo(result2.getName());
            }
        });
        return packs;
    }

    public List<Pack> getPacksSortedPositionally() {
        LinkedList<Pack> packs = new LinkedList<Pack>(this.packs);
        Collections.sort(packs, new Comparator<Pack>(){

            @Override
            public int compare(Pack result1, Pack result2) {
                return result1.getPosition() < result2.getPosition() ? -1 : (result1.getPosition() == result2.getPosition() ? 0 : 1);
            }
        });
        return packs;
    }

    public void setPackVisbility(Pack pack, boolean collapsed) {
        if (pack != null && this.account != null && this.account.isReal()) {
            if (collapsed) {
                if (!this.account.getCollapsedPacks().contains(pack.getName())) {
                    this.account.getCollapsedPacks().add(pack.getName());
                }
            } else if (this.account.getCollapsedPacks().contains(pack.getName())) {
                this.account.getCollapsedPacks().remove(pack.getName());
            }
            this.saveAccounts();
            this.reloadPacksPanel();
        }
    }

    public boolean isUsingMacApp() {
        return Utils.isMac() && new File(this.baseDir.getParentFile().getParentFile(), "MacOS").exists();
    }

    public void setInstanceVisbility(Instance instance, boolean collapsed) {
        if (instance != null && this.account.isReal()) {
            if (collapsed) {
                if (!this.account.getCollapsedInstances().contains(instance.getName())) {
                    this.account.getCollapsedInstances().add(instance.getName());
                }
            } else if (this.account.getCollapsedInstances().contains(instance.getName())) {
                this.account.getCollapsedInstances().remove(instance.getName());
            }
            this.saveAccounts();
            this.reloadInstancesPanel();
        }
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public ArrayList<Instance> getInstancesSorted() {
        ArrayList<Instance> instances = new ArrayList<Instance>(this.instances);
        Collections.sort(instances, new Comparator<Instance>(){

            @Override
            public int compare(Instance result1, Instance result2) {
                return result1.getName().compareTo(result2.getName());
            }
        });
        return instances;
    }

    public void setInstanceUnplayable(Instance instance) {
        instance.setUnplayable();
        this.saveInstances();
        this.reloadInstancesPanel();
    }

    public void removeInstance(Instance instance) {
        if (this.instances.remove(instance)) {
            Utils.delete(instance.getRootDirectory());
            this.saveInstances();
            this.reloadInstancesPanel();
        }
    }

    public boolean canViewSemiPublicPackByCode(String packCode) {
        for (String code : this.addedPacks.split(",")) {
            if (!Utils.getMD5(code).equalsIgnoreCase(packCode)) continue;
            return true;
        }
        return false;
    }

    public MinecraftVersion getMinecraftVersion(String version) throws InvalidMinecraftVersion {
        if (this.minecraftVersions.containsKey(version)) {
            return this.minecraftVersions.get(version);
        }
        throw new InvalidMinecraftVersion("No Minecraft version found matching " + version);
    }

    public boolean semiPublicPackExistsFromCode(String packCode) {
        String packCodeMD5 = Utils.getMD5(packCode);
        for (Pack pack : this.packs) {
            if (!pack.isSemiPublic() || !pack.getCode().equalsIgnoreCase(packCodeMD5)) continue;
            return true;
        }
        return false;
    }

    public boolean addPack(String packCode) {
        String packCodeMD5 = Utils.getMD5(packCode);
        for (Pack pack : this.packs) {
            if (!pack.isSemiPublic() || App.settings.canViewSemiPublicPackByCode(packCodeMD5) || !pack.getCode().equalsIgnoreCase(packCodeMD5)) continue;
            if (pack.isTester()) {
                return false;
            }
            this.addedPacks = this.addedPacks + packCode + ",";
            this.saveProperties();
            this.reloadInstancesPanel();
            return true;
        }
        return false;
    }

    public void removePack(String packCode) {
        for (String code : this.addedPacks.split(",")) {
            if (!Utils.getMD5(code).equalsIgnoreCase(packCode)) continue;
            this.addedPacks = this.addedPacks.replace(code + ",", "");
            this.saveProperties();
            this.reloadInstancesPanel();
        }
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public List<News> getNews() {
        return this.news;
    }

    public String getNewsHTML() {
        String news = "<html>";
        for (News newsItem : App.settings.getNews()) {
            news = news + newsItem.getHTML();
            if (App.settings.getNews().get(App.settings.getNews().size() - 1) == newsItem) continue;
            news = news + "<hr/>";
        }
        news = news + "</html>";
        return news;
    }

    public List<String> getLanguages() {
        LinkedList<String> langs = new LinkedList<String>();
        for (File file : this.getLanguagesDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lang");
            }
        })) {
            langs.add(file.getName().substring(0, file.getName().lastIndexOf(".")));
        }
        return langs;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public boolean isInOfflineMode() {
        return this.offlineMode;
    }

    public void checkOnlineStatus() {
        for (Server server : this.servers) {
            server.enableServer();
        }
        this.offlineMode = false;
        Downloadable download = new Downloadable("ping", true);
        String test = download.getContents();
        if (test != null && test.equalsIgnoreCase("pong")) {
            this.reloadPacksPanel();
            this.reloadInstancesPanel();
        } else {
            this.offlineMode = true;
        }
    }

    public void setOfflineMode() {
        this.offlineMode = true;
    }

    public void setOnlineMode() {
        this.offlineMode = false;
    }

    public Window getParent() {
        return this.parent;
    }

    public void setInstancesPanel(InstancesTab instancesPanel) {
        this.instancesPanel = instancesPanel;
    }

    public void reloadInstancesPanel() {
        if (this.instancesPanel != null) {
            this.instancesPanel.reload();
        }
    }

    public void setPacksPanel(PacksTab packsPanel) {
        this.packsPanel = packsPanel;
    }

    public void setNewsPanel(NewsTab newsPanel) {
        this.newsPanel = newsPanel;
    }

    public void reloadNewsPanel() {
        this.newsPanel.reload();
    }

    public void reloadPacksPanel() {
        this.packsPanel.reload();
    }

    public void setBottomBar(LauncherBottomBar bottomBar) {
        this.bottomBar = bottomBar;
    }

    public void reloadAccounts() {
        if (this.bottomBar == null) {
            return;
        }
        this.bottomBar.reloadAccounts();
    }

    public boolean isInstance(String name) {
        for (Instance instance : this.instances) {
            if (!instance.getSafeName().equalsIgnoreCase(name.replaceAll("[^A-Za-z0-9]", ""))) continue;
            return true;
        }
        return false;
    }

    public Pack getPackByID(int id) throws InvalidPack {
        for (Pack pack : this.packs) {
            if (pack.getID() != id) continue;
            return pack;
        }
        throw new InvalidPack("No pack exists with ID " + id);
    }

    public boolean isPackByName(String name) {
        for (Pack pack : this.packs) {
            if (!pack.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Pack getPackByName(String name) {
        for (Pack pack : this.packs) {
            if (!pack.getName().equalsIgnoreCase(name)) continue;
            return pack;
        }
        return null;
    }

    public boolean isInstanceByName(String name) {
        for (Instance instance : this.instances) {
            if (!instance.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceBySafeName(String name) {
        for (Instance instance : this.instances) {
            if (!instance.getSafeName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Instance getInstanceByName(String name) {
        for (Instance instance : this.instances) {
            if (!instance.getName().equalsIgnoreCase(name)) continue;
            return instance;
        }
        return null;
    }

    public Instance getInstanceBySafeName(String name) {
        for (Instance instance : this.instances) {
            if (!instance.getSafeName().equalsIgnoreCase(name)) continue;
            return instance;
        }
        return null;
    }

    private Server getServerByName(String name) {
        for (Server server : this.servers) {
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return server;
        }
        return null;
    }

    public Account getAccountByName(String username) {
        for (Account account : this.accounts) {
            if (!account.getUsername().equalsIgnoreCase(username)) continue;
            return account;
        }
        return null;
    }

    public boolean isLanguageByName(String name) {
        return this.getLanguages().contains(name.toLowerCase());
    }

    public boolean isServerByName(String name) {
        for (Server server : this.servers) {
            if (!server.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isAccountByName(String username) {
        for (Account account : this.accounts) {
            if (!account.getUsername().equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    public String getFileURL(String filename) {
        return this.server.getFileURL(filename);
    }

    public String getMasterFileURL(String filename) {
        for (Server server : this.servers) {
            if (!server.isMaster()) continue;
            return server.getFileURL(filename);
        }
        return null;
    }

    public boolean isConsoleVisible() {
        return this.console.isVisible();
    }

    public LauncherConsole getConsole() {
        return this.console;
    }

    public void clearConsole() {
        this.console.clearConsole();
    }

    public void addConsoleListener(WindowAdapter wa) {
        this.console.addWindowListener(wa);
    }

    public String getLog() {
        return this.console.getLog();
    }

    public void logStackTrace(Exception exception) {
        exception.printStackTrace();
        LogManager.error(exception.getMessage());
        for (StackTraceElement element : exception.getStackTrace()) {
            if (element.toString() == null) continue;
            LogManager.error(element.toString());
        }
    }

    public void logStackTrace(String message, Exception exception) {
        LogManager.error(message);
        this.logStackTrace(exception);
    }

    public void showKillMinecraft(Process minecraft) {
        this.minecraftProcess = minecraft;
        this.console.showKillMinecraft();
    }

    public void hideKillMinecraft() {
        this.console.hideKillMinecraft();
    }

    public void killMinecraft() {
        if (this.minecraftProcess != null) {
            LogManager.error("Killing Minecraft");
            this.minecraftProcess.destroy();
            this.minecraftProcess = null;
        } else {
            LogManager.error("Cannot kill Minecraft as there is no instance open!");
        }
    }

    public void setLanguage(String language) {
        try {
            Language.INSTANCE.load(language);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
        this.originalServer = server;
    }

    public Server getOriginalServer() {
        return this.originalServer;
    }

    public String getForgeLoggingLevel() {
        return this.forgeLoggingLevel;
    }

    public void setForgeLoggingLevel(String forgeLoggingLevel) {
        this.forgeLoggingLevel = forgeLoggingLevel;
    }

    public int getInitialMemory() {
        return this.initialMemory;
    }

    public void setInitialMemory(int initialMemory) {
        this.initialMemory = initialMemory;
    }

    public int getMaximumMemory() {
        return this.maximumMemory;
    }

    public void setMaximumMemory(int memory) {
        this.maximumMemory = memory;
    }

    public int getPermGen() {
        return this.permGen;
    }

    public void setPermGen(int permGen) {
        this.permGen = permGen;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public void setWindowWidth(int windowWidth) {
        this.windowWidth = windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public void setWindowHeight(int windowHeight) {
        this.windowHeight = windowHeight;
    }

    public boolean isUsingCustomJavaPath() {
        return this.usingCustomJavaPath;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.usingCustomJavaPath = !javaPath.equalsIgnoreCase(Utils.getJavaHome());
        this.javaPath = javaPath;
    }

    public String getJavaParameters() {
        return this.javaParamaters;
    }

    public void setJavaParameters(String javaParamaters) {
        this.javaParamaters = javaParamaters;
    }

    public Account getAccount() {
        return this.account;
    }

    public boolean startMinecraftMaximised() {
        return this.maximiseMinecraft;
    }

    public void setStartMinecraftMaximised(boolean maximiseMinecraft) {
        this.maximiseMinecraft = maximiseMinecraft;
    }

    public boolean saveCustomMods() {
        return this.saveCustomMods;
    }

    public void setSaveCustomMods(boolean saveCustomMods) {
        this.saveCustomMods = saveCustomMods;
    }

    public boolean isAdvancedBackupsEnabled() {
        return this.advancedBackup;
    }

    public void setAdvancedBackups(boolean advancedBackup) {
        this.advancedBackup = advancedBackup;
    }

    public boolean sortPacksAlphabetically() {
        return this.sortPacksAlphabetically;
    }

    public void setSortPacksAlphabetically(boolean sortPacksAlphabetically) {
        this.sortPacksAlphabetically = sortPacksAlphabetically;
    }

    public boolean enableConsole() {
        return this.enableConsole;
    }

    public boolean keepLauncherOpen() {
        return this.keepLauncherOpen;
    }

    public boolean enableTrayIcon() {
        return this.enableTrayIcon;
    }

    public void setEnableConsole(boolean enableConsole) {
        this.enableConsole = enableConsole;
    }

    public void setKeepLauncherOpen(boolean keepLauncherOpen) {
        this.keepLauncherOpen = keepLauncherOpen;
    }

    public String getLastSelectedSync() {
        if (this.lastSelectedSync == null) {
            this.setLastSelectedSync("Dropbox");
        }
        return this.lastSelectedSync;
    }

    public void setLastSelectedSync(String lastSelected) {
        this.lastSelectedSync = lastSelected;
        this.saveProperties();
    }

    public boolean getNotifyBackup() {
        return this.notifyBackup;
    }

    public void setNotifyBackup(boolean notify) {
        this.notifyBackup = notify;
        this.saveProperties();
    }

    public String getDropboxLocation() {
        return this.dropboxFolderLocation;
    }

    public void setDropboxLocation(String dropboxLoc) {
        this.dropboxFolderLocation = dropboxLoc;
        this.saveProperties();
    }

    public boolean getAutoBackup() {
        return this.autoBackup;
    }

    public void setAutoBackup(boolean enableBackup) {
        this.autoBackup = enableBackup;
        this.saveProperties();
    }

    public void setEnableTrayIcon(boolean enableTrayIcon) {
        this.enableTrayIcon = enableTrayIcon;
    }

    public boolean enableLeaderboards() {
        return this.enableLeaderboards;
    }

    public void setEnableLeaderboards(boolean enableLeaderboards) {
        this.enableLeaderboards = enableLeaderboards;
    }

    public boolean enableLogs() {
        return this.enableLogs;
    }

    public void setEnableLogs(boolean enableLogs) {
        this.enableLogs = enableLogs;
    }

    public boolean enableServerChecker() {
        return this.enableServerChecker;
    }

    public void setEnableServerChecker(boolean enableServerChecker) {
        this.enableServerChecker = enableServerChecker;
    }

    public boolean enableOpenEyeReporting() {
        return this.enableOpenEyeReporting;
    }

    public void setEnableOpenEyeReporting(boolean enableOpenEyeReporting) {
        this.enableOpenEyeReporting = enableOpenEyeReporting;
    }

    public boolean getEnableProxy() {
        return this.enableProxy;
    }

    public void setEnableProxy(boolean enableProxy) {
        this.enableProxy = enableProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public int getServerCheckerWait() {
        return this.serverCheckerWait;
    }

    public void setServerCheckerWait(int serverCheckerWait) {
        this.serverCheckerWait = serverCheckerWait;
    }

    public int getServerCheckerWaitInMilliseconds() {
        return this.serverCheckerWait * 60 * 1000;
    }

    public int getConcurrentConnections() {
        return this.concurrentConnections;
    }

    public void setConcurrentConnections(int concurrentConnections) {
        this.concurrentConnections = concurrentConnections;
    }

    public int getDaysOfLogsToKeep() {
        return this.daysOfLogsToKeep;
    }

    public void setDaysOfLogsToKeep(int daysOfLogsToKeep) {
        this.daysOfLogsToKeep = daysOfLogsToKeep;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public File getThemeFile() {
        File theme = new File(this.themesDir, this.theme + ".zip");
        if (theme.exists()) {
            return theme;
        }
        return null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        Timestamper.updateDateFormat();
    }

    public Proxy getProxy() {
        if (!this.enableProxy) {
            return null;
        }
        if (this.proxy == null) {
            Proxy.Type type;
            if (this.proxyType.equals("HTTP")) {
                type = Proxy.Type.HTTP;
            } else if (this.proxyType.equals("SOCKS")) {
                type = Proxy.Type.SOCKS;
            } else if (this.proxyType.equals("DIRECT")) {
                type = Proxy.Type.DIRECT;
            } else {
                LogManager.warn("Tried to set proxy type to " + this.proxyType + " which is not valid! Proxy support " + "disabled!");
                this.enableProxy = false;
                return null;
            }
            this.proxy = new Proxy(type, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        return this.proxy;
    }

    public Proxy getProxyForAuth() {
        if (!this.enableProxy) {
            return Proxy.NO_PROXY;
        }
        if (this.proxy == null) {
            Proxy.Type type;
            if (this.proxyType.equals("HTTP")) {
                type = Proxy.Type.HTTP;
            } else if (this.proxyType.equals("SOCKS")) {
                type = Proxy.Type.SOCKS;
            } else if (this.proxyType.equals("DIRECT")) {
                type = Proxy.Type.DIRECT;
            } else {
                LogManager.warn("Tried to set proxy type to " + this.proxyType + " which is not valid! Proxy support " + "disabled!");
                this.enableProxy = false;
                return Proxy.NO_PROXY;
            }
            this.proxy = new Proxy(type, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        return this.proxy;
    }

    public String getUserAgent() {
        return this.userAgent + "OpenLauncher" + " /" + Constants.VERSION;
    }

    public String getLocalizedString(String string) {
        return Language.INSTANCE.localize(string);
    }

    public String getLocalizedString(String string, String replace) {
        return Language.INSTANCE.localize(string).replace("%s", replace);
    }

    public void restartLauncher() {
        File thisFile = new File(Update.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        String path = null;
        try {
            path = thisFile.getCanonicalPath();
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logStackTrace(e);
        }
        catch (IOException e) {
            this.logStackTrace(e);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.isUsingMacApp()) {
            arguments.add("open");
            arguments.add("-n");
            arguments.add(this.baseDir.getParentFile().getParentFile().getParentFile().getAbsolutePath());
        } else {
            String jpath = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (Utils.isWindows()) {
                jpath = jpath + "w";
            }
            arguments.add(jpath);
            arguments.add("-jar");
            arguments.add(path);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(arguments);
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void cloneInstance(Instance instance, String clonedName) {
        Instance clonedInstance = (Instance)instance.clone();
        if (clonedInstance == null) {
            LogManager.error("Error Occured While Cloning Instance! Instance Object Couldn't Be Cloned!");
        } else {
            clonedInstance.setName(clonedName);
            clonedInstance.getRootDirectory().mkdir();
            Utils.copyDirectory(instance.getRootDirectory(), clonedInstance.getRootDirectory());
            this.instances.add(clonedInstance);
            this.saveInstances();
            this.reloadInstancesPanel();
        }
    }

    public String getPackInstallableCount() {
        int count = 0;
        for (Pack pack : this.getPacks()) {
            if (!pack.canInstall()) continue;
            ++count;
        }
        return count + "";
    }
}

