/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data.json;

import com.atlauncher.LogManager;
import com.atlauncher.data.json.Action;
import com.atlauncher.data.json.CaseType;
import com.atlauncher.data.json.Deletes;
import com.atlauncher.data.json.ExtraArguments;
import com.atlauncher.data.json.Library;
import com.atlauncher.data.json.MainClass;
import com.atlauncher.data.json.Messages;
import com.atlauncher.data.json.Mod;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Version {
    private String version;
    private String minecraft;
    private int memory;
    private int permGen;
    private boolean noconfigs;
    private CaseType caseAllFiles;
    private MainClass mainClass;
    private ExtraArguments extraArguments;
    private Deletes deletes;
    private Messages messages;
    private Map<String, String> warnings;
    private List<Library> libraries = new ArrayList<Library>();
    private Map<String, String> colours = new HashMap<String, String>();
    private List<Mod> mods = new ArrayList<Mod>();
    private List<Action> actions = new ArrayList<Action>();

    public String getVersion() {
        return this.version;
    }

    public String getMinecraft() {
        return this.minecraft;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getPermGen() {
        return this.permGen;
    }

    public boolean hasNoConfigs() {
        return this.noconfigs;
    }

    public CaseType getCaseAllFiles() {
        return this.caseAllFiles;
    }

    public boolean shouldCaseAllFiles() {
        return this.caseAllFiles != null;
    }

    public MainClass getMainClass() {
        return this.mainClass;
    }

    public boolean hasMainClass() {
        return this.mainClass != null && this.mainClass.getMainClass() != null;
    }

    public ExtraArguments getExtraArguments() {
        return this.extraArguments;
    }

    public boolean hasExtraArguments() {
        return this.extraArguments != null && this.extraArguments.getArguments() != null;
    }

    public Deletes getDeletes() {
        return this.deletes;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public boolean hasMessages() {
        return this.messages != null;
    }

    public List<Library> getLibraries() {
        return this.libraries;
    }

    public Map<String, String> getColours() {
        return this.colours;
    }

    public List<Mod> getMods() {
        return this.mods;
    }

    public List<Mod> getClientInstallMods() {
        ArrayList<Mod> mods = new ArrayList<Mod>();
        for (Mod mod : this.mods) {
            if (!mod.installOnClient()) continue;
            mods.add(mod);
        }
        return mods;
    }

    public List<Mod> getServerInstallMods() {
        ArrayList<Mod> mods = new ArrayList<Mod>();
        for (Mod mod : this.mods) {
            if (!mod.installOnServer()) continue;
            mods.add(mod);
        }
        return mods;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions != null && this.actions.size() != 0;
    }

    public boolean isColour(String key) {
        return this.colours.containsKey(key);
    }

    public boolean hasWarningMessage(String key) {
        return this.warnings.containsKey(key);
    }

    public String getWarningMessage(String key) {
        return this.warnings.get(key);
    }

    public Color getColour(String key) {
        if (key == null) {
            return null;
        }
        if (!this.isColour(key)) {
            LogManager.warn("Colour with key " + key + " not found!");
            return null;
        }
        String colour = this.colours.get(key);
        if (colour.substring(0, 1).equals("#")) {
            colour = colour.replace("#", "");
        }
        if (!colour.matches("[0-9A-Fa-f]{6}")) {
            LogManager.warn("Colour with key " + key + " has invalid value of " + colour + "!");
            return null;
        }
        try {
            int r = Integer.parseInt(colour.substring(0, 2), 16);
            int g = Integer.parseInt(colour.substring(2, 4), 16);
            int b = Integer.parseInt(colour.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        catch (NumberFormatException e) {
            LogManager.warn("Colour with key " + key + " failed to create object with value of " + colour + "!");
            return null;
        }
    }

    public void compileColours() {
        for (Mod mod : this.mods) {
            if (!mod.hasColour()) continue;
            mod.setCompiledColour(this.getColour(mod.getColour()));
        }
    }
}

