/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data.mojang;

import com.atlauncher.App;
import com.atlauncher.data.mojang.Action;
import com.atlauncher.data.mojang.ExtractRule;
import com.atlauncher.data.mojang.MojangConstants;
import com.atlauncher.data.mojang.OperatingSystem;
import com.atlauncher.data.mojang.Rule;
import com.atlauncher.utils.Utils;
import java.io.File;
import java.util.List;
import java.util.Map;

public class Library {
    private String name;
    private Map<OperatingSystem, String> natives;
    private List<Rule> rules;
    private ExtractRule extract;
    private String url;

    public boolean shouldInstall() {
        if (this.rules == null) {
            return true;
        }
        Action lastAction = Action.DISALLOW;
        for (Rule rule : this.rules) {
            if (!rule.ruleApplies()) continue;
            lastAction = rule.getAction();
        }
        return lastAction == Action.ALLOW;
    }

    public boolean shouldExtract() {
        return this.extract != null;
    }

    public ExtractRule getExtractRule() {
        return this.extract;
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        String[] parts = this.name.split(":", 3);
        String path = parts[0].replace(".", "/") + "/" + parts[1] + "/" + parts[2] + "/" + parts[1] + "-" + parts[2] + this.getClassifier() + ".jar";
        return MojangConstants.LIBRARIES_BASE.getURL(path);
    }

    public File getFile() {
        String[] parts = this.name.split(":", 3);
        return new File(App.settings.getLibrariesDir(), parts[1] + "-" + parts[2] + this.getClassifier() + ".jar");
    }

    public String getClassifier() {
        if (this.natives == null) {
            return "";
        }
        return "-" + this.natives.get((Object)OperatingSystem.getOS()).replace("${arch}", Utils.getArch());
    }
}

