/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.data.mojang;

public enum OperatingSystem {
    LINUX("linux"),
    WINDOWS("windows"),
    OSX("osx");

    private final String name;

    private OperatingSystem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static OperatingSystem getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("mac")) {
            return OSX;
        }
        return LINUX;
    }

    public static String getVersion() {
        return System.getProperty("os.version");
    }
}

