/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.evnt;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.gui.components.Console;
import com.atlauncher.utils.Timestamper;
import com.atlauncher.writer.LogEventWriter;
import java.awt.Color;
import java.io.IOException;

public final class LogEvent {
    public static final int CONSOLE = 10;
    public static final int FILE = 11;
    public final LogType type;
    public final String body;
    public final int meta;

    public LogEvent(LogType type, String body) {
        this(type, body, 11);
    }

    public LogEvent(LogType type, String body, int meta) {
        this.type = type;
        if (App.settings != null && !LogManager.showDebug) {
            body = body.replace(App.settings.getBaseDir().getAbsolutePath(), "**USERSDIR**");
        }
        this.body = !body.endsWith("\n") ? body + "\n" : body;
        this.meta = meta;
    }

    public void post(LogEventWriter writer) {
        if ((this.meta & 0xA) == 10) {
            Console c = App.settings.getConsole().console;
            c.setColor(this.type.color()).setBold(true).write("[" + Timestamper.now() + "] ");
            c.setColor(App.THEME.getConsoleTextColor()).setBold(false).write(this.body);
        }
        if ((this.meta & 0xB) == 11) {
            try {
                writer.write(this);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "[" + Timestamper.now() + "] [" + this.type.name() + "]" + this.body;
    }

    public static enum LogType {
        INFO,
        WARN,
        ERROR,
        DEBUG;


        public Color color() {
            switch (this) {
                case INFO: {
                    return App.THEME.getLogInfoColor();
                }
                case WARN: {
                    return App.THEME.getLogWarnColor();
                }
                case ERROR: {
                    return App.THEME.getLogErrorColor();
                }
                case DEBUG: {
                    return App.THEME.getLogDebugColor();
                }
            }
            return App.THEME.getConsoleTextColor();
        }
    }
}

