/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Constants;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.ConsoleCloseManager;
import com.atlauncher.evnt.manager.ConsoleOpenManager;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.Console;
import com.atlauncher.gui.components.ConsoleBottomBar;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class LauncherConsole
extends JFrame
implements RelocalizationListener {
    private static final long serialVersionUID = -3538990021922025818L;
    public Console console;
    private JScrollPane scrollPane;
    private ConsoleBottomBar bottomBar;
    private JPopupMenu contextMenu;
    private JMenuItem copy;

    public LauncherConsole() {
        this.setTitle("OpenLauncher Console " + Constants.VERSION);
        this.setDefaultCloseOperation(1);
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        this.setMinimumSize(new Dimension(600, 400));
        this.setLayout(new BorderLayout());
        this.console = new Console();
        this.console.setFont(App.THEME.getConsoleFont().deriveFont(Utils.getBaseFontSize().floatValue()));
        this.console.setForeground(App.THEME.getConsoleTextColor());
        this.console.setSelectionColor(App.THEME.getSelectionColor());
        this.setupContextMenu();
        this.bottomBar = new ConsoleBottomBar();
        this.scrollPane = new JScrollPane(this.console, 20, 31);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.bottomBar, "South");
        RelocalizationManager.addListener(this);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            ConsoleOpenManager.post();
        } else {
            ConsoleCloseManager.post();
        }
    }

    private void setupContextMenu() {
        this.contextMenu = new JPopupMenu();
        this.copy = new JMenuItem("Copy");
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection text = new StringSelection(LauncherConsole.this.console.getSelectedText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(text, null);
            }
        });
        this.contextMenu.add(this.copy);
        this.console.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (LauncherConsole.this.console.getSelectedText() != null && e.getButton() == 3) {
                    LauncherConsole.this.contextMenu.show(LauncherConsole.this.console, e.getX(), e.getY());
                }
            }
        });
    }

    public String getLog() {
        return this.console.getText();
    }

    public void showKillMinecraft() {
        this.bottomBar.showKillMinecraft();
    }

    public void hideKillMinecraft() {
        this.bottomBar.hideKillMinecraft();
    }

    public void setupLanguage() {
        LogManager.debug("Setting up language for console");
        this.copy.setText(Language.INSTANCE.localize("common.copy"));
        this.bottomBar.setupLanguage();
        LogManager.debug("Finished setting up language for console");
    }

    public void clearConsole() {
        this.console.setText(null);
    }

    @Override
    public void onRelocalization() {
        this.copy.setText(Language.INSTANCE.localize("common.copy"));
        this.bottomBar.setupLanguage();
    }
}

