/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Constants;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.evnt.manager.TabChangeManager;
import com.atlauncher.gui.components.LauncherBottomBar;
import com.atlauncher.gui.tabs.AccountsTab;
import com.atlauncher.gui.tabs.InstancesTab;
import com.atlauncher.gui.tabs.NewsTab;
import com.atlauncher.gui.tabs.PacksTab;
import com.atlauncher.gui.tabs.SettingsTab;
import com.atlauncher.gui.tabs.Tab;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import modmuss50.mods.CustomPacks.GuiUtils;

public final class LauncherFrame
extends JFrame
implements RelocalizationListener {
    private JTabbedPane tabbedPane;
    private NewsTab newsTab;
    private PacksTab packsTab;
    private InstancesTab instancesTab;
    private AccountsTab accountsTab;
    private SettingsTab settingsTab;
    private List<Tab> tabs;
    private LauncherBottomBar bottomBar;

    public LauncherFrame(boolean show) {
        LogManager.info("Launcher opening");
        LogManager.info("Made By Bob*");
        LogManager.info("*(Not Actually)");
        App.settings.setParentFrame(this);
        this.setSize(new Dimension(1000, 615));
        this.setTitle("OpenLauncher" + Constants.VERSION);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.setIconImage(Utils.getImage("/assets/image/Icon.png"));
        LogManager.info("Setting up Bottom Bar");
        this.setupBottomBar();
        LogManager.info("Finished Setting up Bottom Bar");
        LogManager.info("Setting up Tabs");
        this.setupTabs();
        LogManager.info("Finished Setting up Tabs");
        this.add((Component)this.tabbedPane, "Center");
        if (show) {
            LogManager.info("Showing Launcher");
            this.setVisible(true);
        }
        RelocalizationManager.addListener(this);
        App.TASKPOOL.execute(new Runnable(){

            @Override
            public void run() {
                App.settings.checkMojangStatus();
                LauncherFrame.this.bottomBar.updateStatus(App.settings.getMojangStatus());
            }
        });
    }

    public void updateTitle(String str) {
        this.setTitle("OpenLauncher" + Constants.VERSION + " - " + str);
    }

    private void setupTabs() {
        this.tabbedPane = new JTabbedPane(2);
        this.tabbedPane.setBackground(App.THEME.getBaseColor());
        this.newsTab = new NewsTab();
        App.settings.setNewsPanel(this.newsTab);
        this.packsTab = new PacksTab();
        App.settings.setPacksPanel(this.packsTab);
        this.instancesTab = new InstancesTab();
        App.settings.setInstancesPanel(this.instancesTab);
        this.accountsTab = new AccountsTab();
        this.settingsTab = new SettingsTab();
        this.tabs = Arrays.asList(this.instancesTab, this.packsTab, GuiUtils.customPacksTab, this.newsTab, this.accountsTab, this.settingsTab);
        this.tabbedPane.setFont(App.THEME.getTabFont().deriveFont(30.0f));
        for (int i = 0; i < this.tabs.size(); ++i) {
            this.tabbedPane.addTab("", new ImageIcon(Utils.getImage(this.tabs.get(i).getIcon())), (JPanel)((Object)this.tabs.get(i)));
            this.tabbedPane.setToolTipTextAt(i, this.tabs.get(i).getTitle());
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String tabName = ((Tab)((Object)LauncherFrame.this.tabbedPane.getSelectedComponent())).getTitle();
                if (LauncherFrame.this.tabbedPane.getSelectedIndex() == 1) {
                    LauncherFrame.this.updateTitle("Packs - " + App.settings.getPackInstallableCount());
                } else {
                    LauncherFrame.this.updateTitle(tabName);
                }
                TabChangeManager.post();
            }
        });
        this.tabbedPane.setBackground(App.THEME.getTabBackgroundColor());
        this.tabbedPane.setOpaque(true);
    }

    private void setupBottomBar() {
        this.bottomBar = new LauncherBottomBar();
        App.settings.setBottomBar(this.bottomBar);
    }

    @Override
    public void onRelocalization() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setTitleAt(i, this.tabs.get(i).getTitle());
        }
    }
}

