/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.card;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Instance;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.CollapsiblePanel;
import com.atlauncher.gui.components.ImagePanel;
import com.atlauncher.gui.dialogs.BackupDialog;
import com.atlauncher.gui.dialogs.EditModsDialog;
import com.atlauncher.gui.dialogs.InstanceInstallerDialog;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.gui.dialogs.RenameInstanceDialog;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class InstanceCard
extends CollapsiblePanel
implements RelocalizationListener {
    private final JSplitPane splitter = new JSplitPane();
    private final Instance instance;
    private final JPanel rightPanel = new JPanel();
    private final JTextArea descArea = new JTextArea();
    private final ImagePanel image;
    private final JButton playButton = new JButton(Language.INSTANCE.localize("common.play"));
    private final JButton reinstallButton = new JButton(Language.INSTANCE.localize("common.reinstall"));
    private final JButton updateButton = new JButton(Language.INSTANCE.localize("common.update"));
    private final JButton renameButton = new JButton(Language.INSTANCE.localize("common.rename"));
    private final JButton backupButton = new JButton(Language.INSTANCE.localize("common.backup"));
    private final JButton cloneButton = new JButton(Language.INSTANCE.localize("instance.clone"));
    private final JButton deleteButton = new JButton(Language.INSTANCE.localize("common.delete"));
    private final JButton editButton = new JButton(Language.INSTANCE.localize("common.editmods"));
    private final JButton openButton = new JButton(Language.INSTANCE.localize("common.openfolder"));
    private final JLabel packName = new JLabel();

    public InstanceCard(Instance instance) {
        super(instance);
        this.instance = instance;
        this.image = new ImagePanel(instance.getImage().getImage());
        this.splitter.setLeftComponent(this.image);
        this.splitter.setRightComponent(this.rightPanel);
        this.splitter.setEnabled(false);
        this.descArea.setText(instance.getPackDescription());
        this.descArea.setBorder(BorderFactory.createEmptyBorder());
        this.descArea.setEditable(false);
        this.descArea.setHighlighter(null);
        this.descArea.setLineWrap(true);
        this.descArea.setWrapStyleWord(true);
        this.descArea.setEditable(false);
        JPanel top = new JPanel(new FlowLayout());
        JPanel bottom = new JPanel(new FlowLayout());
        JSplitPane as = new JSplitPane(0);
        as.setEnabled(false);
        as.setTopComponent(top);
        as.setBottomComponent(bottom);
        this.packName.setText(instance.getName());
        Font boldFont = new Font(this.packName.getFont().getFontName(), 1, this.packName.getFont().getSize());
        this.packName.setFont(boldFont);
        top.add(this.packName);
        top.add(this.playButton);
        if (!instance.getCustomPack()) {
            top.add(this.reinstallButton);
        }
        if (!instance.getCustomPack()) {
            top.add(this.updateButton);
        }
        top.add(this.renameButton);
        bottom.add(this.backupButton);
        bottom.add(this.cloneButton);
        bottom.add(this.deleteButton);
        if (!instance.getCustomPack()) {
            bottom.add(this.editButton);
        }
        bottom.add(this.openButton);
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.setPreferredSize(new Dimension(this.rightPanel.getPreferredSize().width, 180));
        this.rightPanel.add((Component)new JScrollPane(this.descArea, 20, 31), "Center");
        this.rightPanel.add((Component)as, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitter, "Center");
        RelocalizationManager.addListener(this);
        if (!instance.hasUpdate() && !instance.getCustomPack()) {
            this.updateButton.setVisible(false);
        }
        this.addActionListeners();
        this.addMouseListeners();
        this.validatePlayable();
    }

    private void validatePlayable() {
        if (!this.instance.isPlayable()) {
            for (ActionListener al : this.playButton.getActionListeners()) {
                this.playButton.removeActionListener(al);
            }
            this.playButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.corruptplay"), Language.INSTANCE.localize("instance.corrupt"), -1, 0, null, options, options[0]);
                }
            });
            for (ActionListener al : this.backupButton.getActionListeners()) {
                this.backupButton.removeActionListener(al);
            }
            this.backupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.corruptbackup"), Language.INSTANCE.localize("instance.corrupt"), -1, 0, null, options, options[0]);
                }
            });
            for (ActionListener al : this.cloneButton.getActionListeners()) {
                this.cloneButton.removeActionListener(al);
            }
            this.cloneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.corruptclone"), Language.INSTANCE.localize("instance.corrupt"), -1, 0, null, options, options[0]);
                }
            });
        }
    }

    private void addActionListeners() {
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InstanceCard.this.instance.hasUpdate() && !InstanceCard.this.instance.hasUpdateBeenIgnored(InstanceCard.this.instance.getLatestVersion()) && !InstanceCard.this.instance.isDev() && !InstanceCard.this.instance.getCustomPack()) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no"), Language.INSTANCE.localize("instance.dontremindmeagain")};
                    int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.updatenow", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("instance.updateavailable"), -1, 0, null, options, options[0]);
                    if (ret == 0) {
                        if (App.settings.getAccount() == null) {
                            Object[] optionss = new String[]{Language.INSTANCE.localize("common.ok")};
                            JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cantupdate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, optionss, optionss[0]);
                        } else {
                            new InstanceInstallerDialog((Object)InstanceCard.this.instance, true, false);
                        }
                    } else if (ret == 1 || ret == -1) {
                        if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                            App.settings.setMinecraftLaunched(true);
                        }
                    } else if (ret == 2) {
                        InstanceCard.this.instance.ignoreUpdate();
                        if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                            App.settings.setMinecraftLaunched(true);
                        }
                    }
                } else if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                    App.settings.setMinecraftLaunched(true);
                }
            }
        });
        this.reinstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.getAccount() == null) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cantreinstall"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, options, options[0]);
                } else {
                    new InstanceInstallerDialog(InstanceCard.this.instance);
                }
            }
        });
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.getAccount() == null) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cantupdate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, options, options[0]);
                } else {
                    new InstanceInstallerDialog((Object)InstanceCard.this.instance, true, false);
                }
            }
        });
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RenameInstanceDialog(InstanceCard.this.instance);
            }
        });
        this.backupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.isAdvancedBackupsEnabled()) {
                    new BackupDialog(InstanceCard.this.instance).setVisible(true);
                } else if (InstanceCard.this.instance.getSavesDirectory().exists()) {
                    int ret = JOptionPane.showConfirmDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("backup.sure", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("backup.backingup", InstanceCard.this.instance.getName()), 0);
                    if (ret == 0) {
                        final JDialog dialog = new JDialog(App.settings.getParent(), Language.INSTANCE.localizeWithReplace("backup.backingup", InstanceCard.this.instance.getName()), Dialog.ModalityType.APPLICATION_MODAL);
                        dialog.setSize(300, 100);
                        dialog.setLocationRelativeTo(App.settings.getParent());
                        dialog.setResizable(false);
                        JPanel topPanel = new JPanel();
                        topPanel.setLayout(new BorderLayout());
                        JLabel doing = new JLabel(Language.INSTANCE.localizeWithReplace("backup.backingup", InstanceCard.this.instance.getName()));
                        doing.setHorizontalAlignment(0);
                        doing.setVerticalAlignment(1);
                        topPanel.add(doing);
                        JPanel bottomPanel = new JPanel();
                        bottomPanel.setLayout(new BorderLayout());
                        JProgressBar progressBar = new JProgressBar();
                        bottomPanel.add((Component)progressBar, "North");
                        progressBar.setIndeterminate(true);
                        dialog.add((Component)topPanel, "Center");
                        dialog.add((Component)bottomPanel, "South");
                        final Thread backupThread = new Thread(){

                            @Override
                            public void run() {
                                Timestamp timestamp = new Timestamp(new Date().getTime());
                                String time = timestamp.toString().replaceAll("[^0-9]", "_");
                                String filename = InstanceCard.this.instance.getSafeName() + "-" + time.substring(0, time.lastIndexOf("_")) + ".zip";
                                Utils.zip(InstanceCard.this.instance.getSavesDirectory(), new File(App.settings.getBackupsDir(), filename));
                                dialog.dispose();
                                App.TOASTER.pop(Language.INSTANCE.localizeWithReplace("backup.backupcomplete", " " + filename));
                            }
                        };
                        backupThread.start();
                        dialog.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                backupThread.interrupt();
                                dialog.dispose();
                            }
                        });
                        dialog.setVisible(true);
                    }
                } else {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("backup.nosaves"), Language.INSTANCE.localize("backup.nosavestitle"), -1, 0, null, options, options[0]);
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new EditModsDialog(InstanceCard.this.instance);
            }
        });
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.openExplorer(InstanceCard.this.instance.getRootDirectory());
            }
        });
        this.cloneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String clonedName = JOptionPane.showInputDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cloneenter"), Language.INSTANCE.localize("instance.clonetitle"), 1);
                if (clonedName != null && clonedName.length() >= 1 && App.settings.getInstanceByName(clonedName) == null && App.settings.getInstanceBySafeName(clonedName.replaceAll("[^A-Za-z0-9]", "")) == null && clonedName.replaceAll("[^A-Za-z0-9]", "").length() >= 1) {
                    final String newName = clonedName;
                    final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("instance.clonetitle"), 0, Language.INSTANCE.localize("instance.cloninginstance"), null);
                    dialog.addThread(new Thread(){

                        @Override
                        public void run() {
                            App.settings.cloneInstance(InstanceCard.this.instance, newName);
                            dialog.close();
                            App.TOASTER.pop(Language.INSTANCE.localizeWithReplace("instance.clonedsuccessfully", InstanceCard.this.instance.getName()));
                        }
                    });
                    dialog.start();
                } else if (clonedName == null || clonedName.equals("")) {
                    LogManager.error("Error Occured While Cloning Instance! Dialog Closed/Cancelled!");
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.errorclone", InstanceCard.this.instance.getName() + "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                } else if (clonedName.replaceAll("[^A-Za-z0-9]", "").length() == 0) {
                    LogManager.error("Error Occured While Cloning Instance! Invalid Name!");
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.errorclone", InstanceCard.this.instance.getName() + "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                } else {
                    LogManager.error("Error Occured While Cloning Instance! Instance With That Name Already Exists!");
                    JOptionPane.showMessageDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.errorclone", InstanceCard.this.instance.getName() + "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("common.error"), 0);
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int response = JOptionPane.showConfirmDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.deletesure"), Language.INSTANCE.localize("instance.deleteinstance"), 0);
                if (response == 0) {
                    final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("instance.deletetitle"), 0, Language.INSTANCE.localize("instance.deletinginstance"), null);
                    dialog.addThread(new Thread(){

                        @Override
                        public void run() {
                            App.settings.removeInstance(InstanceCard.this.instance);
                            dialog.close();
                            App.TOASTER.pop(Language.INSTANCE.localizeWithReplace("instance.deletedsuccessfully", InstanceCard.this.instance.getName()));
                        }
                    });
                    dialog.start();
                }
            }
        });
    }

    private void addMouseListeners() {
        this.image.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() >= 2) {
                    if (InstanceCard.this.instance.hasUpdate() && !InstanceCard.this.instance.hasUpdateBeenIgnored(InstanceCard.this.instance.getLatestVersion()) && !InstanceCard.this.instance.isDev()) {
                        Object[] options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no"), Language.INSTANCE.localize("instance.dontremindmeagain")};
                        int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("instance.updatenow", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("instance.updateavailable"), -1, 0, null, options, options[0]);
                        if (ret == 0) {
                            if (App.settings.getAccount() == null) {
                                Object[] optionss = new String[]{Language.INSTANCE.localize("common.ok")};
                                JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cantupdate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, optionss, optionss[0]);
                            } else {
                                new InstanceInstallerDialog((Object)InstanceCard.this.instance, true, false);
                            }
                        } else if (ret == 1 || ret == -1) {
                            if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                                App.settings.setMinecraftLaunched(true);
                            }
                        } else if (ret == 2) {
                            InstanceCard.this.instance.ignoreUpdate();
                            if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                                App.settings.setMinecraftLaunched(true);
                            }
                        }
                    } else if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                        App.settings.setMinecraftLaunched(true);
                    }
                } else if (e.getButton() == 3) {
                    JPopupMenu rightClickMenu = new JPopupMenu();
                    JMenuItem changeImageItem = new JMenuItem(Language.INSTANCE.localize("instance.changeimage"));
                    JMenuItem updateItem = new JMenuItem("Update Instance");
                    rightClickMenu.add(changeImageItem);
                    rightClickMenu.add(updateItem);
                    rightClickMenu.show(InstanceCard.this.image, e.getX(), e.getY());
                    changeImageItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            File img;
                            JFileChooser chooser = new JFileChooser();
                            chooser.setFileSelectionMode(0);
                            chooser.setAcceptAllFileFilterUsed(false);
                            chooser.setFileFilter(new FileNameExtensionFilter("PNG Files", "png"));
                            int ret = chooser.showOpenDialog(App.settings.getParent());
                            if (ret == 0 && (img = chooser.getSelectedFile()).getAbsolutePath().endsWith(".png")) {
                                try {
                                    Utils.safeCopy(img, new File(InstanceCard.this.instance.getRootDirectory(), "instance.png"));
                                    InstanceCard.this.image.setImage(InstanceCard.this.instance.getImage().getImage());
                                    InstanceCard.this.instance.save();
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace(System.err);
                                }
                            }
                        }
                    });
                    updateItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (InstanceCard.this.instance.hasUpdate() && !InstanceCard.this.instance.hasUpdateBeenIgnored(InstanceCard.this.instance.getLatestVersion()) && !InstanceCard.this.instance.isDev()) {
                                Object[] options = new String[]{Language.INSTANCE.localize("common.yes"), Language.INSTANCE.localize("common.no"), Language.INSTANCE.localize("instance.dontremindmeagain")};
                                int ret = JOptionPane.showOptionDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localize("instance.updatenow", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("instance.updateavailable"), -1, 0, null, options, options[0]);
                                if (ret == 0) {
                                    if (App.settings.getAccount() == null) {
                                        Object[] optionss = new String[]{Language.INSTANCE.localize("common.ok")};
                                        JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cantupdate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, optionss, optionss[0]);
                                    } else {
                                        new InstanceInstallerDialog((Object)InstanceCard.this.instance, true, false);
                                    }
                                } else if (ret == 1 || ret == -1) {
                                    if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                                        App.settings.setMinecraftLaunched(true);
                                    }
                                } else if (ret == 2) {
                                    InstanceCard.this.instance.ignoreUpdate();
                                    if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                                        App.settings.setMinecraftLaunched(true);
                                    }
                                }
                            } else if (!App.settings.isMinecraftLaunched() && InstanceCard.this.instance.launch()) {
                                App.settings.setMinecraftLaunched(true);
                            }
                        }
                    });
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                InstanceCard.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                InstanceCard.this.setCursor(new Cursor(0));
            }
        });
    }

    @Override
    public void onRelocalization() {
        this.playButton.setText(Language.INSTANCE.localize("common.play"));
        this.reinstallButton.setText(Language.INSTANCE.localize("common.reinstall"));
        this.updateButton.setText(Language.INSTANCE.localize("common.update"));
        this.renameButton.setText(Language.INSTANCE.localize("instance.rename"));
        this.backupButton.setText(Language.INSTANCE.localize("common.backup"));
        this.cloneButton.setText(Language.INSTANCE.localize("instance.clone"));
        this.deleteButton.setText(Language.INSTANCE.localize("common.delete"));
        this.editButton.setText(Language.INSTANCE.localize("common.editmods"));
        this.openButton.setText(Language.INSTANCE.localize("common.openfolder"));
    }
}

