/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.card;

import com.atlauncher.App;
import com.atlauncher.data.Language;
import com.atlauncher.data.Pack;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.CollapsiblePanel;
import com.atlauncher.gui.components.PackImagePanel;
import com.atlauncher.gui.dialogs.InstanceInstallerDialog;
import com.atlauncher.gui.dialogs.ViewModsDialog;
import com.atlauncher.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class PackCard
extends CollapsiblePanel
implements RelocalizationListener {
    private static final long serialVersionUID = -2617283435728223314L;
    private final JTextArea descArea = new JTextArea();
    private final JButton newInstanceButton = new JButton(Language.INSTANCE.localize("common.newinstance"));
    private final JButton createServerButton = new JButton(Language.INSTANCE.localize("common.createserver"));
    private final JButton websiteButton = new JButton(Language.INSTANCE.localize("common.website"));
    private final JButton modsButton = new JButton(Language.INSTANCE.localize("pack.viewmods"));
    private final JPanel actionsPanel = new JPanel(new BorderLayout());
    private final JLabel packName = new JLabel();
    private final JSplitPane splitter = new JSplitPane();
    private final GridBagConstraints gbc = new GridBagConstraints();
    private final Pack pack;

    public PackCard(Pack pack) {
        super(pack);
        RelocalizationManager.addListener(this);
        this.pack = pack;
        this.splitter.setLeftComponent(new PackImagePanel(pack));
        this.splitter.setRightComponent(this.actionsPanel);
        this.splitter.setEnabled(false);
        JPanel abPanel = new JPanel(new FlowLayout(1));
        this.packName.setText(pack.getName());
        Font boldFont = new Font(this.packName.getFont().getFontName(), 1, this.packName.getFont().getSize());
        this.packName.setFont(boldFont);
        abPanel.add(this.packName);
        abPanel.add(this.newInstanceButton);
        abPanel.add(this.createServerButton);
        abPanel.add(this.websiteButton);
        abPanel.add(this.modsButton);
        this.descArea.setText(pack.getDescription());
        this.descArea.setLineWrap(true);
        this.descArea.setEditable(false);
        this.descArea.setHighlighter(null);
        this.descArea.setWrapStyleWord(true);
        this.actionsPanel.add((Component)new JScrollPane(this.descArea, 20, 31), "Center");
        this.actionsPanel.add((Component)abPanel, "South");
        this.actionsPanel.setPreferredSize(new Dimension(this.actionsPanel.getPreferredSize().width, 180));
        this.getContentPane().add(this.splitter);
        this.addActionListeners();
        if (this.pack.getVersionCount() == 0) {
            this.modsButton.setVisible(false);
        }
        if (!this.pack.canCreateServer()) {
            this.createServerButton.setVisible(false);
        }
    }

    public Pack getPack() {
        return this.pack;
    }

    private void addActionListeners() {
        this.newInstanceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.isInOfflineMode()) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("pack.offlinenewinstance"), Language.INSTANCE.localize("common.offline"), -1, 0, null, options, options[0]);
                } else if (App.settings.getAccount() == null) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cannotcreate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, options, options[0]);
                } else {
                    new InstanceInstallerDialog(PackCard.this.pack);
                }
            }
        });
        this.createServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (App.settings.isInOfflineMode()) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("pack.offlinecreateserver"), Language.INSTANCE.localize("common.offline"), -1, 0, null, options, options[0]);
                } else if (App.settings.getAccount() == null) {
                    Object[] options = new String[]{Language.INSTANCE.localize("common.ok")};
                    JOptionPane.showOptionDialog(App.settings.getParent(), Language.INSTANCE.localize("instance.cannotcreate"), Language.INSTANCE.localize("instance.noaccountselected"), -1, 0, null, options, options[0]);
                } else {
                    new InstanceInstallerDialog(PackCard.this.pack, true);
                }
            }
        });
        this.websiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.openBrowser(PackCard.this.pack.getWebsiteURL());
            }
        });
        this.modsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ViewModsDialog(PackCard.this.pack).setVisible(true);
            }
        });
    }

    @Override
    public void onRelocalization() {
        this.newInstanceButton.setText(Language.INSTANCE.localize("common.newinstance"));
        this.createServerButton.setText(Language.INSTANCE.localize("common.createserver"));
        this.websiteButton.setText(Language.INSTANCE.localize("common.website"));
        this.modsButton.setText(Language.INSTANCE.localize("pack.viewmods"));
    }
}

