/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.components;

import com.atlauncher.App;
import com.atlauncher.LogManager;
import com.atlauncher.data.Language;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.components.BottomBar;
import com.atlauncher.thread.PasteUpload;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ConsoleBottomBar
extends BottomBar
implements RelocalizationListener {
    private final JPanel leftSide = new JPanel(new FlowLayout(0, 5, 10));
    private final JButton clearButton = new JButton("Clear");
    private final JButton copyLogButton = new JButton("Copy Log");
    private final JButton uploadLogButton = new JButton("Upload Log");
    private final JButton killMinecraftButton = new JButton("Kill Minecraft");

    public ConsoleBottomBar() {
        this.addActionListeners();
        this.leftSide.add(this.clearButton);
        this.leftSide.add(this.copyLogButton);
        this.leftSide.add(this.uploadLogButton);
        this.leftSide.add(this.killMinecraftButton);
        this.killMinecraftButton.setVisible(false);
        this.add((Component)this.leftSide, "West");
        RelocalizationManager.addListener(this);
    }

    private void addActionListeners() {
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                App.settings.clearConsole();
                LogManager.info("Console Cleared");
            }
        });
        this.copyLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                App.TOASTER.pop("Copied Log to clipboard");
                LogManager.info("Copied Log to clipboard");
                StringSelection text = new StringSelection(App.settings.getLog());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(text, null);
            }
        });
        this.uploadLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String result = App.TASKPOOL.submit(new PasteUpload()).get();
                    if (result.contains("http://rushmead.playat.ch/stikket/")) {
                        App.TOASTER.pop("Log uploaded and link copied to clipboard");
                        LogManager.info("Log uploaded and link copied to clipboard: " + result);
                        StringSelection text = new StringSelection(result);
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        clipboard.setContents(text, null);
                    } else {
                        App.TOASTER.popError("Log failed to upload!");
                        LogManager.error("Log failed to upload: " + result);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        });
        this.killMinecraftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int ret = JOptionPane.showConfirmDialog(App.settings.getParent(), "<html><p align=\"center\">" + Language.INSTANCE.localizeWithReplace("console.killsure", "<br/><br/>") + "</p></html>", Language.INSTANCE.localize("console.kill"), 0);
                if (ret == 0) {
                    App.settings.killMinecraft();
                    ConsoleBottomBar.this.killMinecraftButton.setVisible(false);
                }
            }
        });
    }

    public void showKillMinecraft() {
        this.killMinecraftButton.setVisible(true);
    }

    public void hideKillMinecraft() {
        this.killMinecraftButton.setVisible(false);
    }

    public void setupLanguage() {
        this.onRelocalization();
    }

    @Override
    public void onRelocalization() {
        this.clearButton.setText(Language.INSTANCE.localize("console.clear"));
        this.copyLogButton.setText(Language.INSTANCE.localize("console.copy"));
        this.uploadLogButton.setText(Language.INSTANCE.localize("console.upload"));
        this.killMinecraftButton.setText(Language.INSTANCE.localize("console.kill"));
    }
}

