/*
 * Decompiled with CFR 0.152.
 */
package com.atlauncher.gui.components;

import com.atlauncher.App;
import com.atlauncher.data.Account;
import com.atlauncher.data.Language;
import com.atlauncher.data.Status;
import com.atlauncher.evnt.listener.ConsoleCloseListener;
import com.atlauncher.evnt.listener.ConsoleOpenListener;
import com.atlauncher.evnt.listener.RelocalizationListener;
import com.atlauncher.evnt.manager.ConsoleCloseManager;
import com.atlauncher.evnt.manager.ConsoleOpenManager;
import com.atlauncher.evnt.manager.RelocalizationManager;
import com.atlauncher.gui.AccountsDropDownRenderer;
import com.atlauncher.gui.CustomLineBorder;
import com.atlauncher.gui.components.BottomBar;
import com.atlauncher.gui.dialogs.GithubIssueReporterDialog;
import com.atlauncher.gui.dialogs.ProgressDialog;
import com.atlauncher.utils.Utils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class LauncherBottomBar
extends BottomBar
implements RelocalizationListener {
    private final JButton submitError = new JButton("Submit Bug");
    private JPanel leftSide;
    private JPanel middle;
    private Account fillerAccount;
    private boolean dontSave = false;
    private JButton toggleConsole;
    private JButton openFolder;
    private JButton updateData;
    public JComboBox<Account> username;
    private JLabel statusIcon;

    public LauncherBottomBar() {
        this.submitError.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new GithubIssueReporterDialog(null).setVisible(true);
                    }
                });
            }
        });
        this.leftSide = new JPanel();
        this.leftSide.setLayout(new GridBagLayout());
        this.middle = new JPanel();
        this.middle.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.createButtons();
        this.setupListeners();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.leftSide.add((Component)this.toggleConsole, gbc);
        ++gbc.gridx;
        this.leftSide.add((Component)this.openFolder, gbc);
        ++gbc.gridx;
        this.leftSide.add((Component)this.updateData, gbc);
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.middle.add(this.username, gbc);
        ++gbc.gridx;
        this.middle.add((Component)this.statusIcon, gbc);
        this.add((Component)this.leftSide, "West");
        this.add((Component)this.middle, "Center");
        RelocalizationManager.addListener(this);
    }

    private void setupListeners() {
        this.toggleConsole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                App.settings.getConsole().setVisible(!App.settings.isConsoleVisible());
            }
        });
        this.openFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utils.openExplorer(App.settings.getBaseDir());
            }
        });
        this.updateData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ProgressDialog dialog = new ProgressDialog(Language.INSTANCE.localize("common.checkingforupdates"), 0, Language.INSTANCE.localize("common.checkingforupdates"), "Aborting Update Check!");
                dialog.addThread(new Thread(){

                    @Override
                    public void run() {
                        if (App.settings.hasUpdatedFiles()) {
                            App.settings.reloadLauncherData();
                        }
                        dialog.close();
                    }
                });
                dialog.start();
            }
        });
        this.username.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !LauncherBottomBar.this.dontSave) {
                    App.settings.switchAccount((Account)LauncherBottomBar.this.username.getSelectedItem());
                }
            }
        });
        ConsoleCloseManager.addListener(new ConsoleCloseListener(){

            @Override
            public void onConsoleClose() {
                LauncherBottomBar.this.toggleConsole.setText(Language.INSTANCE.localize("console.show"));
            }
        });
        ConsoleOpenManager.addListener(new ConsoleOpenListener(){

            @Override
            public void onConsoleOpen() {
                LauncherBottomBar.this.toggleConsole.setText(Language.INSTANCE.localize("console.hide"));
            }
        });
    }

    private void createButtons() {
        this.toggleConsole = App.settings.isConsoleVisible() ? new JButton(Language.INSTANCE.localize("console.hide")) : new JButton(Language.INSTANCE.localize("console.show"));
        this.openFolder = new JButton(Language.INSTANCE.localize("common.openfolder"));
        this.updateData = new JButton(Language.INSTANCE.localize("common.updatedata"));
        this.username = new JComboBox();
        this.username.setRenderer(new AccountsDropDownRenderer());
        this.fillerAccount = new Account(Language.INSTANCE.localize("account.select"));
        this.username.addItem(this.fillerAccount);
        for (Account account : App.settings.getAccounts()) {
            this.username.addItem(account);
        }
        Account active = App.settings.getAccount();
        if (active == null) {
            this.username.setSelectedIndex(0);
        } else {
            this.username.setSelectedItem(active);
        }
        this.statusIcon = new JLabel(Utils.getIconImage("/assets/image/StatusWhite.png")){

            @Override
            public JToolTip createToolTip() {
                JToolTip tip = super.createToolTip();
                CustomLineBorder border = new CustomLineBorder(5, App.THEME.getHoverBorderColor(), 2);
                tip.setBorder(border);
                return tip;
            }
        };
        this.statusIcon.setBorder(BorderFactory.createEmptyBorder());
        this.statusIcon.setToolTipText(Language.INSTANCE.localize("status.minecraft.checking"));
    }

    public void updateStatus(Status status) {
        switch (status) {
            case UNKNOWN: {
                this.statusIcon.setToolTipText(Language.INSTANCE.localize("status.minecraft.checking"));
                this.statusIcon.setIcon(Utils.getIconImage("/assets/image/StatusWhite.png"));
                break;
            }
            case ONLINE: {
                this.statusIcon.setToolTipText(Language.INSTANCE.localize("status.minecraft.online"));
                this.statusIcon.setIcon(Utils.getIconImage("/assets/image/StatusGreen.png"));
                break;
            }
            case OFFLINE: {
                this.statusIcon.setToolTipText(Language.INSTANCE.localize("status.minecraft.offline"));
                this.statusIcon.setIcon(Utils.getIconImage("/assets/image/StatusRed.png"));
                break;
            }
            case PARTIAL: {
                this.statusIcon.setToolTipText(Language.INSTANCE.localize("status.minecraft.partial"));
                this.statusIcon.setIcon(Utils.getIconImage("/assets/image/StatusYellow.png"));
                break;
            }
        }
    }

    public void reloadAccounts() {
        this.dontSave = true;
        this.username.removeAllItems();
        this.username.addItem(this.fillerAccount);
        for (Account account : App.settings.getAccounts()) {
            this.username.addItem(account);
        }
        if (App.settings.getAccount() == null) {
            this.username.setSelectedIndex(0);
        } else {
            this.username.setSelectedItem(App.settings.getAccount());
        }
        this.dontSave = false;
    }

    @Override
    public void onRelocalization() {
        if (App.settings.getConsole().isVisible()) {
            this.toggleConsole.setText(Language.INSTANCE.localize("console.hide"));
        } else {
            this.toggleConsole.setText(Language.INSTANCE.localize("console.show"));
        }
        this.updateData.setText(Language.INSTANCE.localize("common.updatedata"));
        this.openFolder.setText(Language.INSTANCE.localize("common.openfolder"));
    }
}

